<?php
function Get_a2000_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '[A相电压]':
            return array(0, $dataArray['A相线电压']);
        case '[B相电压]':
            return array(0, $dataArray['B相线电压']);
        case '[C相电压]':
            return array(0, $dataArray['C相线电压']);
        case '[总功率]':
            return array(0, $dataArray['总有功功率2']);
    }
    return array(1 , '设备无此信号数据:'. $varname);
}

function Get_a2000_Active_Power($dataArray){
    return array(0 , $dataArray['总电能2']);
}

function Get_a2000_RtData($memData, &$dataArray, $extraPara = false)
{
    if(empty($memData))
    {
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    }else{
        $dataArray["无数据"] = false;
        $dataArray['AlertArray'] = array();
        $v = unpack('f*', substr($memData, 4, 4 * 24));
        $dataArray['A-B线电压'] = number_format($v[1] , 2).' V';
        $dataArray['A相线电压'] = number_format($v[1] , 2);
        $dataArray['B-C线电压'] = number_format($v[2] , 2).' V';
        $dataArray['B相线电压'] = number_format($v[2] , 2);
        $dataArray['C-A线电压'] = number_format($v[3] , 2).' V';
        $dataArray['C相线电压'] = number_format($v[3] , 2);
        $dataArray['A相电流'] = number_format($v[4] , 2).' A';
        $dataArray['B相电流'] = number_format($v[5] , 2).' A';
        $dataArray['C相电流'] = number_format($v[6] , 2).' A';
        $dataArray['A相有功功率'] = number_format($v[7] , 2).' KW';
        $dataArray['B相有功功率'] = number_format($v[8] , 2).' KW';
        $dataArray['C相有功功率'] = number_format($v[9] , 2).' KW';
        $dataArray['总有功功率'] = number_format($v[10] , 2).' KW';
        $dataArray['总有功功率2'] = number_format($v[10] , 3 ,'.','');
        $dataArray['A相无功功率'] = number_format($v[11] , 2).' KVar';
        $dataArray['B相无功功率'] = number_format($v[12] , 2).' KVar';
        $dataArray['C相无功功率'] = number_format($v[13] , 2).' KVar';
        $dataArray['总无功功率'] = number_format($v[14] , 2).' KVar';
        $dataArray['A相视在功率'] = number_format($v[15] , 2).' KVA';
        $dataArray['B相视在功率'] = number_format($v[16] , 2).' KVA';
        $dataArray['C相视在功率'] = number_format($v[17] , 2).' KVA';
        $dataArray['总视在功率'] = number_format($v[18] , 2).' KVA';
        $dataArray['功率因数'] = number_format($v[19] , 2);
        $dataArray['A相电能'] = number_format($v[20] , 2 ,'.','').' KWh';
        $dataArray['B相电能'] = number_format($v[21] , 2 ,'.','').' KWh';
        $dataArray['C相电能'] = number_format($v[22] , 2 ,'.','').' KWh';
        $dataArray['总电能'] = number_format($v[23] , 2 ,'.','').' KWh';
        $dataArray['总电能2'] = number_format($v[23] , 2 ,'.','');
        $dataArray['频率'] = number_format($v[24] , 2).' Hz';
        $v = unpack('v', substr($memData, 4 + 4 * 24 , 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData, 4 + 4 * 24 + 2 , 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}


?>
