<?php

function Get_acrel_aem_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '[A相电压]':
            return array(0, $dataArray['A相电压(V)'] * 1.732);
        case '[B相电压]':
            return array(0, $dataArray['B相电压(V)'] * 1.732);
        case '[C相电压]':
            return array(0, $dataArray['C相电压(V)'] * 1.732);
	 case '[A相电流]':
            return array(0, $dataArray['A相电流(A)']);
        case '[B相电流]':
            return array(0, $dataArray['B相电流(A)']);
        case '[C相电流]':
            return array(0, $dataArray['C相电流(A)']);

        case '[总功率]':
            return  array(0, $dataArray['总有功功率2']);
    }
    return array(1 , '设备无此信号数据:'. $varname);
}

function Get_acrel_aem_Active_Power($dataArray){
    return array(0 , $dataArray['当前组合有功总电能(KWh)']);
}

function Get_acrel_aem_RtData($memData, &$dataArray, $extraPara = false)
{
   if($memData == false) {
       $dataArray['无数据'] = true;
       $dataArray['更新时间'] = '无';
       $dataArray['错误'] = '数据长度不一致';
   } else {
        $dataArray['无数据'] = false;
        $v = unpack('s*',substr($memData,4,2*11));
        $dataArray['地址'] = $v[1];
         switch ($v[2]) {
                case 1:
                    $dataArray['波特率(bps)'] = "9600";
                    break;
                case 2:
                    $dataArray['波特率(bps)'] = "4800";
                    break;
                case 3:
                    $dataArray['波特率(bps)'] = "2400";
                    break;
                case 4:
                    $dataArray['波特率(bps)'] = "1200";
                    break;
                default:
                    $dataArray['波特率(bps)'] = "未定义";
                    break;
            }
        // $v[3]; controlword
        // $v[4]; backlight
        $dataArray['VT'] = $v[5];
        $dataArray['CT'] = intval($v[6]);
        $dataArray['复用脉冲选择'] = $v[7];
        $dataArray['脉冲常数'] = $v[8];
        $dataArray['需量周期/滑差时间(min)'] = $v[9];
        // $v[10]; passwd
        // date('Y-m-d H:m:s',$v[11]); datetime
        $v = unpack('S*',substr($memData,4 + 2*11, 2*28));
        $dataArray['A相电压(V)'] = $v[1] / 10;
        $dataArray['B相电压(V)'] = $v[2] / 10;
        $dataArray['C相电压(V)'] = $v[3] / 10;
        //reserved  3
        $dataArray['A相电流(A)'] = $dataArray['CT'] * $v[7] / 1000;
        $dataArray['B相电流(A)'] = $dataArray['CT'] * $v[8] / 1000;
        $dataArray['C相电流(A)'] = $dataArray['CT'] * $v[9] / 1000;
        $dataArray['合相电流(A)'] = $dataArray['CT'] * $v[10] / 1000;
        $dataArray['A相有功功率(KW)'] = $dataArray['CT'] * $v[11] / 10000;
        $dataArray['B相有功功率(KW)'] = $dataArray['CT'] * $v[12] / 10000;
        $dataArray['C相有功功率(KW)'] = $dataArray['CT'] * $v[13] / 10000;
        $dataArray['合相有功功率(KW)'] = $dataArray['CT'] * $v[14] / 10000;
        $dataArray['总有功功率2'] = $dataArray['CT'] * $v[14] / 10000;
        $dataArray['A相无功功率(KVA)'] = $dataArray['CT'] * $v[15] / 10000;
        $dataArray['B相无功功率(KVA)'] = $dataArray['CT'] * $v[16] / 10000;
        $dataArray['C相无功功率(KVA)'] = $dataArray['CT'] * $v[17] / 10000;
        $dataArray['合相无功功率(KVA)'] = $dataArray['CT'] * $v[18] / 10000;
        $dataArray['A相视在功率(KVar)'] = $dataArray['CT'] * $v[19] / 10000;
        $dataArray['B相视在功率(KVar)'] = $dataArray['CT'] * $v[20] / 10000;
        $dataArray['C相视在功率(KVar)'] = $dataArray['CT'] * $v[21] / 10000;
        $dataArray['合相视在功率(KVar)'] = $dataArray['CT'] * $v[22] / 10000;
        $dataArray['A相功率因数'] = $v[23] / 1000;
        $dataArray['B相功率因数'] = $v[24] / 1000;
        $dataArray['C相功率因数'] = $v[25] / 1000;
        $dataArray['合相功率因数'] = $v[26] / 1000;
        // $v[27]; //功率方向  8位二进制 PowerHead
        $dataArray['A相有功功率方向'] = (($v[27] >> 2) & 0x1) === 0 ? "正向" : "反向";
        $dataArray['B相有功功率方向'] = (($v[27] >> 1) & 0x1) === 0 ? "正向" : "反向";
        $dataArray['C相有功功率方向'] = (($v[27] >> 0) & 0x1) === 0 ? "正向" : "反向";
        $dataArray['合相有功功率方向'] = (($v[27] >> 3) & 0x1) === 0 ? "正向" : "反向";
        $dataArray['A相无功功率方向'] = (($v[27] >> 4) & 0x1) === 0 ? "正向" : "反向";
        $dataArray['B相无功功率方向'] = (($v[27] >> 5) & 0x1) === 0 ? "正向" : "反向";
        $dataArray['C相无功功率方向'] = (($v[27] >> 6) & 0x1) === 0 ? "正向" : "反向";
        $dataArray['合相无功功率方向'] = (($v[27] >> 7) & 0x1) === 0 ? "正向" : "反向";
        $dataArray['频率(Hz)'] = $v[28] / 100;

        $v = unpack('f*',substr($memData,4 + 2*39, 40*4));

        $dataArray['当前组合有功总电能(KWh)'] = number_format($v[1] , 2 ,'.' ,'');
        $dataArray['当前正向有功总电能(KWh)'] = number_format($v[2] , 2 ,'.' ,'');
        $dataArray['当前反向有功总电能(KWh)'] = number_format($v[3] , 2 ,'.' ,'');
        $dataArray['当前正向无功总电能(KVAh)'] = number_format($v[4] , 2 ,'.' ,'');
        $dataArray['当前反向无功总电能(KVAh)'] = number_format($v[5] , 2 ,'.' ,'');
        $dataArray['A相组合有功总电能(KWh)'] = number_format($v[26] , 2 ,'.' ,'');
        $dataArray['A相正向有功总电能(KWh)'] = number_format($v[27] , 2 ,'.' ,'');
        $dataArray['A相反向有功总电能(KWh)'] = number_format($v[28] , 2 ,'.' ,'');
        $dataArray['A相正向无功总电能(KVAh)'] = number_format($v[29] , 2 ,'.' ,'');
        $dataArray['A相反向无功总电能(KVAh)'] = number_format($v[30] , 2 ,'.' ,'');
        $dataArray['B相组合有功总电能(KWh)'] = number_format($v[31] , 2 ,'.' ,'');
        $dataArray['B相正向有功总电能(KWh)'] = number_format($v[32] , 2 ,'.' ,'');
        $dataArray['B相反向有功总电能(KWh)'] = number_format($v[33] , 2 ,'.' ,'');
        $dataArray['B相正向无功总电能(KVAh)'] = number_format($v[34] , 2 ,'.' ,'');
        $dataArray['B相反向无功总电能(KVAh)'] = number_format($v[35] , 2 ,'.' ,'');
        $dataArray['C相组合有功总电能(KWh)'] = number_format($v[36] , 2 ,'.' ,'');
        $dataArray['C相正向有功总电能(KWh)'] = number_format($v[37] , 2 ,'.' ,'');
        $dataArray['C相反向有功总电能(KWh)'] = number_format($v[38] , 2 ,'.' ,'');
        $dataArray['C相正向无功总电能(KVAh)'] = number_format($v[39] , 2 ,'.' ,'');
        $dataArray['C相反向无功总电能(KVAh)'] = number_format($v[40] , 2 ,'.' ,'');

        $v = unpack('v', substr($memData, 4 + 2*39 + 40*4,2));
        $year = $v[1];
        $v = unpack('C*', substr($memData,  4 + 2*39 + 40*4 +2,5));
        $dataArray["更新时间"] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
   }
}

?>
