<?php
function Get_acrel_pz_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '[A相电压]':
            return array(0, $dataArray['A相电压2'] * 1.732);
        case '[B相电压]':
            return array(0, $dataArray['B相电压2'] * 1.732);
        case '[C相电压]':
            return array(0, $dataArray['C相电压2'] * 1.732);
        case "[总功率]":
            return array(0, $dataArray['总有功功率2']);
    }
    return array(1 , '设备无此信号数据:'. $varname);
}

function _GetSwitchInputOutputStatus($v)
{
    switch ($v) {
        case 5: return "DO4";
        case 6: return "DO3";
        case 7: return "DO2";
        case 8: return "DO1";
        case 9: return "DI8";
        case 10: return "DI7";
        case 11: return "DI6";
        case 12: return "DI5";
        case 13: return "DI4";
        case 14: return "DI3";
        case 15: return "DI2";
        case 16: return "DI1";
    }
    return "无效";
}

function Get_acrel_pz_Active_Power($dataArray){
    return array(0 , $dataArray['总能耗2']);
}

function Get_acrel_pz_RtData($memData, &$dataArray, $extraPara = false)
{
        if($memData == false){
            $dataArray['无数据'] = true;
            $dataArray['更新时间'] = '无';
            $dataArray['错误'] = '数据长度不一致';
        }else{
            $dataArray['无数据'] = false;
            $dataArray['AlertArray'] = array();
            $v = unpack('S*', substr($memData, 4, 2 * 5));
            $dataArray['保护密码'] = $v[1];
            $dataArray['通讯地址'] = ($v[2] >> 8);
            switch($v[2] & 0xFF){
                case 0: $dataArray['通讯波特率'] = '38400 bps'; break;
                case 1: $dataArray['通讯波特率'] = '19200 bps'; break;
                case 2: $dataArray['通讯波特率'] = '9600 bps'; break;
                case 3: $dataArray['通讯波特率'] = '4800 bps'; break;
                default : $dataArray['通讯波特率'] = '无效';
            }
            $dataArray['接线方式'] = ($v[3] >> 8) & 0x1 == 1 ? '三相三线' : '三线四线';
            $dataArray['输入电压范围'] = ($v[3] >> 7) & 0x1 == 1 ? '100 V' : '400 V';
            $dataArray['输入电流范围'] = ($v[3] >> 2) & 0x1 == 1 ? '1 A' : '5 A';
            $dataArray['PT变比'] = $v[4];
            $dataArray['CT变比'] = $v[5];
            //保留12*char 6*short
            $v = unpack('S*', substr($memData, 16 + 2 * 11, 2 * 2));
            $dataArray['背光控制'] = $v[1] == 0 ? "常亮" : "关闭";
            $dataArray['开关量输入输出状态'] = _GetSwitchInputOutputStatus($v[2]);
            $v = unpack('S*', substr($memData, 16 + 2 * 13, 2 * 2));
            $DPT_U = ($v[1] >> 8);//电压小数点位数
            $DCT_I = ($v[1] & 0xFF);//电流小数点位数
            $DPQ_HIGH = ($v[2] >> 8);//P Q 小数点
            $DPQ_LOW = ($v[2] & 0xFF); //高位-低位:Q、Qc、Qb、Qa、P、Pc、Pb、Pa; 0 为正,1 为负
            $v = unpack('S*', substr($memData, 20 + 2 * 13, 2 * 26));
            $dataArray['A相电压'] = number_format($v[1] * pow(10, $DPT_U - 4), 2).' V';
            $dataArray['B相电压'] = number_format($v[2] * pow(10, $DPT_U - 4), 2).' V';
            $dataArray['C相电压'] = number_format($v[3] * pow(10, $DPT_U - 4), 2).' V';
            $dataArray['AB线电压'] = number_format($v[4] * pow(10, $DPT_U - 4), 2).' V';
            $dataArray['BC线电压'] = number_format($v[5] * pow(10, $DPT_U - 4), 2).' V';
            $dataArray['CA线电压'] = number_format($v[6] * pow(10, $DPT_U - 4), 2).' V';
            $dataArray['A相电压2'] = number_format($v[4] * pow(10, $DPT_U - 4), 2);
            $dataArray['B相电压2'] = number_format($v[5] * pow(10, $DPT_U - 4), 2);
            $dataArray['C相电压2'] = number_format($v[6] * pow(10, $DPT_U - 4), 2);
            $dataArray['A相电流'] = number_format($v[7] * pow(10, $DCT_I - 4), 2).' A';
            $dataArray['B相电流'] = number_format($v[8] * pow(10, $DCT_I - 4), 2).' A';
            $dataArray['C相电流'] = number_format($v[9] * pow(10, $DCT_I - 4), 2).' A';
            $dataArray['A相有功功率'] = ($DPQ_LOW & 0x1) == 1 ? "-".number_format($v[10] * pow(10, $DPQ_HIGH - 4), 2).' W' : number_format($v[10] * pow(10, $DPQ_HIGH - 4), 2).' W';
            $dataArray['B相有功功率'] = (($DPQ_LOW >> 1) & 0x1) == 1 ? "-".number_format($v[11] * pow(10, $DPQ_HIGH - 4), 2).' W' : number_format($v[11] * pow(10, $DPQ_HIGH - 4), 2).' W';
            $dataArray['C相有功功率'] = (($DPQ_LOW >> 2) & 0x1) == 1 ? "-".number_format($v[12] * pow(10, $DPQ_HIGH - 4), 2).' W' : number_format($v[12] * pow(10, $DPQ_HIGH - 4), 2).' W';
            $dataArray['总有功功率'] = (($DPQ_LOW >> 3) & 0x1) == 1 ? "-".number_format($v[13] * pow(10, $DPQ_HIGH - 4), 2).' W' : number_format($v[13] * pow(10, $DPQ_HIGH - 4), 2).' W';
            $dataArray['总有功功率2'] = (($DPQ_LOW >> 3) & 0x1) == 1 ? "-".number_format($v[13] * pow(10, $DPQ_HIGH - 4) / 1000 , 3 ,'.','') : number_format($v[13] * pow(10, $DPQ_HIGH - 4) / 1000, 3,'.','');
            $dataArray['A相无功功率'] = (($DPQ_LOW >> 4) & 0x1) == 1 ? "-".number_format($v[14] * pow(10, $DPQ_HIGH - 4), 2).' Var' : number_format($v[14] * pow(10, $DPQ_HIGH - 4), 2).' Var';
            $dataArray['B相无功功率'] = (($DPQ_LOW >> 5) & 0x1) == 1 ? "-".number_format($v[15] * pow(10, $DPQ_HIGH - 4), 2).' Var' : number_format($v[15] * pow(10, $DPQ_HIGH - 4), 2).' Var';
            $dataArray['C相无功功率'] = (($DPQ_LOW >> 6) & 0x1) == 1 ? "-".number_format($v[16] * pow(10, $DPQ_HIGH - 4), 2).' Var' : number_format($v[16] * pow(10, $DPQ_HIGH - 4), 2).' Var';
            $dataArray['总无功功率'] = (($DPQ_LOW >> 7) & 0x1) == 1 ? "-".number_format($v[17] * pow(10, $DPQ_HIGH - 4), 2).' Var' : number_format($v[17] * pow(10, $DPQ_HIGH - 4), 2).' Var';
            $dataArray['A相功率因数'] = $v[18]/1000;
            $dataArray['B相功率因数'] = $v[19]/1000;
            $dataArray['C相功率因数'] = $v[20]/1000;
            $dataArray['总功率因数'] = $v[21]/1000;
            $dataArray['A相视在功率'] = ($v[22]).' VA';
            $dataArray['B相视在功率'] = ($v[23]).' VA';
            $dataArray['C相视在功率'] = ($v[24]).' VA';
            $dataArray['总视在功率'] = ($v[25]).' VA';
            $dataArray['频率'] = ($v[26]/100).' Hz';
            $v = unpack('f', substr($memData, 20 + 2 * 39 , 4));
            $dataArray['总能耗'] = ($v[1]/1000). " KWh";
            $dataArray['总能耗2'] = ($v[1]/1000);
            $v = unpack('v', substr($memData, 20 + 2 * 39 + 4, 2));
            $year = $v[1];
            $v = unpack('C*', substr($memData, 22 + 2 * 39 + 4, 5));
            $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));

        }
}
