<?php

function Get_aeg_ms10m_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '[A相电压]':
            return array(0, floatval($dataArray['实时基本测量数据']['A相电压']));
        case '[B相电压]':
            return array(0, floatval($dataArray['实时基本测量数据']['B相电压']));
        case '[C相电压]':
            return array(0, floatval($dataArray['实时基本测量数据']['C相电压']));
        case "[总功率]":
            return array(0, floatval($dataArray['实时基本测量数据']['总有功功率']));
    }
    return array(1 , '设备无此信号数据:'. $varname);
}

function Get_aeg_ms10m_Active_Power($dataArray){
    return array(0 , floatval($dataArray['实时基本测量数据']['有功输入电度']));
}

function Get_aeg_ms10m_RtData($memData, &$dataArray, $extraPara = false)
{
        if (empty($memData)){
            $dataArray['无数据'] = true;
            $dataArray['更新时间'] = '无';
            $dataArray['错误'] = '数据长度不一致';
        }else{
            $dataArray['无数据'] = false;
            $dataArray['AlertArray'] = array();
            $dataArray['实时基本测量数据'] = array();
            $v = unpack('f*', substr($memData, 4, 30 * 4));
            $dataArray['实时基本测量数据']['A相电压'] = number_format($v[1] , 2).' V';
            $dataArray['实时基本测量数据']['B相电压'] = number_format($v[2] , 2).' V';
            $dataArray['实时基本测量数据']['C相电压'] = number_format($v[3] , 2).' V';
            $dataArray['实时基本测量数据']['平均相电压'] = number_format($v[4] , 2).' V';
            $dataArray['实时基本测量数据']['AB线电压'] = number_format($v[5] , 2).' V';
            $dataArray['实时基本测量数据']['BC线电压'] = number_format($v[6] , 2).' V';
            $dataArray['实时基本测量数据']['CA线电压'] = number_format($v[7] , 2).' V';
            $dataArray['实时基本测量数据']['平均线电压'] = number_format($v[8] , 2).' V';
            $dataArray['实时基本测量数据']['A相电流'] = number_format($v[9] , 2).' A';
            $dataArray['实时基本测量数据']['B相电流'] = number_format($v[10] , 2).' A';
            $dataArray['实时基本测量数据']['C相电流'] = number_format($v[11] , 2).' A';
            $dataArray['实时基本测量数据']['平均相电流'] = number_format($v[12] , 2).' A';
            $dataArray['实时基本测量数据']['零序电流'] = number_format($v[13] , 2).' A';
            $dataArray['实时基本测量数据']['A相有功功率'] = number_format($v[14] , 2).' KW';
            $dataArray['实时基本测量数据']['B相有功功率'] = number_format($v[15] , 2).' KW';
            $dataArray['实时基本测量数据']['C相有功功率'] = number_format($v[16] , 2).' KW';
            $dataArray['实时基本测量数据']['总有功功率'] = number_format($v[17] , 2).' KW';
            $dataArray['实时基本测量数据']['A相无功功率'] = number_format($v[18] , 2).' KVar';
            $dataArray['实时基本测量数据']['B相无功功率'] = number_format($v[19] , 2).' KVar';
            $dataArray['实时基本测量数据']['C相无功功率'] = number_format($v[20] , 2).' KVar';
            $dataArray['实时基本测量数据']['总无功功率'] = number_format($v[21] , 2).' KVar';
            $dataArray['实时基本测量数据']['A相视在功率'] = number_format($v[22] , 2).' KVA';
            $dataArray['实时基本测量数据']['B相视在功率'] = number_format($v[23] , 2).' KVA';
            $dataArray['实时基本测量数据']['C相视在功率'] = number_format($v[24] , 2).' KVA';
            $dataArray['实时基本测量数据']['总视在功率'] = number_format($v[25] , 2).' KVA';
            $dataArray['实时基本测量数据']['A相功率因数'] = number_format($v[26] , 2);
            $dataArray['实时基本测量数据']['B相功率因数'] = number_format($v[27] , 2);
            $dataArray['实时基本测量数据']['C相功率因数'] = number_format($v[28] , 2);
            $dataArray['实时基本测量数据']['总功率因数'] = number_format($v[29] , 2);
            $dataArray['实时基本测量数据']['频率'] = number_format($v[30] , 2).' Hz';
            $v = unpack('S*', substr($memData, 124, 2));
            //$dataArray['DI'] = $v[1];
            $v = unpack('f*', substr($memData, 126, 16));
            $dataArray['实时基本测量数据']['有功输入电度'] = number_format($v[1] , 2, ".", "").' KWh';
            $dataArray['实时基本测量数据']['有功输出电度'] = number_format($v[2] , 2).' KWh';
            $dataArray['实时基本测量数据']['无功输入电度'] = number_format($v[3] , 2).' KVarh';
            $dataArray['实时基本测量数据']['无功输出电度'] = number_format($v[4] , 2).' KVarh';
            $v = unpack('S*', substr($memData, 142, 2));
            //$dataArray['DO'] = $v[1];
            $v = unpack('f*', substr($memData, 144, 28 * 4));
            $dataArray['单位时间内最大数据'] = array();
            $dataArray['单位时间内最大数据']['A相电压'] = number_format($v[1] , 2).' V';
            $dataArray['单位时间内最大数据']['B相电压'] = number_format($v[2] , 2).' V';
            $dataArray['单位时间内最大数据']['C相电压'] = number_format($v[3] , 2).' V';
            $dataArray['单位时间内最大数据']['AB线电压'] = number_format($v[4] , 2).' V';
            $dataArray['单位时间内最大数据']['BC线电压'] = number_format($v[5] , 2).' V';
            $dataArray['单位时间内最大数据']['CA线电压'] = number_format($v[6] , 2).' V';
            $dataArray['单位时间内最大数据']['A相电流'] = number_format($v[7] , 2).' A';
            $dataArray['单位时间内最大数据']['B相电流'] = number_format($v[8] , 2).' A';
            $dataArray['单位时间内最大数据']['C相电流'] = number_format($v[9] , 2).' A';
            $dataArray['单位时间内最大数据']['零序电流'] = number_format($v[10] , 2).' A';
            $dataArray['单位时间内最大数据']['总有功功率'] = number_format($v[11] , 2).' KW';
            $dataArray['单位时间内最大数据']['总无功功率'] = number_format($v[12] , 2).' KVar';
            $dataArray['单位时间内最大数据']['总视在功率'] = number_format($v[13] , 2).' KVA';
            $dataArray['单位时间内最大数据']['频率'] = number_format($v[14] , 2).' Hz';
            $dataArray['单位时间内平均数据'] = array();
            $dataArray['单位时间内平均数据']['A相电压'] = number_format($v[15] , 2).' V';
            $dataArray['单位时间内平均数据']['B相电压'] = number_format($v[16] , 2).' V';
            $dataArray['单位时间内平均数据']['C相电压'] = number_format($v[17] , 2).' V';
            $dataArray['单位时间内平均数据']['AB线电压'] = number_format($v[18] , 2).' V';
            $dataArray['单位时间内平均数据']['BC线电压'] = number_format($v[19] , 2).' V';
            $dataArray['单位时间内平均数据']['CA线电压'] = number_format($v[20] , 2).' V';
            $dataArray['单位时间内平均数据']['A相电流'] = number_format($v[21] , 2).' A';
            $dataArray['单位时间内平均数据']['B相电流'] = number_format($v[22] , 2).' A';
            $dataArray['单位时间内平均数据']['C相电流'] = number_format($v[23] , 2).' A';
            $dataArray['单位时间内平均数据']['零序电流'] = number_format($v[24] , 2).' A';
            $dataArray['单位时间内平均数据']['总有功功率'] = number_format($v[25] , 2).' KW';
            $dataArray['单位时间内平均数据']['总无功功率'] = number_format($v[26] , 2).' KVar';
            $dataArray['单位时间内平均数据']['总视在功率'] = number_format($v[27] , 2).' KVA';
            $dataArray['单位时间内平均数据']['频率'] = number_format($v[28] , 2).' Hz';
            //谐波分析数据区  不显示/////
            $v = unpack('v', substr($memData, 256 + 1140, 2));
            $year = $v[1];
            $v = unpack('C*', substr($memData, 1398, 5));
            $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
        }
}
