<?php
function Get_aeg_ms10se_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '[A相电压]':
            return array(0, floatval($dataArray['A相电压']));
        case '[B相电压]':
            return array(0, floatval($dataArray['B相电压']));
        case '[C相电压]':
            return array(0, floatval($dataArray['C相电压']));
        case "[总功率]":
            return array(0, floatval($dataArray['总有功功率'])/1000);
    }
    return array(1 , '设备无此信号数据:'. $varname);
}

function Get_aeg_ms10se_Active_Power($dataArray){
    return array(0 , floatval($dataArray['有功输入电度']));
}


function Get_aeg_ms10se_RtData($memData, &$dataArray, $extraPara = false)
{
        if (empty($memData)) {
            $dataArray['无数据'] = true;
            $dataArray['更新时间'] = '无';
            $dataArray['错误'] = '数据长度不一致';
        }else{
            $dataArray['无数据'] = false;
            $dataArray['AlertArray'] = array();
            $v = unpack('I*', substr($memData, 4, 4 * 4));
            $dataArray['PT1'] = $v[1];
            $dataArray['PT2'] = $v[2];
            $dataArray['CT1'] = $v[3];
            $dataArray['CT2'] = $v[4];
            $v = unpack('f*', substr($memData, 4 + 4*4, 14 * 4));
            $dataArray['频率'] = number_format($v[1], 2).' Hz';
            $dataArray['A相电压'] = number_format($v[2], 2).' V';
            $dataArray['B相电压'] = number_format($v[3], 2).' V';
            $dataArray['C相电压'] = number_format($v[4], 2).' V';
            $dataArray['平均相电压'] = number_format($v[5], 2).' V';
            $dataArray['AB线电压'] = number_format($v[6], 2).' V';
            $dataArray['BC线电压'] = number_format($v[7], 2).' V';
            $dataArray['CA线电压'] = number_format($v[8], 2).' V';
            $dataArray['平均线电压'] = number_format($v[9], 2).' V';
            $dataArray['A相电流'] = number_format($v[10], 2).' A';
            $dataArray['B相电流'] = number_format($v[11], 2).' A';
            $dataArray['C相电流'] = number_format($v[12], 2).' A';
            $dataArray['平均相电流'] = number_format($v[13], 2).' A';
            $dataArray['中线电流'] = number_format($v[14], 2).' A';
            $v = unpack('f*', substr($memData,76, 32));
            $dataArray['A相有功功率'] = $v[1].' W';
            $dataArray['B相有功功率'] = $v[2].' W';
            $dataArray['C相有功功率'] = $v[3].' W';
            $dataArray['总有功功率'] = $v[4].' W';
            $dataArray['A相无功功率'] = $v[5].' Var';
            $dataArray['B相无功功率'] = $v[6].' Var';
            $dataArray['C相无功功率'] = $v[7].' Var';
            $dataArray['总无功功率'] = $v[8].' Var';
            $v = unpack('I*',substr($memData,108,16));
            $dataArray['A相视在功率'] = $v[1].' VA';
            $dataArray['B相视在功率'] = $v[2].' VA';
            $dataArray['C相视在功率'] = $v[3].' VA';
            $dataArray['总视在功率'] = $v[4].' VA';
            $v = unpack('i*',substr($memData,124,16));
            $dataArray['A相功率因数'] = $v[1];
            $dataArray['B相功率因数'] = $v[2];
            $dataArray['C相功率因数'] = $v[3];
            $dataArray['总功率因数'] = $v[4];
            $v = unpack('l*',substr($memData,140,24));
            $dataArray['系统有功功率'] = $v[1].' W';
            $dataArray['系统无功功率'] = $v[2].' Var';
            $dataArray['系统视在功率'] = $v[3].' VA';
            $v = unpack('f*',substr($memData,164,32));
            $dataArray['有功输入电度'] = number_format($v[1] , 2, ".", "").' KWh';
            $dataArray['有功输出电度'] = number_format($v[2] , 2).' KWh';
            $dataArray['无功输入电度'] = number_format($v[3] , 2).' KVarh';
            $dataArray['无功输出电度'] = number_format($v[4] , 2).' KVarh';
            $dataArray['总有功电度'] = number_format($v[5] , 2).' KWh';
            $dataArray['净有功电度'] = number_format($v[6] , 2).' KWh';
            $dataArray['总无功电度'] = number_format($v[7] , 2).' KVarh';
            $dataArray['净无功电度'] = number_format($v[8] , 2).' KVarh';
            $v = unpack('C*',substr($memData,196,12));
            $dataArray['DI1 开关状态'] = $v[1] == 1 ? '闭合' : '断开';
            $dataArray['DI2 开关状态'] = $v[2] == 1 ? '闭合' : '断开';
            $dataArray['DI3 开关状态'] = $v[3] == 1 ? '闭合' : '断开';
            $dataArray['DI4 开关状态'] = $v[4] == 1 ? '闭合' : '断开';
            $dataArray['DI5 开关状态'] = $v[5] == 1 ? '闭合' : '断开';
            $dataArray['DI6 开关状态'] = $v[6] == 1 ? '闭合' : '断开';
            $dataArray['DO1 开关状态'] = $v[7] == 1 ? '闭合' : '断开';
            $dataArray['DO2 开关状态'] = $v[8] == 1 ? '闭合' : '断开';
            $dataArray['DO3 开关状态'] = $v[9] == 1 ? '闭合' : '断开';
            $dataArray['DO4 开关状态'] = $v[10] == 1 ? '闭合' : '断开';
            $dataArray['DO5 开关状态'] = $v[11] == 1 ? '闭合' : '断开';
            $dataArray['DO6 开关状态'] = $v[12] == 1 ? '闭合' : '断开';
            $v = unpack('v', substr($memData, 208, 2));
            $year = $v[1];
            $v = unpack('C*', substr($memData, 210, 5));
            $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
        }
}
