<?php 

function Get_airsys_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '温度设定点':
            return array(0,  $dataArray["温度设定点（℃）"]);
        case '回风温度':
            return array(0, $dataArray["室内回风温度（℃）"]);
        default:
            break;
    }
    return array(1 , '设备无此信号数据:'. $varname);
}   



function Get_airsys_RtData($memData, &$dataArray, $extraPara = false)
{
    if(empty($memData)) {
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    } else {
        $dataArray['无数据'] = false;
        $v = unpack('C*', substr($memData, 4, 34));
        $dataArray["泵极功能"] = $v[1];
        $dataArray["制冷模式"] = $v[2];
        $dataArray["除湿模式"] = $v[3];
        $dataArray["高水位开关"] = $v[4];
        $dataArray["烟火/用户报警"] = $v[5];
        $dataArray["远地开/关"] = $v[6];
        $dataArray["风压差开关"] = $v[7];
        $dataArray["电加热保护"] = $v[8];
        $dataArray["送风机过载和热保护"] = $v[9];
        $dataArray["过滤网堵塞"] = $v[10];
        $dataArray["地板漏水报警"] = $v[11];
        $dataArray["加湿器电源（断路器辅助开关）"] = $v[12];
        $dataArray["电源故障（相序保护器）"] = $v[13];
        $dataArray["压缩机1低压保护开关"] = $v[14];
        $dataArray["压缩机2低压保护开关"] = $v[15];
        $dataArray["压缩机1高压保护开关"] = $v[16];
        $dataArray["压缩机2高压保护开关"] = $v[17];
        $dataArray["压缩机1"] = $v[18];
        $dataArray["压缩机2"] = $v[19];
        $dataArray["电加热1"] = $v[20];
        $dataArray["电加热2"] = $v[21];
        $dataArray["压缩机1除湿电磁阀"] = $v[22];
        $dataArray["压缩机2除湿电磁阀"] = $v[23];
        $dataArray["加湿器"] = $v[24];
        $dataArray["总报警输出"] = $v[25];
        $dataArray["送风机（蒸发器）"] = $v[26];
        $dataArray["压缩机1液管电磁阀"] = $v[27];
        $dataArray["压缩机2液管电磁阀"] = $v[28];
        $dataArray["加湿器进水阀"] = $v[29];
        $dataArray["加湿器排水阀"] = $v[30];
        $dataArray["风机模式"] = $v[31];
        $dataArray["总报警"] = $v[32];
        $dataArray["加热模式"] = $v[33];
        $dataArray["加湿模式"] = $v[34];

        $v = unpack('C*', substr($memData, 38, 66));
        ///AirSys_bit_36_102_t  报警
        $alertKeyArr = [
            "过滤网堵塞",  
            "时钟",     
            "压缩机1排气压力传感器故障", 
            "压缩机2排气压力传感器故障", 
            "用户自定义报警",       
            "送风机（蒸发器）过载",    
            "烟火报警",   
            "室内湿度过高", 
            "室内温度过高", 
            "压缩机1高压保护",      
            "压缩机2高压保护",      
            "压缩机1运行时间超时",    
            "压缩机2运行时间超时",    
            "送风机运行时间超时",     
            "电加热1运行时间超时",    
            "电加热2运行时间超时",    
            "机组运行时间超时",      
            "加湿器电源故障",       
            "室内湿度过低", 
            "室内温度过低", 
            "机组过热",   
            "局域网未连接", 
            "相序保护器",  
            "压缩机1高压预报警",     
            "压缩机2高压预报警",     
            "风压差开关",  
            "压缩机1低压保护开关",    
            "压缩机2低压保护开关",    
            "室内湿度传感器故障",     
            "室内温度传感器故障",     
            "送风温度传感器故障",     
            "地板漏水报警", 
            "加湿水电导率高",       
            "加湿电流高",  
            "加湿器运行时间超时",     
            "加湿器维护时间报警",     
            "加湿电流低",  
            "缺水报警",   
            "低蒸气加湿量", 
            "排水报警",   
            "加湿罐满水",  
            "加湿罐损坏报警",       
            "泡沫报警",   
            "加湿罐损坏",  
            "加湿水电导率高",       
            "机组由BMS开/关",     
            "机组可由温度强制启动",    
            "机组可远地开/关",      
            "机组由时间控制开/关",    
            "可根据时区、设定点来控制",  
            "冷凝水泵有效", 
            "有室外温度传感器否",     
            "冷凝水泵过载输入",      
            "冷凝水泵报警", 
            "高压1手动复位",       
            "低压1手动复位",       
            "高压2手动复位",       
            "低压2手动复位",       
            "除湿跟随湿度", 
            "入水温度传感器故障",     
            "出水温度传感器故障",     
            "水流开关故障", 
            "冷却水泵过载", 
            "三通阀故障",  
            "出水温度高提示报警"
        ];
        for($i = 0; $i < 65;$i++) {
            $dataArray[$alertKeyArr[$i]] = $v[$i] == 1 ? "告警" : "正常";
        }
        $AirFilter = $v[1];
        $CLOCK = $v[2];
        $Compressor_1_PressureTransducerFailure = $v[3];
        $Compressor_2_PressureTransducerFailure = $v[4];
        $Customer = $v[5];
        $EvaporatorFanOverload = $v[6];
        $FireDetection = $v[7];
        $HighHumidity = $v[8];
        $HighRoomTemperature = $v[9];
        //rsv 保留一位
        $Compressor_1_HighPressure = $v[11];
        $Compressor_2_HighPressure = $v[12];
        $ExceedsRunningHoursThreshold_Compressor_1 = $v[13];
        $ExceedsRunningHoursThreshold_Compressor_2 = $v[14];
        $ExceedsRunningHoursThreshold_Fan = $v[15];
        $ExceedsRunningHoursThresholdHeater_1 = $v[16];
        $ExceedsRunningHoursThresholdHeater_2 = $v[17];
        $ExceedsRunningHoursThresholdUnit = $v[18];
        $HumidifierPowerFailure = $v[19];
        $LowHumidity = $v[20];
        $LowRoomTemperature = $v[21];
        $UnitOverheat_Heater_Overload = $v[22];
        $pLANDisconnected = $v[23];
        $PowerFailure = $v[24];
        $Compressor_1_HighPressurePrealarm = $v[25];
        $Compressor_2_HighPressurePrealarm = $v[26];
        $PressureDifferential = $v[27];
        $Compressor_1_LowPressure = $v[28];
        $Compressor_2_LowPressure = $v[29];
        $RoomHumiditySensor = $v[30];
        $RoomTemperatureSensor = $v[31];
        $SupplyAirSensor = $v[32];
        $WaterLeakage = $v[33];
        $HighConductivity = $v[34];
        $HighCurrent = $v[35];
        $CylinderMaintenance = $v[36];
        $CylinderMaintenanceWarning = $v[37];
        $LowCurrent = $v[38];
        $LackOfWater = $v[39];
        $LowStreamProduction = $v[40];
        $Drain = $v[41];
        $CylinderFull = $v[42];
        $CylinderExhaustionWarning = $v[43];
        $Foam = $v[44];
        $CylinderExhaustion = $v[45];
        $HighConductivityWarning = $v[46];
        $SystemOn_OffByBMS = $v[47];
        $EnableForceUnitByTemperature = $v[48];
        $EnableOn_OffByDigitalInput = $v[49];
        $EnableScheduleOnOff = $v[50];
        $EnableSetpointChangeAccordingToTime = $v[51];
        $EnableCondenserPump = $v[52];
        $EnableOutdoorTemperatureSensor = $v[53];
        $CondensingPumpOverloadInput = $v[54];
        $CondensingPumpOverloadAlarm = $v[55];
        $Comp1HighReset = $v[56];
        $Comp1LowReset = $v[57];
        $Comp2HighReset = $v[58];
        $Comp2LowReset = $v[59];
        $DehumidBaseOnHumid = $v[60];
        $IntletWaterProbeFault = $v[61];
        $OutletWaterProbeFault = $v[62];
        $WaterFlowAlarm = $v[63];
        $ChillerPumpOL = $v[64];
        $WAYValveWarning = $v[65];
        $OutletWaterTempHighWarning = $v[66];

        $v = unpack('s*', substr($memData, 104, 100));
        //AirSys_reg_2_61_t模拟量
        $dataArray["压缩机1排气压力（Pa）"] = $v[1] / 10;
        $dataArray["压缩机2排气压力（Pa）"] = $v[2] / 10;
        $dataArray["加湿电流（A）"] = $v[3] / 10;
        $dataArray["压缩机1回路的冷凝风机"] = $v[4] / 10;
        $dataArray["压缩机2回路的冷凝风机"] = $v[5] / 10;
        $dataArray["加湿器输出信号（v）"] = $v[6] / 10;
        $dataArray["蒸气产量（kg/h）"] = $v[7] / 10;
        $dataArray["室内回风湿度（%）"] = $v[8] / 10;
        $dataArray["室内回风温度（℃）"] = $v[9] / 10;
        $dataArray["湿度设定点（%）"] = $v[10] / 10;
        $dataArray["温度设定点（℃）"] = $v[11] / 10;
        $dataArray["送风温度（℃）"] = $v[12] / 10;
        $dataArray["高压报警（Pa）"] = $v[13] / 10;
        $dataArray["高压预报警（Pa）"] = $v[14] / 10;
        $dataArray["温度死区范围（℃）"] = $v[15] / 10;
        $dataArray["湿度差（%）"] = $v[16] / 10;
        $dataArray["温度微分时间"] = $v[17] / 10;
        $dataArray["高温时强制启动温差（℃）"] = $v[18] / 10;
        $dataArray["低温时强制启动温差（℃）"] = $v[19] / 10;
        $dataArray["高温时强制启动设置值（℃）"] = $v[20] / 10;
        $dataArray["低温时强制启动设置值（℃）"] = $v[21] / 10;
        $dataArray["室内温度过高报警设定点（℃）"] = $v[22] / 10;
        $dataArray["室内湿度过高报警设定点（%）"] = $v[23] / 10;
        $dataArray["室内湿度过低报警设定点（%）"] = $v[24] / 10;
        $dataArray["室内温度过低报警设定点（℃）"] = $v[25] / 10;
        $dataArray["最大蒸气产量（%）"] = $v[26] / 10;
        $dataArray["湿度设定点（%）"] = $v[27] / 10;
        $dataArray["温度设定点（℃）"] = $v[28] / 10;
        $dataArray["时区1湿度启动设定点（%）"] = $v[29] / 10;
        $dataArray["时区2湿度启动设定点（%）"] = $v[30] / 10;
        $dataArray["时区3湿度启动设定点（%）"] = $v[31] / 10;
        $dataArray["时区4湿度启动设定点（%）"] = $v[32] / 10;
        $dataArray["时区1温度启动设定点（℃）"] = $v[33] / 10;
        $dataArray["时区2温度启动设定点（℃）"] = $v[34] / 10;
        $dataArray["时区3温度启动设定点（℃）"] = $v[35] / 10;
        $dataArray["时区4温度启动设定点（℃）"] = $v[36] / 10;
        $dataArray["自然冷却温差（℃）"] = $v[37] / 10;
        $dataArray["自然冷却极限（℃）"] = $v[38] / 10;
        $dataArray["新风阀最小输出"] = $v[39] / 10;
        $dataArray["制冷阀"] = $v[40] / 10;
        $dataArray["新风阀"] = $v[41] / 10;
        $dataArray["制热阀"] = $v[42] / 10;
        $dataArray["室外温度（℃）"] = $v[43] / 10;
        $dataArray["湿度死区（%）"] = $v[44] / 10;
        $dataArray["除湿死区（%）"] = $v[45] / 10;
        $dataArray["除湿带宽（%）"] = $v[46] / 10;
        $dataArray["加热死区（℃）"] = $v[47] / 10;
        $dataArray["加热带宽（℃）"] = $v[48] / 10;
        $dataArray["入水温度（℃）"] = $v[49] / 10;
        $dataArray["出水温度（℃）"] = $v[50] / 10;
        $v = unpack('s*', substr($memData, 204, 20));
        $dataArray["加湿水电导率"] = $v[1] / 10;
        $v = unpack('v', substr($memData, 204 + 20, 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData,  204 + 20 + 2, 5));
        $dataArray["更新时间"] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}


