<?php
function _amc16z_2ac_ShowAlert(&$dataArray, $label, $value, $vsValue)
{
    $dataArray[$label] = $value == $vsValue ? '正常' : '告警';
    $dataArray['AlertArray'][$label] = $value != $vsValue;
}

//设备类型
function Get_amc16z_2ac_UnicomCategory()
{
    return "406";
}


function Get_amc16z_2ac_RtData($memData, &$dataArray, $extraPara = false){
    if($memData == false){
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    }else{
        $dataArray['无数据'] = false;
        $dataArray['AlertArray'] = array();

        $v = unpack("C*" , substr($memData , 4, 63+6));
        for($i=1;$i<=63;$i++)
        {
            $dataArray["A面分路".$i."开关状态"] = ($v[$i] == 1) ? "打开" : "闭合";
        }
        $dataArray["A面主路开关状态"] = ($v[64] == 1) ? "打开" : "闭合";
        $dataArray["A面防雷器开关状态"] = ($v[65] == 1) ? "打开" : "闭合";
        $dataArray["A面备路开关状态"] = ($v[66] == 1) ? "打开" : "闭合";
        $dataArray["A面跳闸开关状态"] = ($v[67] == 1) ? "打开" : "闭合";
        $dataArray["A面备路跳闸开关状态"] = ($v[68] == 1) ? "打开" : "闭合";
        $dataArray["A面备路防雷器开关状态"] = ($v[69] == 1) ? "打开" : "闭合";

        $v = unpack("C*" , substr($memData , 4 + 63+6, 63+6));
        for($i=1;$i<=63;$i++)
        {
            $dataArray["B面分路".$i."开关状态"] = ($v[$i] == 1) ? "打开" : "闭合";
        }
        $dataArray["B面主路开关状态"] = ($v[64] == 1) ? "打开" : "闭合";
        $dataArray["B面防雷器开关状态"] = ($v[65] == 1) ? "打开" : "闭合";
        $dataArray["B面备路开关状态"] = ($v[66] == 1) ? "打开" : "闭合";
        $dataArray["B面跳闸开关状态"] = ($v[67] == 1) ? "打开" : "闭合";
        $dataArray["B面备路跳闸开关状态"] = ($v[68] == 1) ? "打开" : "闭合";
        $dataArray["B面备路防雷器开关状态"] = ($v[69] == 1) ? "打开" : "闭合";

        $v = unpack("C*" , substr($memData , 4 + 63+6 + 63+6, 25));
        _amc16z_2ac_ShowAlert($dataArray, "A面进线A相电压缺相", $v[1] , 0);
        _amc16z_2ac_ShowAlert($dataArray, "A面进线B相电压缺相", $v[2] , 0);
        _amc16z_2ac_ShowAlert($dataArray, "A面进线C相电压缺相", $v[3] , 0);
        _amc16z_2ac_ShowAlert($dataArray, "A面进线A相电压欠电压", $v[4] , 0);
        _amc16z_2ac_ShowAlert($dataArray, "A面进线B相电压欠电压", $v[5] , 0);
        _amc16z_2ac_ShowAlert($dataArray, "A面进线C相电压欠电压", $v[6] , 0);
        _amc16z_2ac_ShowAlert($dataArray, "A面进线A相电压过电压", $v[7] , 0);
        _amc16z_2ac_ShowAlert($dataArray, "A面进线B相电压过电压", $v[8] , 0);
        _amc16z_2ac_ShowAlert($dataArray, "A面进线C相电压过电压", $v[9] , 0);
        _amc16z_2ac_ShowAlert($dataArray, "A面进线欠频率", $v[10] , 0);
        _amc16z_2ac_ShowAlert($dataArray, "A面进线过频率", $v[11] , 0);
        _amc16z_2ac_ShowAlert($dataArray, "A面进线A相电流过载", $v[12] , 0);
        _amc16z_2ac_ShowAlert($dataArray, "A面进线B相电流过载", $v[13] , 0);
        _amc16z_2ac_ShowAlert($dataArray, "A面进线C相电流过载", $v[14] , 0);
        _amc16z_2ac_ShowAlert($dataArray, "A面进线A相功率过载", $v[15] , 0);
        _amc16z_2ac_ShowAlert($dataArray, "A面进线B相功率过载", $v[16] , 0);
        _amc16z_2ac_ShowAlert($dataArray, "A面进线C相功率过载", $v[17] , 0);
        _amc16z_2ac_ShowAlert($dataArray, "A面FAK48-2#AMC16Z通讯故障", $v[18] , 0);
        _amc16z_2ac_ShowAlert($dataArray, "A面FAK24#AMC16Z通讯故障", $v[19] , 0);
        _amc16z_2ac_ShowAlert($dataArray, "A面ZA2#AMC16Z通讯故障", $v[20] , 0);
        _amc16z_2ac_ShowAlert($dataArray, "A面电流三相不平衡报警", $v[21] , 0);
        _amc16z_2ac_ShowAlert($dataArray, "A面电压三相不平衡报警", $v[22] , 0);
        _amc16z_2ac_ShowAlert($dataArray, "A面进线A相二段电流过载", $v[23] , 0);
        _amc16z_2ac_ShowAlert($dataArray, "A面进线B相二段电流过载", $v[24] , 0);
        _amc16z_2ac_ShowAlert($dataArray, "A面进线C相二段电流过载", $v[25] , 0);

        $v = unpack("C*" , substr($memData , 4 + 63+6 + 63+6 + 25, 25));
        _amc16z_2ac_ShowAlert($dataArray, "B面进线A相电压缺相", $v[1] , 0);
        _amc16z_2ac_ShowAlert($dataArray, "B面进线B相电压缺相", $v[2] , 0);
        _amc16z_2ac_ShowAlert($dataArray, "B面进线C相电压缺相", $v[3] , 0);
        _amc16z_2ac_ShowAlert($dataArray, "B面进线A相电压欠电压", $v[4] , 0);
        _amc16z_2ac_ShowAlert($dataArray, "B面进线B相电压欠电压", $v[5] , 0);
        _amc16z_2ac_ShowAlert($dataArray, "B面进线C相电压欠电压", $v[6] , 0);
        _amc16z_2ac_ShowAlert($dataArray, "B面进线A相电压过电压", $v[7] , 0);
        _amc16z_2ac_ShowAlert($dataArray, "B面进线B相电压过电压", $v[8] , 0);
        _amc16z_2ac_ShowAlert($dataArray, "B面进线C相电压过电压", $v[9] , 0);
        _amc16z_2ac_ShowAlert($dataArray, "B面进线欠频率", $v[10] , 0);
        _amc16z_2ac_ShowAlert($dataArray, "B面进线过频率", $v[11] , 0);
        _amc16z_2ac_ShowAlert($dataArray, "B面进线A相电流过载", $v[12] , 0);
        _amc16z_2ac_ShowAlert($dataArray, "B面进线B相电流过载", $v[13] , 0);
        _amc16z_2ac_ShowAlert($dataArray, "B面进线C相电流过载", $v[14] , 0);
        _amc16z_2ac_ShowAlert($dataArray, "B面进线A相功率过载", $v[15] , 0);
        _amc16z_2ac_ShowAlert($dataArray, "B面进线B相功率过载", $v[16] , 0);
        _amc16z_2ac_ShowAlert($dataArray, "B面进线C相功率过载", $v[17] , 0);
        _amc16z_2ac_ShowAlert($dataArray, "B面ZA1#AMC16Z通讯故障", $v[18] , 0);
        _amc16z_2ac_ShowAlert($dataArray, "B面ZA2#AMC16Z通讯故障", $v[19] , 0);
        _amc16z_2ac_ShowAlert($dataArray, "B面FAK48-1#AMC16Z通讯故障", $v[20] , 0);
        _amc16z_2ac_ShowAlert($dataArray, "B面电流三相不平衡报警", $v[21] , 0);
        _amc16z_2ac_ShowAlert($dataArray, "B面电压三相不平衡报警", $v[22] , 0);
        _amc16z_2ac_ShowAlert($dataArray, "B面进线A相二段电流过载", $v[23] , 0);
        _amc16z_2ac_ShowAlert($dataArray, "B面进线B相二段电流过载", $v[24] , 0);
        _amc16z_2ac_ShowAlert($dataArray, "B面进线C相二段电流过载", $v[25] , 0);

        $v = unpack("C*" , substr($memData , 4 + 63+6 + 63+6 + 25 + 25, 63));
        for($i=1; $i<=63;$i++)
        {            
            _amc16z_2ac_ShowAlert($dataArray, "A面分路".$i."电流过载", $v[$i] , 0);
        }
        $v = unpack("C*" , substr($memData , 4 + 63+6 + 63+6 + 25 + 25 + 63, 63));
        for($i=1; $i<=63;$i++)
        {            
            _amc16z_2ac_ShowAlert($dataArray, "B面分路".$i."电流过载", $v[$i] , 0);
        }
        $v = unpack("C*" , substr($memData , 4 + 63+6 + 63+6 + 25 + 25 + 63 + 63, 69));
        for($i=1; $i<=63;$i++)
        {            
            _amc16z_2ac_ShowAlert($dataArray, "A面分路".$i."开关故障", $v[$i] , 0);
        }
        _amc16z_2ac_ShowAlert($dataArray, "A面主路开关故障", $v[64], 0);
        _amc16z_2ac_ShowAlert($dataArray, "A面防雷器开关故障", $v[65], 0);
        _amc16z_2ac_ShowAlert($dataArray, "A面备路开关故障", $v[66], 0);
        _amc16z_2ac_ShowAlert($dataArray, "A面主路跳闸", $v[67], 0);
        _amc16z_2ac_ShowAlert($dataArray, "A面备路跳闸", $v[68], 0);
        _amc16z_2ac_ShowAlert($dataArray, "A面备路防雷器开关故障", $v[69], 0);
        $v = unpack("C*" , substr($memData , 4 + 63+6 + 63+6 + 25 + 25 + 63 + 63 + 69, 69));
        for($i=1; $i<=63;$i++)
        {            
            _amc16z_2ac_ShowAlert($dataArray, "B面分路".$i."开关故障", $v[$i] , 0);
        }
        _amc16z_2ac_ShowAlert($dataArray, "B面主路开关故障", $v[64], 0);
        _amc16z_2ac_ShowAlert($dataArray, "B面防雷器开关故障", $v[65], 0);
        _amc16z_2ac_ShowAlert($dataArray, "B面备路开关故障", $v[66], 0);
        _amc16z_2ac_ShowAlert($dataArray, "B面主路跳闸", $v[67], 0);
        _amc16z_2ac_ShowAlert($dataArray, "B面备路跳闸", $v[68], 0);
        _amc16z_2ac_ShowAlert($dataArray, "B面备路防雷器开关故障", $v[69], 0);
        $v = unpack("C*" , substr($memData , 4 + 63+6 + 63+6 + 25 + 25 + 63 + 63 + 69 + 69, 63));
        for($i=1; $i<=63;$i++)
        {            
            _amc16z_2ac_ShowAlert($dataArray, "A面分路".$i."二段电流过载", $v[$i] , 0);
        }
        $v = unpack("C*" , substr($memData , 4 + 63+6 + 63+6 + 25 + 25 + 63 + 63 + 69 + 69 + 63, 63));
        for($i=1; $i<=63;$i++)
        {            
            _amc16z_2ac_ShowAlert($dataArray, "B面分路".$i."二段电流过载", $v[$i] , 0);
        }
        $v = unpack("C*" , substr($memData , 4 + 63+6 + 63+6 + 25 + 25 + 63 + 63 + 69 + 69 + 63 + 63, 22));
        _amc16z_2ac_ShowAlert($dataArray, "A面备路A相电压缺相", $v[1], 0);
        _amc16z_2ac_ShowAlert($dataArray, "A面备路B相电压缺相", $v[2], 0);
        _amc16z_2ac_ShowAlert($dataArray, "A面备路C相电压缺相", $v[3], 0);
        _amc16z_2ac_ShowAlert($dataArray, "A面备路A相电压欠电压", $v[4], 0);
        _amc16z_2ac_ShowAlert($dataArray, "A面备路B相电压欠电压", $v[5], 0);
        _amc16z_2ac_ShowAlert($dataArray, "A面备路C相电压欠电压", $v[6], 0);
        _amc16z_2ac_ShowAlert($dataArray, "A面备路A相电压过电压", $v[7], 0);
        _amc16z_2ac_ShowAlert($dataArray, "A面备路B相电压过电压", $v[8], 0);
        _amc16z_2ac_ShowAlert($dataArray, "A面备路C相电压过电压", $v[9], 0);
        _amc16z_2ac_ShowAlert($dataArray, "A面备路欠频率", $v[10], 0);
        _amc16z_2ac_ShowAlert($dataArray, "A面备路过频率", $v[11], 0);
        _amc16z_2ac_ShowAlert($dataArray, "A面备路A相电流过载", $v[12], 0);
        _amc16z_2ac_ShowAlert($dataArray, "A面备路B相电流过载", $v[13], 0);
        _amc16z_2ac_ShowAlert($dataArray, "A面备路C相电流过载", $v[14], 0);
        _amc16z_2ac_ShowAlert($dataArray, "A面备路A相功率过载", $v[15], 0);
        _amc16z_2ac_ShowAlert($dataArray, "A面备路B相功率过载", $v[16], 0);
        _amc16z_2ac_ShowAlert($dataArray, "A面备路C相功率过载", $v[17], 0);

        _amc16z_2ac_ShowAlert($dataArray, "A面电流三相不平衡报警", $v[18], 0);
        _amc16z_2ac_ShowAlert($dataArray, "A面电压三相不平衡报警", $v[19], 0);
        _amc16z_2ac_ShowAlert($dataArray, "A面备路A相二段电流过载", $v[20], 0);
        _amc16z_2ac_ShowAlert($dataArray, "A面备路B相二段电流过载", $v[21], 0);
        _amc16z_2ac_ShowAlert($dataArray, "A面备路C相二段电流过载", $v[22], 0);

        $v = unpack("C*" , substr($memData , 4 + 63+6 + 63+6 + 25 + 25 + 63 + 63 + 69 + 69 + 63 + 63 + 22, 22));
        _amc16z_2ac_ShowAlert($dataArray, "B面备路A相电压缺相", $v[1], 0);
        _amc16z_2ac_ShowAlert($dataArray, "B面备路B相电压缺相", $v[2], 0);
        _amc16z_2ac_ShowAlert($dataArray, "B面备路C相电压缺相", $v[3], 0);
        _amc16z_2ac_ShowAlert($dataArray, "B面备路A相电压欠电压", $v[4], 0);
        _amc16z_2ac_ShowAlert($dataArray, "B面备路B相电压欠电压", $v[5], 0);
        _amc16z_2ac_ShowAlert($dataArray, "B面备路C相电压欠电压", $v[6], 0);
        _amc16z_2ac_ShowAlert($dataArray, "B面备路A相电压过电压", $v[7], 0);
        _amc16z_2ac_ShowAlert($dataArray, "B面备路B相电压过电压", $v[8], 0);
        _amc16z_2ac_ShowAlert($dataArray, "B面备路C相电压过电压", $v[9], 0);
        _amc16z_2ac_ShowAlert($dataArray, "B面备路欠频率", $v[10], 0);
        _amc16z_2ac_ShowAlert($dataArray, "B面备路过频率", $v[11], 0);
        _amc16z_2ac_ShowAlert($dataArray, "B面备路A相电流过载", $v[12], 0);
        _amc16z_2ac_ShowAlert($dataArray, "B面备路B相电流过载", $v[13], 0);
        _amc16z_2ac_ShowAlert($dataArray, "B面备路C相电流过载", $v[14], 0);
        _amc16z_2ac_ShowAlert($dataArray, "B面备路A相功率过载", $v[15], 0);
        _amc16z_2ac_ShowAlert($dataArray, "B面备路B相功率过载", $v[16], 0);
        _amc16z_2ac_ShowAlert($dataArray, "B面备路C相功率过载", $v[17], 0);

        _amc16z_2ac_ShowAlert($dataArray, "B面电流三相不平衡报警", $v[18], 0);
        _amc16z_2ac_ShowAlert($dataArray, "B面电压三相不平衡报警", $v[19], 0);
        _amc16z_2ac_ShowAlert($dataArray, "B面备路A相二段电流过载", $v[20], 0);
        _amc16z_2ac_ShowAlert($dataArray, "B面备路B相二段电流过载", $v[21], 0);
        _amc16z_2ac_ShowAlert($dataArray, "B面备路C相二段电流过载", $v[22], 0);

        $v = unpack("C*" , substr($memData , 4 + 63+6 + 63+6 + 25 + 25 + 63 + 63 + 69 + 69 + 63 + 63 + 22 + 22, 2));
        _amc16z_2ac_ShowAlert($dataArray, "KD2#AMC16Z通讯故障", $v[1], 0);
        _amc16z_2ac_ShowAlert($dataArray, "KD3#AMC16Z通讯故障", $v[2], 0);

        $v = unpack("C*" , substr($memData , 4 + 63+6 + 63+6 + 25 + 25 + 63 + 63 + 69 + 69 + 63 + 63 + 22 + 22 + 2, 60));
        for($i=1; $i<=60; $i++)
        {            
            _amc16z_2ac_ShowAlert($dataArray, "A面分路".$i."SD开关状态", $v[$i] , 0);
        }
        $v = unpack("C*" , substr($memData , 4 + 63+6 + 63+6 + 25 + 25 + 63 + 63 + 69 + 69 + 63 + 63 + 22 + 22 + 2 + 60, 60));
        for($i=1; $i<=60; $i++)
        {            
            _amc16z_2ac_ShowAlert($dataArray, "B面分路".$i."SD开关状态", $v[$i] , 0);
        }
        $v = unpack("C*" , substr($memData , 4 + 63+6 + 63+6 + 25 + 25 + 63 + 63 + 69 + 69 + 63 + 63 + 22 + 22 + 2 + 60 + 60, 60));
        for($i=1; $i<=60; $i++)
        {            
            _amc16z_2ac_ShowAlert($dataArray, "A面分路".$i."SD故障", $v[$i] , 0);
        }
        $v = unpack("C*" , substr($memData , 4 + 63+6 + 63+6 + 25 + 25 + 63 + 63 + 69 + 69 + 63 + 63 + 22 + 22 + 2 + 60 + 60 + 60, 60));
        for($i=1; $i<=60; $i++)
        {            
            _amc16z_2ac_ShowAlert($dataArray, "B面分路".$i."SD故障", $v[$i] , 0);
        }
	//779 state
        $v = unpack("f*" , substr($memData , 4 + 864, 4*44));
        $dataArray["A面进线A相电压"] = number_format($v[1], 2).' V'; 
        $dataArray["A面进线B相电压"] = number_format($v[2], 2).' V'; 
        $dataArray["A面进线C相电压"] = number_format($v[3], 2).' V'; 

        $dataArray["A面进线AB线电压"] = number_format($v[4], 2).' V'; 
        $dataArray["A面进线BC线电压"] = number_format($v[5], 2).' V'; 
        $dataArray["A面进线CA线电压"] = number_format($v[6], 2).' V'; 

        $dataArray["A面进线频率"] = number_format($v[7],2)." Hz";

        $dataArray["A面进线A相电流"] = number_format($v[8]*$v[31], 2); 
        $dataArray["A面进线B相电流"] = number_format($v[9]*$v[32], 2); 
        $dataArray["A面进线C相电流"] = number_format($v[10]*$v[33], 2); 

        $dataArray["A面进线总有功功率"] = number_format($v[11]*$v[31], 2);
        $dataArray["A面进线总无功功率"] = number_format($v[12]*$v[31], 2);
        $dataArray["A面进线总功率因数"] = number_format($v[13], 2);
        $dataArray["A面进线总有功电能"] = number_format($v[14]*$v[31], 2);
        $dataArray["A面进线总无功电能"] = number_format($v[15]*$v[31], 2);
        $dataArray["A面进线A相有功功率"] = number_format($v[16]*$v[31], 2);
        $dataArray["A面进线B相有功功率"] = number_format($v[17]*$v[32], 2);
        $dataArray["A面进线C相有功功率"] = number_format($v[18]*$v[33], 2);
        $dataArray["A面进线A相无功功率"] = number_format($v[19]*$v[31], 2);
        $dataArray["A面进线B相无功功率"] = number_format($v[20]*$v[32], 2);
        $dataArray["A面进线C相无功功率"] = number_format($v[21]*$v[33], 2);
        $dataArray["A面进线A相功率因数"] = number_format($v[22], 2);
        $dataArray["A面进线B相功率因数"] = number_format($v[23], 2);
        $dataArray["A面进线C相功率因数"] = number_format($v[24], 2);
        $dataArray["A面进线A相有功电能"] = number_format($v[25]*$v[31], 2);
        $dataArray["A面进线B相有功电能"] = number_format($v[26]*$v[32], 2);
        $dataArray["A面进线C相有功电能"] = number_format($v[27]*$v[33], 2);
        $dataArray["A面进线A相无功电能"] = number_format($v[28]*$v[31], 2);
        $dataArray["A面进线B相无功电能"] = number_format($v[29]*$v[32], 2);
        $dataArray["A面进线C相无功电能"] = number_format($v[30]*$v[33], 2);
        $dataArray["A面进线A相CT变比"] = $v[31];
        $dataArray["A面进线B相CT变比"] = $v[32];
        $dataArray["A面进线C相CT变比"] = $v[33];
        $dataArray["A面进线总视在功率"] = number_format($v[34]*$v[31], 2);
        $dataArray["A面进线A相视在功率"] = number_format($v[35]*$v[31], 2);
        $dataArray["A面进线B相视在功率"] = number_format($v[36]*$v[32], 2);
        $dataArray["A面进线C相视在功率"] = number_format($v[37]*$v[33], 2);
        $dataArray["A面进线电流三相不平衡度"] = number_format($v[38], 2);
        $dataArray["A面进线电压三相不平衡度"] = number_format($v[39], 2);
        $dataArray["A主零地电压"] = number_format($v[40], 2);
        $dataArray["A主零序电流"] = number_format($v[41], 2);
        $dataArray["温度"] = number_format($v[42], 2);
        $dataArray["湿度"] = number_format($v[43], 2);
        $dataArray["A主漏电流"] = number_format($v[44], 2);
        //+24*12+42*2
        $v = unpack("f*" , substr($memData , 4 + 864 + 4*44, 4*42));
        $dataArray["B面进线A相电压"] = number_format($v[1], 2).' V'; 
        $dataArray["B面进线B相电压"] = number_format($v[2], 2).' V'; 
        $dataArray["B面进线C相电压"] = number_format($v[3], 2).' V'; 

        $dataArray["B面进线AB线电压"] = number_format($v[4], 2).' V'; 
        $dataArray["B面进线BC线电压"] = number_format($v[5], 2).' V'; 
        $dataArray["B面进线CA线电压"] = number_format($v[6], 2).' V'; 

        $dataArray["B面进线频率"] = number_format($v[7],2)." Hz";

        $dataArray["B面进线A相电流"] = number_format($v[8]*$v[31], 2).' A'; 
        $dataArray["B面进线B相电流"] = number_format($v[9]*$v[32], 2).' A'; 
        $dataArray["B面进线C相电流"] = number_format($v[10]*$v[33], 2).' A'; 

        $dataArray["B面进线总有功功率"] = number_format($v[11]*$v[31], 2);
        $dataArray["B面进线总无功功率"] = number_format($v[12]*$v[31], 2);
        $dataArray["B面进线总功率因数"] = number_format($v[13], 2);
        $dataArray["B面进线总有功电能"] = number_format($v[14]*$v[31], 2);
        $dataArray["B面进线总无功电能"] = number_format($v[15]*$v[31], 2);
        $dataArray["B面进线A相有功功率"] = number_format($v[16]*$v[31], 2);
        $dataArray["B面进线B相有功功率"] = number_format($v[17]*$v[32], 2);
        $dataArray["B面进线C相有功功率"] = number_format($v[18]*$v[33], 2);
        $dataArray["B面进线A相无功功率"] = number_format($v[19]*$v[31], 2);
        $dataArray["B面进线B相无功功率"] = number_format($v[20]*$v[32], 2);
        $dataArray["B面进线C相无功功率"] = number_format($v[21]*$v[33], 2);
        $dataArray["B面进线A相功率因数"] = number_format($v[22], 2);
        $dataArray["B面进线B相功率因数"] = number_format($v[23], 2);
        $dataArray["B面进线C相功率因数"] = number_format($v[24], 2);
        $dataArray["B面进线A相有功电能"] = number_format($v[25]*$v[31], 2);
        $dataArray["B面进线B相有功电能"] = number_format($v[26]*$v[32], 2);
        $dataArray["B面进线C相有功电能"] = number_format($v[27]*$v[33], 2);
        $dataArray["B面进线A相无功电能"] = number_format($v[28]*$v[31], 2);
        $dataArray["B面进线B相无功电能"] = number_format($v[29]*$v[32], 2);
        $dataArray["B面进线C相无功电能"] = number_format($v[30]*$v[33], 2);
        $dataArray["B面进线A相CT变比"] = $v[31];
        $dataArray["B面进线B相CT变比"] = $v[32];
        $dataArray["B面进线C相CT变比"] = $v[33];
        $dataArray["B面进线总视在功率"] = number_format($v[34]*$v[31], 2);
        $dataArray["B面进线A相视在功率"] = number_format($v[35]*$v[31], 2);
        $dataArray["B面进线B相视在功率"] = number_format($v[36]*$v[32], 2);
        $dataArray["B面进线C相视在功率"] = number_format($v[37]*$v[31], 2);
        $dataArray["B面进线电流三相不平衡度"] = number_format($v[38], 2);
        $dataArray["B面进线电压三相不平衡度"] = number_format($v[39], 2);
        $dataArray["B主零地电压"] = number_format($v[40], 2);
        $dataArray["B主零序电流"] = number_format($v[41], 2);
        $dataArray["B主漏电流"] = number_format($v[42], 2);

        //先解析电流变比
        $v = unpack("f*" , substr($memData , 4 + 864 + 4*44 + 4*42 + 4*63 + 4*63 + 4*63 + 4*63 + 4*63 + 4*63 + 4*75 + 4*75 + 4*63 + 4*63, 4*63));
        for($i=1;$i<=63;$i++)
        {
            $dataArray["A面分路".$i."电流变比"] = number_format($v[$i], 2);
        }
        $v = unpack("f*" , substr($memData , 4 + 864 + 4*44 + 4*42 + 4*63 + 4*63 + 4*63 + 4*63 + 4*63 + 4*63 + 4*75 + 4*75 + 4*63 + 4*63 + 4*63, 4*63));
        for($i=1;$i<=63;$i++)
        {
            $dataArray["B面分路".$i."电流变比"] = number_format($v[$i], 2);
        }
        
        $v = unpack("f*" , substr($memData , 4 + 864 + 4*44 + 4*42, 4*63));
        for($i=1;$i<=63;$i++)
        {
            $dataArray["A面分路".$i."电流"] = number_format($v[$i]*$dataArray["A面分路".$i."电流变比"], 2);
        }
        $v = unpack("f*" , substr($memData , 4 + 864 + 4*44 + 4*42 + 4*63, 4*63));
        for($i=1;$i<=63;$i++)
        {
            $dataArray["B面分路".$i."电流"] = number_format($v[$i]*$dataArray["B面分路".$i."电流变比"], 2);
        }

        $v = unpack("f*" , substr($memData , 4 + 864 + 4*44 + 4*42 + 4*63 + 4*63, 4*63));
        for($i=1;$i<=63;$i++)
        {
            $dataArray["A面分路".$i."有功功率"] = number_format($v[$i]*$dataArray["A面分路".$i."电流变比"], 2);
        }
        $v = unpack("f*" , substr($memData , 4 + 864 + 4*44 + 4*42 + 4*63 + 4*63 + 4*63, 4*63));
        for($i=1;$i<=63;$i++)
        {
            $dataArray["B面分路".$i."有功功率"] = number_format($v[$i]*$dataArray["B面分路".$i."电流变比"], 2);
        }

        $v = unpack("f*" , substr($memData , 4 + 864 + 4*44 + 4*42 + 4*63 + 4*63 + 4*63 + 4*63, 4*63));
        for($i=1;$i<=63;$i++)
        {
            $dataArray["A面分路".$i."有功电能"] = number_format($v[$i]*$dataArray["A面分路".$i."电流变比"], 2);
        }
        $v = unpack("f*" , substr($memData , 4 + 864 + 4*44 + 4*42 + 4*63 + 4*63 + 4*63 + 4*63 + 4*63, 4*63));
        for($i=1;$i<=63 ;$i++)
        {
            $dataArray["B面分路".$i."有功电能"] = number_format($v[$i]*$dataArray["B面分路".$i."电流变比"], 2);
        }

        $v = unpack("f*" , substr($memData , 4 + 864 + 4*44 + 4*42 + 4*63 + 4*63 + 4*63 + 4*63 + 4*63 + 4*63, 4*75));
        for($i=1;$i<=63;$i++)
        {
            $dataArray["A面分路".$i."电流总谐波"] = number_format($v[$i], 2);
        }
        $dataArray["A面进线A相电压总谐波"] = number_format($v[64], 2);
        $dataArray["A面进线B相电压总谐波"] = number_format($v[65], 2);
        $dataArray["A面进线C相电压总谐波"] = number_format($v[66], 2);
        $dataArray["A面进线A相电流总谐波"] = number_format($v[67], 2);
        $dataArray["A面进线B相电流总谐波"] = number_format($v[68], 2);
        $dataArray["A面进线C相电流总谐波"] = number_format($v[69], 2);
        $dataArray["A面备路A相电压总谐波"] = number_format($v[70], 2);
        $dataArray["A面备路B相电压总谐波"] = number_format($v[71], 2);
        $dataArray["A面备路C相电压总谐波"] = number_format($v[72], 2);
        $dataArray["A面备路A相电流总谐波"] = number_format($v[73], 2);
        $dataArray["A面备路B相电流总谐波"] = number_format($v[74], 2);
        $dataArray["A面备路C相电流总谐波"] = number_format($v[75], 2);

        $v = unpack("f*" , substr($memData , 4 + 864 + 4*44 + 4*42 + 4*63 + 4*63 + 4*63 + 4*63 + 4*63 + 4*63 + 4*75, 4*75));
        for($i=1;$i<=63;$i++)
        {
            $dataArray["B面分路".$i."电流总谐波"] = number_format($v[$i], 2);
        }
        $dataArray["B面进线A相电压总谐波"] = number_format($v[64], 2);
        $dataArray["B面进线B相电压总谐波"] = number_format($v[65], 2);
        $dataArray["B面进线C相电压总谐波"] = number_format($v[66], 2);
        $dataArray["B面进线A相电流总谐波"] = number_format($v[67], 2);
        $dataArray["B面进线B相电流总谐波"] = number_format($v[68], 2);
        $dataArray["B面进线C相电流总谐波"] = number_format($v[69], 2);
        $dataArray["B面备路A相电压总谐波"] = number_format($v[70], 2);
        $dataArray["B面备路B相电压总谐波"] = number_format($v[71], 2);
        $dataArray["B面备路C相电压总谐波"] = number_format($v[72], 2);
        $dataArray["B面备路A相电流总谐波"] = number_format($v[73], 2);
        $dataArray["B面备路B相电流总谐波"] = number_format($v[74], 2);
        $dataArray["B面备路C相电流总谐波"] = number_format($v[75], 2);

        $v = unpack("f*" , substr($memData , 4 + 864 + 4*44 + 4*42 + 4*63 + 4*63 + 4*63 + 4*63 + 4*63 + 4*63 + 4*75 + 4*75, 4*63));
        for($i=1;$i<=63;$i++)
        {
            $dataArray["A面分路".$i."电压"] = number_format($v[$i], 2);
        }
        $v = unpack("f*" , substr($memData , 4 + 864 + 4*44 + 4*42 + 4*63 + 4*63 + 4*63 + 4*63 + 4*63 + 4*63 + 4*75 + 4*75 + 4*63, 4*63));
        for($i=1;$i<=63;$i++)
        {
            $dataArray["B面分路".$i."电压"] = number_format($v[$i], 2);
        }
        //电流变比需要上提
        // $v = unpack("f*" , substr($memData , 4 + 864 + 4*44 + 4*42 + 4*63 + 4*63 + 4*63 + 4*63 + 4*63 + 4*63 + 4*75 + 4*75 + 4*63 + 4*63, 4*63));
        // for($i=1;$i<=63;$i++)
        // {
        //     $dataArray["A面分路".$i."电流变比"] = number_format($v[$i], 2);
        // }
        // $v = unpack("f*" , substr($memData , 4 + 864 + 4*44 + 4*42 + 4*63 + 4*63 + 4*63 + 4*63 + 4*63 + 4*63 + 4*75 + 4*75 + 4*63 + 4*63 + 4*63, 4*63));
        // for($i=1;$i<=63;$i++)
        // {
        //     $dataArray["B面分路".$i."电流变比"] = number_format($v[$i], 2);
        // }

        //备路解析需要上提
        $v = unpack("f*" , substr($memData , 4 + 864 + 4*44 + 4*42 + 4*63 + 4*63 + 4*63 + 4*63 + 4*63 + 4*63 + 4*75 + 4*75 + 4*63 + 4*63 + 4*63 + 4*63 + 4*42 + 4*42 + 4*42 + 4*42, 4*42));
       
        $dataArray["A面备路A相电压"] = number_format($v[1], 2);
        $dataArray["A面备路B相电压"] = number_format($v[2], 2);
        $dataArray["A面备路C相电压"] = number_format($v[3], 2);
        $dataArray["A面备路AB线电压"] = number_format($v[4], 2);
        $dataArray["A面备路BC线电压"] = number_format($v[5], 2);
        $dataArray["A面备路CA线电压"] = number_format($v[6], 2);
        $dataArray["A面备路频率"] = number_format($v[7], 2);
        $dataArray["A面备路A相电流"] = number_format($v[8], 2);
        $dataArray["A面备路B相电流"] = number_format($v[9], 2);
        $dataArray["A面备路C相电流"] = number_format($v[10], 2);
        $dataArray["A面备路总有功功率"] = number_format($v[11]*$v[31], 2);
        $dataArray["A面备路总无功功率"] = number_format($v[12]*$v[31], 2);
        $dataArray["A面备路总功率因数"] = number_format($v[13], 2);
        $dataArray["A面备路总有功电能"] = number_format($v[14]*$v[31], 2);
        $dataArray["A面备路总无功电能"] = number_format($v[15]*$v[31], 2);
        $dataArray["A面备路A相有功功率"] = number_format($v[16]*$v[31], 2);
        $dataArray["A面备路B相有功功率"] = number_format($v[17]*$v[32], 2);
        $dataArray["A面备路C相有功功率"] = number_format($v[18]*$v[33], 2);
        $dataArray["A面备路A相无功功率"] = number_format($v[19]*$v[31], 2);
        $dataArray["A面备路B相无功功率"] = number_format($v[20]*$v[32], 2);
        $dataArray["A面备路C相无功功率"] = number_format($v[21]*$v[33], 2);
        $dataArray["A面备路A相功率因数"] = number_format($v[22], 2);
        $dataArray["A面备路B相功率因数"] = number_format($v[23], 2);
        $dataArray["A面备路C相功率因数"] = number_format($v[24], 2);
        $dataArray["A面备路A相有功电能"] = number_format($v[25]*$v[31], 2);
        $dataArray["A面备路B相有功电能"] = number_format($v[26]*$v[32], 2);
        $dataArray["A面备路C相有功电能"] = number_format($v[27]*$v[33], 2);
        $dataArray["A面备路A相无功电能"] = number_format($v[28]*$v[31], 2);
        $dataArray["A面备路B相无功电能"] = number_format($v[29]*$v[32], 2);
        $dataArray["A面备路C相无功电能"] = number_format($v[30]*$v[33], 2);
        $dataArray["A面备路A相CT变比"] = $v[31];
        $dataArray["A面备路B相CT变比"] = $v[32];
        $dataArray["A面备路C相CT变比"] = $v[33];
        $dataArray["A面备路总视在功率"] = number_format($v[34], 2);
        $dataArray["A面备路A相视在功率"] = number_format($v[35], 2);
        $dataArray["A面备路B相视在功率"] = number_format($v[36], 2);
        $dataArray["A面备路C相视在功率"] = number_format($v[37], 2);
        $dataArray["A面备路电流三相不平衡度"] = number_format($v[38], 2);
        $dataArray["A面备路电压三相不平衡度"] = number_format($v[39], 2);
        $dataArray["A备零地电压"] = number_format($v[40], 2);
        $dataArray["A备零序电流"] = number_format($v[41], 2);
        $dataArray["A备漏电流"] = number_format($v[42], 2);

        $v = unpack("f*" , substr($memData , 4 + 864 + 4*44 + 4*42 + 4*63 + 4*63 + 4*63 + 4*63 + 4*63 + 4*63 + 4*75 + 4*75 + 4*63 + 4*63 + 4*63 + 4*63 + 4*42 + 4*42 + 4*42 + 4*42 + 4*42, 4*42));
       
        $dataArray["B面备路A相电压"] = number_format($v[1], 2);
        $dataArray["B面备路B相电压"] = number_format($v[2], 2);
        $dataArray["B面备路C相电压"] = number_format($v[3], 2);
        $dataArray["B面备路AB线电压"] = number_format($v[4], 2);
        $dataArray["B面备路BC线电压"] = number_format($v[5], 2);
        $dataArray["B面备路CA线电压"] = number_format($v[6], 2);
        $dataArray["B面备路频率"] = number_format($v[7], 2);
        $dataArray["B面备路A相电流"] = number_format($v[8], 2);
        $dataArray["B面备路B相电流"] = number_format($v[9], 2);
        $dataArray["B面备路C相电流"] = number_format($v[10], 2);
        $dataArray["B面备路总有功功率"] = number_format($v[11]*$v[31], 2);
        $dataArray["B面备路总无功功率"] = number_format($v[12]*$v[31], 2);
        $dataArray["B面备路总功率因数"] = number_format($v[13], 2);
        $dataArray["B面备路总有功电能"] = number_format($v[14]*$v[31], 2);
        $dataArray["B面备路总无功电能"] = number_format($v[15]*$v[31], 2);
        $dataArray["B面备路A相有功功率"] = number_format($v[16]*$v[31], 2);
        $dataArray["B面备路B相有功功率"] = number_format($v[17]*$v[32], 2);
        $dataArray["B面备路C相有功功率"] = number_format($v[18]*$v[33], 2);
        $dataArray["B面备路A相无功功率"] = number_format($v[19]*$v[31], 2);
        $dataArray["B面备路B相无功功率"] = number_format($v[20]*$v[32], 2);
        $dataArray["B面备路C相无功功率"] = number_format($v[21]*$v[33], 2);
        $dataArray["B面备路A相功率因数"] = number_format($v[22], 2);
        $dataArray["B面备路B相功率因数"] = number_format($v[23], 2);
        $dataArray["B面备路C相功率因数"] = number_format($v[24], 2);
        $dataArray["B面备路A相有功电能"] = number_format($v[25]*$v[31], 2);
        $dataArray["B面备路B相有功电能"] = number_format($v[26]*$v[32], 2);
        $dataArray["B面备路C相有功电能"] = number_format($v[27]*$v[33], 2);
        $dataArray["B面备路A相无功电能"] = number_format($v[28]*$v[31], 2);
        $dataArray["B面备路B相无功电能"] = number_format($v[29]*$v[32], 2);
        $dataArray["B面备路C相无功电能"] = number_format($v[30]*$v[33], 2);
        $dataArray["B面备路A相CT变比"] = $v[31];
        $dataArray["B面备路B相CT变比"] = $v[32];
        $dataArray["B面备路C相CT变比"] = $v[33];
        $dataArray["B面备路总视在功率"] = number_format($v[34]*$v[31], 2);
        $dataArray["B面备路A相视在功率"] = number_format($v[35]*$v[31], 2);
        $dataArray["B面备路B相视在功率"] = number_format($v[36]*$v[31], 2);
        $dataArray["B面备路C相视在功率"] = number_format($v[37]*$v[31], 2);
        $dataArray["B面备路电流三相不平衡度"] = number_format($v[38], 2);
        $dataArray["B面备路电压三相不平衡度"] = number_format($v[39], 2);
        $dataArray["B备零地电压"] = number_format($v[40], 2);
        $dataArray["B备零序电流"] = number_format($v[41], 2);
        $dataArray["B备漏电流"] = number_format($v[42], 2);

        $v = unpack("f*" , substr($memData , 4 + 864 + 4*44 + 4*42 + 4*63 + 4*63 + 4*63 + 4*63 + 4*63 + 4*63 + 4*75 + 4*75 + 4*63 + 4*63 + 4*63 + 4*63, 4*42));
        $dataArray["A面进线A相电流最大需量"] = number_format($v[1]*$dataArray["A面进线A相CT变比"], 2);
        $dataArray["A面进线A相电流最大需量年"] = number_format($v[2], 2);
        $dataArray["A面进线A相电流最大需量月"] = number_format($v[3], 2);
        $dataArray["A面进线A相电流最大需量日"] = number_format($v[4], 2);
        $dataArray["A面进线A相电流最大需量时"] = number_format($v[5], 2);
        $dataArray["A面进线A相电流最大需量分"] = number_format($v[6], 2);
        $dataArray["A面进线A相电流最大需量秒"] = number_format($v[7], 2);
        $dataArray["A面进线B相电流最大需量"] = number_format($v[8]*$dataArray["A面进线B相CT变比"], 2);
        $dataArray["A面进线B相电流最大需量年"] = number_format($v[9], 2);
        $dataArray["A面进线B相电流最大需量月"] = number_format($v[10], 2);
        $dataArray["A面进线B相电流最大需量日"] = number_format($v[11], 2);
        $dataArray["A面进线B相电流最大需量时"] = number_format($v[12], 2);
        $dataArray["A面进线B相电流最大需量分"] = number_format($v[13], 2);
        $dataArray["A面进线B相电流最大需量秒"] = number_format($v[14], 2);
        $dataArray["A面进线C相电流最大需量"] = number_format($v[15]*$dataArray["A面进线C相CT变比"], 2);
        $dataArray["A面进线C相电流最大需量年"] = number_format($v[16], 2);
        $dataArray["A面进线C相电流最大需量月"] = number_format($v[17], 2);
        $dataArray["A面进线C相电流最大需量日"] = number_format($v[18], 2);
        $dataArray["A面进线C相电流最大需量时"] = number_format($v[19], 2);
        $dataArray["A面进线C相电流最大需量分"] = number_format($v[20], 2);
        $dataArray["A面进线C相电流最大需量秒"] = number_format($v[21], 2);
        $dataArray["A面进线A相功率最大需量"] = number_format($v[22]*$dataArray["A面进线A相CT变比"], 2);
        $dataArray["A面进线A相功率最大需量年"] = number_format($v[23], 2);
        $dataArray["A面进线A相功率最大需量月"] = number_format($v[24], 2);
        $dataArray["A面进线A相功率最大需量日"] = number_format($v[25], 2);
        $dataArray["A面进线A相功率最大需量时"] = number_format($v[26], 2);
        $dataArray["A面进线A相功率最大需量分"] = number_format($v[27], 2);
        $dataArray["A面进线A相功率最大需量秒"] = number_format($v[28], 2);
        $dataArray["A面进线B相功率最大需量"] = number_format($v[29]*$dataArray["A面进线B相CT变比"], 2);
        $dataArray["A面进线B相功率最大需量年"] = number_format($v[30], 2);
        $dataArray["A面进线B相功率最大需量月"] = number_format($v[31], 2);
        $dataArray["A面进线B相功率最大需量日"] = number_format($v[32], 2);
        $dataArray["A面进线B相功率最大需量时"] = number_format($v[33], 2);
        $dataArray["A面进线B相功率最大需量分"] = number_format($v[34], 2);
        $dataArray["A面进线B相功率最大需量秒"] = number_format($v[35], 2);
        $dataArray["A面进线C相功率最大需量"] = number_format($v[36]*$dataArray["A面进线C相CT变比"], 2);
        $dataArray["A面进线C相功率最大需量年"] = number_format($v[37], 2);
        $dataArray["A面进线C相功率最大需量月"] = number_format($v[38], 2);
        $dataArray["A面进线C相功率最大需量日"] = number_format($v[39], 2);
        $dataArray["A面进线C相功率最大需量时"] = number_format($v[40], 2);
        $dataArray["A面进线C相功率最大需量分"] = number_format($v[41], 2);
        $dataArray["A面进线C相功率最大需量秒"] = number_format($v[42], 2);

        $v = unpack("f*" , substr($memData , 4 + 864 + 4*44 + 4*42 + 4*63 + 4*63 + 4*63 + 4*63 + 4*63 + 4*63 + 4*75 + 4*75 + 4*63 + 4*63 + 4*63 + 4*63 + 4*42, 4*42));
        $dataArray["A面备路A相电流最大需量"] = number_format($v[1]*$dataArray["A面备路A相CT变比"], 2);
        $dataArray["A面备路A相电流最大需量年"] = number_format($v[2], 2);
        $dataArray["A面备路A相电流最大需量月"] = number_format($v[3], 2);
        $dataArray["A面备路A相电流最大需量日"] = number_format($v[4], 2);
        $dataArray["A面备路A相电流最大需量时"] = number_format($v[5], 2);
        $dataArray["A面备路A相电流最大需量分"] = number_format($v[6], 2);
        $dataArray["A面备路A相电流最大需量秒"] = number_format($v[7], 2);
        $dataArray["A面备路B相电流最大需量"] = number_format($v[8]*$dataArray["A面备路B相CT变比"], 2);
        $dataArray["A面备路B相电流最大需量年"] = number_format($v[9], 2);
        $dataArray["A面备路B相电流最大需量月"] = number_format($v[10], 2);
        $dataArray["A面备路B相电流最大需量日"] = number_format($v[11], 2);
        $dataArray["A面备路B相电流最大需量时"] = number_format($v[12], 2);
        $dataArray["A面备路B相电流最大需量分"] = number_format($v[13], 2);
        $dataArray["A面备路B相电流最大需量秒"] = number_format($v[14], 2);
        $dataArray["A面备路C相电流最大需量"] = number_format($v[15]*$dataArray["A面备路C相CT变比"], 2);
        $dataArray["A面备路C相电流最大需量年"] = number_format($v[16], 2);
        $dataArray["A面备路C相电流最大需量月"] = number_format($v[17], 2);
        $dataArray["A面备路C相电流最大需量日"] = number_format($v[18], 2);
        $dataArray["A面备路C相电流最大需量时"] = number_format($v[19], 2);
        $dataArray["A面备路C相电流最大需量分"] = number_format($v[20], 2);
        $dataArray["A面备路C相电流最大需量秒"] = number_format($v[21], 2);
        $dataArray["A面备路A相功率最大需量"] = number_format($v[22]*$dataArray["A面备路A相CT变比"], 2);
        $dataArray["A相备路功率最大需量年"] = number_format($v[23], 2);
        $dataArray["A面备路A相功率最大需量月"] = number_format($v[24], 2);
        $dataArray["A面备路A相功率最大需量日"] = number_format($v[25], 2);
        $dataArray["A面备路A相功率最大需量时"] = number_format($v[26], 2);
        $dataArray["A面备路A相功率最大需量分"] = number_format($v[27], 2);
        $dataArray["A面备路A相功率最大需量秒"] = number_format($v[28], 2);
        $dataArray["A面备路B相功率最大需量"] = number_format($v[29]*$dataArray["A面备路B相CT变比"], 2);
        $dataArray["A面备路B相功率最大需量年"] = number_format($v[30], 2);
        $dataArray["A面备路B相功率最大需量月"] = number_format($v[31], 2);
        $dataArray["A面备路B相功率最大需量日"] = number_format($v[32], 2);
        $dataArray["A面备路B相功率最大需量时"] = number_format($v[33], 2);
        $dataArray["A面备路B相功率最大需量分"] = number_format($v[34], 2);
        $dataArray["A面备路B相功率最大需量秒"] = number_format($v[35], 2);
        $dataArray["A面备路C相功率最大需量"] = number_format($v[36]*$dataArray["A面备路C相CT变比"], 2);
        $dataArray["A面备路C相功率最大需量年"] = number_format($v[37], 2);
        $dataArray["A面备路C相功率最大需量月"] = number_format($v[38], 2);
        $dataArray["A面备路C相功率最大需量日"] = number_format($v[39], 2);
        $dataArray["A面备路C相功率最大需量时"] = number_format($v[40], 2);
        $dataArray["A面备路C相功率最大需量分"] = number_format($v[41], 2);
        $dataArray["A面备路C相功率最大需量秒"] = number_format($v[42], 2);
      
        $v = unpack("f*" , substr($memData , 4 + 864 + 4*44 + 4*42 + 4*63 + 4*63 + 4*63 + 4*63 + 4*63 + 4*63 + 4*75 + 4*75 + 4*63 + 4*63 + 4*63 + 4*63 + 4*42 + 4*42, 4*42));
        $dataArray["B面进线A相电流最大需量"] = number_format($v[1]*$dataArray["B面进线A相CT变比"], 2);
        $dataArray["B面进线A相电流最大需量年"] = number_format($v[2], 2);
        $dataArray["B面进线A相电流最大需量月"] = number_format($v[3], 2);
        $dataArray["B面进线A相电流最大需量日"] = number_format($v[4], 2);
        $dataArray["B面进线A相电流最大需量时"] = number_format($v[5], 2);
        $dataArray["B面进线A相电流最大需量分"] = number_format($v[6], 2);
        $dataArray["B面进线A相电流最大需量秒"] = number_format($v[7], 2);
        $dataArray["B面进线B相电流最大需量"] = number_format($v[8]*$dataArray["B面进线B相CT变比"], 2);
        $dataArray["B面进线B相电流最大需量年"] = number_format($v[9], 2);
        $dataArray["B面进线B相电流最大需量月"] = number_format($v[10], 2);
        $dataArray["B面进线B相电流最大需量日"] = number_format($v[11], 2);
        $dataArray["B面进线B相电流最大需量时"] = number_format($v[12], 2);
        $dataArray["B面进线B相电流最大需量分"] = number_format($v[13], 2);
        $dataArray["B面进线B相电流最大需量秒"] = number_format($v[14], 2);
        $dataArray["B面进线C相电流最大需量"] = number_format($v[15]*$dataArray["B面进线C相CT变比"], 2);
        $dataArray["B面进线C相电流最大需量年"] = number_format($v[16], 2);
        $dataArray["B面进线C相电流最大需量月"] = number_format($v[17], 2);
        $dataArray["B面进线C相电流最大需量日"] = number_format($v[18], 2);
        $dataArray["B面进线C相电流最大需量时"] = number_format($v[19], 2);
        $dataArray["B面进线C相电流最大需量分"] = number_format($v[20], 2);
        $dataArray["B面进线C相电流最大需量秒"] = number_format($v[21], 2);
        $dataArray["B面进线A相功率最大需量"] = number_format($v[22]*$dataArray["B面进线A相CT变比"], 2);
        $dataArray["B面进线A相功率最大需量年"] = number_format($v[23], 2);
        $dataArray["B面进线A相功率最大需量月"] = number_format($v[24], 2);
        $dataArray["B面进线A相功率最大需量日"] = number_format($v[25], 2);
        $dataArray["B面进线A相功率最大需量时"] = number_format($v[26], 2);
        $dataArray["B面进线A相功率最大需量分"] = number_format($v[27], 2);
        $dataArray["B面进线A相功率最大需量秒"] = number_format($v[28], 2);
        $dataArray["B面进线B相功率最大需量"] = number_format($v[29]*$dataArray["B面进线B相CT变比"], 2);
        $dataArray["B面进线B相功率最大需量年"] = number_format($v[30], 2);
        $dataArray["B面进线B相功率最大需量月"] = number_format($v[31], 2);
        $dataArray["B面进线B相功率最大需量日"] = number_format($v[32], 2);
        $dataArray["B面进线B相功率最大需量时"] = number_format($v[33], 2);
        $dataArray["B面进线B相功率最大需量分"] = number_format($v[34], 2);
        $dataArray["B面进线B相功率最大需量秒"] = number_format($v[35], 2);
        $dataArray["B面进线C相功率最大需量"] = number_format($v[36]*$dataArray["B面进线C相CT变比"], 2);
        $dataArray["B面进线C相功率最大需量年"] = number_format($v[37], 2);
        $dataArray["B面进线C相功率最大需量月"] = number_format($v[38], 2);
        $dataArray["B面进线C相功率最大需量日"] = number_format($v[39], 2);
        $dataArray["B面进线C相功率最大需量时"] = number_format($v[40], 2);
        $dataArray["B面进线C相功率最大需量分"] = number_format($v[41], 2);
        $dataArray["B面进线C相功率最大需量秒"] = number_format($v[42], 2);

        $v = unpack("f*" , substr($memData , 4 + 864 + 4*44 + 4*42 + 4*63 + 4*63 + 4*63 + 4*63 + 4*63 + 4*63 + 4*75 + 4*75 + 4*63 + 4*63 + 4*63 + 4*63 + 4*42 + 4*42 + 4*42, 4*42));
        $dataArray["B面备路A相电流最大需量"] = number_format($v[1]*$dataArray["B面备路A相CT变比"], 2);
        $dataArray["B面备路A相电流最大需量年"] = number_format($v[2], 2);
        $dataArray["B面备路A相电流最大需量月"] = number_format($v[3], 2);
        $dataArray["B面备路A相电流最大需量日"] = number_format($v[4], 2);
        $dataArray["B面备路A相电流最大需量时"] = number_format($v[5], 2);
        $dataArray["B面备路A相电流最大需量分"] = number_format($v[6], 2);
        $dataArray["B面备路A相电流最大需量秒"] = number_format($v[7], 2);
        $dataArray["B面备路B相电流最大需量"] = number_format($v[8]*$dataArray["B面备路B相CT变比"], 2);
        $dataArray["B面备路B相电流最大需量年"] = number_format($v[9], 2);
        $dataArray["B面备路B相电流最大需量月"] = number_format($v[10], 2);
        $dataArray["B面备路B相电流最大需量日"] = number_format($v[11], 2);
        $dataArray["B面备路B相电流最大需量时"] = number_format($v[12], 2);
        $dataArray["B面备路B相电流最大需量分"] = number_format($v[13], 2);
        $dataArray["B面备路B相电流最大需量秒"] = number_format($v[14], 2);
        $dataArray["B面备路C相电流最大需量"] = number_format($v[15]*$dataArray["B面备路C相CT变比"], 2);
        $dataArray["B面备路C相电流最大需量年"] = number_format($v[16], 2);
        $dataArray["B面备路C相电流最大需量月"] = number_format($v[17], 2);
        $dataArray["B面备路C相电流最大需量日"] = number_format($v[18], 2);
        $dataArray["B面备路C相电流最大需量时"] = number_format($v[19], 2);
        $dataArray["B面备路C相电流最大需量分"] = number_format($v[20], 2);
        $dataArray["B面备路C相电流最大需量秒"] = number_format($v[21], 2);
        $dataArray["B面备路A相功率最大需量"] = number_format($v[22]*$dataArray["B面备路A相CT变比"], 2);
        $dataArray["B相备路功率最大需量年"] = number_format($v[23], 2);
        $dataArray["B面备路A相功率最大需量月"] = number_format($v[24], 2);
        $dataArray["B面备路A相功率最大需量日"] = number_format($v[25], 2);
        $dataArray["B面备路A相功率最大需量时"] = number_format($v[26], 2);
        $dataArray["B面备路A相功率最大需量分"] = number_format($v[27], 2);
        $dataArray["B面备路A相功率最大需量秒"] = number_format($v[28], 2);
        $dataArray["B面备路B相功率最大需量"] = number_format($v[29]*$dataArray["B面备路B相CT变比"], 2);
        $dataArray["B面备路B相功率最大需量年"] = number_format($v[30], 2);
        $dataArray["B面备路B相功率最大需量月"] = number_format($v[31], 2);
        $dataArray["B面备路B相功率最大需量日"] = number_format($v[32], 2);
        $dataArray["B面备路B相功率最大需量时"] = number_format($v[33], 2);
        $dataArray["B面备路B相功率最大需量分"] = number_format($v[34], 2);
        $dataArray["B面备路B相功率最大需量秒"] = number_format($v[35], 2);
        $dataArray["B面备路C相功率最大需量"] = number_format($v[36]*$dataArray["B面备路C相CT变比"], 2);
        $dataArray["B面备路C相功率最大需量年"] = number_format($v[37], 2);
        $dataArray["B面备路C相功率最大需量月"] = number_format($v[38], 2);
        $dataArray["B面备路C相功率最大需量日"] = number_format($v[39], 2);
        $dataArray["B面备路C相功率最大需量时"] = number_format($v[40], 2);
        $dataArray["B面备路C相功率最大需量分"] = number_format($v[41], 2);
        $dataArray["B面备路C相功率最大需量秒"] = number_format($v[42], 2);
        
        $offset = 4 + 864 + 4*44 + 4*42 + 4*63 + 4*63 + 4*63 + 4*63 + 4*63 + 4*63 + 4*75 + 4*75 + 4*63 + 4*63 + 4*63 + 4*63 + 4*42 + 4*42 + 4*42 + 4*42 + 4*42 +4*42;
        $v = unpack('v', substr($memData, $offset , 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData, $offset + 2 , 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}
