<?php
function _amc16z_2dc_ShowAlert(&$dataArray, $label, $value, $vsValue)
{
    $dataArray[$label] = $value == $vsValue ? '正常' : '告警';
    $dataArray['AlertArray'][$label] = $value != $vsValue;
}

//设备类型
function Get_amc16z_2dc_UnicomCategory()
{
    return "406";
}


function Get_amc16z_2dc_RtData($memData, &$dataArray, $extraPara = false){
    if($memData == false){
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    }else{
        $dataArray['无数据'] = false;
        $dataArray['AlertArray'] = array();

        $v = unpack("C*" , substr($memData , 4, 63+6));
        for($i=1;$i<=63;$i++)
        {
            $dataArray["A面分路".$i."开关状态"] = ($v[$i] == 1) ? "打开" : "闭合";
        }
        $dataArray["A面主路开关状态"] = ($v[64] == 1) ? "打开" : "闭合";
        $dataArray["A面防雷器开关状态"] = ($v[65] == 1) ? "打开" : "闭合";
        $dataArray["A面备路开关状态"] = ($v[66] == 1) ? "打开" : "闭合";
        $dataArray["A面跳闸开关状态"] = ($v[67] == 1) ? "打开" : "闭合";
        $dataArray["A面备路跳闸开关状态"] = ($v[68] == 1) ? "打开" : "闭合";
        $dataArray["A面备路防雷器开关状态"] = ($v[69] == 1) ? "打开" : "闭合";

        $v = unpack("C*" , substr($memData , 4 + 63+6, 63+6));
        for($i=1;$i<=63;$i++)
        {
            $dataArray["B面分路".$i."开关状态"] = ($v[$i] == 1) ? "打开" : "闭合";
        }
        $dataArray["B面主路开关状态"] = ($v[64] == 1) ? "打开" : "闭合";
        $dataArray["B面防雷器开关状态"] = ($v[65] == 1) ? "打开" : "闭合";
        $dataArray["B面备路开关状态"] = ($v[66] == 1) ? "打开" : "闭合";
        $dataArray["B面跳闸开关状态"] = ($v[67] == 1) ? "打开" : "闭合";
        $dataArray["B面备路跳闸开关状态"] = ($v[68] == 1) ? "打开" : "闭合";
        $dataArray["B面备路防雷器开关状态"] = ($v[69] == 1) ? "打开" : "闭合";

        $v = unpack("C*" , substr($memData , 4 + 63+6 + 63+6, 25));

        _amc16z_2dc_ShowAlert($dataArray, "A面进线A相电压欠电压", $v[4] , 0);

        _amc16z_2dc_ShowAlert($dataArray, "A面进线A相电压过电压", $v[7] , 0);
        
        _amc16z_2dc_ShowAlert($dataArray, "A面进线A相电流过载", $v[12] , 0);
        
        _amc16z_2dc_ShowAlert($dataArray, "A面进线A相功率过载", $v[15] , 0);
        
        _amc16z_2dc_ShowAlert($dataArray, "A面FAK48-1通讯故障", $v[18] , 0);
        _amc16z_2dc_ShowAlert($dataArray, "A面ZD2通讯故障", $v[19] , 0);
        _amc16z_2dc_ShowAlert($dataArray, "A面ZJY通讯故障", $v[20] , 0);
        
        _amc16z_2dc_ShowAlert($dataArray, "A面进线A相二段电流过载", $v[23] , 0);

        $v = unpack("C*" , substr($memData , 4 + 63+6 + 63+6 + 25, 25));
        _amc16z_2dc_ShowAlert($dataArray, "B面进线A相电压欠电压", $v[4] , 0);
        
        _amc16z_2dc_ShowAlert($dataArray, "B面进线A相电压过电压", $v[7] , 0);
        

        
        _amc16z_2dc_ShowAlert($dataArray, "B面进线A相电流过载", $v[12] , 0);
        
        _amc16z_2dc_ShowAlert($dataArray, "B面进线A相功率过载", $v[15] , 0);
        
        _amc16z_2dc_ShowAlert($dataArray, "B面ZD1通讯故障", $v[18] , 0);
        _amc16z_2dc_ShowAlert($dataArray, "B面FDK48-2通讯故障", $v[19] , 0);
        _amc16z_2dc_ShowAlert($dataArray, "B面FDK24-3通讯故障", $v[20] , 0); 

        _amc16z_2dc_ShowAlert($dataArray, "B面进线A相二段电流过载", $v[23] , 0);
        

        $v = unpack("C*" , substr($memData , 4 + 63+6 + 63+6 + 25 + 25, 63));
        for($i=1; $i<=63;$i++)
        {            
            _amc16z_2dc_ShowAlert($dataArray, "A面分路".$i."电流过载", $v[$i] , 0);
        }
        $v = unpack("C*" , substr($memData , 4 + 63+6 + 63+6 + 25 + 25 + 63, 63));
        for($i=1; $i<=63;$i++)
        {            
            _amc16z_2dc_ShowAlert($dataArray, "B面分路".$i."电流过载", $v[$i] , 0);
        }
        $v = unpack("C*" , substr($memData , 4 + 63+6 + 63+6 + 25 + 25 + 63 + 63, 69));
        for($i=1; $i<=63;$i++)
        {            
            _amc16z_2dc_ShowAlert($dataArray, "A面分路".$i."开关故障", $v[$i] , 0);
        }
        _amc16z_2dc_ShowAlert($dataArray, "A面主路开关故障", $v[64], 0);
        _amc16z_2dc_ShowAlert($dataArray, "A面防雷器开关故障", $v[65], 0);
        _amc16z_2dc_ShowAlert($dataArray, "A面备路开关故障", $v[66], 0);
        _amc16z_2dc_ShowAlert($dataArray, "A面主路跳闸", $v[67], 0);
        _amc16z_2dc_ShowAlert($dataArray, "A面备路跳闸", $v[68], 0);
        _amc16z_2dc_ShowAlert($dataArray, "A面备路防雷器开关故障", $v[69], 0);
        $v = unpack("C*" , substr($memData , 4 + 63+6 + 63+6 + 25 + 25 + 63 + 63 + 69, 69));
        for($i=1; $i<=63;$i++)
        {            
            _amc16z_2dc_ShowAlert($dataArray, "B面分路".$i."开关故障", $v[$i] , 0);
        }
        _amc16z_2dc_ShowAlert($dataArray, "B面主路开关故障", $v[64], 0);
        _amc16z_2dc_ShowAlert($dataArray, "B面防雷器开关故障", $v[65], 0);
        _amc16z_2dc_ShowAlert($dataArray, "B面备路开关故障", $v[66], 0);
        _amc16z_2dc_ShowAlert($dataArray, "B面主路跳闸", $v[67], 0);
        _amc16z_2dc_ShowAlert($dataArray, "B面备路跳闸", $v[68], 0);
        _amc16z_2dc_ShowAlert($dataArray, "B面备路防雷器开关故障", $v[69], 0);
        $v = unpack("C*" , substr($memData , 4 + 63+6 + 63+6 + 25 + 25 + 63 + 63 + 69 + 69, 63));
        for($i=1; $i<=63;$i++)
        {            
            _amc16z_2dc_ShowAlert($dataArray, "A面分路".$i."二段电流过载", $v[$i] , 0);
        }
        $v = unpack("C*" , substr($memData , 4 + 63+6 + 63+6 + 25 + 25 + 63 + 63 + 69 + 69 + 63, 63));
        for($i=1; $i<=63;$i++)
        {            
            _amc16z_2dc_ShowAlert($dataArray, "B面分路".$i."二段电流过载", $v[$i] , 0);
        }
        $v = unpack("C*" , substr($memData , 4 + 63+6 + 63+6 + 25 + 25 + 63 + 63 + 69 + 69 + 63 + 63, 20));

        _amc16z_2dc_ShowAlert($dataArray, "A面备路A相电压欠电压", $v[1], 0);
        _amc16z_2dc_ShowAlert($dataArray, "A面备路A相电压过电压", $v[4], 0);

        _amc16z_2dc_ShowAlert($dataArray, "A面备路A相电流过载", $v[9], 0);
        _amc16z_2dc_ShowAlert($dataArray, "A面备路A相功率过载", $v[12], 0);

        _amc16z_2dc_ShowAlert($dataArray, "A面备路A相二段电流过载", $v[20], 0);
        $v = unpack("C*" , substr($memData , 4 + 63+6 + 63+6 + 25 + 25 + 63 + 63 + 69 + 69 + 63 + 63 + 20, 20));

        _amc16z_2dc_ShowAlert($dataArray, "B面备路A相电压欠电压", $v[1], 0);
        _amc16z_2dc_ShowAlert($dataArray, "B面备路A相电压过电压", $v[4], 0);
        _amc16z_2dc_ShowAlert($dataArray, "B面备路A相电流过载", $v[9], 0);
        _amc16z_2dc_ShowAlert($dataArray, "B面备路A相功率过载", $v[12], 0);

        _amc16z_2dc_ShowAlert($dataArray, "B面备路A相二段电流过载", $v[20], 0);

        $v = unpack("C*" , substr($memData , 4 + 63+6 + 63+6 + 25 + 25 + 63 + 63 + 69 + 69 + 63 + 63 + 20 + 20, 60));
        for($i=1; $i<=60; $i++)
        {            
            _amc16z_2dc_ShowAlert($dataArray, "A面绝缘".$i."正对地电阻报警", $v[$i] , 0);
        }
        $v = unpack("C*" , substr($memData , 4 + 63+6 + 63+6 + 25 + 25 + 63 + 63 + 69 + 69 + 63 + 63 + 20 + 20 + 60, 60));
        for($i=1; $i<=60; $i++)
        {            
            _amc16z_2dc_ShowAlert($dataArray, "A面绝缘".$i."负对地电阻报警", $v[$i] , 0);
        }
        $v = unpack("C*" , substr($memData , 4 + 63+6 + 63+6 + 25 + 25 + 63 + 63 + 69 + 69 + 63 + 63 + 20 + 20 + 60 + 60, 60));
        for($i=1; $i<=60; $i++)
        {            
            _amc16z_2dc_ShowAlert($dataArray, "B面绝缘".$i."正对地电阻报警", $v[$i] , 0);
        }
        $v = unpack("C*" , substr($memData , 4 + 63+6 + 63+6 + 25 + 25 + 63 + 63 + 69 + 69 + 63 + 63 + 20 + 20 + 60 + 60 + 60, 60));
        for($i=1; $i<=60; $i++)
        {            
            _amc16z_2dc_ShowAlert($dataArray, "B面绝缘".$i."负对地电阻报警", $v[$i] , 0);
        }

        $v = unpack("C*" , substr($memData , 4 + 63+6 + 63+6 + 25 + 25 + 63 + 63 + 69 + 69 + 63 + 63 + 20 + 20 + 60 + 60 + 60 + 60, 15));
        for($i=1; $i<=8; $i++){
            _amc16z_2dc_ShowAlert($dataArray, "绝缘分模块".$i."通讯报警", $v[$i], 0);
        }
        
        _amc16z_2dc_ShowAlert($dataArray, "ZJY1正对地电阻报警", $v[9], 0);
        _amc16z_2dc_ShowAlert($dataArray, "ZJY1负对地电阻报警", $v[10], 0);
        _amc16z_2dc_ShowAlert($dataArray, "ZJY2正对地电阻报警", $v[11], 0);
        _amc16z_2dc_ShowAlert($dataArray, "ZJY2负对地电阻报警", $v[12], 0);

        _amc16z_2dc_ShowAlert($dataArray, "KD1通讯故障", $v[13], 0);
        _amc16z_2dc_ShowAlert($dataArray, "KD2通讯故障", $v[14], 0);
        _amc16z_2dc_ShowAlert($dataArray, "KD3通讯故障", $v[15], 0);

        $offset = 4 + 63+6 + 63+6 + 25 + 25 + 63 + 63 + 69 + 69 + 63 + 63 + 20 + 20 + 60 + 60 + 60 + 60 + 15;
        $v = unpack("C*" , substr($memData , $offset , 60));
        for($i=1; $i<=60; $i++)
        {            
            _amc16z_2dc_ShowAlert($dataArray, "A面分路".$i."SD开关状态", $v[$i] , 0);
        }
        $offset += 60;
        $v = unpack("C*" , substr($memData , $offset, 60));
        for($i=1; $i<=60; $i++)
        {            
            _amc16z_2dc_ShowAlert($dataArray, "B面分路".$i."SD开关状态", $v[$i] , 0);
        }
        $offset += 60;
        $v = unpack("C*" , substr($memData , $offset, 60));
        for($i=1; $i<=60; $i++)
        {            
            _amc16z_2dc_ShowAlert($dataArray, "A面分路".$i."SD故障", $v[$i] , 0);
        }
        $offset += 60;
        $v = unpack("C*" , substr($memData , $offset, 60));
        for($i=1; $i<=60; $i++)
        {            
            _amc16z_2dc_ShowAlert($dataArray, "B面分路".$i."SD故障", $v[$i] , 0);
        }
        $offset += 60;
	    //779 state
        $v = unpack("f*" , substr($memData , $offset, 4*12));
        $dataArray["A面进线A相电压"] = number_format($v[1], 2); 
        $dataArray["A面进线A相电流"] = number_format($v[2]*$v[5], 2); 
        $dataArray["A面进线A相有功功率"] = number_format($v[3]*$v[5], 2); 
        $dataArray["A面进线A相有功电能"] = number_format($v[4]*$v[5], 2); 
        $dataArray["A面进线A相CT变比"] = number_format($v[5], 2);

        $dataArray["温度"] = number_format($v[6], 2); 

        $dataArray["湿度"] = number_format($v[7],2);

        $dataArray["B面进线A相电压"] = number_format($v[8], 2); 
        $dataArray["B面进线A相电流"] = number_format($v[9]*$v[12], 2); 
        $dataArray["B面进线A相有功功率"] = number_format($v[10]*$v[12], 2);
        $dataArray["B面进线A相有功电能"] = number_format($v[11]*$v[12], 2);
        $dataArray["B面进线A相CT变比"] = number_format($v[12], 2);

        $offset += 4*12;
        $v = unpack("f*" , substr($memData , $offset, 4*63));
        for($i=1;$i<=63;$i++)
        {
            $dataArray["A面分路".$i."电流"] = $v[$i];
        }
        $offset += 4*63;
        $v = unpack("f*" , substr($memData , $offset, 4*63));
        for($i=1;$i<=63;$i++)
        {
            $dataArray["B面分路".$i."电流"] = $v[$i];
        }
        $offset += 4*63;
        $v = unpack("f*" , substr($memData , $offset, 4*63));
        for($i=1;$i<=63;$i++)
        {
            $dataArray["A面分路".$i."有功功率"] = $v[$i];
        }
        $offset += 4*63;
        $v = unpack("f*" , substr($memData , $offset, 4*63));
        for($i=1;$i<=63;$i++)
        {
            $dataArray["B面分路".$i."有功功率"] = $v[$i];
        }
        $offset += 4*63;
        $v = unpack("f*" , substr($memData , $offset, 4*63));
        for($i=1;$i<=63;$i++)
        {
            $dataArray["A面分路".$i."有功电能"] = $v[$i];
        }
        $offset += 4*63;
        $v = unpack("f*" , substr($memData , $offset, 4*63));
        for($i=1;$i<=63 ;$i++)
        {
            $dataArray["B面分路".$i."有功电能"] = $v[$i];
        }
        $offset += 4*63;
        $v = unpack("f*" , substr($memData , $offset, 4*63));
        for($i=1;$i<=63;$i++)
        {
            $dataArray["A面分路".$i."电压"] = number_format($v[$i], 2);
        }
        $offset += 4*63;
        $v = unpack("f*" , substr($memData , $offset, 4*63));
        for($i=1;$i<=63;$i++)
        {
            $dataArray["B面分路".$i."电压"] = number_format($v[$i], 2);
        }
        $offset += 4*63;
        //电流变比需要上提
        $v = unpack("f*" , substr($memData ,  $offset, 4*63));
        for($i=1;$i<=63;$i++)
        {
            $dataArray["A面分路".$i."电流变比"] = number_format($v[$i], 2);
            $dataArray["A面分路".$i."电流"] = number_format($dataArray["A面分路".$i."电流"]*$v[$i], 2);
            $dataArray["A面分路".$i."有功功率"] = number_format($dataArray["A面分路".$i."有功功率"]*$v[$i], 2);
            $dataArray["A面分路".$i."有功电能"] = number_format($dataArray["A面分路".$i."有功电能"]*$v[$i], 2);
        }
        $offset += 4*63;
        $v = unpack("f*" , substr($memData ,  $offset, 4*63));
        for($i=1;$i<=63;$i++)
        {
            $dataArray["B面分路".$i."电流变比"] = number_format($v[$i], 2);
            $dataArray["B面分路".$i."电流"] = number_format($dataArray["B面分路".$i."电流"]*$v[$i], 2);
            $dataArray["B面分路".$i."有功功率"] = number_format($dataArray["B面分路".$i."有功功率"]*$v[$i], 2);
            $dataArray["B面分路".$i."有功电能"] = number_format($dataArray["B面分路".$i."有功电能"]*$v[$i], 2);
        }
        
        $offset += 4*63;

        $v = unpack("f*" , substr($memData , $offset, 4*7));
        $dataArray["A面进线A相电流最大需量"] = number_format($v[1]*$dataArray["A面进线A相CT变比"], 2);
        $dataArray["A面进线A相电流最大需量年"] = number_format($v[2], 2);
        $dataArray["A面进线A相电流最大需量月"] = number_format($v[3], 2);
        $dataArray["A面进线A相电流最大需量日"] = number_format($v[4], 2);
        $dataArray["A面进线A相电流最大需量时"] = number_format($v[5], 2);
        $dataArray["A面进线A相电流最大需量分"] = number_format($v[6], 2);
        $dataArray["A面进线A相电流最大需量秒"] = number_format($v[7], 2);
        
        $offset += 4*7;
        $v = unpack("f*" , substr($memData , $offset, 4*7));
        $dataArray["A面进线A相功率最大需量"] = number_format($v[1]*$dataArray["A面进线A相CT变比"], 2);
        $dataArray["A面进线A相功率最大需量年"] = number_format($v[2], 2);
        $dataArray["A面进线A相功率最大需量月"] = number_format($v[3], 2);
        $dataArray["A面进线A相功率最大需量日"] = number_format($v[4], 2);
        $dataArray["A面进线A相功率最大需量时"] = number_format($v[5], 2);
        $dataArray["A面进线A相功率最大需量分"] = number_format($v[6], 2);
        $dataArray["A面进线A相功率最大需量秒"] = number_format($v[7], 2);
        
        $offset += 4*7;
        $v = unpack("f*" , substr($memData , $offset, 4*7));
        $dataArray["A面备路A相电流最大需量"] = number_format($v[1]*$dataArray["A面备路A相CT变比"], 2);
        $dataArray["A面备路A相电流最大需量年"] = number_format($v[2], 2);
        $dataArray["A面备路A相电流最大需量月"] = number_format($v[3], 2);
        $dataArray["A面备路A相电流最大需量日"] = number_format($v[4], 2);
        $dataArray["A面备路A相电流最大需量时"] = number_format($v[5], 2);
        $dataArray["A面备路A相电流最大需量分"] = number_format($v[6], 2);
        $dataArray["A面备路A相电流最大需量秒"] = number_format($v[7], 2);
       
        $offset += 4*7;
        $v = unpack("f*" , substr($memData , $offset, 4*7));
        $dataArray["A面备路A相功率最大需量"] = number_format($v[22]*$dataArray["A面备路A相CT变比"], 2);
        $dataArray["A面备路A相功率最大需量年"] = number_format($v[23], 2);
        $dataArray["A面备路A相功率最大需量月"] = number_format($v[24], 2);
        $dataArray["A面备路A相功率最大需量日"] = number_format($v[25], 2);
        $dataArray["A面备路A相功率最大需量时"] = number_format($v[26], 2);
        $dataArray["A面备路A相功率最大需量分"] = number_format($v[27], 2);
        $dataArray["A面备路A相功率最大需量秒"] = number_format($v[28], 2);
        
        $offset += 4*7;
        $v = unpack("f*" , substr($memData , $offset, 4*7));
        $dataArray["B面进线A相电流最大需量"] = number_format($v[1]*$dataArray["B面进线A相CT变比"], 2);
        $dataArray["B面进线A相电流最大需量年"] = number_format($v[2], 2);
        $dataArray["B面进线A相电流最大需量月"] = number_format($v[3], 2);
        $dataArray["B面进线A相电流最大需量日"] = number_format($v[4], 2);
        $dataArray["B面进线A相电流最大需量时"] = number_format($v[5], 2);
        $dataArray["B面进线A相电流最大需量分"] = number_format($v[6], 2);
        $dataArray["B面进线A相电流最大需量秒"] = number_format($v[7], 2);
        
        $offset += 4*7;
        $v = unpack("f*" , substr($memData , $offset, 4*7));
        $dataArray["B面进线A相功率最大需量"] = number_format($v[22]*$dataArray["B面进线A相CT变比"], 2);
        $dataArray["B面进线A相功率最大需量年"] = number_format($v[23], 2);
        $dataArray["B面进线A相功率最大需量月"] = number_format($v[24], 2);
        $dataArray["B面进线A相功率最大需量日"] = number_format($v[25], 2);
        $dataArray["B面进线A相功率最大需量时"] = number_format($v[26], 2);
        $dataArray["B面进线A相功率最大需量分"] = number_format($v[27], 2);
        $dataArray["B面进线A相功率最大需量秒"] = number_format($v[28], 2);
        
        $offset += 4*7;
        $v = unpack("f*" , substr($memData , $offset, 4*7));
        $dataArray["B面备路A相电流最大需量"] = number_format($v[1]*$dataArray["B面备路A相CT变比"], 2);
        $dataArray["B面备路A相电流最大需量年"] = number_format($v[2], 2);
        $dataArray["B面备路A相电流最大需量月"] = number_format($v[3], 2);
        $dataArray["B面备路A相电流最大需量日"] = number_format($v[4], 2);
        $dataArray["B面备路A相电流最大需量时"] = number_format($v[5], 2);
        $dataArray["B面备路A相电流最大需量分"] = number_format($v[6], 2);
        $dataArray["B面备路A相电流最大需量秒"] = number_format($v[7], 2);
        
        $offset += 4*7;
        $v = unpack("f*" , substr($memData , $offset, 4*7));
        $dataArray["B面备路A相功率最大需量"] = number_format($v[22]*$dataArray["B面备路A相CT变比"], 2);
        $dataArray["B面备路A相功率最大需量年"] = number_format($v[23], 2);
        $dataArray["B面备路A相功率最大需量月"] = number_format($v[24], 2);
        $dataArray["B面备路A相功率最大需量日"] = number_format($v[25], 2);
        $dataArray["B面备路A相功率最大需量时"] = number_format($v[26], 2);
        $dataArray["B面备路A相功率最大需量分"] = number_format($v[27], 2);
        $dataArray["B面备路A相功率最大需量秒"] = number_format($v[28], 2);
        
        $offset += 4*7;
        $v = unpack("f*" , substr($memData , $offset, 4*60));
        for($i=1;$i<=60;$i++)
        {
            $dataArray["A面绝缘".$i."正对地电阻"] = number_format($v[$i], 2);
        }
        $offset += 4*60;
        $v = unpack("f*" , substr($memData , $offset, 4*60));
        for($i=1;$i<=60;$i++)
        {
            $dataArray["A面绝缘".$i."负对地电阻"] = number_format($v[$i], 2);
        }

        $offset += 4*60;
        $v = unpack("f*" , substr($memData , $offset, 4*60));
        for($i=1;$i<=60;$i++)
        {
            $dataArray["B面绝缘".$i."正对地电阻"] = number_format($v[$i], 2);
        }
        $offset += 4*60;
        $v = unpack("f*" , substr($memData , $offset, 4*60));
        for($i=1;$i<=60;$i++)
        {
            $dataArray["B面绝缘".$i."负对地电阻"] = number_format($v[$i], 2);
        }

        $offset += 4*60;
        $v = unpack("f*" , substr($memData , $offset, 4*10));
        $dataArray["A母线正对地电压"] = number_format($v[1], 2);
        $dataArray["A母线负对地电压"] = number_format($v[2], 2);
        $dataArray["A母线电压"] = number_format($v[3], 2);
        $dataArray["A母线正对地电阻"] = number_format($v[4], 2);
        $dataArray["A母线负对地电阻"] = number_format($v[5], 2);
        $dataArray["B母线正对地电压"] = number_format($v[6], 2);
        $dataArray["B母线负对地电压"] = number_format($v[7], 2);
        $dataArray["B母线电压"] = number_format($v[8], 2);
        $dataArray["B母线正对地电阻"] = number_format($v[9], 2);
        $dataArray["B母线负对地电阻"] = number_format($v[10], 2);
        $offset += 4*10;        
        $v = unpack('v', substr($memData, $offset , 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData, $offset + 2 , 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}
