<?php
function Get_amc72_96_RtData($memData, &$dataArray, $extraPara = false){
    if(empty($memData)){
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    }else{
        $dataArray['无数据'] = false;
        $dataArray['AlertArray'] = array();
        $v = unpack("S*" , substr($memData , 4 , 4 * 11));
        $dataArray['PT'] = $v[1];
        $dataArray['CT'] = $v[2];
        $dataArray['相电压UA'] = number_format($v[3] / 10, 1).' V';
        $dataArray['相电压UB'] = number_format($v[4] / 10, 1).' V';
        $dataArray['相电压UC'] = number_format($v[5] / 10, 1 ).' V';
        $dataArray['线电压UAB'] = number_format($v[6] / 10, 1).' V';
        $dataArray['线电压UBC'] = number_format($v[7] / 10, 1).' V';
        $dataArray['线电压UAC'] = number_format($v[8] / 10 , 1 ).' V';
        $dataArray['电流IA'] = number_format($v[9] / 1000 , 3, '.', '').' A';
        $dataArray['电流IB'] = number_format($v[10] / 1000 , 3, '.', '').' A';
        $dataArray['电流IC'] = number_format($v[11] / 1000 , 3, '.', '').' A';
        $v = unpack("s*" , substr($memData , 4 + 2*11, 2*12));
        $dataArray['A相有功功率'] = number_format($v[1] / 1000 , 3,'.','').' kW';
        $dataArray['B相有功功率'] = number_format($v[2] / 1000 , 3,'.','').' kW';
        $dataArray['C相有功功率'] = number_format($v[3] / 1000 , 3,'.','').' kW';
        $dataArray['总有功功率'] = number_format($v[4] / 1000 , 3,'.','').' kW';

        $dataArray['A相无功功率'] = number_format($v[5] / 1000 , 2,'.','').' kvar';
        $dataArray['B相无功功率'] = number_format($v[6] / 1000 , 2,'.','').' kvar';
        $dataArray['C相无功功率'] = number_format($v[7] / 1000 , 2,'.','').' kvar';
        $dataArray['总无功功率'] = number_format($v[8] / 1000 , 2,'.','').' kvar';

        $dataArray['A相功率因数'] = $v[9] / 1000;
        $dataArray['B相功率因数'] = $v[10] / 1000;
        $dataArray['C相功率因数'] = $v[11] / 1000;
        $dataArray['总功率因数'] = $v[12] / 1000;

        $v = unpack("S*" , substr($memData , 4 + 2*11 + 2*12 , 2*7));
        $dataArray['A相视在功率'] = number_format($v[1] / 1000 , 2,'.','').' VA';
        $dataArray['B相视在功率'] = number_format($v[2] / 1000 , 2,'.','').' VA';
        $dataArray['C相视在功率'] = number_format($v[3] / 1000 , 2,'.','').' VA';
        $dataArray['总视在功率'] = number_format($v[4] / 1000 , 2,'.','').' VA';
        $dataArray['频率F'] = ($v[5] / 100).' Hz';
        $dataArray['零序电压'] = ($v[6] / 10).' V';
        $dataArray['零序电流'] = number_format($v[5] / 1000, 3, '.', '').' I';

        $v = unpack("I" , substr($memData , 4 + 2*11 + 2*12 + 2*7, 4));
	$dataArray["组合有功电能"] = ($v[1] /1000 * $dataArray['PT'] * $dataArray['CT'] ) . " KWH";

        $v = unpack('v', substr($memData, 4 + 2*11 + 2*12 + 2*7 + 4, 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData, 4 + 2*11 + 2*12 + 2*7 + 4 +  2 , 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}
