<?php

function Get_Amf20_Standard_Variable($dataArray, $varname){
   //var_dump($dataArray);die;
    switch ($varname){
    
        case '启动电池电压':
            return array(0, $dataArray['电池电压（V）']);
        case '转速':
            return array(0, $dataArray["转速"]);

        case '发电机频率':
            return array(0, $dataArray['ECU频率选择']);
        case '发电机A相有功功率Pa':
            return array(0, $dataArray['L1有功功率']);
        case '发电机B相有功功率Pb':
            return array(0, $dataArray['L2有功功率']);
        case '发电机C相有功功率Pc':
            return array(0, $dataArray["L3有功功率"]);

         case '固定式发电机组功率因数PF':
            return array(0, $dataArray['功率因数']);
        case '发电机相电压Ua':
            return array(0, $dataArray['发电电压L1-N']);
        case '发电机相电压Ub':
            return array(0, $dataArray['发电电压L2-N']);
        case '发电机相电压Uc':
            return array(0, $dataArray["发电电压L3-N"]);
        case '发电机输出线电压Uab':
            return array(0, $dataArray['发电电压L12']);
        case '发电机输出线电压Ubc':
            return array(0, $dataArray['发电电压L23']);
        case '发电机输出线电压Uca':
            return array(0, $dataArray['发电电压L31']);
        case '发电机相电流Ia':
            return array(0, $dataArray["负载电流L1"]);
         case '发电机相电流Ib':
            return array(0, $dataArray['负载电流L2']);
        case '发电机相电流Ic':
            return array(0, $dataArray['负载电流L3']);
        case '市电频率':
            return array(0, $dataArray['市电频率']);
        case '市电A相电压':
            return array(0, $dataArray["市电电压L1-N"]);
        case '市电B相电压':
            return array(0, $dataArray['市电电压L2-N']);
        case '市电C相电压':
            return array(0, $dataArray['市电电压L3-N']);
        case '油压':
            return array(0, $dataArray['油压']);
        case '启动电池电压':
            return array(0, $dataArray["电池电压"]);
        case '燃油油位低告警':
            return array(0, $dataArray["燃油位"]);
        case '固定式发电机组有功电能':
            return array(0, $dataArray["发电有功电度"]);
        case '固定式发电机组无功电能':
            return array(0, $dataArray["发电无功电度"]);
        case '固定发电机组运行时间':
            return array(0, $dataArray["运行时间"]);
    }
    return array(1 , '设备无此信号数据:'. $varname);
}

function Get_Amf20_RtData($memData, &$dataArray, $extraPara = false)
{
    if (empty($memData)) {
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
        /* $dataObj->isEmpty = true;
        $dataObj->update_datetime = '无'; */
    } else {
        $dataArray["无数据"] = false;
        $dataArray['AlertArray'] = array();
        
                //AMF20_reg_1000_1003_t
                $v = unpack('S*',substr($memData,4 + 1*111, 2*4));
              $dataArray['转速'] = $v[2];
                $dataArray['ECU频率选择']  = $v[3];
        
        $v = unpack('S*',substr($memData,4 + 1*111 + 2*4, 2*41));
                
               $dataArray['L1有功功率']= $v[4];
               $dataArray['L2有功功率'] = $v[5];
                $dataArray['L3有功功率'] = $v[6];
        $v = unpack('S*',substr($memData,4 + 1*111 + 2*4, 2*41));
         $dataArray['功率因数'] = $v[15];
         $dataArray['发电电压L1-N'] = $v[20];
         $dataArray['发电电压L2-N'] = $v[21];
         $dataArray['发电电压L3-N']= $v[22];
         $dataArray['发电电压L12']= $v[23];
         $dataArray['发电电压L23'] = $v[24];
         $dataArray['发电电压L31'] = $v[25];
         $dataArray['负载电流L1'] = $v[26];
         $dataArray['负载电流L2']  = $v[27];
         $dataArray['负载电流L3']  = $v[28];
         $dataArray['市电频率'] = $v[29];
         $dataArray['市电电压L1-N']  = $v[30];
         $dataArray['市电电压L2-N']  = $v[31];
         $dataArray['市电电压L3-N'] = $v[32];
         $dataArray['电池电压']= $v[36];
         $dataArray['油压']= $v[38];
         $dataArray['燃油位']= $v[40]/10;
       $v = unpack('I*',substr($memData,4 + 1*111 + 2*53, 4*6));
               
                $dataArray['发电有功电度']= $v[2];
                $dataArray['发电无功电度'] = $v[3];
    $v = unpack('I*',substr($memData,4 + 1*111 + 2*53, 4*6));
   $dataArray['运行时间']= $v[6];
    
    }
}


?>
