<?php

function _GetCheckMsgBreakerState($v)
{
    switch ($v) {
        case 20: return "初始化";
        case 21: return "准备未就绪";
        case 22: return "起动前";
        case 23: return "Cranking";
        case 24: return "暂停";
        case 25: return "启动";
        case 26: return "运行";
        case 27: return "加载";
        case 28: return "停止";
        case 29: return "关机";
        case 30: return "准备就绪";
        case 31: return "制冷";
        case 32: return "EmergMan";
        case 33: return "MainsOper";
        case 34: return "MainsFlt";
        case 35: return "MainsFlt";
        case 36: return "IslOper";
        case 37: return "MainsRet";
        case 38: return "断路器关闭";
        case 39: return "无计时器";
        case 40: return "MCB关闭";
        case 41: return "返回删除";
        case 42: return "Trans Del";
        case 43: return "空转";
        case 44: return "MinStabTO";
        case 45: return "MinStabTO";
        case 46: return "冷却后";
        case 47: return "GCB开启";
        case 48: return "截止阀";
        case 49: return "开始删除";
        case 50: return "(1Ph)";
        case 51: return "(2Ph)";
        case 52: return "(3Ph)";
        case 53: return "MRS模式";
        default:
            break;
    }
    return "无效";
}

function _GetAmf25ControllerMode($v)
{
    switch ($v) {
        case 0: return "关闭";
        case 1: return "手动";
        case 2: return "自动";
        case 3: return '测试';
    }
    return "无效";
}

function Get_amf25_RtData($memData, &$dataArray, $extraPara = false)
{
    if (empty($memData)) {
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
        /* $dataObj->isEmpty = true;
        $dataObj->update_datetime = '无'; */
    } else {
        $dataArray["无数据"] = false;
        $dataArray['AlertArray'] = array();
        $v = unpack('S*', substr($memData, 4, 2 * 10));
        $dataArray['发电机L1相电压'] = number_format($v[1] , 2).' V';
        $dataArray['发电机L2相电压'] = number_format($v[2] , 2).' V';
        $dataArray['发电机L3相电压'] = number_format($v[3] , 2).' V';
        $dataArray['发电机L1-L2线电压'] = number_format($v[4] , 2).' V';
        $dataArray['发电机L2-L3线电压'] = number_format($v[5] , 2).' V';
        $dataArray['发电机L3-L1线电压'] = number_format($v[6] , 2).' V';
        $dataArray['L1负载电流'] = number_format($v[7] , 2).' A';
        $dataArray['L2负载电流'] = number_format($v[8] , 2).' A';
        $dataArray['L3负载电流'] = number_format($v[9] , 2).' A';
        $dataArray['转速'] = number_format($v[10] , 2).' RPM';
        $v = unpack('f*', substr($memData, 4 + 20, 4));
        $dataArray['频率'] = number_format($v[1] , 2).' Hz';
        $v = unpack('S*', substr($memData, 4 + 20 + 4, 2 * 9));
        $dataArray['有功功率'] = number_format($v[1] , 2).' KW';
        $dataArray['L1有功功率'] = number_format($v[2] , 2).' KW';
        $dataArray['L2有功功率'] = number_format($v[3] , 2).' KW';
        $dataArray['L3有功功率'] = number_format($v[4] , 2).' KW';
        $dataArray['标称视在功率'] = number_format($v[5] , 2).' KVA';
        $dataArray['无功功率'] = number_format($v[6] , 2).' KVAr';
        $dataArray['L1无功功率'] = number_format($v[7] , 2).' KVAr';
        $dataArray['L2无功功率'] = number_format($v[8] , 2).' KVAr';
        $dataArray['L3无功功率'] = number_format($v[9] , 2).' KVAr';
        $v = unpack('f*', substr($memData, 4 + 20 + 4 + 18, 16));
        $dataArray['总功率因数'] = number_format($v[1] / 2 , 2);
        $dataArray['L1功率因数'] = number_format($v[2] , 2);
        $dataArray['L2功率因数'] = number_format($v[3] , 2);
        $dataArray['L3功率因数'] = number_format($v[4] , 2);
        $v = unpack('S*', substr($memData, 4 + 20 + 4 + 18 + 16, 2 * 11));
        $dataArray['总视在功率'] = number_format($v[1] , 2).' KVA';
        $dataArray['L1视在功率'] = number_format($v[2] , 2).' KVA';
        $dataArray['L2视在功率'] = number_format($v[3] , 2).' KVA';
        $dataArray['L3视在功率'] = number_format($v[4] , 2).' KVA';
        $dataArray['干线L1相电压'] = number_format($v[5] , 2).' V';
        $dataArray['干线L2相电压'] = number_format($v[6] , 2).' V';
        $dataArray['干线L3相电压'] = number_format($v[7] , 2).' V';
        $dataArray['干线L1-L2线电压'] = number_format($v[8] , 2).' V';
        $dataArray['干线L2-L3线电压'] = number_format($v[9] , 2).' V';
        $dataArray['干线L3-L1线电压'] = number_format($v[10] , 2).' V';
        $dataArray['干线频率'] = number_format($v[11] , 2).' Hz';
        $v = unpack('f*', substr($memData, 4 + 20 + 4 + 18 + 16 + 22, 16));
        //$dataArray['接地故障'] = $v[1];//接地故障
        //$dataArray["AlertArray"]["接地故障"] = $v[1] == 1;
        $dataArray['电池电压'] = number_format($v[2] , 2).' V';//电池电压
        $dataArray['充电电压'] = number_format($v[3]/10 , 2).' V';//充电电压
        $dataArray['油压'] = $v[4] == 65535 ? '无效' : number_format($v[4]/10 , 2).' Bar';//油压
        $v = unpack('S*', substr($memData, 4 + 20 + 4 + 18 + 16 + 22 + 16, 2 * 6));
        $dataArray['引擎温度'] = number_format($v[1] , 2).' ℃';//引擎温度
        $dataArray['GCB反馈'] = (($v[2] >> 0) & 0x1) === 1  ? '开启' :'关闭';
        $dataArray['MCB反馈'] = (($v[2] >> 1) & 0x1) === 1  ? '开启' :'关闭';
        $Emergency_Stop = (($v[2] >> 2) & 0x1);
        $low_oil_pressure = (($v[2] >> 3) & 0x1);
        $dataArray['高水温'] = (($v[2] >> 4) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['高水温'] = (($v[2] >> 4) & 0x1) == 1;
        $dataArray['远程测试'] = (($v[2] >> 5) & 0x1) === 1  ? '开启' :'关闭';
        $dataArray['远程启动'] = (($v[2] >> 6) & 0x1) === 1  ? '开启' :'关闭';

        $dataArray['启动器'] = (($v[3] >> 0) & 0x1) === 1  ? '开启' : '关闭';
        $dataArray['供油阀'] = (($v[3] >> 1) & 0x1) === 1  ? '开启' : '关闭';
        $dataArray['GCB'] = (($v[3] >> 2) & 0x1) === 1  ? '开启' : '关闭';
        $dataArray['MCB'] = (($v[3] >> 3) & 0x1) === 1  ? '开启' : '关闭';
        $dataArray['预启动'] = (($v[3] >> 4) & 0x1) === 1  ? '开启' : '关闭';
        $dataArray['喇叭'] = (($v[3] >> 5) & 0x1) === 1  ? '开启' : '关闭';
        $Running = ($v[3] >> 6) & 0x1;
        if($Running == 1){
            $dataArray['紧急停机'] = $Emergency_Stop == 1 ? '告警' : '正常';
            $dataArray['低油压'] = $low_oil_pressure == 1 ? '告警' : '正常';
            $dataArray['AlertArray']['紧急停机'] = $Emergency_Stop == 1;
            $dataArray['AlertArray']['低油压'] = $low_oil_pressure == 1;
        }else{
            $dataArray['紧急停机'] = '正常';
            $dataArray['低油压'] = '正常';
            $dataArray['AlertArray']['紧急停机'] = 0;
            $dataArray['AlertArray']['低油压'] = 0;
        }
        $dataArray['运行状态'] = (($v[3] >> 6) & 0x1) === 1  ? '运行' : '停机';

        $dataArray['IOM_BI1报警'] = (($v[4] >> 0) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['IOM_BI2报警'] = (($v[4] >> 1) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['IOM_BI3报警'] = (($v[4] >> 2) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['IOM_BI4报警'] = (($v[4] >> 3) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['IOM_BI5报警'] = (($v[4] >> 4) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['IOM_BI6报警'] = (($v[4] >> 5) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['IOM_BI7报警'] = (($v[4] >> 6) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['IOM_BI8报警'] = (($v[4] >> 7) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['IOM_BI1报警'] = (($v[4] >> 0) & 0x1) == 1;
        $dataArray['AlertArray']['IOM_BI2报警'] = (($v[4] >> 1) & 0x1) == 1;
        $dataArray['AlertArray']['IOM_BI3报警'] = (($v[4] >> 2) & 0x1) == 1;
        $dataArray['AlertArray']['IOM_BI4报警'] = (($v[4] >> 3) & 0x1) == 1;
        $dataArray['AlertArray']['IOM_BI5报警'] = (($v[4] >> 4) & 0x1) == 1;
        $dataArray['AlertArray']['IOM_BI6报警'] = (($v[4] >> 5) & 0x1) == 1;
        $dataArray['AlertArray']['IOM_BI7报警'] = (($v[4] >> 6) & 0x1) == 1;
        $dataArray['AlertArray']['IOM_BI8报警'] = (($v[4] >> 7) & 0x1) == 1;
        $dataArray['发动机状态'] = _GetCheckMsgBreakerState($v[5]);
        $dataArray['断路器状态'] = _GetCheckMsgBreakerState($v[6]);
        $v = unpack('f*', substr($memData, 4 + 20 + 4 + 18 + 16 + 22 + 16 + 12, 4));
        $dataArray['运行时长'] = number_format($v[1] , 2).' H';//运行时长
        $v = unpack('S*', substr($memData, 4 + 20 + 4 + 18 + 16 + 22 + 16 + 12 + 4, 2 * 2));
        //$dataObj->maintainance = $v[1];
        //$dataObj->num_starts = $v[2];
        $v = unpack('I*', substr($memData, 4 + 20 + 4 + 18 + 16 + 22 + 16 + 12 + 4 + 4, 4 * 4));
        $dataArray['总发电有功电量'] = number_format($v[1] , 2).' KWh';//总发电有功电量
        $dataArray['总发电无功电量'] = number_format($v[2] , 2).' KVArh';//总发电无功电量
        $dataArray['紧急停车数'] = $v[3];//紧急停车数
        $dataArray['关机数'] = $v[4];//关机数
        $v = unpack('s*', substr($memData, 4 + 20 + 4 + 18 + 16 + 22 + 16 + 12 + 4 + 4 + 16, 2));
        $dataArray['控制模式'] = _GetAmf25ControllerMode($v[1]);

        //这里开始告警
        $v = unpack('C', substr($memData, 4 + 20 + 4 + 18 + 16 + 22 + 16 + 12 + 4 + 4 + 16 + 2, 1));
        $dataArray["告警总数"] = $v[1];

        $dataArray["告警列表"] = array();
        for($i=0; $i < $dataArray["告警总数"]; $i++)
        {
            $v = unpack('C*', substr($memData, 4 + 20 + 4 + 18 + 16 + 22 + 16 + 12 + 4 + 4 + 16 + 2 + 1 + 51*$i, 51));
            $dataArray["告警列表"][] = implode("", array_slice($v,1) );
        }

        //协议里面两个时间   再加7
        $v = unpack('v', substr($memData, 4 + 20 + 4 + 18 + 16 + 22 + 16 + 12 + 4 + 4 + 16 + 2 + 1 + 51*15, 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData, 4 + 20 + 4 + 18 + 16 + 22 + 16 + 12 + 4 + 4 + 16 + 2 + 1 + 51*15 + 2, 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}


?>
