<?php
function _bat61cj_ShowAlert(&$dataArray, $label, $value, $vsValue)
{
    $dataArray[$label] = $value == $vsValue ? '正常' : '告警';
    $dataArray['AlertArray'][$label] = $value != $vsValue;
}

function _bat61cj_BatteryV(&$dataArray, $memData, $prefix, $index  )
{
    $offset = 0;
      $v = unpack("S*" , $memData);
      
        $name = $prefix.sprintf("#%d电池电压", $index);
          $dataArray[$name] = number_format($v[1]/1000, 2)."V";
}
function _bat61cj_BatteryT(&$dataArray, $memData, $prefix, $index  )
{
    $offset = 0;
      $v = unpack("s*" , $memData);
      
        $name = $prefix.sprintf("#%d电池温度", $index);
          $dataArray[$name]  = ( ($v[1] == 0x7FFF) ? "" : (($v[1]/100)."°C"));
}
function _bat61cj_BatteryR(&$dataArray, $memData, $prefix, $index  )
{
    $offset = 0;
      $v = unpack("S*" , $memData);
      
        $name = $prefix.sprintf("#%d电池内阻", $index);
          $dataArray[$name] = number_format($v[1]/1000, 2)."mΩ";
}
function _bat61cj_BatteryInfo(&$dataArray, $memData, $prefix, $index  )
{
    $offset = 0;
    $v = unpack("S*" , $memData);
      
      $lMemData = substr($memData, $offset, 2);
      _bat61cj_BatteryV($dataArray, $lMemData, $prefix, $index);
      
      $lMemData = substr($memData, $offset, 2);
      _bat61cj_BatteryT($dataArray, $lMemData, $prefix, $index);
      
      $lMemData = substr($memData, $offset, 2);
      _bat61cj_BatteryR($dataArray, $lMemData, $prefix, $index);
}

function Get_bat61cj_RtData($memData, &$dataArray, $extraPara = false){
    if($memData == false){
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    }else{
        $dataArray['无数据'] = false;
        $dataArray['AlertArray'] = array();
        $offset = 4;
            $v = unpack("s*" , substr($memData , $offset, 2*21));
      
        $dataArray["电池组总电压"] = number_format($v[1]/10, 2)."V";
      

      
        $dataArray["电池组充放电电流"] = number_format($v[2]/10, 2)."A";
      

      
        $dataArray["电池组温度1"] = number_format($v[3]/10, 2)."℃";
      

      
        $dataArray["电池组温度2"] = number_format($v[4]/10, 2)."℃";
      

      
        $dataArray["电池组单节电压平均值"] = number_format($v[5]/1000, 2)."V";
      

      
        $dataArray["电池组单节温度平均值"] = number_format($v[6]/10, 2)."℃";
      

      
        $dataArray["电池组单节内阻平均值"] = number_format($v[7]/1000, 2)."mΩ";
      

      
        switch($v[8]){
          case 0:
          $dataArray["电池组状态"] = "充电";
            break;
          case 1:
          $dataArray["电池组状态"] = "放电";
            break;
          default:
            $dataArray["电池组状态"] = "无效值";
            break;
        }
      

      
        $dataArray["CJ模块ICT通道对应电压值"] = number_format($v[9], 2)."mV";
      

      
        $dataArray["正在内阻测试的电池组号"] = number_format($v[10], 2);
      

      
        $dataArray["电池组容量"] = number_format($v[11], 2)."%";
      

      
        $dataArray["电池剩余放电时间"] = number_format($v[12], 2)."分钟";
      

      
        $dataArray["电池组容量AH"] = number_format($v[13]/10, 2)."AH";
      

      
        switch($v[14]){
          case 0:
          $dataArray["电池组电流状态"] = "浮充";
            break;
          case 1:
          $dataArray["电池组电流状态"] = "放电";
            break;
          case 2:
          $dataArray["电池组电流状态"] = "均充";
            break;
          case 3:
          $dataArray["电池组电流状态"] = "离线";
            break;
          default:
            $dataArray["电池组电流状态"] = "无效值";
            break;
        }
      

      
        $dataArray["第1组电池电流"] = number_format($v[15]/10, 2)."A";
      

      
        $dataArray["第2组电池电流"] = number_format($v[16]/10, 2)."A";
      

      
        $dataArray["第3组电池电流"] = number_format($v[17]/10, 2)."A";
      

      
        $dataArray["第4组电池电流"] = number_format($v[18]/10, 2)."A";
      

      
        $dataArray["第5组电池电流"] = number_format($v[19]/10, 2)."A";
      

      
        $dataArray["第6组电池电流"] = number_format($v[20]/10, 2)."A";
      

      
        switch($v[21]){
          case 0:
          $dataArray["内阻测量状态"] = "当前未进行内阻测";
            break;
          case 1:
          $dataArray["内阻测量状态"] = "正在进行内阻测试";
            break;
          default:
            $dataArray["内阻测量状态"] = "无效值";
            break;
        }
      

      $offset += 42;

            $v = unpack("S*" , substr($memData , $offset, 2*120));
      
          $lOffset = 0;
          for($i=1;$i<=40;$i++)
          {
            $tMemData = substr($memData, $offset + $lOffset, 6);            
            _bat61cj_BatteryInfo($dataArray, $tMemData, "", $index + $i);
            $lOffset += 6;
          }

      $offset += 240;

            $v = unpack("S*" , substr($memData , $offset, 2*120));
      
          $lOffset = 0;
          for($i=41;$i<=80;$i++)
          {
            $tMemData = substr($memData, $offset + $lOffset, 6);            
            _bat61cj_BatteryInfo($dataArray, $tMemData, "", $index + $i);
            $lOffset += 6;
          }

      $offset += 240;

            $v = unpack("S*" , substr($memData , $offset, 2*120));
      
          $lOffset = 0;
          for($i=81;$i<=120;$i++)
          {
            $tMemData = substr($memData, $offset + $lOffset, 6);            
            _bat61cj_BatteryInfo($dataArray, $tMemData, "", $index + $i);
            $lOffset += 6;
          }

      $offset += 240;

        $v = unpack('v', substr($memData, $offset , 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData, $offset + 2 , 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}

