<?php

function Get_bmu24_DeviceIoControl_Parameter($action, $parameter)
{
    if($action == 100 && count($parameter) == 2){
        return pack("S", intval($parameter[0])).pack("S", intval($parameter[1]));
    }
    return -1;
}


function Get_bmu24_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case 'all':
            return array(0, $dataArray);
    }
    return array(1 , '设备无此信号数据:'. $varname);
}


function Get_bmu24_RtData($memData, &$dataArray, $extraPara = false,$pi = false,$time = false,$dynamic_config = false)
{
   if(empty($memData)) {
       $dataArray['无数据'] = true;
       $dataArray['更新时间'] = '无';
       $dataArray['错误'] = '数据长度不一致';
   } else {
       $dataArray['无数据'] = false;
       $dataArray['AlertArray'] = array();
       $v = unpack('S*', substr($memData, 4, 30 * 2));
       $dataArray["温度1"] = number_format($v[1]/10, 1).' ℃';
       $dataArray["温度2"] = number_format($v[2]/10, 1).' ℃';
       for ($i=0; $i <24; $i++) {
           $dataArray["电池".($i+1)."电压"] = number_format($v[3+$i]/100,2).' V';
       }
       $v = unpack('C*', substr($memData, 4 + 30 * 2, 8));
       for ($i=0; $i <24; $i++) {
           $dataArray["电池".($i+1)."告警"] = (($v[1 + $i/8]>>($i%8))&0x1) ? "告警" : "正常";
           $dataArray['AlertArray']["电池".($i+1)."告警"] = ($v[1 + $i/8]>>($i%8))&0x1;
       }
       /*$v = unpack('S*', substr($memData, 4, 58 * 2));
       $dataArray["第一组电池"] = array();
       $dataArray["第二组电池"] = array();
       $dataArray["第一组电池"]["温度"] = number_format($v[1]/10, 1).' ℃';
       $dataArray["第二组电池"]["温度"] = number_format($v[2]/10, 1).' ℃';
       $dataArray["第一组电池"] = array();
       $dataArray["第二组电池"] = array();
       for ($i=0; $i <28; $i++) {
           array_push($dataArray["第一组电池"]["电池".($i+1)."电压"], number_format($v[3+$i]/10,2).' V');
       }
       for ($i=0; $i <28; $i++) {
           array_push($dataArray["第二组电池"]["电池".($i+1)."电压"], number_format($v[3 + 28 +$i]/10,2).' V');
       }
       $dataArray["第一组电池"]['AlertArray'] = array();
       $dataArray["第二组电池"]['AlertArray'] = array();
       $v = unpack('C*', substr($memData, 4 + 58 * 2, 8));
       for ($i=0; $i <28; $i++) {
           array_push($dataArray["第一组电池"]["电池".($i+1)."告警"], ($v[%i/8]>>($i%8))&0x1 ? "告警" : "正常");
           array_push($dataArray["第一组电池"]['AlertArray']["电池".($i+1)."告警"], ($v[%i/8]>>($i%8))&0x1);
       }
       for ($i=0; $i <28; $i++) {
           array_push($dataArray["第二组电池"]["电池".($i+1)."告警"], ($v[%i/8 + 4]>>($i%8))&0x1 ? "告警" : "正常");
           array_push($dataArray["第二组电池"]['AlertArray']["电池".($i+1)."告警"], ($v[%i/8 + 4]>>($i%8))&0x1);
       }*/
       $val = unpack('v', substr($memData, 4 + 30 * 2 + 8, 2));
       $year = $val[1];
       $val = unpack('C*', substr($memData, 4 + 30 * 2 + 8 + 2, 5));
       $dataArray["更新时间"] = date('Y-m-d H:i:s', strtotime($year . '-' . $val[1] . '-' . $val[2] . ' ' . $val[3] . ':' . $val[4] . ':' . $val[5]));

   }
}
