<?php
function Is_bwdk326_NeedExtraPara(){
    return true;
}

function Get_bwdk326_RtData($memData, &$dataArray, $extraPara = false)
{
        if(empty($memData)){
            $dataArray['无数据'] = true;
            $dataArray['更新时间']  = '无';
            $dataArray['错误'] = '数据长度不一致';
        }else{
            $dataArray['无数据'] = false;
            $dataArray['AlertArray'] = array();
            $v = unpack('S*', substr($memData, 4, 2*4));
            switch($v[1])
            {
                case 0x7000:
                    $dataArray['A路温度'] = '开路';
                    $dataArray['AlertArray']['A路温度'] = true;
                    break;
                case 0x6000:
                    $dataArray['A路温度'] = "超上限";
                    $dataArray['AlertArray']['A路温度'] = true;
                    break;
                case 0x8000:
                    $dataArray['A路温度'] = "超下限";
                    $dataArray['AlertArray']['A路温度'] = true;
                    break;
                case 0x5000:
                    $dataArray['A路温度'] = "故障";
                    $dataArray['AlertArray']['A路温度'] = true;
                    break;
                default:
                    $dataArray['A路温度'] = ($v[1] / 10)." ℃";
                    $dataArray['AlertArray']['A路温度'] = false;
                    break;
            }
            switch($v[2])
            {
                case 0x7000:
                    $dataArray['B路温度'] = "开路";
                    $dataArray['AlertArray']['B路温度'] = true;
                    break;
                case 0x6000:
                    $dataArray['B路温度'] = "超上限";
                    $dataArray['AlertArray']['B路温度'] = true;
                    break;
                case 0x8000:
                    $dataArray['B路温度'] = "超下限";
                    $dataArray['AlertArray']['B路温度'] = true;
                    break;
                case 0x5000:
                    $dataArray['B路温度'] = "故障";
                    $dataArray['AlertArray']['B路温度'] = true;
                    break;
                default:
                    $dataArray['B路温度'] = ($v[2] / 10)." ℃";
                    $dataArray['AlertArray']['B路温度'] = false;
                    break;
            }
            switch($v[3])
            {
                case 0x7000:
                    $dataArray['C路温度'] = "开路";
                    $dataArray['AlertArray']['C路温度'] = true;
                    break;
                case 0x6000:
                    $dataArray['C路温度'] = "超上限";
                    $dataArray['AlertArray']['C路温度'] = true;
                    break;
                case 0x8000:
                    $dataArray['C路温度'] = "超下限";
                    $dataArray['AlertArray']['C路温度'] = true;
                    break;
                case 0x5000:
                    $dataArray['C路温度'] = "故障";
                    $dataArray['AlertArray']['C路温度'] = true;
                    break;
                default:
                    $dataArray['C路温度'] = ($v[3] / 10) ." ℃";
                    $dataArray['AlertArray']['C路温度'] = false;
                    break;
            }
            switch($v[4])
            {
                case 0x7000:
                    $dataArray['D路温度'] = "开路";
                    $dataArray['AlertArray']['D路温度'] = true;
                    break;
                case 0x6000:
                    $dataArray['D路温度'] = "超上限";
                    $dataArray['AlertArray']['D路温度'] = true;
                    break;
                case 0x8000:
                    $dataArray['D路温度'] = "超下限";
                    $dataArray['AlertArray']['D路温度'] = true;
                    break;
                case 0x5000:
                    $dataArray['D路温度'] = "故障";
                    $dataArray['AlertArray']['D路温度'] = true;
                    break;
                default:
                    $dataArray['D路温度'] = ($v[4] / 10) ." ℃";
                    $dataArray['AlertArray']['D路温度'] = false;
                    break;
            }
            $v = unpack('c*', substr($memData, 4 + 2*4, 5));
            $dataArray['风机控制'] = $v[1] == 1 ? '闭合' : '断开';
            $dataArray['超温跳闸'] = $v[2] == 1 ? '告警' : '正常';
            $dataArray['AlertArray']['超温跳闸'] = $v[2] == 1;
            $dataArray['超温报警'] = $v[3] == 1 ? '告警' : '正常';
            $dataArray['AlertArray']['超温报警'] = $v[3] == 1;
            if($extraPara && isset($extraPara->channel_count) && $extraPara->channel_count == 4){
                $dataArray['铁心超温报警/机房风扇控制输出'] = $v[4] == 1 ? '告警' : '正常';
                $dataArray['AlertArray']['铁心超温报警/机房风扇控制输出'] = $v[4] == 1;
                $dataArray['故障报警'] = $v[5] == 1 ? '告警' : '正常';
                $dataArray['AlertArray']['故障报警'] = $v[5] == 1;
            }else{
                $dataArray['故障报警'] = $v[4] == 1 ? '告警' : '正常';
                $dataArray['AlertArray']['故障报警'] = $v[4] == 1;
            }
            $v = unpack('v', substr($memData, 17, 2));
            $year = $v[1];
            $v = unpack('C*', substr($memData, 19, 5));
            $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
        }
}
