<?php
function _canatal_ShowAlert(&$dataArray, $label, $value, $vsValue)
{
    $dataArray[$label] = $value == $vsValue ? '正常' : '告警';
    $dataArray['AlertArray'][$label] = $value != $vsValue;
}


function Get_canatal_DeviceIoControl_ErrorMsg($ret){
    switch($ret){
        case 1:
            return "执行成功";
        case 3:
            return "执行失败，校验不符";
        default:
            return "未知错误";
        }
}

function Get_canatal_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '温度设定点':
            return array(0,  $dataArray['温度设定点']);
        case '回风温度':
            return array(0, $dataArray['回风温度']);
        case '开关机状态':
            return array(0, $dataArray['开关机状态']);
        default:
            break;
    }
    return array(1 , '设备无此信号数据:'. $varname);
}

function Get_canatal_RtData($memData , &$dataArray , $extraPara = false)
{
    if ($memData == false) {
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    }else{
        $dataArray['无数据'] = false;
        $v = unpack('C*', substr($memData, 4, 11));
        $dataArray['开关机状态'] = $v[1] > 0 ? "开机" : "关机";
        _canatal_ShowAlert($dataArray, "通用报警", $v[2], 0);
        $dataArray['风机'] = $v[3] > 0 ? "开机" : "关机";
        $dataArray['压缩机'] = $v[4] > 0 ? "开机" : "关机";
        $dataArray['加热器'] = $v[5] > 0 ? "开机" : "关机";
        $dataArray['加湿器'] = $v[6] > 0 ? "开机" : "关机";
        $dataArray['Co-work模式'] = $v[7] > 0 ? "开机" : "关机";
        $dataArray['除湿'] = $v[8] > 0 ? "开机" : "关机";
        $dataArray['加湿'] = $v[9] > 0 ? "开机" : "关机";
        $dataArray['制冷'] = $v[10] > 0 ? "开机" : "关机";
        $dataArray['加热'] = $v[11] > 0 ? "开机" : "关机";

        $v = unpack('f*', substr($memData, 15, 4 * 11));
        $dataArray["现场温度"] =  $v[1];
        $dataArray["现场湿度"] =  $v[2];
        $dataArray["平均温度"] =  $v[3];
        $dataArray["平均湿度"] =  $v[4];
        $dataArray["压缩机输出"] =  $v[5];
        $dataArray["加热器输出"] =  $v[6];
        $dataArray["加湿器输出"] =  $v[7];
        $dataArray["风机运行小时"] =  $v[8];
        $dataArray["压缩机运行小时"] =  $v[9];
        $dataArray["加热器运行小时"] =  $v[10];
        $dataArray["加湿器运行小时"] =  $v[11];
	$v = unpack('C*', substr($memData, 15 + 4*11 , 14));
	_canatal_ShowAlert($dataArray, "风机过载", $v[1], 0);
	_canatal_ShowAlert($dataArray, "压缩机高压", $v[2], 0);
	_canatal_ShowAlert($dataArray, "压缩机低压", $v[3], 0);
	_canatal_ShowAlert($dataArray, "加热器过载", $v[4], 0);
	_canatal_ShowAlert($dataArray, "加湿器淤塞", $v[5], 0);
	_canatal_ShowAlert($dataArray, "火警", $v[6], 0);
	_canatal_ShowAlert($dataArray, "溢水报警", $v[7], 0);
	_canatal_ShowAlert($dataArray, "相位错误", $v[8], 0);
	_canatal_ShowAlert($dataArray, "温度上限报警", $v[9], 0);
	_canatal_ShowAlert($dataArray, "温度下限报警", $v[10], 0);
	_canatal_ShowAlert($dataArray, "湿度上限报警", $v[11], 0);
	_canatal_ShowAlert($dataArray, "湿度下限报警", $v[12], 0);
	_canatal_ShowAlert($dataArray, "温度传感器坏", $v[13], 0);
	$dataArray['再启动模式'] = $v[14] > 0 ? "手动" : "自动";

        $v = unpack('f*', substr($memData, 15 + 4 * 11 +14, 4 * 14));
        $dataArray["温度设定点"] = $v[1];
        $dataArray["温度高限设定点"] = $v[2];
        $dataArray["温度低限设定点"] = $v[3];
        $dataArray["温度静区设定点"] = $v[4];
        $dataArray["设湿度定点"] = $v[5];
        $dataArray["湿度高限设定点"] = $v[6];
        $dataArray["湿度低限设定点"] = $v[7];
        $dataArray["湿度静区设定点"] = $v[8];
        $dataArray["轮候时间设定点"] = $v[9];
        $dataArray["低压延时设定点"] = $v[10];
        $dataArray["风扇关延时设定点"] = $v[11];
        $dataArray["压缩机重开设定点"] = $v[12];
        $dataArray["淤塞延时设定点"] = $v[13];
        $dataArray["值班机台数"] = $v[14];
        $v = unpack('v', substr($memData, 15 + 4*11 + 14 + 4*14, 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData, 15+4*11+14+4*14+2, 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}

?>
