<?php
function Get_championups_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '[UPS输出线电压Uab]':
        case '[UPS输出线电压Ubc]':
        case '[UPS输出线电压Uca]':
            return array(1 , '设备无此信号数据:'. $varname);
        case '[UPS输出频率]':
            $freqData = explode(' ' , $dataArray['频率']);
            return array(0 , $freqData[0]);
        case 'A相输出电流':
            return array(0, $dataArray["负载A相"]);
        case 'B相输出电流':
            return array(0, $dataArray["负载B相"]);
        case 'C相输出电流':
            return array(0, $dataArray["负载C相"]);
    }
    return array(1 , '设备无此信号数据:'. $varname);
}

function Get_championups_RtData($memData, &$dataArray, $extraPara = false)
{
    if (empty($memData)) {
        $dataArray["无数据"] = true;
        $dataArray["更新时间"] = '无';
        $dataArray["错误"] = "数据长度不一致";
    } else {
        $dataArray["无数据"] = false;
        $dataArray["AlertArray"] = array();
        $v = unpack('C*', substr($memData, 4, 5));
        $dataArray["UPS状态"] = $v[1] == 0 ? "正常" : "异常";
        $dataArray["AlertArray"]["UPS状态"] = $v[1] == 1;
        $dataArray["UPS供电"] = $v[2] == 0 ? "逆变" : "旁路";
        $dataArray["AlertArray"]["UPS供电"] = $v[2] == 1;
        $dataArray["市电状态"] = $v[3] == 0 ? "供电" : "掉电";
        $dataArray["AlertArray"]["市电状态"] = $v[3] == 1;
        $dataArray["电压状态"] = $v[4] == 0 ? "正常" : "低压";
        $dataArray["AlertArray"]["电压状态"] = $v[4] == 1;
        $dataArray["电池状态"] = $v[5] == 0 ? "逆变" : "放电";
        $dataArray["AlertArray"]["电池状态"] = $v[5] == 1;

        $v = unpack('f*', substr($memData, 4 + 5, 15 * 4));
        $dataArray["输入电压A相"] = number_format($v[1], 2)." V";
        $dataArray["输入电压B相"] = number_format($v[2], 2)." V";
        $dataArray["输入电压C相"] = number_format($v[3], 2)." V";
        $dataArray["输出电压A相"] = number_format($v[4], 2)." V";
        $dataArray["输出电压B相"] = number_format($v[5], 2)." V";
        $dataArray["输出电压C相"] = number_format($v[6], 2)." V";
        $dataArray["负载A相"] = number_format($v[7], 2)." A";
        $dataArray["负载B相"] = number_format($v[8], 2)." A";
        $dataArray["负载C相"] = number_format($v[9], 2)." A";

        $dataArray["温度"] = number_format($v[10], 2)." ℃";
        $dataArray["频率"] = number_format($v[11], 2)." Hz";
        $dataArray["电池电压"] = number_format($v[12], 2)." V";

        $dataArray["额定放电时间"] = number_format($v[13], 2)." 分钟";
        $dataArray["负电池电压"] = number_format($v[14], 2)." V";
        $dataArray["电池容量"] = number_format($v[15], 2)." %";

        $v = unpack('v', substr($memData, 4 + 5 + 15 * 4, 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData, 4 + 5 + 15 * 4 + 2, 5));
        $dataArray["更新时间"] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}
