<?php


function Get_climavenetaac_RtData($memData, &$dataArray, $extraPara = false)
{
    if (empty($memData)) {
        $dataArray["无数据"] = true;
        $dataArray["更新时间"] = '无';
        $dataArray["错误"] = "数据长度不一致";
    } else {
        $dataArray["无数据"] = false;
        $dataArray["AlertArray"] = array();
        $v = unpack('C*', substr($memData, 4, 5));
        $dataArray["工作状态"] = $v[1] == 1 ? "开机" : "关机";
        $dataArray["蒸发器泵1状态"] = $v[2] == 1 ? "开机" : "关机";
        $dataArray["蒸发器泵2状态"] = $v[3] == 1 ? "开机" : "关机";
        $dataArray["回热泵状态"] = $v[4] == 1 ? "开机" : "关机";
        $dataArray["冷凝泵状态"] = $v[5] == 1 ? "开机" : "关机";
        $v = unpack('S*', substr($memData, 4 + 5, 2*168));
        $dataArray["制冷温度设定点"] = ($v[1]/10)."°C";
        $dataArray["热泵温度设定点"] = ($v[2]/10)."°C";
        $dataArray["恢复设定点"] = ($v[3]/10)."°C";
        $dataArray["主设定点激活温度"] = ($v[4]/10)."°C";
        $dataArray["恢复设定点激活温度"] = ($v[5]/10)."°C";
        $dataArray["蒸发器进口温度"] = ($v[6]/10)."°C";
        $dataArray["蒸发器出口温度"] = ($v[7]/10)."°C";
        $dataArray["冷凝泵进口温度"] = ($v[8]/10)."°C";
        $dataArray["冷凝泵出口温度"] = ($v[9]/10)."°C";
        $dataArray["回热泵进口温度"] = ($v[10]/10)."°C";
        $dataArray["回热泵出口温度"] = ($v[11]/10)."°C";

        $dataArray["高压传感器1"] = ($v[12]/10)."bar";
        $dataArray["高压传感器2"] = ($v[13]/10)."bar";
        $dataArray["高压传感器3"] = ($v[14]/10)."bar";
        $dataArray["高压传感器4"] = ($v[15]/10)."bar";

        $dataArray["低压传感器1"] = ($v[16]/10)."bar";
        $dataArray["低压传感器2"] = ($v[17]/10)."bar";
        $dataArray["低压传感器3"] = ($v[18]/10)."bar";
        $dataArray["低压传感器4"] = ($v[19]/10)."bar";

        $dataArray["外部空气温度"] = ($v[20]/10)."°C";
        $dataArray["可选探测器温度"] = ($v[21]/10)."°C";
        $dataArray["Freecooling进口温度"] = ($v[22]/10)."°C";

        $dataArray["蒸发器水侧差分压力传感器"] = ($v[23]/10)."kPa";
        $dataArray["回热泵水侧差分压力传感器"] = ($v[24]/10)."kPa";

        $dataArray["压缩机1排出压力"] = ($v[25]/10)."°C";
        $dataArray["压缩机2排出压力"] = ($v[26]/10)."°C";
        $dataArray["压缩机3排出压力"] = ($v[27]/10)."°C";
        $dataArray["压缩机4排出压力"] = ($v[28]/10)."°C";
        $dataArray["压缩机5排出压力"] = ($v[29]/10)."°C";
        $dataArray["压缩机6排出压力"] = ($v[30]/10)."°C";
        $dataArray["压缩机7排出压力"] = ($v[31]/10)."°C";
        $dataArray["压缩机8排出压力"] = ($v[32]/10)."°C";

        $dataArray["离心机1的IGV位置(%)"] = ($v[52]/10)."%";
        $dataArray["离心机2的IGV位置(%)"] = ($v[53]/10)."%";
        $dataArray["离心机3的IGV位置(%)"] = ($v[54]/10)."%";
        $dataArray["离心机4的IGV位置(%)"] = ($v[55]/10)."%";

        $dataArray["离心机1内部入口压力"] = ($v[56]/10)."barg";
        $dataArray["离心机2内部入口压力"] = ($v[57]/10)."barg";
        $dataArray["离心机3内部入口压力"] = ($v[58]/10)."barg";
        $dataArray["离心机4内部入口压力"] = ($v[59]/10)."barg";

        $dataArray["离心机1入口温度"] = ($v[60]/10)."°C";
        $dataArray["离心机2入口温度"] = ($v[61]/10)."°C";
        $dataArray["离心机3入口温度"] = ($v[62]/10)."°C";
        $dataArray["离心机4入口温度"] = ($v[63]/10)."°C";

        $dataArray["离心机1SCR温度"] = ($v[64]/10)."°C";
        $dataArray["离心机2SCR温度"] = ($v[65]/10)."°C";
        $dataArray["离心机3SCR温度"] = ($v[66]/10)."°C";
        $dataArray["离心机4SCR温度"] = ($v[67]/10)."°C";

        $dataArray["离心机1出口温度"] = ($v[68]/10)."°C";
        $dataArray["离心机2出口温度"] = ($v[69]/10)."°C";
        $dataArray["离心机3出口温度"] = ($v[70]/10)."°C";
        $dataArray["离心机4出口温度"] = ($v[71]/10)."°C";

        $dataArray["离心机1腔温度"] = ($v[72]/10)."°C";
        $dataArray["离心机2腔温度"] = ($v[73]/10)."°C";
        $dataArray["离心机3腔温度"] = ($v[74]/10)."°C";
        $dataArray["离心机4腔温度"] = ($v[75]/10)."°C";

        $dataArray["离心机1逆变器温度"] = ($v[76]/10)."°C";
        $dataArray["离心机2逆变器温度"] = ($v[77]/10)."°C";
        $dataArray["离心机3逆变器温度"] = ($v[78]/10)."°C";
        $dataArray["离心机4逆变器温度"] = ($v[79]/10)."°C";

        $dataArray["离心机1压缩比"] = ($v[80]/10);
        $dataArray["离心机2压缩比"] = ($v[81]/10);
        $dataArray["离心机3压缩比"] = ($v[82]/10);
        $dataArray["离心机4压缩比"] = ($v[83]/10);

        $dataArray["软件版本"] = ($v[84]/1);
        $dataArray["软件修订版本"] = ($v[85]/1);
        switch($v[86]){
            case 00:
                $dataArray["主机配置"] = "制冷";
                break;
            case 1:
                $dataArray["主机配置"] = "制冷+恢复";
                break;
            case 2:
                $dataArray["主机配置"] = "制冷+Freecooling";
                break;
            case 10:
                $dataArray["主机配置"] = "热泵";
                break;
            case 11:
                $dataArray["主机配置"] = "热泵+恢复";
                break;
            case 14:
                $dataArray["主机配置"] = "热泵+DHW";
                break;
            case 15:
                $dataArray["主机配置"] = "+2P 模组";
                break;
            case 21:
                $dataArray["主机配置"] = "能量提升";
                break;
            case 25:
                $dataArray["主机配置"] = "能量提升 + 2P";
                break;
            default:
                $dataArray["主机配置"] = "未知";
                break;
        }
        $dataArray["回路数"] = $v[87];
        $dataArray["压缩机数"] = $v[88];
        $dataArray["压缩机冲程数"] = $v[89];
        switch($v[90])
        {
            case 0:
                $dataArray["压缩机类型"] = "离心式";
                break;
            case 1:
                $dataArray["压缩机类型"] = "密封式";
                break;
            case 2:
                $dataArray["压缩机类型"] = "交替式";
                break;
            case 3:
                $dataArray["压缩机类型"] = "螺旋式";
                break;
        }
        $dataArray["设备配置状态"] = "";
        if($v[91] & 0x1){
            $dataArray["设备配置状态"] .= "热泵启用; ";
        }else{
            //$dataArray["设备配置状态"] .= "热泵禁用; ";
        }
        if(($v[91]>>3) & 0x1){
            $dataArray["设备配置状态"] .= "Freecooling启用; ";
        }else{
            //$dataArray["设备配置状态"] .= "Freecooling禁用; ";
        }
        if(($v[91]>>11) & 0x1){
            $dataArray["设备配置状态"] .= "恢复启用;";
        }else{
            //$dataArray["设备配置状态"] .= "恢复禁用;";
        }
        if(($v[92]) & 0x1){
            $dataArray["设备配置状态"] .= "定时启用; ";
        }else{
            //$dataArray["设备配置状态"] .= "定时禁用; ";
        }
        if(($v[92]>>1) & 0x1){
            $dataArray["设备配置状态"] .= "抽空启用; ";
        }else{
            //$dataArray["设备配置状态"] .= "抽空禁用; ";
        }
        if(($v[92]>>2) & 0x1){
            $dataArray["设备配置状态"] .= "设置点修改启用; ";
        }else{
            //$dataArray["设备配置状态"] .= "设置点修改禁用; ";
        }
        if(($v[92]>>3) & 0x1){
            $dataArray["设备配置状态"] .= "水冷; ";
        }else{
            $dataArray["设备配置状态"] .= "风冷; ";
        }
        if(($v[92]>>4) & 0x1){
            $dataArray["设备配置状态"] .= "时序器启用; ";
        }else{
            //$dataArray["设备配置状态"] .= "时序器禁用; ";
        }
        if(($v[92]>>5) & 0x1){
            $dataArray["设备配置状态"] .= "DHW启用; ";
        }else{
            //$dataArray["设备配置状态"] .= "DHW禁用; ";
        }
        if(($v[92]>>5) & 0x1){
            $dataArray["设备配置状态"] .= "+2P模组启用; ";
        }else{
            //$dataArray["设备配置状态"] .= "+2P模组禁用; ";
        }
        switch($v[93]){
            case 0:
                $dataArray["设备状态"] = "控制器开机";
                break;
            case 1:
                $dataArray["设备状态"] = "DI开机";
                break;
            case 2:
                $dataArray["设备状态"] = "定时开机";
                break;
            case 3:
                $dataArray["设备状态"] = "管理员开机";
                break;
            case 4:
                $dataArray["设备状态"] = "告警关机";
                break;
            case 5:
                $dataArray["设备状态"] = "管理员关机";
                break;
            case 6:
                $dataArray["设备状态"] = "定时关机";
                break;
            case 7:
                $dataArray["设备状态"] = "DI关机";
                break;
            case 8:
                $dataArray["设备状态"] = "控制器关机";
                break;
            case 9:
                $dataArray["设备状态"] = "压缩机脱离关机";
                break;
            case 10:
                $dataArray["设备状态"] = "关机";
                break;
        }
        switch($v[94])
        {
            case 0:
                $dataArray["时序状态"] = "关机";
                break;
            case 1:
                $dataArray["时序状态"] = "准备中";
                break;
            case 3:
                $dataArray["时序状态"] = "全速运转";
                break;
            case 4:
                $dataArray["时序状态"] = "关断相位";
                break;
            case 5:
                $dataArray["时序状态"] = "压缩机启动";
                break;
            case 6:
                $dataArray["时序状态"] = "泵启动";
                break;
            case 8:
                $dataArray["时序状态"] = "告警关机";
                break;
        }

        $dataArray["离心机1-3相输入电压"] = $v[151];
        $dataArray["离心机2-3相输入电压"] = $v[152];
        $dataArray["离心机3-3相输入电压"] = $v[153];
        $dataArray["离心机4-3相输入电压"] = $v[154];

        $dataArray["离心机1-消耗电流"] = $v[155];
        $dataArray["离心机2-消耗电流"] = $v[156];
        $dataArray["离心机3-消耗电流"] = $v[157];
        $dataArray["离心机4-消耗电流"] = $v[158];

        $dataArray["VPF管理下主泵速度%"] = $v[167]/10;
        $dataArray["VPF管理下备用泵速度%"] = $v[168]/10;
        $v = unpack('v', substr($memData, 4 + 5+  2*168, 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData, 4 + 5 + 2*168 + 2, 5));
        $dataArray["更新时间"] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}
?>
