<?php

function Get_cmplus_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '温度设定点':
            return array(0,  $dataArray['温度设定点']);
        case '回风温度':
            return array(0, $dataArray['温度']);
        default:
            break;
    }
    return array(1 , '设备无此信号数据:'. $varname);
}    

function Get_cmplus_RtData($memData, &$dataArray, $extraPara = false)
{
    if (empty($memData)) {
        $dataArray["无数据"] = true;
        $dataArray["更新时间"] = '无';
        $dataArray["错误"] = "数据长度不一致";
    } else {
        $dataArray["无数据"] = false;
        $dataArray["AlertArray"] = array();
        $v = unpack('c*', substr($memData, 4, 4 * 1));
        $dataArray["机组状态"] = $v[1] == 0 ? "开机" : "关机";
        $dataArray["报警蜂鸣器状态"] = $v[2] == 1 ? "开" : "关";
        if($v[3] == 1){
            $dataArray["机组类型"] = "数据冷却器机组";
        }else if($v[4] == 1)
        {
            $dataArray["机组类型"] = "LECS15机组";
        }
        $v = unpack('f*', substr($memData, 8, 2 * 4));
        $dataArray["温度"] = number_format($v[1], 2)."℃";
        $dataArray["湿度"] = number_format($v[2], 2)."%";

        $v = unpack('c*', substr($memData, 16, 1 * 3));
        $dataArray["高温"] = (($v[1] & 0x1) == 0) ? "告警" : "正常";
        $dataArray["AlertArray"]["高温"] = (($v[1] & 0x1) == 0);

        $dataArray["低温"] = ((($v[1]>>1) & 0x1) == 0)  ? "告警" : "正常";
        $dataArray["AlertArray"]["低温"] = ((($v[1]>>1) & 0x1) == 0);

        $dataArray["传感器板故障"] = (($v[1] & 0x3) == 0x0) ? "告警" : "正常";
        $dataArray["AlertArray"]["传感器板故障"] = (($v[1] & 0x3) == 0x0);

        $dataArray["高湿"] = ((($v[1]>>2) & 0x1) == 0) ? "告警" : "正常";
        $dataArray["AlertArray"]["高湿"] = ((($v[1]>>2) & 0x1) == 0);

        $dataArray["低湿"] = ((($v[1]>>3) & 0x1) == 0) ? "告警" : "正常";
        $dataArray["AlertArray"]["低湿"] = ((($v[1]>>3) & 0x1) == 0);

        $dataArray["气流丢失"] = ((($v[1]>>4) & 0x1) == 0) ? "告警" : "正常";
        $dataArray["AlertArray"]["气流丢失"] = ((($v[1]>>4) & 0x1) == 0);

        $dataArray["地板溢水"] = ((($v[1]>>5) & 0x1) == 0) ? "告警" : "正常";
        $dataArray["AlertArray"]["地板溢水"] = ((($v[1]>>5) & 0x1) == 0);

        $dataArray["压缩机1低压"] = (($v[2] & 0x1) == 0) ? "告警" : "正常";
        $dataArray["AlertArray"]["压缩机1低压"] = (($v[2] & 0x1) == 0);

        $dataArray["压缩机1高压"] = ((($v[2]>>1) & 0x1) == 0) ? "告警" : "正常";
        $dataArray["AlertArray"]["压缩机1高压"] = ((($v[2]>>1) & 0x1) == 0);

        $dataArray["压缩机2高压"] = ((($v[2]>>2) & 0x1) == 0) ? "告警" : "正常";
        $dataArray["AlertArray"]["压缩机2高压"] = ((($v[2]>>2) & 0x1) == 0);

        $dataArray["制冷模式"] = ((($v[2]>>3) & 0x1) == 0) ? "是" : "否";
        $dataArray["加热模式"] = ((($v[2]>>4) & 0x1) == 0) ? "是" : "否";
        $dataArray["加湿模式"] = ((($v[2]>>5) & 0x1) == 0) ? "是" : "否";
        $dataArray["除湿模式"] = ((($v[2]>>6) & 0x1) == 0) ? "是" : "否";

        $dataArray["压缩机2低压"] = ((($v[2]>>7) & 0x1) == 0) ? "告警" : "正常";
        $dataArray["AlertArray"]["压缩机2低压"] = ((($v[2]>>7) & 0x1) == 0);

        $dataArray["制冷系统维护请求"] = (($v[3] & 0x1) == 0) ? "告警" : "正常";
        $dataArray["AlertArray"]["制冷系统维护请求"] = (($v[3] & 0x1) == 0);

        $dataArray["湿度系统维护请求"] = ((($v[3]>>1) & 0x1) == 0) ? "告警" : "正常";
        $dataArray["AlertArray"]["湿度系统维护请求"] = ((($v[3]>>1) & 0x1) == 0);

        $dataArray["空气系统维护请求"] = ((($v[3]>>2) & 0x1) == 0) ? "告警" : "正常";
        $dataArray["AlertArray"]["空气系统维护请求"] = ((($v[3] >> 2) & 0x1) == 0);

        $dataArray["加湿器低水位"] = ((($v[3]>>3) & 0x1) == 0) ? "告警" : "正常";
        $dataArray["AlertArray"]["加湿器低水位"] = ((($v[3] >> 3) & 0x1) == 0);

        $dataArray["备用报警1"] = ((($v[3]>>4) & 0x1) == 0) ? "告警" : "正常";
        $dataArray["AlertArray"]["备用报警1"] = ((($v[3] >> 4) & 0x1) == 0);

        $dataArray["备用告警2"] = ((($v[3]>>5) & 0x1) == 0) ? "告警" : "正常";
        $dataArray["AlertArray"]["备用告警2"] = ((($v[3] >> 5) & 0x1) == 0);

        $dataArray["备用报警3"] = ((($v[3]>>6) & 0x1) == 0) ? "告警" : "正常";
        $dataArray["AlertArray"]["备用报警3"] = ((($v[3] >> 6) & 0x1) == 0);

        $dataArray["电源丢失"] = ((($v[3]>>7) & 0x1) == 0) ? "告警" : "正常";
        $dataArray["AlertArray"]["电源丢失"] = ((($v[3] >> 7) & 0x1) == 0);

        $v = unpack('C*', substr($memData, 19, 2 * 1));
        $dataArray["温度设定点"] = number_format($v[1], 2)."℃";
        $dataArray["湿度设定点"] = number_format($v[2], 2)."%";
        $v = unpack('C*', substr($memData, 21, 10));

        $dataArray["HP1输入状态"] = ($v[5] & 0x1) ? "使能" : "禁用";
        $dataArray["LP1输入状态"] = (($v[5] >> 3) & 0x1) ? "使能" : "禁用";
        $dataArray["LP2输入状态"] = (($v[5] >> 4) & 0x1) ? "使能" : "禁用";
        $dataArray["远程关机使能"] = (($v[5] >> 5) & 0x1) ? "使能" : "禁用";
        $dataArray["HP2输入状态"] = (($v[5] >> 7) & 0x1) ? "使能" : "禁用";

        $dataArray["压缩机1开"] = (($v[6] >> 3) & 0x1) ? "开" : "关";
        $dataArray["压缩机2开"] = (($v[6] >> 4) & 0x1) ? "开" : "关";
        $dataArray["电加热1开"] = (($v[6] >> 5) & 0x1) ? "开" : "关";
        $dataArray["电加热2开"] = (($v[6] >> 6) & 0x1) ? "开" : "关";
        $dataArray["热气盘通开"] = (($v[6] >> 7) & 0x1) ? "开" : "关";

        $dataArray["冷冻水阀开度"] = number_format( ($v[7] >> 4)/15, 2)."%";

        $dataArray["冲洗阀开"] = (($v[8]) & 0x1) ? "开" : "关";
        $dataArray["加湿器开"] = (($v[8] >> 1) & 0x1) ? "开" : "关";
        $dataArray["除湿风机模式开"] = (($v[8] >> 2) & 0x1) ? "开" : "关";
        $dataArray["风机开"] = (($v[8] >> 4) & 0x1) ? "开" : "关";

        $dataArray["二号机组使能"] = (($v[9] >> 4) & 0x1) ? "开" : "关";

        $v = unpack('S*', substr($memData, 31, 2 * 3));
        $dataArray["制冷系统小时数"] = $v[1];
        $dataArray["湿度系统小时数"] = $v[2];
        $dataArray["空气系统小时数"] = $v[3];

        $v = unpack('v', substr($memData, 31+6, 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData, 31 + 6 + 2, 5));
        $dataArray["更新时间"] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}

?>
