<?php
function Get_cpm3310_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '[A相电压]':
            return array(0, $dataArray['AB线电压(V)']);
        case '[B相电压]':
            return array(0, $dataArray['BC线电压(V)']);
        case '[C相电压]':
            return array(0, $dataArray['CA线电压(V)']);
        case '[总功率]':
            return array(0, $dataArray["总有功功率2"]);
    }
    return array(1 , '设备无此信号数据:'. $varname);
}

function Get_cpm3310_RtData($memData, &$dataArray, $extraPara = false)
{
   if(empty($memData)) {
       $dataArray['无数据'] = true;
       $dataArray['更新时间'] = '无';
       $dataArray['错误'] = '数据长度不一致';
   } else {
        $dataArray['无数据'] = false;
        $v = unpack('s*',substr($memData,4,4));
        $dataArray["voltageScale"] = $v[1];//电压变比
        $dataArray["currentScale"] = $v[2];//电流变比
        $v = unpack('s*',substr($memData,8,27*2));
        $dataArray["A相电流(A)"] = number_format($v[1] * $dataArray["currentScale"],2);
        $dataArray["B相电流(A)"] = number_format($v[2] * $dataArray["currentScale"],2);
        $dataArray["C相电流(A)"] = number_format($v[3] * $dataArray["currentScale"],2);
        $dataArray["reserved"] = $v[4];
        $dataArray["AB线电压(V)"] = number_format($v[5]/10,2);
        $dataArray["BC线电压(V)"] = number_format($v[6]/10,2);
        $dataArray["CA线电压(V)"] = number_format($v[7]/10,2);
        $dataArray["A相电压(V)"] = number_format($v[8]/10,2);
        $dataArray["B相电压(V)"] = number_format($v[9]/10,2);
        $dataArray["C相电压(V)"] = number_format($v[10]/10,2);
        $dataArray["频率(Hz)"] = $v[11]/100;
        $dataArray["总有功功率(W)"] = $v[12];
        $dataArray["总有功功率2"] = $v[12] / 1000;
        $dataArray["总无功功率(var)"] = $v[13];
        $dataArray["总视功功率(VA)"] = $v[14];
        $dataArray["总功率因数"] = $v[15]/1000;
        $dataArray["A相有功功率(W)"] = $v[16];
        $dataArray["B相有功功率(W)"] = $v[17];
        $dataArray["C相有功功率(W)"] = $v[18];
        $dataArray["A相无功功率(var)"] = $v[19];
        $dataArray["B相无功功率(var)"] = $v[20];
        $dataArray["C相无功功率(var)"] = $v[21];
        $dataArray["A相视在功率(VA)"] = $v[22];
        $dataArray["B相视在功率(VA)"] = $v[23];
        $dataArray["C相视在功率(VA)"] = $v[24];
        $dataArray["A相功率因数"] = $v[25]/1000;
        $dataArray["B相功率因数"] = $v[26]/1000;
        $dataArray["C相功率因数"] = $v[27]/1000;
        
        $v = unpack('v', substr($memData, 8+27*2,2));
        $year = $v[1];
        $v = unpack('C*', substr($memData,  8+27*2+2,5));
        $dataArray["更新时间"] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
   }
}

?>
