<?php

function Get_cuc21vb_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '直流负载电流':
            $total = 0.0;
            for($i=1;$i<=5;$i++){
                if(isset($dataArray["直流屏".$i])){
                    $total += floatval($dataArray["直流屏".$i]["负载总电流"]);
                    continue;
                }
                break;
            }
            return array(0, $total."A");
        case '整流模块数量':
            return array(0, $dataArray['整流模块数']);
        default:
            break;
    }
    return array(1 , '设备无此信号数据:'. $varname);
}

function _GetCheckCuc21vbShutDown($value){
    switch ($value){
        case 0: return '开机';
        case 1: return '关机';
        case 225: return '效能待机';
        case 240: return '模块屏蔽';
        case 254: return '通讯中断';
        default : break;
    }
    return '无效';
}

function _GetCheckCuc21vbILimit($value){
    switch ($value){
        case 0: return '限流';
        case 1: return '不限流';
        case 240: return '模块屏蔽';
        case 254: return '通讯中断';
        default : break;
    }
    return '无效';
}

function _GetCheckCuc21vbCharge($value){
    switch ($value){
        case 0: return '浮充';
        case 1: return '均充';
        case 2: return '测试';
        case 240: return '模块屏蔽';
        case 241: return '电池放电';
        case 242: return '市电中断';
        case 254: return '通讯中断';
        default : break;
    }
    return '无效';
}

function _GetCheckCuc21vbFault($value){
    switch ($value){
        case 0: return '正常';
        case 1: return '告警';
        case 240: return '模块屏蔽';
        case 254: return '通讯中断';
        default : break;
    }
    return '无效';
}

function Is_cuc21vb_NeedExtraPara(){
    return true;
}

function Get_cuc21vb_RtData($memData, &$dataArray, $extraPara = false)
{
    if (!empty($memData)) {
        $dataArray["无数据"] = false;
        $v = unpack('f*', substr($memData, 4, 4));    //float
        $dataArray["整流器输出电压"] = number_format($v[1], 2)."V";
        $v = unpack('C*', substr($memData, 4 + 4, 1));//unsigned char
        $dataArray["整流模块数"] = $channel_count = $v[1];
        $v = unpack('v', substr($memData, 9, 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData, 11, 5));
        $dataArray["更新时间"] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
        $ac_number = isset($extraPara->ac_number) ? $extraPara->ac_number : 1;
        $offset = 16;
        for($i = 0; $i < $ac_number; $i++){
            $key = "交流屏".($i+1);
            $v = unpack('f*', substr($memData, $offset, 4 * 12));
            $dataArray[$key."交流1-A相电压"] = number_format($v[1], 2)."V";
            $dataArray[$key."交流1-B相电压"] = number_format($v[2], 2)."V";
            $dataArray[$key."交流1-C相电压"] = number_format($v[3], 2)."V";
            $dataArray[$key."交流2-A相电压"] = number_format($v[4], 2)."V";
            $dataArray[$key."交流2-B相电压"] = number_format($v[5], 2)."V";
            $dataArray[$key."交流2-C相电压"] = number_format($v[6], 2)."V";
            $dataArray[$key."交流A相负载电流"] = number_format($v[7], 2)."A";
            $dataArray[$key."交流B相负载电流"] = number_format($v[8], 2)."A";
            $dataArray[$key."交流C相负载电流"] = number_format($v[9], 2)."A";
            $dataArray[$key."交流零线电流"] = number_format($v[10], 2)."A";
            $dataArray[$key."交流1-频率"] = number_format($v[11]*10, 2)."Hz";//协议说应该除以10,实际读出来是5,应该x10
            $dataArray[$key."交流2-频率"] = number_format($v[12]*10, 2)."Hz";

            $v = unpack('c*', substr($memData, $offset + 4 * 12, 3));
            switch($v[1])
            {
                case '0':
                    $dataArray[$key."ATS状态"] = "位置0";
                    break;
                case '1':
                    $dataArray[$key."ATS状态"] = "位置1";
                    break;
                case '2':
                    $dataArray[$key."ATS状态"] = "位置2";
                    break;
            }
            switch($v[2])
            {
                case '0':
                    $dataArray[$key."ATS工作模式"] = "自动";
                    break;
                case '1':
                    $dataArray[$key."ATS工作模式"] = "手动";
                    break;
                case '2':
                    $dataArray[$key."ATS工作模式"] = "维护";
                    break;
            }
            switch($v[3])
            {
                case '0':
                    $dataArray[$key."交流投入状态"] = "AC全断";
                    break;
                case '1':
                    $dataArray[$key."交流投入状态"] = "AC1供电";
                    break;
                case '2':
                    $dataArray[$key."交流投入状态"] = "AC2供电";
                    break;
                case '3':
                    $dataArray[$key."交流投入状态"] = "AC3供电";
                    break;
            }
            $offset += 4*12 + 3;
        }

        $dc_number = isset($extraPara->dc_number) ? $extraPara->dc_number : 1;
        $a = $offset;
        for($i = 0; $i < $dc_number; $i++){
            $key = "直流屏".($i+1);
            $v = unpack('s',substr($memData, $offset, 2));
            $dataArray[$key."负载总电流"] = number_format($v[1]/10, 2)."A";
            $v = unpack('i*',substr($memData, $offset + 2, 4*2));
            $dataArray[$key."总电度"] = number_format($v[1]/100, 2)."KWh";
            $dataArray[$key."总功率"] = number_format($v[2]/100, 2)."KW";
            $v = unpack('c',substr($memData, $offset + 2 + 4*2, 1));
            $dataArray[$key."直流分路数目"] = $v[1];
            $channelOffset = $offset + 2 + 4*2 + 1;
            for($j = 0; $j < 16; $j++)
            {
                $cKey = "直流分路". ($j+1);
                $v = unpack('s',substr($memData, $channelOffset, 2));
                $dataArray[$key.$cKey."分路电流"] = number_format($v[1]/10, 2)."A";
                $v = unpack('i*',substr($memData, $channelOffset + 2, 4*2));
                $dataArray[$key.$cKey."电度"] = number_format($v[1]/100, 2)."KWh";
                $dataArray[$key.$cKey."功率"] = number_format($v[2]/100, 2)."KW";
                $v = unpack('s',substr($memData, $channelOffset + 2 + 4*2, 2));
                $dataArray[$key.$cKey."漏电流"] = number_format($v[1]/10, 2)."A";
                $channelOffset += (2 + 4*2 + 2 + 1);
            }
            $offset += (2 + 4*2 + 1) + (2 + 4*2 + 2 + 1)*16;
        }
        $v = unpack('c*',substr($memData, $offset, 2));
        $dataArray["限流状态"] = $v[1] == 1 ? '限流' : '不限流';
        $currentChargeStatus = $v[2];
        switch($currentChargeStatus)
        {
            case 1:
                $dataArray["系统状态"] = '电池放电';
    	        break;
    	    case 2:
                $dataArray["系统状态"] = '浮充';
    	        break;
    	    case 3:
                $dataArray["系统状态"] = '手动均充';
    	        break;
    	    case 4:
                $dataArray["系统状态"] = '周期均充';
    	        break;
    	    case 5:
                $dataArray["系统状态"] = '交流复电均充';
    	        break;
    	    case 6:
                $dataArray["系统状态"] = '整流屏交流中断';
    	        break;
    	    case 7:
                $dataArray["系统状态"] = '浅放电触发均充';
    	        break;
    	    case 8:
                $dataArray["系统状态"] = '电流触发均充';
    	        break;
    	    case 9:
                $dataArray["系统状态"] = '电压触发均充';
    	        break;
    	    case 10:
                $dataArray["系统状态"] = '电池测试';
    	        break;
    	    default:
                $dataArray["系统状态"] = '无效';
                break;
        }
        $v = unpack('f*',substr($memData, $offset + 2, 4));
        $dataArray["系统负载电流"] = number_format($v[1], 2)."A";
        $offset += (2 + 4);
        for ($i = 0; $i < $channel_count ; $i++) {
            $key = "模块".($i+1);
            $channelData = substr($memData, $offset + $i * 68, 68);
            $v = unpack('f*', substr($channelData, 0 , 4 * 1));//float
            $dataArray[$key."输出电流"] = number_format($v[1], 2)."A";
            $v = unpack('C*', substr($channelData, 4, 1 * 14));//signed char
            $dataArray[$key."开机/关机状态"] = _GetCheckCuc21vbShutDown($v[1]);
            $dataArray[$key."限流/不限流状态"] = _GetCheckCuc21vbILimit($v[2]);
            $dataArray[$key."浮充/均充/测试状态"] = _GetCheckCuc21vbCharge($v[3]);
            $dataArray[$key."告警状态"] = _GetCheckCuc21vbFault($v[4]);
            $dataArray["AlertArray"][$key."告警状态"] = $v[4] == 1;
            $dataArray[$key."id"] = $v[5];
            //status 9

            //byte 1
            $dataArray[$key."运行状态"] = ($v[6] >> 1) & 0x1 ? "关机" : "运行";
            $dataArray[$key."故障状态"] = ($v[6] >> 4) & 0x1 ? "故障" : "正常";

            $dataArray[$key."模块限流"] = ($v[6] >> 5) & 0x1 ? "限流" : "不限流";
            $dataArray["AlertArray"][$key."模块限流"] = ($v[6] >> 5) & 0x1;
            $dataArray[$key."风扇状态"] = ($v[6] >> 6) & 0x1 ? "故障" : "正常";
            $dataArray["AlertArray"][$key."风扇告警"] = ($v[6] >> 6) & 0x1;
            //byte 2
            $dataArray[$key."交流高压"] = ($v[7]) & 0x1 ? "交流高压" : "正常";
            $dataArray["AlertArray"][$key."交流高压"] = ($v[7]) & 0x1;
            $dataArray[$key."交流低压"] = ($v[7] >> 2) & 0x1 ? "交流低压" : "正常";
            $dataArray["AlertArray"][$key."交流低压"] = ($v[7] >> 2) & 0x1;
            $dataArray[$key."1相状态"] = ($v[7] >> 3) & 0x1 ? "异常" : "正常";
            $dataArray["AlertArray"][$key."1相状态"] = ($v[7] >> 3) & 0x1;
            $dataArray[$key."2相状态"] = ($v[7] >> 4) & 0x1 ? "异常" : "正常";
            $dataArray["AlertArray"][$key."2相状态"] = ($v[7] >> 4) & 0x1;
            $dataArray[$key."单机工作"] = ($v[7] >> 6) & 0x1 ? "单机工作" : "正常";
            $dataArray["AlertArray"][$key."单机工作"] = ($v[7] >> 6) & 0x1;
            $dataArray[$key."均流状态"] = ($v[7] >> 7) & 0x1 ? "异常" : "正常";
            $dataArray["AlertArray"][$key."均流状态"] = ($v[7] >> 7) & 0x1;
            //byte 3
            $dataArray[$key."轻载"] = ($v[8]) & 0x1 ? "轻载" : "正常";
            $dataArray["AlertArray"][$key."轻载"] = ($v[8]) & 0x1;
            $dataArray[$key."直流高压"] = ($v[8] >> 1) & 0x1 ? "直流高压" : "正常";
            $dataArray["AlertArray"][$key."直流高压"] = ($v[8] >> 1) & 0x1;
            $dataArray[$key."直流过高压"] = ($v[8] >> 2) & 0x1 ? "直流过高压" : "正常";
            $dataArray["AlertArray"][$key."直流过高压"] = ($v[8] >> 2) & 0x1;
            $dataArray[$key."直流低压"] = ($v[8] >> 3) & 0x1 ? "直流低压" : "正常";
            $dataArray["AlertArray"][$key."直流低压"] = ($v[8] >> 3) & 0x1;
            $dataArray[$key."过流保护"] = ($v[8] >> 6) & 0x1 ? "过流保护" : "正常";
            $dataArray["AlertArray"][$key."过流保护"] = ($v[8] >> 6) & 0x1;
            $dataArray[$key."内部环境过温"] = ($v[8] >> 7) & 0x1 ? "过温" : "正常";
            $dataArray["AlertArray"][$key."内部环境过温"] = ($v[8] >> 7) & 0x1;
            //byte 4
            $dataArray[$key."模块休眠待机"] = ($v[9]) & 0x1 ? "休眠待机" : "正常";
            //$dataArray["AlertArray"][$key."模块休眠待机"] = ($v[9]) & 0x1;
            $dataArray[$key."模块交流低压限功率"] = ($v[9] >> 1) & 0x1 ? "模块交流低压限功率" : "正常";
            $dataArray["AlertArray"][$key."模块交流低压限功率"] = ($v[9] >> 1) & 0x1;
            $dataArray[$key."模块高温限功率"] = ($v[9] >> 2) & 0x1 ? "模块高温限功率" : "正常";
            $dataArray["AlertArray"][$key."模块高温限功率"] = ($v[9] >> 2) & 0x1;
            $dataArray[$key."模块内部错误"] = ($v[9] >> 3) & 0x1 ? "模块内部错误" : "正常";
            $dataArray["AlertArray"][$key."模块内部错误"] = ($v[9] >> 3) & 0x1;
            $dataArray[$key."PFC过压"] = ($v[9] >> 4) & 0x1 ? "PFC过压" : "正常";
            $dataArray["AlertArray"][$key."PFC过压"] = ($v[9] >> 4) & 0x1;
            $dataArray[$key."PFC欠压"] = ($v[9] >> 5) & 0x1 ? "PFC欠压" : "正常";
            $dataArray["AlertArray"][$key."PFC欠压"] = ($v[9] >> 5) & 0x1;
            $dataArray[$key."PFC过温"] = ($v[9] >> 6) & 0x1 ? "PFC过温" : "正常";
            $dataArray["AlertArray"][$key."PFC过温"] = ($v[9] >> 6) & 0x1;
            $dataArray[$key."PFC故障"] = ($v[9] >> 7) & 0x1 ? "PFC故障" : "正常";
            $dataArray["AlertArray"][$key."PFC故障"] = ($v[9] >> 7) & 0x1;
            //byte 5
            $dataArray[$key."DCDC过温"] = ($v[10]) & 0x1 ? "DCDC过温" : "正常";
            $dataArray["AlertArray"][$key."DCDC过温"] = ($v[10]) & 0x1;
            $dataArray[$key."均流不平衡"] = ($v[10] >> 1) & 0x1 ? "均流不平衡" : "正常";
            $dataArray["AlertArray"][$key."均流不平衡"] = ($v[10] >> 1) & 0x1;
            $dataArray[$key."DCDC故障"] = ($v[10] >> 2) & 0x1 ? "DCDC故障" : "正常";
            $dataArray["AlertArray"][$key."DCDC故障"] = ($v[10] >> 2) & 0x1;
            $dataArray[$key."EEPROM读写错误"] = ($v[10] >> 3) & 0x1 ? "EEPROM读写错误" : "正常";
            $dataArray["AlertArray"][$key."EEPROM读写错误"] = ($v[10] >> 3) & 0x1;
            $dataArray[$key."内部SCI通讯中断"] = ($v[11] >> 4) & 0x1 ? "内部SCI通讯中断" : "正常";
            $dataArray["AlertArray"][$key."内部SCI通讯中断"] = ($v[11] >> 4) & 0x1;
            $dataArray[$key."模块地址设置错误"] = ($v[11] >> 5) & 0x1 ? "模块地址设置错误" : "正常";
            $dataArray["AlertArray"][$key."模块地址设置错误"] = ($v[11] >> 5) & 0x1;
            //byte 9, 15
            $dataArray[$key."通信状态"] = ($v[14]) & 0x1 ? "故障" : "正常";
            $dataArray["AlertArray"][$key."通信状态"] = ($v[14]) & 0x1;

            $v = unpack('S*', substr($channelData, 4 + 14, 2*3));
            $dataArray[$key."电压"] = $v[1];
            $dataArray[$key."电流"] = $v[2];
            $dataArray[$key."温度"] = $v[3]."℃";
            $v = unpack('i*', substr($channelData, 4 + 14 + 2*3, 12));
            $dataArray[$key."功率"] = $v[1];
            $dataArray[$key."运行时间"] = $v[2];
            $dataArray[$key."休眠时间"] = $v[3];
            //$v = unpack('c*', substr($channelData, 4 + 14 + 2*3 + 12, 16));
            //$channelObj["机种号"] = implode("", $v);
            //$v = unpack('c*', substr($channelData, 4 + 14 + 2*3 + 12 + 16, 16));
            //$channelObj["序列号"] = implode("", $v);
        }
        $offset += $channel_count * 68;
        //CUC21VB_41_91_t  电池组信息
        for($i = 0 ; $i < 8 ; $i++){
            $key = "电池组".($i+1);
            $batteryData = substr($memData , $offset + $i*18, 18);
            $v = unpack('I*' , substr($batteryData , 0 , 4));
            //$dataArray[$key."电池组标签"] = $v[1];
            $v = unpack('S*' , substr($batteryData , 4 , 2*7));
            $dataArray[$key."电压"] = ($v[1]/10)."V";
            $dataArray[$key."电流"] = $v[2];
            $dataArray[$key."温度"] = number_format($v[3]/10, 1)."℃";
            $dataArray[$key."剩余电量"] = $v[4]."AH";
            $dataArray[$key."浅放电容量"] = $v[5];
            $dataArray[$key."后备时间"] = ($v[6]/10)."小时";
            $dataArray[$key."放电时间"] = $v[7]."小时";
            $dataArray["电池组".($i+1)] = $batteryObj;
        }
        $offset += 144;
        //CUC21VB_41_93_t  环境温度
        $v = unpack('S*', substr($memData , $offset , 2));
        $dataArray["环境温度"] = number_format($v[1]/10, 1)."℃";
        $leftLen = strlen($memData) - ($offset + 2);
        if($leftLen)
        {
            $count = $leftLen / 4;
            $alarmItemArray = array();
            $alarmOffset = ($offset + 2);
            for($iAlarm=0;$iAlarm<$count; $iAlarm++)
            {
                //echo "offset:".( + 4*$iAlarm)."<br/>";
                $v = unpack("C*", substr($memData, $alarmOffset + 4*$iAlarm, 2));
                $device_no = $v[1];
                $type = $v[2];
                $v = unpack("S", substr($memData, $alarmOffset + 4*$iAlarm + 2, 2));
                $alarm_no = $v[1];
                //echo $device_no." ".$type." ".$alarm_no."<br/>";
                switch($type)
                {
                    case 1:
                        if($alarm_no <= 8)
                        {
                            $alarmItemArray[] = "第".$alarm_no."组电池温度高";
                        }else if($alarm_no <= 12)
                        {
                            $alarmItemArray[] = "第A1-".($alarm_no-8)."组电池温度高";
                        }else{
                            $alarmItemArray[] = "第B1-".($alarm_no-12)."组电池温度高";
                        }
                        break;
                    case 2:
                        if($alarm_no <= 8)
                        {
                            $alarmItemArray[] = "第".$alarm_no."组电池回路断";
                        }else if($alarm_no <= 12)
                        {
                            $alarmItemArray[] = "第A1-".($alarm_no-8)."组电池回路断";
                        }else{
                            $alarmItemArray[] = "第B1-".($alarm_no-12)."组电池回路断";
                        }
                        break;
                    case 3:
                        if($alarm_no <= 8)
                        {
                            $alarmItemArray[] = "第".$alarm_no."组电池温度传感器故障";
                        }else if($alarm_no <= 12)
                        {
                            $alarmItemArray[] = "第A1-".($alarm_no-8)."组电池温度传感器故障";
                        }else{
                            $alarmItemArray[] = "第B1-".($alarm_no-12)."组电池温度传感器故障";
                        }
                        break;
                    case 4:
                        if($alarm_no <= 8)
                        {
                            $alarmItemArray[] = "第".$alarm_no."组电池电压传感器故障";
                        }else if($alarm_no <= 12)
                        {
                            $alarmItemArray[] = "第A1-".($alarm_no-8)."组电池电压传感器故障";
                        }else{
                            $alarmItemArray[] = "第B1-".($alarm_no-12)."组电池电压传感器故障";
                        }
                        break;
                    case 5:
                        if($alarm_no <= 8)
                        {
                            $alarmItemArray[] = "第".$alarm_no."组电池测试失败";
                        }else if($alarm_no <= 12)
                        {
                            $alarmItemArray[] = "第A1-".($alarm_no-8)."组电池测试失败";
                        }else{
                            $alarmItemArray[] = "第B1-".($alarm_no-12)."组电池测试失败";
                        }
                        break;
                    case 6:
                        $alarmItemArray[] = "第".$alarm_no."模块通讯故障";
                        break;
                    case 7:
                        $alarmItemArray[] = "第".$alarm_no."模块电压钳位";
                        break;
                    case 8:
                        $alarmItemArray[] = "第".$alarm_no."模块关机";
                        break;
                    case 9:
                        $alarmItemArray[] = "第".$alarm_no."模块限流";
                        break;
                    case 10:
                        $alarmItemArray[] = "第".$alarm_no."模块风扇故障";
                        break;
                    case 11:
                        $alarmItemArray[] = "第".$alarm_no."模块熔丝断";
                        break;
                    case 12:
                        $name = "第".$device_no."交流屏";
                        switch($alarm_no)
                        {
                            case 1:
                                $alarmItemArray[] = $name."AC1过压";
                                break;
                            case 4:
                                $alarmItemArray[] = $name."AC1低压";
                                break;
                            case 7:
                                $alarmItemArray[] = $name."AC1频率异常";
                                break;
                            case 8:
                                $alarmItemArray[] = $name."AC1瞬间高压";
                                break;
                            case 9:
                                $alarmItemArray[] = $name."AC1缺相";
                                break;
                            case 12:
                                $alarmItemArray[] = $name."AC1相间不平衡";
                                break;
                            case 13:
                                $alarmItemArray[] = $name."AC1停电";
                                break;
                            case 14:
                                $alarmItemArray[] = $name."AC1输入空开跳脱";
                                break;
                            case 17:
                                $alarmItemArray[] = $name."AC2过压";
                                break;
                            case 20:
                                $alarmItemArray[] = $name."AC2欠压";
                                break;
                            case 23:
                                $alarmItemArray[] = $name."AC2频率异常";
                                break;
                            case 24:
                                $alarmItemArray[] = $name."AC2瞬间高压";
                                break;
                            case 25:
                                $alarmItemArray[] = $name."AC2缺相";
                                break;
                            case 28:
                                $alarmItemArray[] = $name."AC2相间不平衡";
                                break;
                            case 29:
                                $alarmItemArray[] = $name."AC2停电";
                                break;
                            case 30:
                                $alarmItemArray[] = $name."AC2输入空开跳脱";
                                break;
                            case 49:
                                $alarmItemArray[] = $name."交流总电流A过大";
                                break;
                            case 50:
                                $alarmItemArray[] = $name."交流总电流B过大";
                                break;
                            case 51:
                                $alarmItemArray[] = $name."交流总电流C过大";
                                break;
                            case 52:
                                $alarmItemArray[] = $name."零线电流过高";
                                break;
                            case 53:
                                $alarmItemArray[] = $name."ATS_AC1位置故障";
                                break;
                            case 54:
                                $alarmItemArray[] = $name."ATS_AC2位置故障";
                                break;
                            case 55:
                                $alarmItemArray[] = $name."ATS断开位置故障";
                                break;
                            case 56:
                                $alarmItemArray[] = $name."ATS手动状态故障";
                                break;
                            case 57:
                                $alarmItemArray[] = $name."无投入告警";
                                break;
                            case 58:
                                $alarmItemArray[] = $name."测试状态告警";
                                break;
                            case 59:
                                $alarmItemArray[] = $name."分路电流告警";
                                break;
                            case 60:
                                $alarmItemArray[] = $name."ATS输出总空开跳脱";
                                break;
                            case 61:
                                $alarmItemArray[] = $name."ATS控制器供电异常";
                                break;
                            case 62:
                                $alarmItemArray[] = $name."ATS互锁故障";
                                break;
                            case 63:
                                $alarmItemArray[] = $name."ATS手动互锁故障";
                                break;
                            case 64:
                                $alarmItemArray[] = $name."定期维护告警";
                                break;
                            case 65:
                                $alarmItemArray[] = $name."扩展板1通讯故障";
                                break;
                            case 66:
                                $alarmItemArray[] = $name."扩展板2通讯故障";
                                break;
                            case 67:
                                $alarmItemArray[] = $name."扩展板3通讯故障";
                                break;
                            case 68:
                                $alarmItemArray[] = $name."扩展板4通讯故障";
                                break;
                            case 69:
                                $alarmItemArray[] = $name."电表通讯故障";
                                break;
                            case 73:
                                $alarmItemArray[] = $name."辅助电源1告警";
                                break;
                            case 74:
                                $alarmItemArray[] = $name."辅助电源2告警";
                                break;
                            case 78:
                                $alarmItemArray[] = $name."避雷器1告警";
                                break;
                            case 79:
                                $alarmItemArray[] = $name."避雷器2告警";
                                break;
                            case 81:
                                $alarmItemArray[] = $name."输入空开1告警";
                                break;
                            case 82:
                                $alarmItemArray[] = $name."输入空开2告警";
                                break;
                            default:
                                for($j=1; $j < 88+ 72; $j++)
                                {
                                    if(88+$j == $alarm_no)
                                    {
                                        $alarmItemArray[] = $name."分路空开".$j."告警";
                                    }

                                }
                                break;
                        }
                        break;
                    case 13:
                        for($j=1; $j<=4; $j++)
                        {
                            if($j == $alarm_no){
                                $alarmItemArray[] = "直流配电屏".$j."通讯故障";
                            }
                        }
                        break;
                    case 14:
                        for($j=1; $j<=4; $j++)
                        {
                            if($device_no == $j)
                            {
                                $name = "直流配电屏".$j;
                                $offset = 560 * ($j -1 );
                                $newNo = $alarm_no - $offset;
                                switch($newNo)
                                {
                                    case 1:
                                        $alarmItemArray[] = $name."直流高压";
                                        break;
                                    case 2:
                                        $alarmItemArray[] = $name."直流低压";
                                        break;
                                    case 3:
                                        $alarmItemArray[] = $name."输入开关异常";
                                        break;
                                    case 4:
                                        $alarmItemArray[] = $name."总负载过流";
                                        break;
                                    case 5:
                                        $alarmItemArray[] = $name."避雷器异常";
                                        break;
                                    case 169:
                                        $alarmItemArray[] = $name."A路直流高压";
                                        break;
                                    case 170:
                                        $alarmItemArray[] = $name."A路直流低压";
                                        break;
                                    case 171:
                                        $alarmItemArray[] = $name."A路输入开关异常";
                                        break;
                                    case 172:
                                        $alarmItemArray[] = $name."A路总负载过流";
                                        break;
                                    case 173:
                                        $alarmItemArray[] = $name."A路避雷器异常";
                                        break;
                                    case 337:
                                        $alarmItemArray[] = $name."B路直流高压";
                                        break;
                                    case 338:
                                        $alarmItemArray[] = $name."B路直流低压";
                                        break;
                                    case 339:
                                        $alarmItemArray[] = $name."B路输入开关异常";
                                        break;
                                    case 340:
                                        $alarmItemArray[] = $name."B路总负载过流";
                                        break;
                                    case 341:
                                        $alarmItemArray[] = $name."B路避雷器异常";
                                        break;
                                    case 505:
                                        $alarmItemArray[] = $name."电池组1放电告警";
                                        break;
                                    case 506:
                                        $alarmItemArray[] = $name."电池组2放电告警";
                                        break;
                                    case 507:
                                        $alarmItemArray[] = $name."电池组3放电告警";
                                        break;
                                    case 508:
                                        $alarmItemArray[] = $name."电池组4放电告警";
                                        break;
                                    case 509:
                                        $alarmItemArray[] = $name."电池组A1放电告警";
                                        break;
                                    case 510:
                                        $alarmItemArray[] = $name."电池组A2放电告警";
                                        break;
                                    case 511:
                                        $alarmItemArray[] = $name."电池组B1放电告警";
                                        break;
                                    case 512:
                                        $alarmItemArray[] = $name."电池组B2放电告警";
                                        break;
                                    case 513:
                                        $alarmItemArray[] = $name."电池组1开关异常";
                                        break;
                                    case 514:
                                        $alarmItemArray[] = $name."电池组2开关异常";
                                        break;
                                    case 515:
                                        $alarmItemArray[] = $name."电池组3开关异常";
                                        break;
                                    case 516:
                                        $alarmItemArray[] = $name."电池组4开关异常";
                                        break;
                                    case 517:
                                        $alarmItemArray[] = $name."电池组A1开关异常";
                                        break;
                                    case 518:
                                        $alarmItemArray[] = $name."电池组A2开关异常";
                                        break;
                                    case 519:
                                        $alarmItemArray[] = $name."电池组B1开关异常";
                                        break;
                                    case 520:
                                        $alarmItemArray[] = $name."电池组B2开关异常";
                                        break;
                                    case 553:
                                        $alarmItemArray[] = $name."环境高温告警";
                                        break;
                                    case 554:
                                        $alarmItemArray[] = $name."环境低温告警";
                                        break;
                                    case 555:
                                        $alarmItemArray[] = $name."环境温度传感器故障";
                                        break;
                                    default:
                                        for($z=1; $z <= 80; $z++)
                                        {
                                            switch($newNo)
                                            {
                                                case ($z+8):
                                                {
                                                    $alarmItemArray[] = $name."分路".$z."开关异常";
                                                    break;
                                                }
                                                case $z + 88:
                                                {
                                                    $alarmItemArray[] = $name."分路".$z."电流过流";
                                                    break;
                                                }
                                                case ($z+176):
                                                {
                                                    $alarmItemArray[] = $name."分路A-".$z."开关异常";
                                                    break;
                                                }
                                                case ($z+255):
                                                {
                                                    $alarmItemArray[] = $name."分路A-".$z."电流过流";
                                                    break;
                                                }
                                                case ($z+344):
                                                {
                                                    $alarmItemArray[] = $name."分路B-".$z."开关异常";
                                                    break;
                                                }
                                                case ($z+424):
                                                {
                                                    $alarmItemArray[] = $name."分路B-".$z."电流过流";
                                                    break;
                                                }
                                            }
                                        }
                                        for($z=1; $z <= 32; $z++)
                                        {
                                            if($alarm_no == ($z + 520))
                                            {
                                                $alarmItemArray[] = $name.$z."号列头柜通讯故障";
                                            }
                                        }
                                        break;
                                }
                            }
                        }
                        break;
                    case 17:
                        $alarmItemArray[] = "整流屏交流中断";
                        break;
                    case 18:
                        $alarmItemArray[] = "直流高压";
                        break;
                    case 19:
                        $alarmItemArray[] = "直流低压";
                        break;
                    case 20:
                        $alarmItemArray[] = "电池组放电";
                        break;
                    case 21:
                        $alarmItemArray[] = "电池组低压放电";
                        break;
                    case 22:
                        $alarmItemArray[] = "电池组充电过流";
                        break;
                    case 23:
                        $alarmItemArray[] = "电池组放电不平衡";
                        break;
                    case 24:
                        $alarmItemArray[] = "手动限流";
                        break;
                    case 25:
                        $alarmItemArray[] = "环境高温";
                        break;
                    case 26:
                        $alarmItemArray[] = "环境低温";
                        break;
                    case 27:
                        $alarmItemArray[] = "总负载过流告警";
                        break;
                    case 28:
                        $alarmItemArray[] = "环境温度传感器故障";
                        break;
                    case 29:
                        $alarmItemArray[] = "直流电压传感器故障";
                        break;
                    case 30:
                        $alarmItemArray[] = "电流传感器侦测异常";
                        break;
                    case 31:
                        $alarmItemArray[] = "电池组标签重复";
                        break;
                    case 32:
                        $alarmItemArray[] = "交流配电屏通讯故障";
                        break;
                    case 34:
                        $alarmItemArray[] = "Flash存储故障";
                        break;
                    case 35:
                        $alarmItemArray[] = "模块地址配置错误";
                        break;
                }
            }
            $dataArray["当前系统告警"] = join(",", $alarmItemArray);
        }
    } else {
        $dataArray["无数据"] = true;
        $dataArray["更新时间"] = '无';
        $dataArray["错误"] = "数据长度不一致";
    }
}




?>
