<?php
function Get_daneng6000_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '[A相电压]':
            return array(0, floatval($dataArray['UA']));
        case '[B相电压]':
            return array(0, floatval($dataArray['UB']));
        case '[C相电压]':
            return array(0, floatval($dataArray['UC']));
    }
    return array(1 , '设备无此信号数据:'. $varname);
}


function Get_daneng6000_RtData($memData, &$dataArray, $extraPara = false){
        if(empty($memData)){
            $dataArray['无数据'] = true;
            $dataArray['更新时间'] = '无';
            $dataArray['错误'] = '数据长度不一致';
        }else{
            $dataArray['无数据'] = false;
            $dataArray['AlertArray'] = array();
            //DB4610_reg_01_69_t
            $v = unpack('S*',substr($memData , 4 , 2*19));
            $dataArray['IA'] = $v[1].' A';
            $dataArray['IC'] = $v[2].' A';
            $dataArray['P'] = ($v[3] / 100).' MW';
            $dataArray['Q']  = ($v[4] / 100).' MVar';
            $dataArray['COSф'] = $v[5];
            $dataArray['F'] = ($v[6] / 100)." Hz";
            $dataArray['UAB'] = ($v[7]/100)." KV";
            $dataArray['UBC'] = ($v[8] / 100)." KV";
            $dataArray['UCA'] = ($v[9] / 100)." KV";

            $dataArray['UA'] = ($v[10] / 100)." KV";
            $dataArray['UB'] = ($v[11] / 100)." KV";
            $dataArray['UC'] = ($v[12] / 100)." KV";
            $dataArray['Ux'] = ($v[13] / 100)." KV";
            $dataArray['UO'] = ($v[14] / 100)." KV";
            $dataArray['I0'] = ($v[15]).' A';
            $dataArray['Ia'] = $v[16].' A';
            $dataArray['Ib'] = $v[17].' A';
            $dataArray['Ic'] = $v[18].' A';
            $v = unpack('v', substr($memData, 52 , 2));
            $year = $v[1];
            $v = unpack('C*', substr($memData, 54 , 5));
            $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
        }
}
