<?php

function Get_datamate3000_DeviceIoControl_ErrorMsg($ret){
    switch($ret){
        case 1:
            return "执行成功";
        case 3:
            return "执行失败，校验不符";
        default:
            return "未知错误";
        }
}

function Get_datamate3000_DeviceIoControl_Parameter($action, $parameter)
{
    if($action == 106 && count($parameter) == 1){
        return pack("S", intval($parameter[0]));
    }
    return -1;
}


function Get_datamate3000_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '温度设定点':
            return array(0,  $dataArray['温度设定点']);
        case '回风温度':
            return array(0, $dataArray['室内温度']);
        case '开关机状态':
            return array(0, $dataArray['开关机状态']);
        default:
            break;
    }
    return array(1 , '设备无此信号数据:'. $varname);
}

function Get_datamate3000_RtData($memData , &$dataArray , $extraPara = false)
{
        if (empty($memData)) {
            $dataArray['无数据'] = true;
            $dataArray['更新时间'] = '无';
            $dataArray['错误'] = '数据长度不一致';
        }else{
            $dataArray['无数据'] = false;
            $dataArray['AlertArray'] = array();
            $v = unpack('f*', substr($memData, 4, 3 * 4));
            $dataArray['室内温度'] = number_format($v[1] , 1).' ℃';
            $dataArray['室内湿度'] = $v[2] > 100 ? '无效' : number_format($v[2] , 1).' %';
            $dataArray['室外温度'] = number_format($v[3] , 1).' ℃';
            $v = unpack('C*', substr($memData, 4 * 4, 1));
            $dataArray['空调状态'] = $v[1] == 1 ? '开机' : '关机';
            $v = unpack('f*', substr($memData, 4 * 4 + 1, 4 * 6));
            $dataArray['开机温度'] = number_format($v[1] , 1).' ℃';
            $dataArray['关机湿度'] = number_format($v[2] , 1).' %';
            $dataArray['温度设定点'] = number_format($v[3] , 1).' ℃';
            $dataArray['温度偏差'] = number_format($v[4] , 1).' ℃';
            $dataArray['湿度设定点'] = number_format($v[5] , 1).' %';
            $dataArray['湿度偏差'] = number_format($v[6] , 1).' %';
            $v = unpack('C*', substr($memData, 4 * 4 + 1 + 4 * 6, 31));
            $dataArray['开关机状态'] = $v[1] == 1 ? '开机' : '关机';
            $dataArray['风机状态'] = $v[2] == 1 ? '打开' : '关闭';
            $dataArray['制冷状态'] = $v[3] == 1 ? '打开' : '关闭';
            $dataArray['加热状态'] = $v[4] == 1 ? '打开' : '关闭';
            $dataArray['加湿状态'] = $v[5] == 1 ? '打开' : '关闭';
            $dataArray['除湿状态'] = $v[6] == 1 ? '打开' : '关闭';
            $dataArray['报警状态'] = $v[7] == 1 ? '有报警' : '无报警';
            $dataArray['AlertArray']['报警状态'] = $v[7] == 1;

            $dataArray['高压报警'] = $v[8] == 1 ? '告警' : '正常';
            $dataArray['低压报警'] = $v[9] == 1 ? '告警' : '正常';
            $dataArray['高温报警'] = $v[10] == 1 ? '告警' : '正常';
            $dataArray['低温报警'] = $v[11] == 1 ? '告警' : '正常';
            $dataArray['高湿报警'] = $v[12] == 1 ? '告警' : '正常';
            $dataArray['低湿报警'] = $v[13] == 1 ? '告警' : '正常';
            $dataArray['电源故障报警'] = $v[14] == 1 ? '告警' : '正常';
            $dataArray['短周期报警'] = $v[15] == 1 ? '告警' : '正常';
            $dataArray['AlertArray']['高压报警'] = $v[8] == 1;
            $dataArray['AlertArray']['低压报警'] = $v[9] == 1;
            $dataArray['AlertArray']['高温报警'] = $v[10] == 1;
            $dataArray['AlertArray']['低温报警'] = $v[11] == 1;
            $dataArray['AlertArray']['高湿报警'] = $v[12] == 1;
            $dataArray['AlertArray']['低湿报警'] = $v[13] == 1;
            $dataArray['AlertArray']['电源故障报警'] = $v[14] == 1;
            $dataArray['AlertArray']['短周期报警'] = $v[15] == 1;

            //用户自定义报警1  2
            $dataArray['主风机维护报警'] = $v[18] == 1 ? '告警' : '正常';
            $dataArray['加湿器维护报警'] = $v[19] == 1 ? '告警' : '正常';
            $dataArray['过滤网维护报警'] = $v[20] == 1 ? '告警' : '正常';
            $dataArray['通讯故障报警'] = $v[21] == 1 ? '告警' : '正常';
            $dataArray['盘管冻结报警'] = $v[22] == 1 ? '告警' : '正常';
            $dataArray['加湿器故障报警'] = $v[23] == 1 ? '告警' : '正常';
            $dataArray['AlertArray']['主风机维护报警'] = $v[18] == 1;
            $dataArray['AlertArray']['加湿器维护报警'] = $v[19] == 1;
            $dataArray['AlertArray']['过滤网维护报警'] = $v[20] == 1;
            $dataArray['AlertArray']['通讯故障报警'] = $v[21] == 1;
            $dataArray['AlertArray']['盘管冻结报警'] = $v[22] == 1;
            $dataArray['AlertArray']['加湿器故障报警'] = $v[23] == 1;

            $dataArray['传感器板丢失报警'] = $v[24] == 1 ? '告警' : '正常';
            $dataArray['排气温度故障报警'] = $v[25] == 1 ? '告警' : '正常';
            $dataArray['电源丢失故障报警'] = $v[26] == 1 ? '告警' : '正常';
            $dataArray['电源过欠压报警'] = $v[27] == 1 ? '告警' : '正常';
            $dataArray['电源缺相报警'] = $v[28] == 1 ? '告警' : '正常';
            $dataArray['电源频率偏移报警'] = $v[29] == 1 ? '告警' : '正常';
            $dataArray['地板溢水报警'] = $v[30] == 1 ? '告警' : '正常';
            $dataArray['节能卡故障'] = $v[31] == 1 ? '告警' : '正常';
            $dataArray['AlertArray']['传感器板丢失报警'] = $v[24] == 1;
            $dataArray['AlertArray']['排气温度故障报警'] = $v[25] == 1;
            $dataArray['AlertArray']['电源丢失故障报警'] = $v[26] == 1;
            $dataArray['AlertArray']['电源过欠压报警'] = $v[27] == 1;
            $dataArray['AlertArray']['电源缺相报警'] = $v[28] == 1;
            $dataArray['AlertArray']['电源频率偏移报警'] = $v[29] == 1;
            $dataArray['AlertArray']['地板溢水报警'] = $v[30] == 1;
            $dataArray['AlertArray']['节能卡故障'] = $v[31] == 1;

            $v = unpack('v', substr($memData, 4 * 4 + 1 + 4 * 6 + 31 + 2 , 2));
            $year = $v[1];
            $v = unpack('C*', substr($memData, 4 * 4 + 1 + 4 * 6 + 31 + 2 + 2, 5));
            $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
        }
}
