<?php
function Get_Db4610_alarm($value){
    switch ($value){
        case 0: return "正常";
        case 1: return "水位过低";
        case 2: return "变频器故障";
        case 3: return "超压报警";
        case 4: return "传感器故障";
        case 5: return "自检故障";
        case 6: return "1#泵故障";
        case 7: return "1#泵过流";
        case 8: return "1#泵缺相";
        case 9: return "2#泵故障";
        case 10: return "2#泵过流";
        case 11: return "2#泵缺相";
        case 12: return "3#泵故障";
        case 13: return "3#泵过流";
        case 14: return "3#泵缺相";
        case 15: return "4#泵故障";
        case 16: return "4#泵过流";
        case 17: return "4#泵缺相";
        case 18: return "5#泵故障";
        case 19: return "5#泵过流";
        case 20: return "5#泵缺相";
        case 21: return "6#泵故障";
        case 22: return "6#泵过流";
        case 23: return "6#泵缺相";
    }
    return '正常';
}

function Get_db4610_RtData($memData, &$dataArray, $extraPara = false){
        if(empty($memData)){
            $dataArray['无数据'] = true;
            $dataArray['更新时间'] = '无';
            $dataArray['错误'] = '数据长度不一致';
        }else{
            $dataArray['无数据'] = false;
            $dataArray['AlertArray'] = array();
            //DB4610_reg_01_69_t
            $v = unpack('S*',substr($memData , 4 , 2*105));
            $dataArray['压力设定值1'] = ($v[1] / 1000).' MPa';
            $dataArray['压力设定值2'] = ($v[2] / 1000).' MPa';
            $dataArray['消防压力'] = ($v[3] / 1000).' MPa';
            $dataArray['消防上限压力']  = ($v[4] / 1000).' MPa';
            $dataArray['超压报警压力'] = ($v[5] / 1000).' MPa';
            switch ($v[6]){
                case 0: $dataArray['传感器类型'] = '0-5 V'; break;
                case 1: $dataArray['传感器类型'] = '4-20 mA'; break;
                default : $dataArray['传感器类型'] = '无效';
            }
            $dataArray['传感器量程'] = ($v[7] / 1000);
            $dataArray['小数点位值'] = $v[8];
            $dataArray['传感器调零'] = $v[9] / 1000;
            $dataArray['满度修正'] = ($v[10] / 10).' %';
            switch ($v[11]){
                case 0: $dataArray['模拟输出类型'] = '0-10 V'; break;
                case 1: $dataArray['模拟输出类型'] = '0-5 V'; break;
                default: $dataArray['模拟输出类型'] = '无效';
            }
            $dataArray['模拟输出增益'] = ($v[12] / 10).' %';
            $dataArray['主泵下限频率'] = ($v[13] / 10).' Hz';
            $dataArray['换泵压力回差'] = ($v[14] / 1000).' MPa';
            $dataArray['加泵延时时间'] = $v[15].' S';
            $dataArray['减泵延时时间'] = $v[16].' S';
            $dataArray['切换时间'] = ($v[17] / 10).' S';
            $dataArray['加减速时间'] = $v[18].' S';
            switch ($v[19]){
                case 0: $dataArray['停车模式'] = '自由停车模式'; break;
                case 1: $dataArray['停车模式'] = '软停止模式'; break;
                default : $dataArray['停车模式'] = '无效';
            }
            switch ($v[20]){
                case 1: $dataArray['休眠功能选择'] = '休眠模式1'; break;
                case 2: $dataArray['休眠功能选择'] = '休眠模式2'; break;
                default: $dataArray['休眠功能选择'] = '无效';
            }
            $dataArray['休眠判断频率'] = ($v[21] / 10).' Hz';
            $dataArray['休眠判断延时'] = $v[22].' S';
            $dataArray['休眠前增量'] = ($v[23] / 1000);
            $dataArray['唤醒压力值'] = ($v[24] / 1000).' MPa';
            $dataArray['唤醒延时'] = $v[25].' S';
            $dataArray['小泵启动压力'] = ($v[26] / 1000).' MPa';
            $dataArray['小泵停止压力'] = ($v[27] / 1000).' MPa';
            $dataArray['小泵下限频率'] = ($v[28] / 10).' Hz';
            //$dataArray['日期设定'] = $v[29];
           // $dataArray['时钟设定'] = $v[30];
            $dataArray['定时换泵间隔'] = ($v[31] / 10).' h';
            $dataArray['换泵倒计时'] = ($v[32] / 10).' h';
            $dataArray['首先启动泵号'] = $v[33];
            $dataArray['定时控制选择'] = $v[34] == 0 ? '关闭' : $v[34];
            /* $dataArray['T1时间'] = ($v[35] / 100);
            $dataArray['T1时间压力'] = ($v[36] / 1000).' MPa';
            $dataArray['T2时间'] = ($v[37] / 100);
            $dataArray['T2时间压力'] = ($v[38] / 1000).' MPa';
            $dataArray['T3时间'] = ($v[39] / 100);
            $dataArray['T3时间压力'] = ($v[40] / 1000).' MPa';
            $dataArray['T4时间'] = ($v[41] / 100);
            $dataArray['T4时间压力'] = ($v[42] / 1000).' MPa';
            $dataArray['T5时间'] = ($v[43] / 100);
            $dataArray['T5时间压力'] = ($v[44] / 1000).' MPa';
            $dataArray['T6时间'] = ($v[45] / 100);
            $dataArray['T6时间压力'] = ($v[46] / 1000).' MPa';
            $dataArray['T7时间'] = ($v[47] / 100);
            $dataArray['T7时间压力'] = ($v[48] / 1000).' MPa';
            $dataArray['T8时间'] = ($v[49] / 100);
            $dataArray['T8时间压力'] = ($v[50] / 1000).' MPa'; */
            switch ($v[51]){
                case 0 : $dataArray['故障处理选择'] = '故障解除后启动下一台变频泵'; break;
                case 1 : $dataArray['故障处理选择'] = '变频器故障后启动下一台工频泵'; break;
                case 2 : $dataArray['故障处理选择'] = '故障解除后变频启动首先启动泵'; break;
                case 3 : $dataArray['故障处理选择'] = '变频器故障后工频启动首先启动泵'; break;
                default : $dataArray['故障处理选择'] = '无效';
            }
            $dataArray['自动复位时间'] = $v[52].' S';
            //$dataArray['故障查询'] = $v[53];
            $dataArray['定时巡检间隔'] = ($v[54] / 10).' h';
            $dataArray['巡检倒计时'] = ($v[55] / 10).' h';
            $dataArray['单泵巡检时间'] = $v[56].' S';
            $dataArray['巡检报警选择'] = $v[57].' S';
            switch ($v[58]){
                case 0 : $dataArray['巡检模式选择'] = '无压巡检'; break;
                case 1 : $dataArray['巡检模式选择'] = '稳压巡检'; break;
                case 2 : $dataArray['巡检模式选择'] = '自动无压巡检+端子控制工频巡检'; break;
                case 3 : $dataArray['巡检模式选择'] = '自动稳压巡检+端子控制工频巡检'; break;
                default : $dataArray['巡检模式选择'] = '无效';
            }
            switch ($v[59]){
                case 0 : $dataArray['消防信号方式'] = '电平方式'; break;
                case 1 : $dataArray['消防信号方式'] = '触发方式'; break;
                case 2 : $dataArray['消防信号方式'] = '电平方式+低压进入消防状态'; break;
                case 3 : $dataArray['消防信号方式'] = '触发方式+低压进入消防状态'; break;
                default : $dataArray['消防信号方式'] = '无效';
            }
            switch ($v[60]){
                case 0 : $dataArray['键盘锁定'] = '不锁定'; break;
                case 1 : $dataArray['键盘锁定'] = '锁定（除压力设定组）'; break;
                case 2 : $dataArray['键盘锁定'] = '全部锁定'; break;
                default : $dataArray['键盘锁定'] = '无效';
            }
            $dataArray['数据初始化'] = $v[61];
            switch ($v[62]){
                case 0 : $dataArray['工作模式选择'] = '供水模式'; break;
                case 1 : $dataArray['工作模式选择'] = '消防模式1'; break;
                case 2 : $dataArray['工作模式选择'] = '消防模式2'; break;
                case 3 : $dataArray['工作模式选择'] = '消防模式3'; break;
                default: $dataArray['工作模式选择'] = '无效';
            }
            switch ($v[63]){
                case 0 : $dataArray['1#泵属性'] = '未使用'; break;
                case 1 : $dataArray['1#泵属性'] = '变量泵'; break;
                case 2 : $dataArray['1#泵属性'] = '定量泵'; break;
                case 3 : $dataArray['1#泵属性'] = '备用变量泵'; break;
                case 4 : $dataArray['1#泵属性'] = '备用定量泵'; break;
                default : $dataArray['1#泵属性'] = '无效';
            }
            switch ($v[64]){
                case 0 : $dataArray['2#泵属性'] = '未使用'; break;
                case 1 : $dataArray['2#泵属性'] = '变量泵'; break;
                case 2 : $dataArray['2#泵属性'] = '定量泵'; break;
                case 3 : $dataArray['2#泵属性'] = '备用变量泵'; break;
                case 4 : $dataArray['2#泵属性'] = '备用定量泵'; break;
                default : $dataArray['2#泵属性'] = '无效';
            }
            switch ($v[65]){
                case 0 : $dataArray['3#泵属性'] = '未使用'; break;
                case 1 : $dataArray['3#泵属性'] = '变量泵'; break;
                case 2 : $dataArray['3#泵属性'] = '定量泵'; break;
                case 3 : $dataArray['3#泵属性'] = '备用变量泵'; break;
                case 4 : $dataArray['3#泵属性'] = '备用定量泵'; break;
                default : $dataArray['3#泵属性'] = '无效';
            }
            switch ($v[66]){
                case 0 : $dataArray['4#泵属性'] = '未使用'; break;
                case 1 : $dataArray['4#泵属性'] = '变量泵'; break;
                case 2 : $dataArray['4#泵属性'] = '定量泵'; break;
                case 3 : $dataArray['4#泵属性'] = '备用变量泵'; break;
                case 4 : $dataArray['4#泵属性'] = '备用定量泵'; break;
                default : $dataArray['4#泵属性'] = '无效';
            }
            switch ($v[67]){
                case 0 : $dataArray['5#泵属性'] = '未使用'; break;
                case 1 : $dataArray['5#泵属性'] = '变量泵'; break;
                case 2 : $dataArray['5#泵属性'] = '定量泵'; break;
                case 3 : $dataArray['5#泵属性'] = '备用变量泵'; break;
                case 4 : $dataArray['5#泵属性'] = '备用定量泵'; break;
                default : $dataArray['5#泵属性'] = '无效';
            }
            switch ($v[68]){
                case 0 : $dataArray['6#泵属性'] = '未使用'; break;
                case 1 : $dataArray['6#泵属性'] = '变量泵'; break;
                case 2 : $dataArray['6#泵属性'] = '定量泵'; break;
                case 3 : $dataArray['6#泵属性'] = '备用变量泵'; break;
                case 4 : $dataArray['6#泵属性'] = '备用定量泵'; break;
                default : $dataArray['6#泵属性'] = '无效';
            }
            switch ($v[69]){
                case 0 : $dataArray['小泵属性'] = '未使用'; break;
                case 1 : $dataArray['小泵属性'] = '变量泵'; break;
                case 2 : $dataArray['小泵属性'] = '定量泵'; break;
                default : $dataArray['小泵属性'] = '无效';
            }
            switch ($v[70]){
                case 0 : $dataArray['电磁阀泵属性'] = '未使用'; break;
                case 1 : $dataArray['电磁阀泵属性'] = '按PI1输入量控制'; break;
                case 2 : $dataArray['电磁阀泵属性'] = '按PI2输入量控制'; break;
                default : $dataArray['电磁阀泵属性'] = '无效';
            }
            //71-105   高级功能   暂时保留  需要再解析
            //DB4610_reg_1001_100c_t
            $v = unpack('S*',substr($memData , 4 + 2*105 , 2*12));
            $dataArray['频率'] = ($v[1] / 10).' Hz';
            $dataArray['反馈压力'] = ($v[2] / 1000).' MPa';
            $dataArray['设定压力'] = ($v[3] / 1000).' MPa';
            $dataArray['1#泵变频'] = ($v[4] & 0x1) == 1 ? '工作' : '关闭';
            $dataArray['1#泵工频'] = (($v[4] >> 1) & 0x1) == 1 ? '工作' : '关闭';
            $dataArray['2#泵变频'] = (($v[4] >> 2) & 0x1) == 1 ? '工作' : '关闭';
            $dataArray['2#泵工频'] = (($v[4] >> 3) & 0x1) == 1 ? '工作' : '关闭';
            $dataArray['3#泵变频'] = (($v[4] >> 4) & 0x1) == 1 ? '工作' : '关闭';
            $dataArray['3#泵工频'] = (($v[4] >> 5) & 0x1) == 1 ? '工作' : '关闭';
            $dataArray['4#泵变频'] = (($v[4] >> 6) & 0x1) == 1 ? '工作' : '关闭';
            $dataArray['4#泵工频'] = (($v[4] >> 7) & 0x1) == 1 ? '工作' : '关闭';
            $dataArray['5#泵变频'] = (($v[4] >> 8) & 0x1) == 1 ? '工作' : '关闭';
            $dataArray['5#泵工频'] = (($v[4] >> 9) & 0x1) == 1 ? '工作' : '关闭';
            $dataArray['6#泵变频'] = (($v[4] >> 10) & 0x1) == 1 ? '工作' : '关闭';
            $dataArray['6#泵工频'] = (($v[4] >> 11) & 0x1) == 1 ? '工作' : '关闭';
            $dataArray['小泵变频'] = (($v[4] >> 12) & 0x1) == 1 ? '工作' : '关闭';
            $dataArray['小泵工频'] = (($v[4] >> 13) & 0x1) == 1 ? '工作' : '关闭';
            $dataArray['电磁阀'] = (($v[4] >> 15) & 0x1) == 1 ? '工作' : '关闭';
            $dataArray['自动运行'] = ($v[5] & 0x1) == 1 ? '是' : '否'; 
            $dataArray['变频器运行'] = (($v[5] >> 1) & 0x1) == 1 ? '是' : '否';
            $dataArray['巡检状态'] = (($v[5] >> 2) & 0x1) == 1 ? '是' : '否';
            $dataArray['休眠状态'] = (($v[5] >> 3) & 0x1) == 1 ? '是' : '否';
            $dataArray['消防状态'] = (($v[5] >> 4) & 0x1) == 1 ? '是' : '否';
            $dataArray['远控状态'] = (($v[5] >> 5) & 0x1) == 1 ? '是' : '否';
            $dataArray['限压运行'] = (($v[5] >> 6) & 0x1) == 1 ? '是' : '否';
            $dataArray['限压停机'] = (($v[5] >> 7) & 0x1) == 1 ? '是' : '否';
            $dataArray['定时停机'] = (($v[5] >> 8) & 0x1) == 1 ? '是' : '否';
            $dataArray['最新故障'] = Get_Db4610_alarm($v[6]);
            $dataArray['X1最新故障'] = Get_Db4610_alarm($v[7]);
            $dataArray['X2最新故障'] = Get_Db4610_alarm($v[8]);
            $dataArray['X3最新故障'] = Get_Db4610_alarm($v[9]);
            $dataArray['X4最新故障'] = Get_Db4610_alarm($v[10]);
            $dataArray['X5最新故障'] = Get_Db4610_alarm($v[11]);
            $dataArray['X6最新故障'] = Get_Db4610_alarm($v[12]);   
            $dataArray['AlertArray']['最新故障'] = $dataArray['最新故障'] == '正常' ? false : true;
            $dataArray['AlertArray']['X1最新故障'] = $dataArray['X1最新故障'] == '正常' ? false : true;
            $dataArray['AlertArray']['X2最新故障'] = $dataArray['X2最新故障'] == '正常' ? false : true;
            $dataArray['AlertArray']['X3最新故障'] = $dataArray['X3最新故障'] == '正常' ? false : true;
            $dataArray['AlertArray']['X4最新故障'] = $dataArray['X4最新故障'] == '正常' ? false : true;
            $dataArray['AlertArray']['X5最新故障'] = $dataArray['X5最新故障'] == '正常' ? false : true;
            $dataArray['AlertArray']['X6最新故障'] = $dataArray['X6最新故障'] == '正常' ? false : true; 
            $v = unpack('v', substr($memData, 4 + 2*117 , 2));
            $year = $v[1];
            $v = unpack('C*', substr($memData, 4 + 2*117 +2 , 5));
            $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
        }
}
