<?php

function Get_dcm3366_RtData($memData,&$dataArray,$extraPara = false) {
	if (empty($memData)) {
		$dataArray['无数据'] = true;
		$dataArray['更新时间'] = '无';
		$dataArray['错误'] = '数据长度不一致';
	} else {
		$dataArray['无数据'] = false;

		$v = unpack('i', substr($memData,4,4 * 1));
		$dataArray["交流电压（V）"] = number_format($v[1],2);	
		$v = unpack('C', substr($memData,4 + 4 * 1,1 * 1));
		$dataArray["交流输入停电告警"] = $v[1] == 1 ? "告警" : "正常";


		for ($i=1; $i <= 6; $i++) { 

			$v = unpack('i*', substr($memData,4 + 4 * 1 + 1 * 1 + ($i - 1) * (4 * 4 + 4 * 1),4 * 4));

			$dataArray["回路{$i}直流电压（V）"] = number_format($v[1] / 100,2);	
			$dataArray["回路{$i}直流电流（A）"] = number_format($v[2] / 100,2);	
			$dataArray["回路{$i}直流功率（kW）"] = number_format($v[3] / 100,2);	
			$dataArray["回路{$i}直流电能读数"] = number_format($v[4] / 100,2);	

			$v = unpack('C*', substr($memData,4 + 4 * 1 + 1 * 1 + ($i - 1) * (4 * 4 + 4 * 1) + 4 * 4,4 * 1));
			$dataArray["回路{$i}直流输出电压过低告警"] = $v[1] == 1 ? "告警" : "正常";
			$dataArray["回路{$i}直流输出电压高低告警"] = $v[2] == 1 ? "告警" : "正常";
			$dataArray["回路{$i}一次下电告警"] = $v[3] == 1 ? "告警" : "正常";
			$dataArray["回路{$i}模块故障告警"] = $v[4] == 1 ? "告警" : "正常";
			
		}

		

		$v = unpack('v',substr($memData, 4 + 4 * 1 + 1 * 1 + (6 - 1) * (4 * 4 + 4 * 1) + 4 * 4 + 4 * 1, 2));
        $year = $v[1];		
		$v = unpack('C*', substr($memData, 4 + 4 * 1 + 1 * 1 + (6 - 1) * (4 * 4 + 4 * 1) + 4 * 4 + 4 * 1 + 2, 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));

	}
}





?>
