<?php

function Get_dcm3366d_w1_UnicomCategory()
{
    return "4C1";
}

function Get_dcm3366d_w1_RtData($memData,&$dataArray,$extraPara = false) {
	if (empty($memData)) {
		$dataArray['无数据'] = true;
		$dataArray['更新时间'] = '无';
		$dataArray['错误'] = '数据长度不一致';
	} else {
		$dataArray['无数据'] = false;

		$v = unpack('S*', substr($memData, 4, 2 * 68));
		$dataArray["电压"] = number_format( (($v[1] << 16) | $v[2])/1000 ,3)."V";
        $dataArray["电流"] = number_format( (($v[15] << 16) | $v[16])/10000 ,4)."A";
		$dataArray["有功功率"] = number_format( (($v[29] << 16) | $v[30])/10000 ,4)."kW";
		$dataArray["正向有功电能"] = number_format( (($v[43] << 16) | $v[44])/100/1000 ,5)."kWH";
		$dataArray["反向有功电能"] = number_format( (($v[57] << 16) | $v[58])/100/1000 ,5)."kWH";
		$v = unpack('v',substr($memData, 4 + 2*68, 2));
        $year = $v[1];		
		$v = unpack('C*', substr($memData, 4 + 2*68 + 2, 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
	}
}





?>
