<?php



function Get_dcm3366m_12_w1_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case "[总功率]":
            return array(0, $dataArray['有功功率']);
        case '合相电能':
            return array(0, $dataArray['组合有功总电能']);
    }
    return array(1 , '设备无此信号数据:'. $varname);
}

function Get_dcm3366m_12_w1_Active_Power($dataArray){
    
    return array(0 , $dataArray['组合有功总电能']);
}

function Is_dcm3366m_12_w1_NeedExtraPara(){
    return true;
}

function Get_dcm3366m_12_w1_RtData($memData, &$dataArray, $extraPara = false){
    if($memData == false){
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    }else{
        $dataArray['无数据'] = false;
        $dataArray['AlertArray'] = array();

	/*$index = 1;
	if(isset($extraPara->index)){
	    $index = $extraPara->index;
	}*/
        for($index=1; $index <= 12; $index++){
	    $label = "通道".$index;
            $v = unpack("S*" , substr($memData , 4 + 2*35* ($index-1), 2*35));
            $v1 = unpack("s*" , substr($memData , 4 + 2*35* ($index-1), 2*35));
            $dataArray[$label."组合有功总电能"] = (($v1[1] << 16 | $v[2])/100)." kWh";
            $dataArray[$label."组合有功尖电能"] = (($v1[3] << 16 | $v[4])/100)." kWh";
            $dataArray[$label."组合有功峰电能"] = (($v1[5] << 16 | $v[6])/100)." kWh";
            $dataArray[$label."组合有功平电能"] = (($v1[7] << 16 | $v[8])/100)." kWh";
            $dataArray[$label."组合有功谷电能"] = (($v1[9] << 16 | $v[10])/100)." kWh";

            $dataArray[$label."正向有功总电能"] = (($v[11] << 16 | $v[12])/100)." kWh";
            $dataArray[$label."正向有功尖电能"] = (($v[13] << 16 | $v[14])/100)." kWh";
            $dataArray[$label."正向有功峰电能"] = (($v[15] << 16 | $v[16])/100)." kWh";
            $dataArray[$label."正向有功平电能"] = (($v[17] << 16 | $v[18])/100)." kWh";
            $dataArray[$label."正向有功谷电能"] = (($v[19] << 16 | $v[20])/100)." kWh";

            $dataArray[$label."反向有功总电能"] = (($v[21] << 16 | $v[22])/100)." kWh";
            $dataArray[$label."反向有功尖电能"] = (($v[23] << 16 | $v[24])/100)." kWh";
            $dataArray[$label."反向有功峰电能"] = (($v[25] << 16 | $v[26])/100)." kWh";
            $dataArray[$label."反向有功平电能"] = (($v[27] << 16 | $v[28])/100)." kWh";
            $dataArray[$label."反向有功谷电能"] = (($v[29] << 16 | $v[30])/100)." kWh";
            
            $dataArray[$label."有功功率"] = abs(($v1[31] << 16 | $v[32])/10000)." kW";
            $dataArray[$label."电流"] = (($v[33] << 16 | $v[34])/1000)." A";
            $dataArray[$label."电压"] = (($v[35])/10)." V";
        }       
       
        $v = unpack('v', substr($memData, 4 + 2*35*12 , 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData, 4 + 2*35*12 + 2 , 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}
