<?php
function _dcm3366ph241s_ShowAlert(&$dataArray, $label, $value, $vsValue)
{
    if($value == 0xFFFF || $value == 0x20){
      $dataArray[$label] = "无效值";
    }else{
      $dataArray[$label] = $value == $vsValue ? '正常' : '告警';
      $dataArray['AlertArray'][$label] = $value != $vsValue;
    }
}


function Get_dcm3366ph241s_RtData($memData, &$dataArray, $extraPara = false){
    if($memData == false){
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    }else{
        $dataArray['无数据'] = false;
        $dataArray['AlertArray'] = array();
        $offset = 4;
            $v = unpack("S*" , substr($memData , $offset, 2*26));
$lMemData = substr($memData , $offset, 2*26);
      $lOffset = 0;
      
        $dataArray["第 1 路电压"] = ((($v[1]<<16)+$v[2])/1000)."V";
      

      
        $dataArray["第 2 路电压"] = ((($v[3]<<16)+$v[4])/1000)."V";
      

      
        $dataArray["第 3 路电压"] = ((($v[5]<<16)+$v[6])/1000)."V";
      

      
        $dataArray["第 4 路电压"] = ((($v[7]<<16)+$v[8])/1000)."V";
      

      
        $dataArray["第 5 路电压"] = ((($v[9]<<16)+$v[10])/1000)."V";
      

      
        $dataArray["第 6 路电压"] = ((($v[11]<<16)+$v[12])/1000)."V";
      

      
        $dataArray["总电流"] = ((($v[13]<<16)+$v[14])/10000)."A";
      

      
        $dataArray["第 1 路电流"] = ((($v[15]<<16)+$v[16])/10000)."A";
      

      
        $dataArray["第 2 路电流"] = ((($v[17]<<16)+$v[18])/10000)."A";
      

      
        $dataArray["第 3 路电流"] = ((($v[19]<<16)+$v[20])/10000)."A";
      

      
        $dataArray["第 4 路电流"] = ((($v[21]<<16)+$v[22])/10000)."A";
      

      
        $dataArray["第 5 路电流"] = ((($v[23]<<16)+$v[24])/10000)."A";
      

      
        $dataArray["第 6 路电流"] = ((($v[25]<<16)+$v[26])/10000)."A";
      

      $offset += 52;

            $v = unpack("S*" , substr($memData , $offset, 2*14));
$lMemData = substr($memData , $offset, 2*14);
      $lOffset = 0;
      
        $dataArray["总功率"] = ((($v[1]<<16)+$v[2])/10000)."kw";
      

      
        $dataArray["第 1 路功率"] = ((($v[3]<<16)+$v[4])/10000)."kw";
      

      
        $dataArray["第 2 路功率"] = ((($v[5]<<16)+$v[6])/10000)."kw";
      

      
        $dataArray["第 3 路功率"] = ((($v[7]<<16)+$v[8])/10000)."kw";
      

      
        $dataArray["第 4 路功率"] = ((($v[9]<<16)+$v[10])/10000)."kw";
      

      
        $dataArray["第 5 路功率"] = ((($v[11]<<16)+$v[12])/10000)."kw";
      

      
        $dataArray["第 6 路功率"] = ((($v[13]<<16)+$v[14])/10000)."kw";
      

      $offset += 28;

            $v = unpack("S*" , substr($memData , $offset, 2*14));
$lMemData = substr($memData , $offset, 2*14);
      $lOffset = 0;
      
        $dataArray["总正向电能"] = ((($v[1]<<16)+$v[2])/100)."kWh";
      

      
        $dataArray["第 1 路正向电能"] = ((($v[3]<<16)+$v[4])/100)."kWh";
      

      
        $dataArray["第 2 路正向电能"] = ((($v[5]<<16)+$v[6])/100)."kWh";
      

      
        $dataArray["第 3 路正向电能"] = ((($v[7]<<16)+$v[8])/100)."kWh";
      

      
        $dataArray["第 4 路正向电能"] = ((($v[9]<<16)+$v[10])/100)."kWh";
      

      
        $dataArray["第 5 路正向电能"] = ((($v[11]<<16)+$v[12])/100)."kWh";
      

      
        $dataArray["第 6 路正向电能"] = ((($v[13]<<16)+$v[14])/100)."kWh";
      

      $offset += 28;

            $v = unpack("S*" , substr($memData , $offset, 2*2));
$lMemData = substr($memData , $offset, 2*2);
      $lOffset = 0;
      
        switch((($v[1]) & 0x1)){
          case 0:
          $dataArray["DO1"] = "断开";
            break;
          case 1:
          $dataArray["DO1"] = "闭合";
            break;
          default:
            $dataArray["DO1"] = "无效值";
            break;
        }
      

      
        switch((($v[1]>>1) & 0x1)){
          case 0:
          $dataArray["熔丝 1"] = "熔丝闭合";
            break;
          case 1:
          $dataArray["熔丝 1"] = "熔丝断开";
            break;
          default:
            $dataArray["熔丝 1"] = "无效值";
            break;
        }
      

      
        switch((($v[1]>>1) & 0x1)){
          case 0:
          $dataArray["熔丝 2"] = "熔丝闭合";
            break;
          case 1:
          $dataArray["熔丝 2"] = "熔丝断开";
            break;
          default:
            $dataArray["熔丝 2"] = "无效值";
            break;
        }
      

      
        switch((($v[1]>>3) & 0x1)){
          case 0:
          $dataArray["DI1"] = "断开";
            break;
          case 1:
          $dataArray["DI1"] = "闭合";
            break;
          default:
            $dataArray["DI1"] = "无效值";
            break;
        }
      

      
        switch((($v[1]>>4) & 0x1)){
          case 0:
          $dataArray["DI2"] = "断开";
            break;
          case 1:
          $dataArray["DI2"] = "闭合";
            break;
          default:
            $dataArray["DI2"] = "无效值";
            break;
        }
      

      
        _dcm3366ph241s_ShowAlert($dataArray, "1 路过压", (($v[2]) & 0x1), 0);
      

      
        _dcm3366ph241s_ShowAlert($dataArray, "2 路过压", (($v[2]>>1) & 0x1), 0);
      

      
        _dcm3366ph241s_ShowAlert($dataArray, "1 路欠压", (($v[2]>>2) & 0x1), 0);
      

      
        _dcm3366ph241s_ShowAlert($dataArray, "2 路欠压", (($v[2]>>3) & 0x1), 0);
      

      
        _dcm3366ph241s_ShowAlert($dataArray, "1 路过流", (($v[2]>>4) & 0x1), 0);
      

      
        _dcm3366ph241s_ShowAlert($dataArray, "2 路过流", (($v[2]>>5) & 0x1), 0);
      

      
        _dcm3366ph241s_ShowAlert($dataArray, "1 路熔丝", (($v[2]>>6) & 0x1), 0);
      

      
        _dcm3366ph241s_ShowAlert($dataArray, "2 路熔丝", (($v[2]>>7) & 0x1), 0);
      

      
        _dcm3366ph241s_ShowAlert($dataArray, "DI1", (($v[2]>>8) & 0x1), 0);
      

      
        _dcm3366ph241s_ShowAlert($dataArray, "DI2", (($v[2]>>9) & 0x1), 0);
      

      
        _dcm3366ph241s_ShowAlert($dataArray, "1 路过载", (($v[2]>>10) & 0x1), 0);
      

      
        _dcm3366ph241s_ShowAlert($dataArray, "2 路过载", (($v[2]>>11) & 0x1), 0);
      

      $offset += 4;

            $v = unpack("S*" , substr($memData , $offset, 2*24));
$lMemData = substr($memData , $offset, 2*24);
      $lOffset = 0;
      
        $dataArray["第 1 路额定电压"] = ((($v[1]<<16)+$v[2])/1000)."V";
      

      
        $dataArray["第 2 路额定电压"] = ((($v[3]<<16)+$v[4])/1000)."V";
      

      
        $dataArray["第 3 路额定电压"] = ((($v[5]<<16)+$v[6])/1000)."V";
      

      
        $dataArray["第 4 路额定电压"] = ((($v[7]<<16)+$v[8])/1000)."V";
      

      
        $dataArray["第 5 路额定电压"] = ((($v[9]<<16)+$v[10])/1000)."V";
      

      
        $dataArray["第 6 路额定电压"] = ((($v[11]<<16)+$v[12])/100)."V";
      

      
        $dataArray["第 1 路标定电流"] = ((($v[13]<<16)+$v[14])/100)."A";
      

      
        $dataArray["第 2 路标定电流"] = ((($v[15]<<16)+$v[16])/100)."A";
      

      
        $dataArray["第 3 路标定电流"] = ((($v[17]<<16)+$v[18])/100)."A";
      

      
        $dataArray["第 4 路标定电流"] = ((($v[19]<<16)+$v[20])/100)."A";
      

      
        $dataArray["第 5 路标定电流"] = ((($v[21]<<16)+$v[22])/100)."A";
      

      
        $dataArray["第 6 路标定电流"] = ((($v[23]<<16)+$v[24])/100)."A";
      

      $offset += 48;

        $v = unpack('v', substr($memData, $offset , 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData, $offset + 2 , 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}

