<?php

function Get_dds3366m_w1_UnicomCategory()
{
    return "321";
}

function Get_dds3366m_w1_RtData($memData,&$dataArray,$extraPara = false) {
	if (empty($memData)) {
		$dataArray['无数据'] = true;
		$dataArray['更新时间'] = '无';
		$dataArray['错误'] = '数据长度不一致';
	} else {
		$dataArray['无数据'] = false;

		$v = unpack('s*', substr($memData, 4, 2 * 13));
		$dataArray["组合有功电能"] = number_format( ($v[1] << 16 | $v[2])/100 , 2)." kWh";
		$dataArray["正向有功电能"] = number_format( ($v[3] << 16 | $v[4])/100 , 2)." kWh";
		$dataArray["反向有功电能"] = number_format( ($v[5] << 16 | $v[6])/100 , 2)." kWh";

        $dataArray["电压"] = number_format( $v[7]/10 , 1)." V";
		$dataArray["电流"] = number_format( ($v[8] << 16 + $v[9])/1000 , 3)." A";
		$vpStr = substr($memData, 4 + 2*9, 4);
		//echo bin2hex($vpStr). " vs ".bin2hex($vpStr[2].$vpStr[3].$vpStr[0].$vpStr[1]);
		$vP = unpack("i", $vpStr[2].$vpStr[3].$vpStr[0].$vpStr[1]);
		$dataArray["功率"] = number_format( ($vP[1])/10000 , 4)." kW";
		$dataArray["功率因数"] = number_format( $v[12]/1000 , 3);
		$dataArray["频率"] = number_format( $v[13]/100 , 2)." Hz";
		$v = unpack('v',substr($memData, 4 + 2*13, 2));
        $year = $v[1];		
		$v = unpack('C*', substr($memData, 4 + 2*13 + 2, 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
	}
}





?>
