<?php
function Get_delta_dps_h_UnicomCategory()
{
    return "911";
}

function Get_delta_dps_h_RtData($memData, &$dataArray, $extraPara = false)
{
    if ($memData == false) {
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    } else {
        $dataArray['无数据'] = false;
        $offset = 4;
        $v = unpack('S*', substr($memData, 4, 101*2));
        switch($v[1])
        {
            case 0:
                $dataArray['型号'] = 'T';
                break;
            case 1:
                $dataArray['型号'] = 'H';
                break;
            case 2:
                $dataArray['型号'] = 'NT';
                break;
            case 3:
                $dataArray['型号'] = 'NH';
                break;
            case 4:
                $dataArray['型号'] = 'DPS';
                break;
            case 5:
                $dataArray['型号'] = 'DPH';
                break;
        }
        
        $dataArray['额定输入电压'] = number_format($v[2], 1) . ' V';
        $dataArray['额定输入频率'] = number_format($v[3] / 10, 1) . ' Hz';
        $dataArray['额定输出电压'] = number_format($v[4], 1) . ' V';
        $dataArray['额定输出频率'] = number_format($v[5] / 10, 1) . ' Hz';

        $dataArray['额定视在功率'] = number_format($v[6]*10, 1) . ' KVA';
        $dataArray['额定输出功率'] = number_format($v[7]*10, 1) . ' KW';

        switch($v[15])
        {
            case 0:
                $dataArray['UPS类型'] = "On-Line";
                break;
            case 1:
                $dataArray['UPS类型'] = "Off-Line";
                break;
            case 2:
                $dataArray['UPS类型'] = "Line-Interactive";
                break;
            case 3:
                $dataArray['UPS类型'] = "3 Phase";
                break;
            case 4:
                $dataArray['UPS类型'] = "Split Phase";
                break;
            case 5:
                $dataArray['UPS类型'] = "其他";
                break;
            case 6:
                $dataArray['UPS类型'] = "HVDC";
                break;
        }
        
        $dataArray['额定电池电压'] = number_format($v[16], 1) . ' V';
        switch($v[31])
        {
            case 0:
                $dataArray['电池健康状态'] = "好";
                break;
            case 1:
                $dataArray['电池健康状态'] = "差";
                break;
            case 2:
                $dataArray['电池健康状态'] = "更换";
                break;
        }
        switch($v[32])
        {
            case 0:
                $dataArray['电池容量状态'] = "好";
                break;
            case 1:
                $dataArray['电池容量状态'] = "低";
                break;
            case 2:
                $dataArray['电池容量状态'] = "耗尽";
                break;
        }
        switch($v[33])
        {
            case 0:
                $dataArray['电池充电状态'] = "过时";
                break;
            case 1:
                $dataArray['电池充电状态'] = "充电中";
                break;
            case 2:
                $dataArray['电池充电状态'] = "休眠中";
                break;
            case 2:
                $dataArray['电池充电状态'] = "放电中";
                break;
        }
        $dataArray['电池上线时长'] = number_format($v[34]) . ' 秒';
        $dataArray['剩余放电时长'] = number_format($v[35]) . ' 分';
        $dataArray['电池电压'] = number_format($v[37] / 10, 1) . ' V';
        $dataArray['电池电流'] = number_format($v[38] / 10, 1) . ' A';

        $dataArray['UPS内部温度'] = number_format($v[39] / 10, 1);
        $dataArray['电池等级'] = number_format($v[40] / 10, 1) . ' %';

	    $dataArray['外部电池包数量'] = number_format($v[41], 1);
        $dataArray['负电池电压'] = number_format(0-$v[42] / 10, 1) . ' V';
        $dataArray['负电池电流'] = number_format(0-$v[43] / 10, 1) . ' A';
        $dataArray['负电池等级'] = number_format($v[45] / 10, 1) . ' %';

        $dataArray['正充电电流'] = number_format($v[46] / 10, 1) . ' A';
        $dataArray['负充电电流'] = number_format($v[47] / 10, 1) . ' A';

        switch($v[48])
        {
            case 0:
                $dataArray['电池充电模式'] =  "无";
                break;
            case 1:
                $dataArray['电池充电模式'] =  "均冲";
                break;
            case 2:
                $dataArray['电池充电模式'] =  "浮冲";
                break;
            case 3:
                $dataArray['电池充电模式'] =  "放电";
                break;
        }
	
	    $dataArray['输入相位数'] = $v[49];
	    $dataArray['输入频率1'] =  number_format($v[50] / 10, 1) . ' Hz';
        $dataArray['输入电压1'] =  number_format($v[51] / 10, 1) . ' V';
        $dataArray['输入电流1'] =  number_format($v[52]) . ' A';
        $dataArray['输入功率1'] =  number_format($v[53] / 100, 1) . ' KW';

        $dataArray['输入频率2'] =  number_format($v[54] / 10, 1) . ' Hz';
        $dataArray['输入电压2'] =  number_format($v[55] / 10, 1) . ' V';
        $dataArray['输入电流2'] =  number_format($v[56]) . ' A';
        $dataArray['输入功率2'] =  number_format($v[57] / 100, 1) . ' KW';

        $dataArray['输入频率3'] =  number_format($v[58] / 10, 1) . ' Hz';
        $dataArray['输入电压3'] =  number_format($v[59] / 10, 1) . ' V';
        $dataArray['输入电流3'] =  number_format($v[60]) . ' A';
        $dataArray['输入功率3'] =  number_format($v[61] / 100, 1) . ' KW';

        $dataArray['输入电压12'] = number_format($v[62] / 10, 1) . ' V';
        $dataArray['输入电压23'] = number_format($v[63] / 10, 1) . ' V';
        $dataArray['输入电压31'] = number_format($v[64] / 10, 1) . ' V';

        $dataArray['总输出功率因数'] = number_format($v[66] / 10, 1);
        switch($v[67])
        {
            case 0:
                $dataArray['输出源'] = "正常";
                break;
            case 1:
                $dataArray['输出源'] = "电池";
                break;
            case 2:
                $dataArray['输出源'] = "旁路";
                break;
            case 3:
                $dataArray['输出源'] = "Reducing";
                break;
            case 4:
                $dataArray['输出源'] = "Boosting";
                break;
            case 5:
                $dataArray['输出源'] = "人工旁路";
                break;
            case 6:
                $dataArray['输出源'] = "其他";
                break;
            case 6:
                $dataArray['输出源'] = "无输出";
                break;
        }

        $dataArray['输出频率'] = number_format($v[68] / 10, 1) . ' Hz';
        $dataArray['输出相位数'] = $v[69];
        $dataArray['输出电压1'] =  number_format($v[70] / 10, 1) . ' V';
        $dataArray['输出电流1'] =  number_format($v[71], 1) . ' A';
        $dataArray['输出功率1'] =  number_format($v[72] / 100, 1) . ' KW';
        $dataArray['输出负载1'] =  number_format($v[73] / 10, 1) . ' %';

        $dataArray['输出电压2'] =  number_format($v[74] / 10, 1) . ' V';
        $dataArray['输出电流2'] =  number_format($v[75]) . ' A';
        $dataArray['输出功率2'] =  number_format($v[76] / 100, 1) . ' KW';
        $dataArray['输出负载2'] =  number_format($v[77] / 10, 1) . ' %';

        $dataArray['输出电压3'] =  number_format($v[78] / 10, 1) . ' V';
        $dataArray['输出电流3'] =  number_format($v[79]) . ' A';
        $dataArray['输出功率3'] =  number_format($v[80] / 100, 1) . ' KW';
        $dataArray['输出负载3'] =  number_format($v[81] / 10, 1) . ' %';

        $dataArray['输出电压12'] = number_format($v[82] / 10, 1) . ' V';
        $dataArray['输出电压23'] = number_format($v[83] / 10, 1) . ' V';
        $dataArray['输出电压31'] = number_format($v[84] / 10, 1) . ' V';

        $dataArray['输出总功率'] = number_format($v[85] / 10, 1) . ' KW';
        $dataArray['输出总视在功率'] = number_format($v[86] / 10, 1) . ' KVA';

        $dataArray['旁路频率'] = number_format($v[87] / 10, 1) . ' Hz';
        $dataArray['旁路相位数'] = $v[88];

        $dataArray['旁路电压1'] =  number_format($v[89] / 10, 1) . ' V';
        $dataArray['旁路电流1'] =  number_format($v[90]) . ' A';
        $dataArray['旁路功率1'] =  number_format($v[91] / 100, 1) . ' KW';

        $dataArray['旁路电压2'] =  number_format($v[92] / 10, 1) . ' V';
        $dataArray['旁路电流2'] =  number_format($v[93]) . ' A';
        $dataArray['旁路功率2'] =  number_format($v[94] / 100, 1) . ' KW';

        $dataArray['旁路电压3'] =  number_format($v[95] / 10, 1) . ' V';
        $dataArray['旁路电流3'] =  number_format($v[96]) . ' A';
        $dataArray['旁路功率3'] =  number_format($v[97] / 100, 1) . ' KW';

        $dataArray['旁路电压12'] = number_format($v[98] / 10, 1) . ' V';
        $dataArray['旁路电压23'] = number_format($v[99] / 10, 1) . ' V';
        $dataArray['旁路电压31'] = number_format($v[100] / 10, 1) . ' V';

        $dataArray['旁路STS温度'] = number_format($v[101] / 10, 1);
        $v = unpack('v', substr($memData, 4 + 101*2, 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData, 4 + 101*2+ 2, 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));

    }

}
