<?php
function _GetDeltanhntOutptSource($v)
{
    switch ($v) {
        case 0: return "正常";
        case 1: return "电池";
        case 2: return "旁路（备用）";
        case 3: return "减少";
        case 4: return "加速";
        case 5: return "手动旁路";
        case 6: return "其他";
        case 7: return "没有";
    }
    return "无效";
}

function _GetDeltanhntTestResult($v)
{
    switch ($v) {
        case 0: return "没有进行测试";
        case 1: return "测试通过";
        case 2: return "测试进行中";
        case 3: return "总体调试失败";
        case 4: return "电池测试失败";
        case 5: return "Deep batt test failed";
        case 6: return "测试失败";
    }
    return "无效";
}

function Get_deltaNHNT_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '[UPS输出频率]':
            return array(0 , $dataArray['额定输出频率']);
        case 'A相输出电流':
            return array(0, $dataArray['输出电流1']);
        case 'B相输出电流':
            return array(0, $dataArray['输出电流2']);
        case 'C相输出电流':
            return array(0, $dataArray['输出电流3']);
        case 'A相输出负载百分比':    
            return array(0,$dataArray['输出负载1']);
        case 'B相输出负载百分比':    
            return array(0,$dataArray['输出负载2']);
        case 'C相输出负载百分比':    
            return array(0,$dataArray['输出负载3']);
        default:
            break;
    }
    return array(1 , '设备无此信号数据:'. $varname);
}

function Get_deltanhnt_RtData($memData, &$dataArray, $extraPara = false)
{
        if ($memData == false) {
            $dataArray['无数据'] = true;
            $dataArray['更新时间'] = '无';
            $dataArray['错误'] = '数据长度不一致';
        } else {
            $dataArray['无数据'] = false;
            $dataArray['AlertArray'] = array();
            //MNU cmd
            $dataArray['制造商'] = substr($memData, 4, 1 * 16);
            //MOD cmd
            $dataArray['UPS类型'] = substr($memData, 20, 1 * 16);
            //RAT cmd
            $v = unpack('I*', substr($memData, 36, 1 * 4));
            $dataArray['额定输入电压'] = $v[1].' V';
            $v = unpack('f*', substr($memData, 40, 1 * 4));
            $dataArray['额定输入频率'] = number_format($v[1], 1).' Hz';
            $v = unpack('I*', substr($memData, 44, 1 * 4));
            $dataArray['额定输出电压'] = $v[1].' V';
            $v = unpack('f*', substr($memData, 48, 1 * 4));
            $dataArray['额定输出频率'] = number_format($v[1], 1).' Hz';
            $v = unpack('I*', substr($memData, 52, 2 * 4));
            $dataArray['额定视在功率'] = ($v[1]/1000).' KVA';
            $dataArray['额定输出功率'] = ($v[2]/1000).' KW';
            $v = unpack('c*', substr($memData, 60, 1 * 1));
            $dataArray['低电池时间'] = $v[1].' min';
            $v = unpack('I*', substr($memData, 61, 6 * 4));
            $dataArray['低输出电压点'] = $v[1].' V';
            $dataArray['高输出电压点'] = $v[2].' V';
            $dataArray['低输出电压上限'] = $v[3].' V';
            $dataArray['低输出电压下限'] = $v[4].' V';
            $dataArray['高输出电压上限'] = $v[5].' V';
            $dataArray['高输出电压下限'] = $v[6].' V';
            $v = unpack('c*', substr($memData, 85, 1));
            switch ($v[1]){
                case 0:
                    $dataArray['UPS状态'] = '在线';
                    break;
                case 1:
                    $dataArray['UPS状态'] = '离线';
                    break;
                case 2:
                    $dataArray['UPS状态'] = '在线交互';
                    break;
                case 3:
                    $dataArray['UPS状态'] = '三相UPS';
                    break;
                default:
                    $dataArray['UPS状态'] = '无效';
            }
            $v = unpack('I*', substr($memData, 86, 4));
            $dataArray['额定电池电压'] = $v[1].' V';
            $v = unpack('f*', substr($memData, 90, 6 * 4));
            $dataArray['低输出频率点'] = number_format($v[1], 1).' Hz';
            $dataArray['高输出频率点'] = number_format($v[2], 1).' Hz';
            $dataArray['低输出频率上限'] = number_format($v[3], 1).' Hz';
            $dataArray['低输出频率下限'] = number_format($v[4], 1).' Hz';
            $dataArray['高输出频率上限'] = number_format($v[5], 1).' Hz';
            $dataArray['高输出频率下限'] = number_format($v[6], 1).' Hz';
            //STB
            $v = unpack('c*', substr($memData, 90 + 6 * 4, 3));
            $dataArray['电池自身状态'] = '无效';
            if($v[1] == 0){
                $dataArray['电池自身状态'] = '良好';
            }else if($v[1] == 1){
                $dataArray['电池自身状态'] = '一般';
            }else if($v[1] == 2){
                $dataArray['电池自身状态'] = '需替换';
            }
            $dataArray['电池电量状态'] = '无效';
            if($v[2] == 0){
                $dataArray['电池电量状态'] = '电量高';
            }else if($v[2] == 1){
                $dataArray['电池电量状态'] = '电量低';
            }else if($v[2] == 2){
                $dataArray['电池电量状态'] = '电量耗尽';
            }
            $dataArray['电池充电状态'] = '无效';
            if($v[3] == 0){
                $dataArray['电池充电状态'] = '浮动';
            }else if($v[3] == 1){
                $dataArray['电池充电状态'] = '充电';
            }else if($v[3] == 2){
                $dataArray['电池充电状态'] = '休眠';
            }else if($v[3] == 4){
                $dataArray['电池充电状态'] = '放电';
            }
            $v = unpack('I*', substr($memData, 93 + 6 * 4, 3 * 4));
            $dataArray['电池运行时间'] = $v[1].' S';
            $dataArray['预计剩余时间'] = $v[2].' min';
            $dataArray['估计剩余电量'] = $v[3].' %';
            $v = unpack('f*', substr($memData, 93 + 9 * 4, 2 * 4));
            $dataArray['电池电压'] = number_format($v[1], 1).' V';
            $dataArray['电池电流'] = number_format($v[2], 1).' A';
            $v = unpack('I*', substr($memData, 93 + 11 * 4, 2 * 4));
            $dataArray['温度'] = $v[1].' ℃';
            $dataArray['电池电量'] = $v[2].' %';
            //STI cmd
            $v = unpack('c*', substr($memData, 93 + 13 * 4, 1 * 1));
            $dataArray['输入数字线'] = $v[1];
            $v = unpack('I*', substr($memData, 94 + 13 * 4, 1 * 4));
            $dataArray['输入线数'] = $v[1];
            $v = unpack('f*', substr($memData, 94 + 14 * 4, 3 * 4));/////
            $dataArray['输入频率1'] = number_format($v[1], 1).' Hz';
            $dataArray['输入电压1'] = number_format($v[2], 1).' V';
            $dataArray['输入电流1'] = number_format($v[3], 1).' A';
            $v = unpack('I*', substr($memData, 94 + 17 * 4, 1 * 4));
            $dataArray['输入功率1'] = $v[1].' W';
            $v = unpack('f*', substr($memData, 94 + 18 * 4, 3 * 4));
            $dataArray['输入频率2'] = number_format($v[1], 1).' Hz';
            $dataArray['输入电压2'] = number_format($v[2], 1).' V';
            $dataArray['输入电流2'] = number_format($v[3], 1).' A';
            $v = unpack('I*', substr($memData, 94 + 21 * 4, 1 * 4));
            $dataArray['输入功率2'] = $v[1].' W';
            $v = unpack('f*', substr($memData, 94 + 22 * 4, 3 * 4));
            $dataArray['输入频率3'] = number_format($v[1], 1).' Hz';
            $dataArray['输入电压3'] = number_format($v[2], 1).' V';
            $dataArray['输入电流3'] = number_format($v[3], 1).' A';
            $v = unpack('I*', substr($memData, 94 + 25 * 4, 1 * 4));
            $dataArray['输入功率3'] = $v[1].' W';
            //STO cmd
            $v = unpack('c*', substr($memData, 94 + 26 * 4, 1 * 1));
            $dataArray['输出源'] =  _GetDeltanhntOutptSource($v[1]);
            $v = unpack('f*', substr($memData, 95 + 26 * 4, 1 * 4));
            $dataArray['输出频率'] = number_format($v[1], 1).' Hz';
            $v = unpack('c*', substr($memData, 95 + 27 * 4, 1 * 1));
            $dataArray['输出线数'] = $v[1];
            $v = unpack('f*', substr($memData, 96 + 27 * 4, 2 * 4));
            $dataArray['输出电压1'] = number_format($v[1], 1).' V';
            $dataArray['输出电流1'] = number_format($v[2], 1).' A';
            $v = unpack('I*', substr($memData, 96 + 29 * 4, 2 * 4));
            $dataArray['输出功率1'] = $v[1].' W';
            $dataArray['输出负载1'] = $v[2];
            $v = unpack('f*', substr($memData, 96 + 31 * 4, 2 * 4));
            $dataArray['输出电压2'] = number_format($v[1], 1).' V';
            $dataArray['输出电流2'] = number_format($v[2], 1).' A';
            $v = unpack('I*', substr($memData, 96 + 33 * 4, 2 * 4));
            $dataArray['输出功率2'] = $v[1].' W';
            $dataArray['输出负载2'] = $v[2];
            $v = unpack('f*', substr($memData, 96 + 35 * 4 , 2 * 4));
            $dataArray['输出电压3'] = number_format($v[1], 1).' V';
            $dataArray['输出电流3'] = number_format($v[2], 1).' A';
            $v = unpack('I*', substr($memData, 96 + 37 * 4, 2 * 4));
            $dataArray['输出功率3'] = $v[1].' W';
            $dataArray['输出负载3'] = $v[2];
            //STP
            $v = unpack('f*', substr($memData, 96 + 39 * 4 , 1 * 4));
            $dataArray['旁路频率'] = number_format($v[1], 1).' Hz';
            $v = unpack('c*', substr($memData, 96 + 40 * 4 , 1 * 1));
            $dataArray['旁路线数'] = $v[1];
            $v = unpack('f*', substr($memData, 97 + 40 * 4, 2 * 4));
            $dataArray['旁路电压1'] = number_format($v[1], 1).' V';
            $dataArray['旁路电流1'] = number_format($v[2], 1).' A';
            $v = unpack('I*', substr($memData, 97 + 42 * 4, 1 * 4));
            $dataArray['旁路功率1'] = $v[1].' W';
            $v = unpack('f*', substr($memData, 97 + 43 * 4, 2 * 4));
            $dataArray['旁路电压2'] = number_format($v[1], 1).' V';
            $dataArray['旁路电流2'] = number_format($v[2], 1).' A';
            $v = unpack('I*', substr($memData, 97 + 45 * 4, 1 * 4));
            $dataArray['旁路功率2'] = $v[1].' W';
            $v = unpack('f*', substr($memData, 97 + 46 * 4, 2 * 4));
            $dataArray['旁路电压3'] = number_format($v[1], 1).' V';
            $dataArray['旁路电流3'] = number_format($v[2], 1).' A';
            $v = unpack('I*', substr($memData, 97 + 48 * 4, 1 * 4));
            $dataArray['旁路功率3'] = $v[1].' W';
            //STA
            $v = unpack('C*', substr($memData, 97 + 49 * 4, 1 * 22));
            $dataArray['温度过高'] = $v[1] == 1 ? '告警' : '正常';
            $dataArray['输入故障'] = $v[2] == 1 ? '告警' : '正常';
            $dataArray['输出故障'] = $v[3] == 1 ? '告警' : '正常';
            $dataArray['过载告警'] = $v[4] == 1 ? '告警' : '正常';
            $dataArray['旁路故障'] = $v[5] == 1 ? '告警' : '正常';
            $dataArray['UPS输出关闭'] = $v[6] == 1 ? '告警' : '正常';
            $dataArray['UPS关机'] = $v[7] == 1 ? '告警' : '正常';
            $dataArray['充电器故障'] = $v[8] == 1 ? '告警' : '正常';
            $dataArray['系统关闭'] = $v[9] == 1 ? '告警' : '正常';
            $dataArray['风扇故障'] = $v[10] == 1 ? '告警' : '正常';
            $dataArray['熔断器故障'] = $v[11] == 1 ? '告警' : '正常';
            $dataArray['通用故障'] = $v[12] == 1 ? '告警' : '正常';
            $dataArray['UPS掉电'] = $v[13] == 1 ? '告警' : '正常';
            $dataArray['正在关机'] = $v[14] == 1 ? '告警' : '正常';
            $dataArray['即将关机'] = $v[15] == 1 ? '告警' : '正常';
            $dataArray['UPS蜂鸣器告警'] = $v[16] == 1 ? '告警' : '正常';
            $dataArray['AlertArray']['温度过高'] = $v[1] == 1;
            $dataArray['AlertArray']['输入故障'] = $v[2] == 1;
            $dataArray['AlertArray']['输出故障'] = $v[3] == 1;
            $dataArray['AlertArray']['过载告警'] = $v[4] == 1;
            $dataArray['AlertArray']['旁路故障'] = $v[5] == 1;
            $dataArray['AlertArray']['UPS输出关闭'] = $v[6] == 1;
            $dataArray['AlertArray']['UPS关机'] = $v[7] == 1;
            $dataArray['AlertArray']['充电器故障'] = $v[8] == 1;
            $dataArray['AlertArray']['系统关闭'] = $v[9] == 1;
            $dataArray['AlertArray']['风扇故障'] = $v[10] == 1;
            $dataArray['AlertArray']['熔断器故障'] = $v[11] == 1;
            $dataArray['AlertArray']['通用故障'] = $v[12] == 1;
            $dataArray['AlertArray']['UPS掉电'] = $v[13] == 1;
            $dataArray['AlertArray']['正在关机'] = $v[14] == 1;
            $dataArray['AlertArray']['即将关机'] = $v[15] == 1;
            $dataArray['AlertArray']['UPS蜂鸣器告警'] = $v[16] == 1;
            $dataArray['经济模式'] = $v[17] == 1 ? '是' : '否';
            $dataArray['逆变器故障告警'] = $v[18] == 1 ? '告警' : '正常';
            $dataArray['AlertArray']['逆变器故障告警'] = $v[18] == 1;
            $dataArray['紧急断电'] = $v[19] == 1 ? '开启' : '关闭';
            $dataArray['蜂鸣器状态'] = $v[20] == 1 ? '启用' : '禁用';
            $dataArray['测试结果'] = _GetDeltanhntTestResult($v[21]);
            $dataArray['UPS身份信息'] = $v[22];
            $dataArray['UPS固件版本'] = substr($memData, 119 + 49 * 4, 1 * 16);
            $v = unpack('v', substr($memData, 135 + 49 * 4, 2));
            $year = $v[1];
            $v = unpack('C*', substr($memData, 137 + 49 * 4, 5));
            $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
        }
}
