<?php 

function Get_diris_a40_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '[A相电压]':
            return array(0, $dataArray['线电压U12(V)']);
        case '[B相电压]':
            return array(0, $dataArray['线电压U23(V)']);
        case '[C相电压]':
            return array(0, $dataArray['线电压U31(V)']);
        case '[总功率]':
            return array(0, $dataArray['总有功功率2']);
    }
    return array(1 , '设备无此信号数据:'. $varname);
}

function Get_diris_a40_Active_Power($dataArray){
    return array(0 , $dataArray['正向有功电度(Kwh)']);
}

function Get_diris_a40_RtData($memData, &$dataArray, $extraPara = false)
{
   if($memData == false) {
       $dataArray['无数据'] = true;
       $dataArray['更新时间'] = '无';
       $dataArray['错误'] = '数据长度不一致';
   } else {
        $dataArray['无数据'] = false;
        $v = unpack('i*',substr($memData,4,288));
        $dataArray['1相电流(A)'] = number_format($v[1]/1000,2);
        $dataArray['2相电流(A)'] = number_format($v[2]/1000,2);
        $dataArray['3相电流(A)'] = number_format($v[3]/1000,2);
        $dataArray['中性线电流(A)'] = number_format($v[4]/1000,2);
        $dataArray['线电压U12(V)'] = number_format($v[5]/100,2);
        $dataArray['线电压U23(V)'] = number_format($v[6]/100,2);
        $dataArray['线电压U31(V)'] = number_format($v[7]/100,2);
        $dataArray['相电压V1(V)'] = number_format($v[8]/100,2);
        $dataArray['相电压V2(V)'] = number_format($v[9]/100,2);
        $dataArray['相电压V3(V)'] = number_format($v[10]/100,2);
        $dataArray['频率(Hz)'] = number_format($v[11]/100,2);
        $dataArray['总有功功率(Kw)'] = number_format($v[12]/100,2);
        $dataArray['总有功功率2'] = number_format($v[12]/100,2,'.','');
        $dataArray['总无功功率(Kvar)'] = number_format($v[13]/100,2);
        $dataArray['总视在功率(Kva)'] = number_format($v[14]/100,2);
        $dataArray['总功率因数'] = number_format($v[15]/1000,3);
        $dataArray['1相有功功率(Kw)'] = number_format($v[16]/100,2);
        $dataArray['2相有功功率(Kw)'] = number_format($v[17]/100,2);
        $dataArray['3相有功功率(Kw)'] = number_format($v[18]/100,2);
        $dataArray['1相无功功率(Kvar)'] = number_format($v[19]/100,2);
        $dataArray['2相无功功率(Kvar)'] = number_format($v[20]/100,2);
        $dataArray['3相无功功率(Kvar)'] = number_format($v[21]/100,2);
        $dataArray['1相视在功率(Kva)'] = number_format($v[22]/100,2);
        $dataArray['2相视在功率(Kva)'] = number_format($v[23]/100,2);
        $dataArray['3相视在功率(Kva)'] = number_format($v[24]/100,2);
        $dataArray['1相功率因数'] = number_format($v[25]/1000,3);
        $dataArray['2相功率因数'] = number_format($v[26]/1000,3);
        $dataArray['3相功率因数'] = number_format($v[27]/1000,3);
        $dataArray['平均电流I1(A)'] = number_format($v[28]/1000,2);
        $dataArray['平均电流I2(A)'] = number_format($v[29]/1000,2);
        $dataArray['平均电流I3(A)'] = number_format($v[30]/1000,2);
        $dataArray['平均正向总有功功率(Kw)'] = number_format($v[31]/100,2);
        $dataArray['平均负向总有功功率(Kw)'] = number_format($v[32]/100,2);
        $dataArray['平均正向总无功功率(Kvar)'] = number_format($v[33]/100,2);
        $dataArray['平均负向总无功功率(Kvar)'] = number_format($v[34]/100,2);
        $dataArray['平均总视在功率(Kva)'] = number_format($v[35]/100,2);
        $dataArray['I1最大值/平均值(A)'] = number_format($v[36]/1000,2);
        $dataArray['I2最大值/平均值(A)'] = number_format($v[37]/1000,2);
        $dataArray['I3平均值/最大值(A)'] = number_format($v[38]/1000,2);
        $dataArray['正向总有功功率最大值/平均值(Kw)'] = number_format($v[39]/100,2);
        $dataArray['负向总有功功率最大值/平均值(Kw)'] = number_format($v[40]/100,2);
        $dataArray['正向总无功功率最大值/平均值(Kvar)'] = number_format($v[41]/100,2);
        $dataArray['负向总无功功率最大值/平均值(Kvar)'] = number_format($v[42]/100,2);
        $dataArray['总视在功率最大值/平均值(Kva)'] = number_format($v[43]/100,2);
        $dataArray['小时计量(h)'] = number_format($v[44]/100,2);
        $dataArray['正向有功电度(Kwh)'] = $v[45];
        $dataArray['正向无功电度(Kvarh)'] = $v[46];
        $dataArray['视在电度(Kvah)'] = $v[47];
        $dataArray['负向有功电度(Kwh)'] = $v[48];
        $dataArray['负向无功电度(Kvarh)'] = $v[49];
        $dataArray['电流系统值(A)'] = number_format($v[50]/1000,2);
        $dataArray['线电压系统值(V)'] = number_format($v[51]/100,2);
        $dataArray['中性线电压系统值(V)'] = number_format($v[52]/100,2);
        $dataArray['线电压U12平均值(V)'] = number_format($v[53]/100,2);
        $dataArray['线电压U23平均值(V)'] = number_format($v[54]/100,2);
        $dataArray['线电压U31平均值(V)'] = number_format($v[55]/100,2);
        $dataArray['相电压V1平均值(V)'] = number_format($v[56]/100,2);
        $dataArray['相电压V2平均值(V)'] = number_format($v[57]/100,2);
        $dataArray['相电压V3平均值(V)'] = number_format($v[58]/100,2);
        $dataArray['频率F平均值(Hz)'] = number_format($v[59]/100,2);
        $dataArray['线电压U12最大值/平均值(V)'] = number_format($v[60]/100,2);
        $dataArray['线电压U23最大值/平均值(V)'] = number_format($v[61]/100,2);
        $dataArray['线电压U31最大值/平均值(V)'] = number_format($v[62]/100,2);
        $dataArray['相电压V1最大值/平均值(V)'] = number_format($v[63]/100,2);
        $dataArray['相电压V2最大值/平均值(V)'] = number_format($v[64]/100,2);
        $dataArray['相电压V3最大值/平均值(V)'] = number_format($v[65]/100,2);
        $dataArray['频率F最大值/平均值(Hz)'] = number_format($v[66]/100,2);
        $dataArray['中性线电流In平均值(A)'] = number_format($v[67]/1000,2);
        $dataArray['中性线电流In最大值/平均值(A)'] = number_format($v[68]/1000,2);
        $dataArray['2信号间正有功功率平均值(Kw)'] = number_format($v[69]/10,1);
        $dataArray['2信号间负有功功率平均值(Kw)'] = number_format($v[70]/10,1);
        $dataArray['2信号间正无功功率平均值(Kvar)'] = number_format($v[71]/10,1);
        $dataArray['2信号间负无功功率平均值(Kvar)'] = number_format($v[72]/10,1);

       $v = unpack('v', substr($memData, 292,2));
       $year = $v[1];
       $v = unpack('C*', substr($memData,  294,5));
       $dataArray["更新时间"] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
   }
}


?>

