<?php

function Get_dk04_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '直流负载电流':
            return array(0, $dataArray['负载总电流']);
        case '整流模块数量':
            return array(0, $dataArray['整流模块数量']);
        default:
            break;
    }
    return array(1 , '设备无此信号数据:'. $varname);
}


function Get_dk04_RtData($memData, &$dataArray, $extraPara = false)
{
    if($memData == false){
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '无数据';
    }else{
        $dataArray['无数据'] = false;
        $dataArray['AlertArray'] = array();
        //StatusPacket   系统状态数据
        $v = unpack('S*', substr($memData, 4, 2 * 2));
        $dataArray['系统电压'] = ($v[1] / 10).' V';
        $dataArray['负载总电流'] = $v[2].' A';
        $v = unpack('s*', substr($memData, 4 + 2 * 2, 2 * 4));
        $dataArray['电池组1电流'] = $v[1].' A';
        $dataArray['电池组2电流'] = $v[2].' A';
        $dataArray['电池组3电流'] = $v[3].' A';
        $dataArray['电池组4电流'] = $v[4].' A';
        $v = unpack('S*', substr($memData, 4 + 2 * 6, 2 * 3));
        $dataArray['系统交流输入电压'] = $v[1].' V';
        $dataArray['系统交流输入电流1'] = $v[2].' A';
        $dataArray['系统交流输入电流2'] = $v[3].' A';
        $v = unpack('C*', substr($memData, 4 + 2 * 9, 1 * 3));
        $dataArray['MDO1-电池温度补偿功能启用'] = ($v[1] & 0x1) == 0 ? '启用' : '未启用';
        $dataArray['MDO1-电池放电'] = (($v[1] >> 1) & 0x1) == 0 ? '是' : '否';
        $dataArray['MDO1-整流模块故障(模块关机)'] = (($v[1] >> 4) & 0x1) == 0 ? '告警' : '正常';
        $dataArray['MDO1-整流模块告警(没有关机的告警)'] = (($v[1] >> 5) & 0x1) == 0 ? '告警' : '正常';
        $dataArray['MDO1-交流输入故障'] = (($v[1] >> 6) & 0x1) == 0 ? '告警' : '正常';
        $dataArray['MDO1-监控模块告警蜂鸣器'] = (($v[1] >> 7) & 0x1) == 0 ? '报警' : '正常';
        $dataArray['AlertArray']['MDO1-整流模块故障(模块关机)'] = (($v[1] >> 4) & 0x1) == 0;
        $dataArray['AlertArray']['MDO1-整流模块告警(没有关机的告警)'] = (($v[1] >> 5) & 0x1) == 0;
        $dataArray['AlertArray']['MDO1-交流输入故障'] = (($v[1] >> 6) & 0x1) == 0;
        $dataArray['AlertArray']['MDO1-监控模块告警蜂鸣器'] = (($v[1] >> 7) & 0x1) == 0;
        
        $dataArray['MDO2-均衡充电状态'] = (($v[2] >> 1) & 0x1) == 0 ? '是' : '否';
        $dataArray['MDO2-浮充状态'] = (($v[2] >> 2) & 0x1) == 0 ? '是' : '否';
        $dataArray['MDO2-电池充电限流'] = (($v[2] >> 3) & 0x1) == 0 ? '是' : '否';
        $dataArray['MDO2-电池温度过高'] = (($v[2] >> 4) & 0x1) == 0 ? '告警' : '正常';
        $dataArray['MDO2-熔丝故障'] = (($v[2] >> 5) & 0x1) == 0 ? '告警' : '正常';
        $dataArray['MDO2-电池开关断开'] = (($v[2] >> 6) & 0x1) == 0 ? '告警' : '正常';
        $dataArray['MDO2-环境温度过高'] = (($v[2] >> 7) & 0x1) == 0 ? '告警' : '正常';
        $dataArray['AlertArray']['MDO2-电池温度过高'] = (($v[2] >> 4) & 0x1) == 0;
        $dataArray['AlertArray']['MDO2-熔丝故障'] = (($v[2] >> 5) & 0x1) == 0;
        $dataArray['AlertArray']['MDO2-电池开关断开'] = (($v[2] >> 6) & 0x1) == 0;
        $dataArray['AlertArray']['MDO2-环境温度过高'] = (($v[2] >> 7) & 0x1) == 0;
        
        $dataArray['MDO3-低压断路开关闭合'] = ($v[3] & 0x1) == 0 ? '是' : '否';
        $dataArray['MDO3-低压断路开关断开'] = (($v[3] >> 1) & 0x1) == 0 ? '是' : '否';
        $dataArray['MDO3-系统输出电压过低'] = (($v[3] >> 2) & 0x1) == 0 ? '告警' : '正常';
        $dataArray['MDO3-系统输出电压过高'] = (($v[3] >> 3) & 0x1) == 0 ? '告警' : '正常';
        $dataArray['AlertArray']['MDO3-系统输出电压过低'] = (($v[3] >> 2) & 0x1) == 0;
        $dataArray['AlertArray']['MDO3-系统输出电压过高'] = (($v[3] >> 3) & 0x1) == 0;
        $v = unpack('c*', substr($memData, 7 + 2 * 9, 1 * 4));
        $dataArray['电池组1温度'] = ($v[1] >= -10 && $v[1] <=90) ? $v[1].' ℃' : '传感器未安装';
        $dataArray['电池组2温度'] = ($v[2] >= -10 && $v[2] <=90) ? $v[2].' ℃' : '传感器未安装';
        $dataArray['电池组3温度'] = ($v[3] >= -10 && $v[3] <=90) ? $v[3].' ℃' : '传感器未安装';
        $dataArray['电池组4温度'] = ($v[4] >= -10 && $v[4] <=90) ? $v[4].' ℃' : '传感器未安装';
        $v = unpack('C*', substr($memData, 11 + 2 * 9, 1 * 5));
        $dataArray['PortA-均衡充电'] = ($v[1] & 0x1) == 1 ? '告警' : '正常';
        $dataArray['PortA-环境温度过高'] = (($v[1] >> 1) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['PortA-整流模块主要告警(两个及以上模块关机)'] = (($v[1] >> 2) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['PortA-整流模块次要告警(一个模块关机)'] = (($v[1] >> 3) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['PortA-交流输入故障'] = (($v[1] >> 4) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['PortA-系统输出电压过高'] = (($v[1] >> 5) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['PortA-系统输出电压过低'] = (($v[1] >> 6) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['PortA-均衡充电'] = ($v[1] & 0x1) == 1;
        $dataArray['AlertArray']['PortA-环境温度过高'] = (($v[1] >> 1) & 0x1) == 1;
        $dataArray['AlertArray']['PortA-整流模块主要告警(两个及以上模块关机)'] = (($v[1] >> 2) & 0x1) == 1;
        $dataArray['AlertArray']['PortA-整流模块次要告警(一个模块关机)'] = (($v[1] >> 3) & 0x1) == 1;
        $dataArray['AlertArray']['PortA-交流输入故障'] = (($v[1] >> 4) & 0x1) == 1;
        $dataArray['AlertArray']['PortA-系统输出电压过高'] = (($v[1] >> 5) & 0x1) == 1;
        $dataArray['AlertArray']['PortA-系统输出电压过低'] = (($v[1] >> 6) & 0x1) == 1;
        
        $dataArray['PortC-整流模块警告(未导致关机)'] = (($v[3] >> 4) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['PortC-整流模块高压关机'] = (($v[3] >> 7) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['PortC-整流模块警告(未导致关机)'] = (($v[3] >> 4) & 0x1) == 1;
        $dataArray['AlertArray']['PortC-整流模块高压关机'] = (($v[3] >> 7) & 0x1) == 1;
        
        $dataArray['DIP-均衡充电功能'] = ($v[4] & 0x1) == 0 ? '启用' : '不启用';
        $dataArray['DIP-电池温度补偿功能'] = (($v[4] >> 1) & 0x1) == 0 ? '启用' : '不启用';
        $dataArray['DIP-电池充电限流功能'] = (($v[4] >> 2) & 0x1) == 0 ? '启用' : '不启用';
        $dataArray['DIP-操作CSU时的密码功能'] = (($v[4] >> 3) & 0x1) == 0 ? '启用' : '不启用';
        $dataArray['DIP-系统接地方式'] = (($v[4] >> 4) & 0x1) == 0 ? '正接地' : '负接地';
        $dataArray['DIP-系统类型'] = (($v[4] >> 5) & 0x1) == 0 ? '48V系统' : '24V系统';
        $dataArray['DIP-低压断路开关自动闭合功能'] = (($v[4] >> 6) & 0x1) == 0 ? '启用' : '不启用';
        
        $dataArray['KB5-均衡充电控制方式'] = (($v[5] >> 2) & 0x1) == 1 ? '手动' : '自动';
        $v = unpack('c*', substr($memData, 16 + 2 * 9, 1 * 1));
        $dataArray['环境温度'] = ($v[1] >= -10 && $v[1] <=90) ? $v[1].' ℃' : '传感器未安装';
        $v = unpack('C*', substr($memData, 17 + 2 * 9, 1 * 6));
        $dataArray['霍尔1告警'] = ($v[1] & 0x1) ==  0 ? '告警' : '正常';
        $dataArray['霍尔2告警'] = (($v[1] >> 1) & 0x1) ==  0 ? '告警' : '正常';
        $dataArray['霍尔3告警'] = (($v[1] >> 2) & 0x1) ==  0 ? '告警' : '正常';
        $dataArray['霍尔4告警'] = (($v[1] >> 3) & 0x1) ==  0 ? '告警' : '正常';
        $dataArray['AlertArray']['霍尔1告警'] = ($v[1] & 0x1) ==  0;
        $dataArray['AlertArray']['霍尔2告警'] = (($v[1] >> 1) & 0x1) ==  0;
        $dataArray['AlertArray']['霍尔3告警'] = (($v[1] >> 2) & 0x1) ==  0;
        $dataArray['AlertArray']['霍尔4告警'] = (($v[1] >> 3) & 0x1) ==  0;
        //Spare4个char  chksum1个char
        //ParamPacket
        $dataArray['监控模块'] = array();
        $v = unpack('s*', substr($memData, 23 + 2 * 9, 2 * 16));
        $dataArray['监控模块']['浮充电压'] = ($v[1] / 10).' V';
        $dataArray['监控模块']['电池充电限流'] = $v[2].' A';
        $dataArray['监控模块']['交流电流传感器满量程'] = $v[3].' A';
        $dataArray['监控模块']['系统输出电压过高告警'] = ($v[4] / 10).' V';
        $dataArray['监控模块']['系统输出电压过低告警'] = ($v[5] / 10).' V';
        $dataArray['监控模块']['电池温度高告警'] = $v[6].' ℃';
        $dataArray['监控模块']['均充周期'] = $v[7].' 星期';
        $dataArray['监控模块']['均充持续时间'] = $v[8].' H';
        $dataArray['监控模块']['手动均充持续时间'] = $v[9].' H';
        $dataArray['监控模块']['自动启动均充的电压阈值'] = ($v[10] / 10).' V';
        $dataArray['监控模块']['均衡电压'] = ($v[11] / 10).' V';
        $dataArray['监控模块']['低压断路开关自动断开的电压阈值'] = ($v[12] / 10).' V';
        $dataArray['监控模块']['电池温度补偿系数'] = $v[13].' 0.1mV/℃/每节电池';
        $dataArray['监控模块']['负载电流传感器满量程'] = $v[14].' A';
        $dataArray['监控模块']['电池电流传感器满量程'] = $v[15].' A';
        $dataArray['监控模块']['整流模块个数'] = $v[16];
        $v = unpack('C*', substr($memData, 23 + 2 * 25, 1 * 60));
        //回报电话号码1 2 3  各20个
        $v = unpack('C*', substr($memData, 83 + 2 * 25, 1 * 12));
        $dataArray['监控模块']['Modem启用'] = $v[1] == 1 ? '启用' : '不启用';
        $dataArray['监控模块']['故障回报启用'] = $v[2] == 1 ? '启用' : '不启用';
        $dataArray['监控模块']['定时回报启用'] = $v[3] == 1 ? '启用' : '不启用';
        $dataArray['监控模块']['定时回报时间'] = $v[5].' 时 '.$v[4].' 分';
        //$dataArray['监控模块']['监控模块的日期时间'] = $v[8]."-".$v[7]."-".$v[6]." ".$v[9].":".$v[10].":".$v[11];
        //12 chksum
        //SMRstatPacket  整流模块状态
        
        $v = unpack('C*', substr($memData, 95 + 2 * 25, 1 * 1));
        $NumSMRs = $v[1];
        $offset = 146;
        $dataArray['整流模块数量'] = $NumSMRs;
        for($i = 1 ; $i <= $NumSMRs ; $i++){
            $dataArray['整流模块'.$i] = array();
            $v = unpack('C*', substr($memData, $offset , 1 * 4));
            $dataArray['整流模块'.$i]['输出电压过高'] = ($v[1] & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$i]['输出电压过低'] = (($v[1] >> 1) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$i]['模块地址为0'] = (($v[1] >> 2) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$i]['输入开关未闭合'] = (($v[1] >> 3) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$i]['内部高压直流回路故障'] = (($v[1] >> 4) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$i]['电压回路控制放大器告警'] = (($v[1] >> 5) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$i]['内部温度高'] = (($v[1] >> 6) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$i]['内部控制回路调节电压故障'] = (($v[1] >> 7) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$i]['AlertArray']['输出电压过高'] = ($v[1] & 0x1) == 1;
            $dataArray['整流模块'.$i]['AlertArray']['输出电压过低'] = (($v[1] >> 1) & 0x1) == 1;
            $dataArray['整流模块'.$i]['AlertArray']['模块地址为0'] = (($v[1] >> 2) & 0x1) == 1;
            $dataArray['整流模块'.$i]['AlertArray']['输入开关未闭合'] = (($v[1] >> 3) & 0x1) == 1;
            $dataArray['整流模块'.$i]['AlertArray']['内部高压直流回路故障'] = (($v[1] >> 4) & 0x1) == 1;
            $dataArray['整流模块'.$i]['AlertArray']['电压回路控制放大器告警'] = (($v[1] >> 5) & 0x1) == 1;
            $dataArray['整流模块'.$i]['AlertArray']['内部温度高'] = (($v[1] >> 6) & 0x1) == 1;
            $dataArray['整流模块'.$i]['AlertArray']['内部控制回路调节电压故障'] = (($v[1] >> 7) & 0x1) == 1;
            
            $dataArray['整流模块'.$i]['输出限流'] = ($v[2] & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$i]['风扇故障'] = (($v[2] >> 1) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$i]['输出欠流'] = (($v[2] >> 2) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$i]['输入开关跳闸'] = (($v[2] >> 3) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$i]['手动关机'] = (($v[2] >> 4) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$i]['遥控关机'] = (($v[2] >> 5) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$i]['参考电压超出范围'] = (($v[2] >> 6) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$i]['通信故障'] = (($v[2] >> 7) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$i]['AlertArray']['输出限流'] = ($v[2] & 0x1) == 1;
            $dataArray['整流模块'.$i]['AlertArray']['风扇故障'] = (($v[2] >> 1) & 0x1) == 1;
            $dataArray['整流模块'.$i]['AlertArray']['输出欠流'] = (($v[2] >> 2) & 0x1) == 1;
            $dataArray['整流模块'.$i]['AlertArray']['输入开关跳闸'] = (($v[2] >> 3) & 0x1) == 1;
            $dataArray['整流模块'.$i]['AlertArray']['手动关机'] = (($v[2] >> 4) & 0x1) == 1;
            $dataArray['整流模块'.$i]['AlertArray']['遥控关机'] = (($v[2] >> 5) & 0x1) == 1;
            $dataArray['整流模块'.$i]['AlertArray']['参考电压超出范围'] = (($v[2] >> 6) & 0x1) == 1;
            $dataArray['整流模块'.$i]['AlertArray']['通信故障'] = (($v[2] >> 7) & 0x1) == 1;
            
            $dataArray['整流模块'.$i]['高压关机'] = ($v[3] & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$i]['交流故障'] = (($v[3] >> 1) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$i]['功率限制'] = (($v[3] >> 2) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$i]['均衡充电'] = (($v[3] >> 5) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$i]['故障并关机'] = (($v[3] >> 6) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$i]['告警未关机'] = (($v[3] >> 7) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$i]['AlertArray']['高压关机'] = ($v[3] & 0x1) == 1;
            $dataArray['整流模块'.$i]['AlertArray']['交流故障'] = (($v[3] >> 1) & 0x1) == 1;
            $dataArray['整流模块'.$i]['AlertArray']['功率限制'] = (($v[3] >> 2) & 0x1) == 1;
            $dataArray['整流模块'.$i]['AlertArray']['均衡充电'] = (($v[3] >> 5) & 0x1) == 1;
            $dataArray['整流模块'.$i]['AlertArray']['故障并关机'] = (($v[3] >> 6) & 0x1) == 1;
            $dataArray['整流模块'.$i]['AlertArray']['告警未关机'] = (($v[3] >> 7) & 0x1) == 1;
            
            $dataArray['整流模块'.$i]['输出电流'] = $v[4].' A';
            $offset += 4;
        }
        $v = unpack('C*', substr($memData, 96 + 2 * 25 + 110 * 4, 1 * 1));//存的是定长110
        // chksum
        $v = unpack('v', substr($memData, 97 + 2 * 25 + 110 * 4, 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData, 99 + 2 * 25 + 110 * 4, 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
        //SMRparamPacket  整流模块参数
        $v = unpack('I*', substr($memData, 104 + 2 * 25 + 110 * 4, 4 * 1));
        $SMRCount = $v[1];
        $offset = 598;
        for($i = 1 ; $i <= $SMRCount ; $i++){
            $v = unpack('S*', substr($memData , $offset , 2 * 5));
            $dataArray['整流模块'.$i]['浮充电压'] = ($v[1] / 100).' V';
            $dataArray['整流模块'.$i]['均衡电压'] = ($v[2] / 100).' V';
            $dataArray['整流模块'.$i]['电压高告警'] = ($v[3] / 100).' V';
            $dataArray['整流模块'.$i]['电压低告警'] = ($v[4] / 100).' V';
            $dataArray['整流模块'.$i]['高压关机阈值电压'] = ($v[5] / 100).' V';
            $v = unpack('C*', substr($memData, $offset + 10 , 1 * 4));
            $dataArray['整流模块'.$i]['限流值'] = $v[1].' A';
            $dataArray['整流模块'.$i]['均流调节值'] = $v[2];
            $dataArray['整流模块'.$i]['保密功能开启'] = $v[3] == 1 ? '启用' : '不启用';
            //chksum
            $offset += 14;
        }     
        
    }
}
