<?php

function Get_dk04c_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '直流负载电流':
            return array(0, $dataArray['负载电流']);
        case '整流模块数量':
            return array(0, $dataArray['整流模块数量']);
        default:
            break;
    }
    return array(1 , '设备无此信号数据:'. $varname);
}  

function Get_dk04c_RtData($memData , &$dataArray , $extraPara = false)
{
    if (empty($memData)) {
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    }else{
        $dataArray['无数据'] = false;
        $dataArray['AlertArray'] = array();
        //DK04C_StatusPacket
        $v = unpack('S*', substr($memData, 0, 3 * 2));
        //$v[1] 数据包类型
        $dataArray['系统电压'] = ($v[2] / 10).' V';
        $dataArray['负载电流'] = $v[3].' A';
        $v = unpack('s*', substr($memData, 6 , 2 * 2));
        $dataArray['电池组1电流'] = $v[4].' A';
        $dataArray['电池组2电流'] = $v[5].' A';
        $v = unpack("C*", substr($memData, 10, 4 * 1));
        $dataArray['EEPROM内的参数超出范围'] = ($v[1] & 0x1) == 1 ? '告警' : '正常';
        $dataArray['整流模块非紧急告警'] = (($v[1] >> 1) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['整流模块紧急告警'] = (($v[1] >> 2) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['熔丝故障'] = (($v[1] >> 3) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['低压断路(LVDS)开关断开'] = (($v[1] >> 4) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['输出电压过高告警'] = (($v[1] >> 5) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['输出电压过低告警'] = (($v[1] >> 6) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['电池处于放电状态'] = (($v[1] >> 7) & 0x1) == 1 ? '是' : '否';
        $dataArray['AlertArray']['EEPROM内的参数超出范围'] = ($v[1] & 0x1) == 1;
        $dataArray['AlertArray']['整流模块非紧急告警'] = (($v[1] >> 1) & 0x1) == 1;
        $dataArray['AlertArray']['整流模块紧急告警'] = (($v[1] >> 2) & 0x1) == 1;
        $dataArray['AlertArray']['熔丝故障'] = (($v[1] >> 3) & 0x1) == 1;
        $dataArray['AlertArray']['低压断路(LVDS)开关断开'] = (($v[1] >> 4) & 0x1) == 1;
        $dataArray['AlertArray']['输出电压过高告警'] = (($v[1] >> 5) & 0x1) == 1;
        $dataArray['AlertArray']['输出电压过低告警'] = (($v[1] >> 6) & 0x1) == 1;
        //$dataArray['AlertArray']['电池处于放电状态'] = (($v[1] >> 7) & 0x1) == 1;
        
        $dataArray['整流模块通信故障'] = ($v[2] & 0x1) == 1 ? '告警' : '正常';
        $dataArray['交流输入电压告警'] = (($v[2] >> 1) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['交流输入频率告警'] = (($v[2] >> 2) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['环境温度过高告警'] = (($v[2] >> 3) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['电池温度过高告警'] = (($v[2] >> 4) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['电池充电限流'] = (($v[2] >> 5) & 0x1) == 1 ? '限流' : '不限流';
        $dataArray['电池组放电不平衡(Ibat1<Ibat2)'] = (($v[2] >> 6) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['电池组放电不平衡(Ibat1>Ibat2)'] = (($v[2] >> 7) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['整流模块通信故障'] = ($v[2] & 0x1) == 1;
        $dataArray['AlertArray']['交流输入电压告警'] = (($v[2] >> 1) & 0x1) == 1;
        $dataArray['AlertArray']['交流输入频率告警'] = (($v[2] >> 2) & 0x1) == 1;
        $dataArray['AlertArray']['环境温度过高告警'] = (($v[2] >> 3) & 0x1) == 1;
        $dataArray['AlertArray']['电池温度过高告警'] = (($v[2] >> 4) & 0x1) == 1;
        //$dataArray['AlertArray']['电池充电限流'] = (($v[2] >> 5) & 0x1) == 1;
        $dataArray['AlertArray']['电池组放电不平衡(Ibat1<Ibat2)'] = (($v[2] >> 6) & 0x1) == 1;
        $dataArray['AlertArray']['电池组放电不平衡(Ibat1>Ibat2)'] = (($v[2] >> 7) & 0x1) == 1;
        
        $dataArray['均衡充电状态'] = ($v[3] & 0x1) == 1 ? '是' : '否';
        $dataArray['整流模块输出电压过高关机'] = (($v[3] >> 3) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['电池开关断开'] = (($v[3] >> 4) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['电池温度传感器故障'] = (($v[3] >> 5) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['整流模块故障'] = (($v[3] >> 6) & 0x1) == 1 ? '告警' : '正常';
        //$dataArray['AlertArray']['均衡充电状态'] = ($v[3] & 0x1) == 1;
        $dataArray['AlertArray']['整流模块输出电压过高关机'] = (($v[3] >> 3) & 0x1) == 1;
        $dataArray['AlertArray']['电池开关断开'] = (($v[3] >> 4) & 0x1) == 1;
        $dataArray['AlertArray']['电池温度传感器故障'] = (($v[3] >> 5) & 0x1) == 1;
        $dataArray['AlertArray']['整流模块故障'] = (($v[3] >> 6) & 0x1) == 1;
        
        $dataArray['整流模块参数超出范围'] = (($v[4] >> 4) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['整流模块参数超出范围'] = (($v[4] >> 4) & 0x1) == 1;
        
        $v = unpack('S*', substr($memData, 14, 2 * 2));
        $dataArray['电池温度'] = ($v[1] / 10).' ℃';
        $dataArray['环境温度'] = ($v[2] / 10).' ℃';
        $v = unpack('I*', substr($memData, 18, 4 * 2));
        $dataArray['电池组1当前容量'] = number_format($v[1] / 41199, 2).' ATH';//单位:AmpTickHour
        $dataArray['电池组2当前容量'] = number_format($v[2] / 41199, 2).' ATH';
        $v = unpack('S*', substr($memData, 26 , 2 * 10));
        $dataArray['单相交流输入电压'] = $v[1].' V';
        $dataArray['单相交流输入电流'] = $v[2].' A';
        $dataArray['单相交流输入频率'] = ($v[3] / 10).' Hz';
        $dataArray['三相交流输入电压1'] = $v[4].' V';
        $dataArray['三相交流输入电压2'] = $v[5].' V';
        $dataArray['三相交流输入电压3'] = $v[6].' V';
        $dataArray['三相交流输入电流1'] = $v[7].' A';
        $dataArray['三相交流输入电流2'] = $v[8].' A';
        $dataArray['三相交流输入电流3'] = $v[9].' A';
        $dataArray['三相交流输入频率'] = ($v[10] / 10).' Hz';
        //DK04C_ParamPacket
        $v = unpack('S*', substr($memData, 46, 2 * 19));
        //$v[1] 数据包类型
        $dataArray['单相交流输入电压过高告警点'] = $v[2].' V';
        $dataArray['单相交流输入电压过低告警点'] = $v[3].' V';
        $dataArray['单相交流输入频率过高告警点'] = ($v[4] / 10).' Hz';
        $dataArray['单相交流输入频率过低告警点'] = ($v[5] / 10).' Hz';
        $dataArray['单相交流输入电流检测满量程'] = ($v[6] * 10).' A';
        $dataArray['环境温度过高告警点'] = $v[7].' ℃';
        $dataArray['电池温度过高告警点'] = $v[8].' ℃';
        $dataArray['输出电压过高告警点'] = ($v[9] / 10).' V';
        $dataArray['输出电压过低告警点'] = ($v[10] / 10).' V';
        $dataArray['整流模块个数'] = $v[11];
        $dataArray['整流模块类型'] = $rcModuleType = $v[12] == 0 ? 'A型' : $v[12] == 1 ? 'B型' : '无效';
        $dataArray['电池电流传感器满量程'] = $v[13].' A';
        $dataArray['MODEM是否启用'] = $v[14] == 0 ? '不启用' : $v[14] == 1 ? '启用' : '无效';
        $dataArray['故障回报是否启用'] = $v[15] == 0 ? '不启用' : $v[15] == 1 ? '启用' : '无效';
        $dataArray['定时回报是否启用'] = $v[16] == 0 ? '不启用' : $v[16] == 1 ? '启用' : '无效';
        $dataArray['定时回报时间'] = $v[17].'时'.$v[18].'分';
        $dataArray['扩展口1功能是否启用'] = $v[19] == 0 ? '不启用' : $v[19] == 1 ? '单相交流检测' : '无效';
        $v = unpack('C*', substr($memData, 46 + 2 * 19, 20 * 3));
        //回报电话1 2 3
        $v = unpack('S*', substr($memData, 46 + 2 * 19 + 20 * 3, 2 * 20));
        $dataArray['电池标称容量'] = $v[1].' AH';
        $dataArray['电池充电温度补偿系数'] = $v[2] == 0 ? '不启用' : ($v[2] / 10).' mV/℃/cell';
        $dataArray['电池充电限流1'] = $v[3].' A';
        $dataArray['电池充电限流2'] = $v[4].' A';
        $dataArray['电池充电限流3'] = $v[5].' A';
        $dataArray['电池深放电电压点'] = ($v[6] / 10).' V';
        $dataArray['系统浮充电压'] = ($v[7] / 10).' V';
        $dataArray['系统均衡充电电压'] = ($v[8] / 10).' V';
        $dataArray['电压降值'] = ($v[9] / 10).' V';
        $dataArray['电池放电告警电压点'] = ($v[10] / 10).' V';
        $dataArray['依照电池放电终止电压启动均衡充电是否启用'] = $v[11] == 0 ? '不启用' : $v[11] == 1 ? '启用' : '无效';
        $dataArray['均衡充电阈值电压'] = ($v[12] / 10).' V';
        $dataArray['依照电池放电安时数启动均衡充电是否启用'] = $v[13] == 0 ? '不启用' : $v[13] == 1 ? '启用' : '无效';
        $dataArray['均衡充电阈值安时数'] = $v[14].' AH';
        $dataArray['均衡充电终止电流'] = $v[15] == 0 ? '不启用' : $v[15].' A';
        $dataArray['均衡充电持续时间'] = $v[16].' H';
        $dataArray['均衡充电周期'] = $v[17].' 星期';
        $dataArray['两组电池放电不平衡告警点'] = $v[18].' A';
        $dataArray['低压断路开关断开电压点'] = ($v[19] / 10).' V';
        switch ($v[20]){
            case 0 : $dataArray['低压断路开关工作方式'] = '断开'; break;
            case 1 : $dataArray['低压断路开关工作方式'] = '合上'; break;
            case 2 : $dataArray['低压断路开关工作方式'] = '自动'; break;
            default : $dataArray['低压断路开关工作方式'] = '无效';
        }
        $v = unpack("C*", substr($memData, 46 + 2 * 19 + 20 * 3 + 2 * 20, 8));//Day,Month,Year,Cent,Hour,Min,Sec;
        //$dk04Obj->CSUTime = $v[3] . "-" . $v[2] . "-" . $v[1] . " " . $v[5] . ":" . $v[6] . ":" . $v[7];
        //$v[8] reserve
        $v = unpack("S*", substr($memData, 46 + 2 * 19 + 20 * 3 + 2 * 20 + 8, 10));
        $dataArray['三相交流输入电压过高告警点'] = $v[1].' V';
        $dataArray['三相交流输入电压过低告警点'] = $v[2].' V';
        $dataArray['三相交流输入频率过高告警点'] = ($v[3] / 10).' Hz';
        $dataArray['三相交流输入频率过低告警点'] = ($v[4] / 10).' Hz';
        $dataArray['三相交流电流检测满量程'] = $v[5].' A';
        $v = unpack("C*", substr($memData, 46 + 2 * 19 + 20 * 3 + 2 * 20 + 18, 8));
        $dataArray['扩展口2功能是否启用'] = $v[1] == 0 ? '不启用' : $v[1] == 1 ? '三相交流检测' : '无效';
        $dataArray['电池温度传感器失效告警是否启用'] = $v[2] == 0 ? '不启用' : $v[2] == 1 ? '启用' : '无效';
        //$v[3]-$v[8] reserve 

        //46 + 164 DK04C_SMRstatPacket   整流模块状态数据
        $v = unpack('S*', substr($memData, 46 + 164, 4));
        //$v[1] 数据包类型
        $Num_SMRs = $v[2];
        $offset = 214;
        $dataArray['整流模块数量'] = $Num_SMRs;
        for($i = 0 ; $i < $Num_SMRs ; $i++){
            $j = $i+1;
            $dataArray['整流模块'.$j] = array();
            $dataArray['整流模块'.$j]['AlertArray'] = array();
            $v = unpack('C*' , substr($memData , $offset, 6));
            $dataArray['整流模块'.$j]['输出电压过高告警'] = ($v[1] & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$j]['输出电压过低告警'] = (($v[1] >> 1) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$j]['整流模块地址错误'] = (($v[1] >> 2) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$j]['整流模块输入开关断开'] = (($v[1] >> 3) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$j]['整流模块内部直流部分故障'] = (($v[1] >> 4) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$j]['内部控制回路电压低'] = (($v[1] >> 5) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$j]['整流模块温度过高'] = (($v[1] >> 6) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$j]['内部控制回路故障'] = (($v[1] >> 7) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$j]['AlertArray']['输出电压过高告警'] = ($v[1] & 0x1) == 1;
            $dataArray['整流模块'.$j]['AlertArray']['输出电压过低告警'] = (($v[1] >> 1) & 0x1) == 1;
            $dataArray['整流模块'.$j]['AlertArray']['整流模块地址错误'] = (($v[1] >> 2) & 0x1) == 1;
            $dataArray['整流模块'.$j]['AlertArray']['整流模块输入开关断开'] = (($v[1] >> 3) & 0x1) == 1;
            $dataArray['整流模块'.$j]['AlertArray']['整流模块内部直流部分故障'] = (($v[1] >> 4) & 0x1) == 1;
            $dataArray['整流模块'.$j]['AlertArray']['内部控制回路电压低'] = (($v[1] >> 5) & 0x1) == 1;
            $dataArray['整流模块'.$j]['AlertArray']['整流模块温度过高'] = (($v[1] >> 6) & 0x1) == 1;
            $dataArray['整流模块'.$j]['AlertArray']['内部控制回路故障'] = (($v[1] >> 7) & 0x1) == 1;
            
            $dataArray['整流模块'.$j]['整流模块输出限流状态'] = ($v[2] & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$j]['风扇故障'] = (($v[2] >> 1) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$j]['负载过轻'] = (($v[2] >> 2) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$j]['输入开关跳开'] = (($v[2] >> 3) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$j]['整流模块关机'] = (($v[2] >> 4) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$j]['整流模块接收MCSU指令而关机'] = (($v[2] >> 5) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$j]['整流模块内部参考电压超出范围'] = (($v[2] >> 6) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$j]['整流模块通信故障'] = (($v[2] >> 7) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$j]['AlertArray']['整流模块输出限流状态'] = ($v[2] & 0x1) == 1;
            $dataArray['整流模块'.$j]['AlertArray']['风扇故障'] = (($v[2] >> 1) & 0x1) == 1;
            $dataArray['整流模块'.$j]['AlertArray']['负载过轻'] = (($v[2] >> 2) & 0x1) == 1;
            $dataArray['整流模块'.$j]['AlertArray']['输入开关跳开'] = (($v[2] >> 3) & 0x1) == 1;
            $dataArray['整流模块'.$j]['AlertArray']['整流模块关机'] = (($v[2] >> 4) & 0x1) == 1;
            $dataArray['整流模块'.$j]['AlertArray']['整流模块接收MCSU指令而关机'] = (($v[2] >> 5) & 0x1) == 1;
            $dataArray['整流模块'.$j]['AlertArray']['整流模块内部参考电压超出范围'] = (($v[2] >> 6) & 0x1) == 1;
            $dataArray['整流模块'.$j]['AlertArray']['整流模块通信故障'] = (($v[2] >> 7) & 0x1) == 1;
            
            $dataArray['整流模块'.$j]['整流模块输出电压过高关机'] = ($v[3] & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$j]['交流输入故障'] = (($v[3] >> 1) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$j]['整流模块输出功率限制'] = (($v[3] >> 2) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$j]['继电器故障'] = (($v[3] >> 3) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$j]['整流模块故障关机'] = (($v[3] >> 4) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$j]['整流模块处于均衡工作状态'] = (($v[3] >> 5) & 0x1) == 1 ? '是' : '否';
            $dataArray['整流模块'.$j]['整流模块告警'] = (($v[3] >> 6) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$j]['整流模块警告'] = (($v[3] >> 7) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流模块'.$j]['AlertArray']['整流模块输出电压过高关机'] = ($v[3] & 0x1) == 1;
            $dataArray['整流模块'.$j]['AlertArray']['交流输入故障'] = (($v[3] >> 1) & 0x1) == 1;
            $dataArray['整流模块'.$j]['AlertArray']['整流模块输出功率限制'] = (($v[3] >> 2) & 0x1) == 1;
            $dataArray['整流模块'.$j]['AlertArray']['继电器故障'] = (($v[3] >> 3) & 0x1) == 1;
            $dataArray['整流模块'.$j]['AlertArray']['整流模块故障关机'] = (($v[3] >> 4) & 0x1) == 1;
            $dataArray['整流模块'.$j]['AlertArray']['整流模块告警'] = (($v[3] >> 6) & 0x1) == 1;
            $dataArray['整流模块'.$j]['AlertArray']['整流模块警告'] = (($v[3] >> 7) & 0x1) == 1;
            
            $dataArray['整流模块'.$j]['整流模块输出电流'] = $v[4].' A';
            if($rcModuleType == 'A型'){
                $dataArray['整流模块'.$j]['散热器温度'] = $v[5].' ℃';
                $dataArray['整流模块'.$j]['温度传感器故障'] = ($v[6] & 0x1) == 1 ? '告警' : '正常';
                $dataArray['整流模块'.$j]['内部直流-直流变换部分故障'] = (($v[6] >> 1) & 0x1) == 1 ? '告警' : '正常';
                $dataArray['整流模块'.$j]['AlertArray']['温度传感器故障'] = ($v[6] & 0x1) == 1;
                $dataArray['整流模块'.$j]['AlertArray']['内部直流-直流变换部分故障'] = (($v[6] >> 1) & 0x1) == 1;
                $v = unpack('S*' , substr($memData , $offset + 6, 2));
                $dataArray['整流模块'.$j]['整流模块电压'] = ($v[1] / 100).' V';
            }
            $offset += 8;
        }
        $offset = 214 + 110*8;//整流模块状态数据  定长   110个模块
        if($rcModuleType == 'A型'){
            for($i = 0 ; $i < $Num_SMRs ; $i++){
                $j = $i + 1;
                $v = unpack("S*", substr($memData, $offset , 14));
                //$dataArray['整流模块'.$j]['数据包类型'] = $v[1];
                $dataArray['整流模块'.$j]['整流模块号码'] = $v[2];
                $dataArray['整流模块'.$j]['浮充电压'] = ($v[3] / 100).' V';
                $dataArray['整流模块'.$j]['均衡工作电压'] = ($v[4] / 100).' V';
                //$v[5] $v[6]
                $dataArray['整流模块'.$j]['高压关机阈值'] = ($v[7] / 100).' V';
                $v = unpack("C*", substr($memData, $offset , 3));
                $dataArray['整流模块'.$j]['整流模块输出限流'] = $v[1].' A';
                $dataArray['整流模块'.$j]['均流调节值'] = $v[2];
                $dataArray['整流模块'.$j]['密码是否启用'] = $v[3] == 0 ? '不启用' : $v[3] == 1 ? '启用' : '无效';
                $offset += 17;
            }
        }else{
            for($i = 0 ; $i < $Num_SMRs ; $i++){
                $j = $i + 1;
                $v = unpack("S*", substr($memData, $offset , 14));
                //$dataArray['整流模块'.$j]['数据包类型'] = $v[1];
                $dataArray['整流模块'.$j]['整流模块号码'] = $v[2];
                $dataArray['整流模块'.$j]['浮充电压'] = ($v[3] / 100).' V';
                $dataArray['整流模块'.$j]['均衡工作电压'] = ($v[4] / 100).' V';
                //$v[5] $v[6]
                $dataArray['整流模块'.$j]['高压关机阈值'] = ($v[7] / 100).' V';
                $v = unpack("C*", substr($memData, $offset , 3));
                $dataArray['整流模块'.$j]['整流模块输出限流'] = $v[1].' A';
                $dataArray['整流模块'.$j]['均流调节值'] = $v[2];
                $dataArray['整流模块'.$j]['密码是否启用'] = $v[3] == 0 ? '不启用' : $v[3] == 1 ? '启用' : '无效';
                $v = unpack("C*", substr($memData, 17, 6));
                //$dataArray['整流模块'.$j]['软件版本'] = $v[1].$v[2].$v[3].$v[4].$v[5].$v[6];
                $offset += 23;
            }
        }
        $CI = &get_instance();
        $dateData = $CI->cache->get($dataArray['数据ID'].":time");
        $dataArray['更新时间'] = date("Y-m-d H:i:s", intval($dateData));
    }
}
