<?php
function Get_dk09_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '直流负载电流':
            return array(0,  $dataArray['直流配电']['负载']);
        case '整流模块数量':
            return array(0, $dataArray['系统整流器个数']);
        default:
            break;
    }
    return array(1 , '设备无此信号数据:'. $varname);
}       


function Get_dk09_RtData($memData , &$dataArray , $extraPara = false)
{
    if (empty($memData)) {
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    } else {
        $dataArray['无数据'] = false;
        $dataArray['AlertArray'] = array();
        //交流配电数据
        $v = unpack('I*', substr($memData, 4, 1 * 4));
        $dataArray['交流配电'] = array();
        $dataArray['交流配电']['交流输入路数'] = $v[1];
        $v = unpack('f*', substr($memData, 8, 3 * 4));
        $dataArray['交流配电']['主供交流电源相电压A'] = number_format($v[1] , 2).' V';
        $dataArray['交流配电']['主供交流电源相电压B'] = number_format($v[2] , 2).' V';
        $dataArray['交流配电']['主供交流电源相电压C'] = number_format($v[3] , 2).' V';
        $v = unpack('I*', substr($memData, 20, 1 * 4));
        $dataArray['交流配电']['主供交流输入频率'] = $v[1].' Hz';
        $v = unpack('f*', substr($memData, 24, 6 * 4));
        $dataArray['交流配电']['三相交流输入电流A'] = number_format($v[1], 2).' A';
        $dataArray['交流配电']['三相交流输入电流B'] = number_format($v[2], 2).' A';
        $dataArray['交流配电']['三相交流输入电流C'] = number_format($v[3], 2).' A';
        $dataArray['交流配电']['备用交流电源相电压A'] = number_format($v[4], 2).' V';
        $dataArray['交流配电']['备用交流电源相电压B'] = number_format($v[5], 2).' V';
        $dataArray['交流配电']['备用交流电源相电压C'] = number_format($v[6], 2).' V';
        $v = unpack('f*', substr($memData, 48, 1 * 4));
        $dataArray['交流配电']['备用交流输入频率'] = number_format($v[1], 2).' Hz';

        //整流配电数据
        $v = unpack('s*', substr($memData, 52, 2));
        $dataArray['系统整流器个数'] = $rc_module = $v[1];
        $offset = 54;
        for($i = 0 ; $i < $rc_module ; $i++){
            $j = $i + 1;
            $dataArray['整流配电模块'.$j] = array();
            $dataArray['整流配电模块'.$j]['AlertArray'] = array();
            $v = unpack('I*', substr($memData , $offset, 4));
            $dataArray['整流配电模块'.$j]['模块内DC/DC故障'] = ($v[1] & 0x1) == 0 ? '告警' : '正常';
            $dataArray['整流配电模块'.$j]['模块交流输入故障'] = ($v[1] & 0x4) == 0 ? '告警' : '正常';
            $dataArray['整流配电模块'.$j]['模块内风扇故障'] = ($v[1] & 0x10) > 0 ? '告警' : '正常';
            $dataArray['整流配电模块'.$j]['模块内温度高'] = ($v[1] & 0x40) > 0 ? '告警' : '正常';
            $dataArray['整流配电模块'.$j]['模块输出限流'] = ($v[1] & 0x80) > 0 ? '告警' : '正常';
            $dataArray['整流配电模块'.$j]['模块输出电压低'] = ($v[1] & 0x100) > 0 ? '告警' : '正常';
            $dataArray['整流配电模块'.$j]['AlertArray']['模块内DC/DC故障'] = ($v[1] & 0x1) == 0;
            $dataArray['整流配电模块'.$j]['AlertArray']['模块交流输入故障'] = ($v[1] & 0x4) == 0;
            $dataArray['整流配电模块'.$j]['AlertArray']['模块内风扇故障'] = ($v[1] & 0x10) > 0;
            $dataArray['整流配电模块'.$j]['AlertArray']['模块内温度高'] = ($v[1] & 0x40) > 0;
            $dataArray['整流配电模块'.$j]['AlertArray']['模块输出限流'] = ($v[1] & 0x80) > 0;
            $dataArray['整流配电模块'.$j]['AlertArray']['模块输出电压低'] = ($v[1] & 0x100) > 0;
            $v = unpack('f*', substr($memData, $offset + 4, 2 * 4));
            $dataArray['整流配电模块'.$j]['模块输出电压'] = number_format($v[1] , 2).' V';
            $dataArray['整流配电模块'.$j]['模块输出电流'] = number_format($v[2] , 2).' A';
            $v = unpack('I*', substr($memData, $offset + 12, 1 * 4));
            $dataArray['整流配电模块'.$j]['内部温度'] = $v[1].' ℃';
            $offset += 16;
        }//整流模块定长  12个模块   
        $offset = 54 + 12 * 16;
        
        //直流配电数据
        $dataArray['直流配电'] = array();
        $v = unpack('I*', substr($memData, $offset , 1 * 4));
        $dataArray['直流配电']['电池组数'] = $v[1];//电池组数
        $v = unpack('f*', substr($memData, $offset + 4 , 3 * 4));
        $dataArray['直流配电']['电池1电压'] = number_format($v[1], 2).' V';//电池1电压	0.01
        $dataArray['直流配电']['电池1电流'] = number_format($v[2], 1).' A';//电池1电流	0.1
        $dataArray['直流配电']['电池1容量'] = number_format($v[3], 1);//电池1容量
        $v = unpack('I*', substr($memData, $offset + 16 , 1 * 4));
        $dataArray['直流配电']['电池1温度'] = $v[1].' ℃';//电池1温度
        $v = unpack('f*', substr($memData, $offset + 20 , 1 * 4));
        $dataArray['直流配电']['系统电压'] = number_format($v[1], 2).' V';//系统电压2
        $v = unpack('f*', substr($memData, $offset + 24 , 1 * 4));
        $dataArray['直流配电']['环境温度'] = number_format($v[1], 2).' ℃';//环境温度2
        $v = unpack('f*', substr($memData, $offset + 28 , 4 * 4));
        $dataArray['直流配电']['负载'] = number_format($v[1] , 1);//负载
        $dataArray['直流配电']['电池2电压'] = number_format($v[2], 2).' V';//电池2电压	0.01
        $dataArray['直流配电']['电池2电流'] = number_format($v[3], 1).' A';//电池2电流	0.1
        $dataArray['直流配电']['电池2容量'] = number_format($v[4], 1);//电池2容量
        $v = unpack('I*', substr($memData, $offset + 44 , 1 * 4));
        $dataArray['直流配电']['电池2温度'] = $v[1].' ℃';//电池2温度
        
        //系统状态
        $v = unpack('s*', substr($memData, $offset + 48 , 2 * 3));
        $dataArray['交流接触器状态'] = ($v[1] & 0x1) == 1 ? '断开' : '闭合';
        $dataArray['交流供电电源'] = (($v[1] >> 1) & 0x1) == 1 ? '市电2供电' : '市电1供电';
        $dataArray['停电状态'] = (($v[1] >> 2) & 0x1) == 1 ? '停电' : '未停电';
        $dataArray['充电状态'] = (($v[1] >> 3) & 0x1) == 1 ? '充电' : '未充电';
        $dataArray['放电状态'] = (($v[1] >> 4) & 0x1) == 1 ? '放电' : '未放电';
        //系统严重告警
        $dataArray['通信故障'] = ($v[2] & 0x1) == 1 ? '告警' : '正常';
        $dataArray['交流断路器断开'] = (($v[2] >> 1) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['电池熔断器故障'] = (($v[2] >> 2) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['负载熔断器故障'] = (($v[2] >> 3) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['负载下电开关状态'] = (($v[2] >> 4) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['电池下电开关状态'] = (($v[2] >> 5) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['SMR输出限流'] = (($v[2] >> 6) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['SMR高压关机'] = (($v[2] >> 7) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['SMR损坏'] = (($v[2] >> 8) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['电池容量低'] = (($v[2] >> 9) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['电池温度高'] = (($v[2] >> 10) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['系统电压高'] = (($v[2] >> 11) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['交流电压告警'] = (($v[2] >> 12) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['电池电压低于系统电压'] = (($v[2] >> 13) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['数据存储错误'] = (($v[2] >> 14) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['通信故障'] = ($v[2] & 0x1) == 1;
        $dataArray['AlertArray']['交流断路器断开'] = (($v[2] >> 1) & 0x1) == 1;
        $dataArray['AlertArray']['电池熔断器故障'] = (($v[2] >> 2) & 0x1) == 1;
        $dataArray['AlertArray']['负载熔断器故障'] = (($v[2] >> 3) & 0x1) == 1;
        $dataArray['AlertArray']['负载下电开关状态'] = (($v[2] >> 4) & 0x1) == 1;
        $dataArray['AlertArray']['电池下电开关状态'] = (($v[2] >> 5) & 0x1) == 1;
        $dataArray['AlertArray']['SMR输出限流'] = (($v[2] >> 6) & 0x1) == 1;
        $dataArray['AlertArray']['SMR高压关机'] = (($v[2] >> 7) & 0x1) == 1;
        $dataArray['AlertArray']['SMR损坏'] = (($v[2] >> 8) & 0x1) == 1;
        $dataArray['AlertArray']['电池容量低'] = (($v[2] >> 9) & 0x1) == 1;
        $dataArray['AlertArray']['电池温度高'] = (($v[2] >> 10) & 0x1) == 1;
        $dataArray['AlertArray']['系统电压高'] = (($v[2] >> 11) & 0x1) == 1;
        $dataArray['AlertArray']['交流电压告警'] = (($v[2] >> 12) & 0x1) == 1;
        $dataArray['AlertArray']['电池电压低于系统电压'] = (($v[2] >> 13) & 0x1) == 1;
        $dataArray['AlertArray']['数据存储错误'] = (($v[2] >> 14) & 0x1) == 1;
        //系统次要告警
        $dataArray['交流负载断开状态'] = ($v[3] & 0x1) == 1 ? '告警' : '正常';
        $dataArray['防雷器断开'] = (($v[3] >> 1) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['交流频率超限'] = (($v[3] >> 2) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['电池放电不平衡'] = (($v[3] >> 3) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['电池电压低'] = (($v[3] >> 4) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['电池充电限流'] = (($v[3] >> 5) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['温度传感器损坏'] = (($v[3] >> 6) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['环境温度高'] = (($v[3] >> 7) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['SMR内DC/DC故障'] = (($v[3] >> 8) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['SMR交流输入故障'] = (($v[3] >> 9) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['SMR内风扇故障'] = (($v[3] >> 10) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['SMR内温度高'] = (($v[3] >> 11) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['SMR输出电压低'] = (($v[3] >> 12) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['交流负载断开状态'] = ($v[3] & 0x1) == 1;
        $dataArray['AlertArray']['防雷器断开'] = (($v[3] >> 1) & 0x1) == 1;
        $dataArray['AlertArray']['交流频率超限'] = (($v[3] >> 2) & 0x1) == 1;
        $dataArray['AlertArray']['电池放电不平衡'] = (($v[3] >> 3) & 0x1) == 1;
        $dataArray['AlertArray']['电池电压低'] = (($v[3] >> 4) & 0x1) == 1;
        $dataArray['AlertArray']['电池充电限流'] = (($v[3] >> 5) & 0x1) == 1;
        $dataArray['AlertArray']['温度传感器损坏'] = (($v[3] >> 6) & 0x1) == 1;
        $dataArray['AlertArray']['环境温度高'] = (($v[3] >> 7) & 0x1) == 1;
        $dataArray['AlertArray']['SMR内DC/DC故障'] = (($v[3] >> 8) & 0x1) == 1;
        $dataArray['AlertArray']['SMR交流输入故障'] = (($v[3] >> 9) & 0x1) == 1;
        $dataArray['AlertArray']['SMR内风扇故障'] = (($v[3] >> 10) & 0x1) == 1;
        $dataArray['AlertArray']['SMR内温度高'] = (($v[3] >> 11) & 0x1) == 1;
        $dataArray['AlertArray']['SMR输出电压低'] = (($v[3] >> 12) & 0x1) == 1;

        $v = unpack('v', substr($memData, $offset + 54 , 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData, $offset + 56 , 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}
