<?php

function _dkd46_GetPMBus41_44Msg($v)
{
    switch ($v) {
        case 0:
            return "正常";
        case 1:     
            return "故障";
    }                       
    return "未知告警" . dechex($v);
}      

function _dkd46_GetPMBusCheckMsg($value)
{
    switch ($value) {       
        case 0:
            return "正常";
        case 1:
            return "低于下限";
        case 2:
            return "高于上限";
        case 3:
            return "缺相";
        case 4:             
            return "熔丝断";
        case 5:
            return "开关断开";
        default:
            break;
    }

    return "无效";
}

function _dkd46_GetAlertM($value)
{       
    switch ($value) {
        case 0:
            return "正常";
        case 3:
            return "熔丝断"; 
        case 4:
            return "开";
        default:
            break;
    }       
            
    return "无效";
}         

function Get_dkd46_RtData($memData , &$dataArray , $extraPara = false)
{
    if (empty($memData)) {
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    } else {
        $dataArray['无数据'] = false;
        //parse rc
        {
            $p42_46_size = 0;
            $v = unpack('f', substr($memData, 4 + 7 * 4 + 1 + $p42_46_size, 4));
            $dataArray["整流模块输出电压"] = number_format($v[1], 2);
            $v = unpack('C', substr($memData, 4 + 7 * 4 + 1 + $p42_46_size + 4, 1));
            $dataArray["整流模块数量"] = $v[1];
            //$v = unpack('v', substr($memData, 4 + 7 * 4 + 1 + $p42_46_size + 4 + 1, 2));
            //$year = $v[1];
            //$v = unpack('C*', substr($memData, 4 + 7 * 4 + 1 + $p42_46_size + 4 + 1 + 2, 5));
            //$dataArray->update_datetime = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
            //解析模块
            $p41_41_number = 0;
            $p41_43_number = 1;
            $p41_44_number = 7;
            $rcLen = (4 * 9 + 0 + 2 + 7);
            $rcChannelLen = (1 + $p41_41_number) * 4 + 7 + $p41_43_number + $p41_44_number;
            $dataArray["整流模块"] = array();
            for ($i = 0; $i < $dataArray["整流模块数量"]; $i++) {
                $label = "整流模块".($i+1);
                $channelData = substr($memData, $rcLen + $rcChannelLen * $i, $rcChannelLen);
                $v = unpack('f', substr($channelData, 0, 4));
                $dataArray[$label."输出电流"] = number_format($v[1], 2);
                $v = unpack('C', substr($channelData, 4, 1));
                $dataArray[$label."41_41_count"] = $v[1];
                $v = unpack('C*', substr($channelData, 4 + 1 + 4 * $p41_41_number, 4));
                if ($v[1] == 0) {
                    $dataArray[$label.'开关机状态'] = "开机";
                } else if ($v[1] == 1) {
                    $dataArray[$label.'开关机状态'] = "关机";
                } else {
                    $dataArray[$label.'开关机状态'] = "未知";
                }
                
                if ($v[2] == 0) {
                    $dataArray[$label."限流/不限流状态"] = "限流";
                } else if ($v[2] == 1) {
                    $dataArray[$label."限流/不限流状态"] = "不限流";
                } else {
                    $dataArray[$label."限流/不限流状态"] = "未知";
                }
                if ($v[3] == 0) {
                    $dataArray[$label."浮充/均充/测试状态"] = "浮充";
                } else if ($v[3] == 1) {
                    $dataArray[$label."浮充/均充/测试状态"] = "均充";
                } else if ($v[3] == 2) {
                    $dataArray[$label."浮充/均充/测试状态"] = "测试";
                } else if ($v[3] == 2) {
                    $dataArray[$label."浮充/均充/测试状态"] = "交流停电";
                } else {
                    $dataArray[$label."浮充/均充/测试状态"] = "未知";
                }
                $dataArray[$label."p41_43_count"] = $v[4];

                $v = unpack('C*', substr($channelData, 4 + 1 + 4 * $p41_41_number + 4 + $p41_43_number, 2));
                $dataArray[$label."故障"] = _dkd46_GetPMBus41_44Msg($v[1]);
                $dataArray[$label."p41_44_count"] = $v[2];
            }
        }
        //parse ac
        {
            $acOffset = $rcLen + $rcChannelLen * $dataArray["整流模块数量"];
            $v = unpack("V", substr($memData, $acOffset, 4));
            $dataArray["交流屏data_id"] = $v[1];                  
            $v = unpack('f*', substr($memData, $acOffset + 4, 3 * 4));
            $dataArray["交流屏输出电流A"] = number_format($v[1], 2);
            if (abs($dataArray["交流屏输出电流A"] - (-0.1)) < 0.1) {
                $dataArray["交流屏输出电流A"] = "未监测";
            }            
            $dataArray["交流屏输出电流B"] = number_format($v[2], 2);
            if (abs($dataArray["交流屏输出电流B"] - (-0.1)) < 0.1) {
                $dataArray["交流屏输出电流B"] = "未监测";
            }                   
            $dataArray["交流屏输出电流C"] = number_format($v[3], 2);
            if (abs($dataArray["交流屏输出电流C"] - (-0.1)) < 0.1) {
                $dataArray["交流屏输出电流C"] = "未监测";
            }
            $v = unpack('C', substr($memData, $acOffset + 4 + 3 * 4, 1));
            $dataArray["交流通道数"] = $v[1];
            $v = unpack('C', substr($memData, $acOffset + 4 + 3 * 4 + 1, 1));
            $dataArray["交流空开数"] = $v[1];
            $airlock_number = 8;
            $p40_43_number = 0;
            /*$v = unpack('C*', substr($memData, 4 + 3 * 4 + 1 + 1, $airlock_number));
            $dataArray->airlock_status = array();
            foreach ($v as $k) {
                array_push($dataArray->airlock_status, Realtime::_GetAirLockMsg($k));
            }*/
            $v = unpack('C', substr($memData, $acOffset + 4 + 3 * 4 + 1 + 1 + $airlock_number, 1));
            $dataArray["p40_43_count"] = $v[1];
            /*if ($dataArray->p40_43_count != $p40_43_number) {
                $dataArray->isMatch = false;
            }*/
            /*$v = unpack('C*', substr($memData, 4 + 3 * 4 + 1 + 1 + $airlock_number + 1, $p40_43_number));
            $dataArray->p40_43 = array();
            $p40_43_index = -1;
            foreach (Constants::$pmBusConfig[$model]['p40_43_label'] as $key => $show) {
                $p40_43_index++;
                if ($show) {
                    $dataArray->p40_43[] = Realtime::_CheckAlertMap($v[$p40_43_index + 1], Constants::$pmBusConfig[$model]['p40_43_rules'][$p40_43_index]);
                }
            }*/

            $v = unpack('C*', substr($memData, $acOffset + 4 + 3 * 4 + 1 + 1 + $airlock_number + 1 + $p40_43_number, 3));
            $dataArray["A相输入电流告警状态"] = _dkd46_GetPMBusCheckMsg($v[1], '');
            $dataArray["B相输入电流告警状态"] = _dkd46_GetPMBusCheckMsg($v[2], '');
            $dataArray["C相输入电流告警状态"] = _dkd46_GetPMBusCheckMsg($v[3], '');

            $acLen = $acOffset + 4 + 3 * 4 + 1 + 1 + $airlock_number + 1 + $p40_43_number + 3 + 7;
            $acChannelLen = (16 + 6);
            for ($i = 0; $i < $dataArray["交流通道数"]; $i++) {
                $channelData = substr($memData, $acLen + $i * $acChannelLen, $acChannelLen);
                $v = unpack('f*', substr($channelData, 0, 4 * 4));
                $dataArray["交流输入".($i+1)."输入线/相电压AB/A"] = number_format($v[1], 2);
                $dataArray["交流输入".($i+1)."输入线/相电压BC/B"] = number_format($v[2], 2);
                $dataArray["交流输入".($i+1)."输入线/相电压CA/C"] = number_format($v[3], 2);
                $dataArray["交流输入".($i+1)."输入频率"] = number_format($v[4], 2);
                $v = unpack('C', substr($channelData, 4 * 4, 1));
                $dataArray["p40_41_count"] = $v[1];
                /*$v = unpack('f*', substr($channelData, 4 * 4 + 1, 4 * $p40_41_number));
                $channelObj->p40_41 = array();
                foreach ($v as $val) {
                    if (abs($val - (-0.1)) < 0.1) {
                        $channelObj->p40_41[] = "未监测";
                    } else {
                        $channelObj->p40_41[] = number_format($val, 2);
                    }
                }*/

                $v = unpack('C*', substr($channelData, 4 * 4 + 1 + 4 * $p40_41_number, 5));
                $dataArray["交流输入".($i+1)."输入线/相电压AB/A告警"] = _dkd46_GetPMBusCheckMsg($v[1], '');
                $dataArray["交流输入".($i+1)."输入线/相电压BC/B告警"] = _dkd46_GetPMBusCheckMsg($v[2], '');
                $dataArray["交流输入".($i+1)."输入线/相电压CA/C告警"] = _dkd46_GetPMBusCheckMsg($v[3], '');
                $dataArray["交流输入".($i+1)."频率告警"] = _dkd46_GetPMBusCheckMsg($v[4], '');
                $dataArray["p40_44_count"] = $v[5];
                //$v = unpack('C*', substr($channelData, 4 * 4 + 1 + 4 * $p40_41_number + 5, $p40_44_number));
            }
            
        }
        //parse dc
        {
            $dcOffset = $acLen + $dataArray["交流通道数"] * $acChannelLen;
            $m_number = 2;
            $n_number = 20;
            $p_number = 9;
            $alert_m_number = 42;
            $alert_p_number = 3;

            $v = unpack("V", substr($memData, $acOffset, 4));
            $dataArray["直流屏data_id"] = $v[1];                  
            $v = unpack('f*', substr($memData, $dcOffset + 4, 4 * 2));
            $dataArray["直流输出电压"] = number_format($v[1], 2) . "V";
            $dataArray["总负载电流"] = number_format($v[2], 2) . "A";
            $v = unpack('C', substr($memData, $dcOffset + 4 + 4 * 2, 1));
            $dataArray["蓄电池组数"] = $v[1];
            $v = unpack('f*', substr($memData, $dcOffset + 4 + 4 * 2 + 1, $m_number * 4));
            foreach ($v as $k=>$val) {
                $dataArray["电池".$k."电流"] = number_format($val, 2) . "A";
            }
            $v = unpack('C', substr($memData, $dcOffset + 4 + 4 * 2 + 1 + $m_number * 4, 1));
            $dataArray["监测直流分路电流数"] = $v[1];
            $v = unpack('f*', substr($memData, $dcOffset + 4 + 4 * 2 + 1 + $m_number * 4 + 1, $n_number * 4));
            foreach ($v as $k=>$val) {
                if (is_nan($val)) {
                    $dataArray["直流分路".$k."电流"] = 0.0;
                } else {
                    $dataArray["直流分路".$k."电流"] = $val;
                }
            }

            $v = unpack('C', substr($memData, $dcOffset + 4 + 4 * 2 + 1 + $m_number * 4 + 1 + $n_number * 4, 1));
            $dataArray["p_count"] = $v[1];
           
            $v = unpack('C*', substr($memData, $dcOffset + 4 + 4 * 2 + 1 + $m_number * 4 + 1 + $n_number * 4 + 1 + $p_number * 4, 2));
            $dataArray["直流电压告警"] = _dkd46_GetPMBusCheckMsg($v[1]);
            $dataArray["直流熔断丝数量"] = $v[2];
            $v = unpack('C*', substr($memData, $dcOffset + 4 + 4 * 2 + 1 + $m_number * 4 + 1 + $n_number * 4 + 1 + $p_number * 4 + 2, $alert_m_number));
            foreach ($v as $k=>$v) {
                $dataArray["负载熔丝/开关".$k] = _dkd46_GetAlertM($v);
            }
            $v = unpack('C', substr($memData, $dcOffset + 4 + 4 * 2 + 1 + $m_number * 4 + 1 + $n_number * 4 + 1 + $p_number * 4 + 2 + $alert_m_number, 1));
            $dataArray["alert_p_count"] = $v[1];

            $v = unpack('v', substr($memData, $dcOffset + 4 + 4 * 2 + 1 + $m_number * 4 + 1 + $n_number * 4 + 1 + $p_number * 4 + 2 + $alert_m_number + 1 + $alert_p_number, 2));
            $year = $v[1];
            $v = unpack('C*', substr($memData, $dcOffset + 4 + 4 * 2 + 1 + $m_number * 4 + 1 + $n_number * 4 + 1 + $p_number * 4 + 2 + $alert_m_number + 1 + $alert_p_number + 2, 5));
            $dataArray["更新时间"] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
        }
	//dc setting
	{
            $v = unpack('S*', substr($memData, $dcOffset + 4 + 4 * 2 + 1 + $m_number * 4 + 1 + $n_number * 4 + 1 + $p_number * 4 + 2 + $alert_m_number + 1 + $alert_p_number + 2 + 5, 2*2));
	    $dataArray["浮充电压设置"] = $v[1]/100;
	    $dataArray["均充电压设置"] = $v[2]/100;
	}
    }
}
