<?php

function Get_dkd46_419_UnicomCategory()
{
    return "419";
}

function Get_dkd46_419_config()
{
    $config = array("model"=>"dkd46", "ac" => array(
        "airlock" => 8, "p40_43" => 0, "p40_41" => 0, "p40_44" => 0,
        "p40_41_label" => array(),
        "p40_43_label" => array(),
        "p40_43_rules" => array(),
        "p40_44_label" => array(),
        "p40_44_rules" => array(),
        "ia_support" => true, "ib_support" => true, "ic_support" => true,
        "ia_alert_support" => true, "ib_alert_support" => true, "ic_alert_support" => true
    ),
    "rc" => array( 
        "p42_46" => 0, "p42_46_size" => 0, "p41_41" => 0, "p41_43" => 1, "p41_44" => 7,
        'p41_41_label' => array(),
        "p41_43_label" => array("整流模块未装" => true),
        "p41_43_rules" => array(
                0 => array(array(0x0 => "整流模块安装", 0x80 => "整流模块未装"), "无效"), 
        ),
        "p41_44_label" => array("DC过压" => true, "AC过压" => true, "风扇故障" => true, "整流器模块过温" => true, "DC过流" => true, "通信故障" => true, "AC欠压" => true),
        'p41_44_rules' => array(
                0 => array(array(0 => "正常", 0x1 => "故障"), "无效"),
                1 => array(array(0 => "正常", 0x1 => "故障"), "无效"),
                2 => array(array(0 => "正常", 0x1 => "故障"), "无效"),
                3 => array(array(0 => "正常", 0x1 => "故障"), "无效"),
                4 => array(array(0 => "正常", 0x1 => "故障"), "无效"),
                5 => array(array(0 => "正常", 0x1 => "故障"), "无效"),
                6 => array(array(0 => "正常", 0x1 => "故障"), "无效")
        ),
        'params' => array()
    ),
    "dc" => array(
        "m" => 2, "n" => 20, "p" => 9, "alert_m" => 42, "alert_p" => 5,
        "p_label" => array('监测蓄路电池安时数路数' => true, '第一路蓄电池组剩余安时数' => true, "第二路蓄电池组剩余安时数" => true, "监测蓄电池温度路数" => true, "第一路蓄电池组温度" => true, "第二路蓄电池组温度" => true, "监测蓄电池中性点电压路数" => true, "第一组电池中性点电压" => true, "第二组电池中性点电压" => true),
        "alert_p_label" => array('一次下电' => true, '二次下电' => true, '电保报警' => true, '三次下电' => true, '四次下电' => true),
        "alert_p_rules" => array(
                0 => array(array(0x0 => "正常", 0x80 => "报警"), "无效"),
                1 => array(array(0x0 => "正常", 0x81 => "报警"), "无效"),
                2 => array(array(0x0 => "正常", 0x82 => "报警"), "无效"),
                3 => array(array(0x0 => "正常", 0x83 => "报警"), "无效"),
                4 => array(array(0x0 => "正常", 0x84 => "报警"), "无效"),
        )
    ));
    return $config;
}

function Get_dkd46_419_RtData($memData,&$dataArray,$extraPara = false) {
	if (!$memData) {
		$dataArray['无数据'] = true;
		$dataArray['更新时间'] = '无';
		$dataArray['错误'] = '数据长度不一致';
	} else {       
        $dataArray['无数据'] = false;
        $config = Get_dkd46_419_config();
        require_once "./application/helpers/device/pmbuspower_419.php";
        _Get_PMBusPower_RtData($memData, $dataArray, $extraPara, $config);
    }
}


?>
