<?php
function Get_dm2300_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '[A相电压]':
            return array(0, $dataArray['线电压Uab(V)']);
        case '[B相电压]':
            return array(0, $dataArray['线电压Ubc(V)']);
        case '[C相电压]':
            return array(0, $dataArray['线电压Uca(V)']);
        case '[总功率]':
            return array(0, $dataArray["总有功功率(KW)"]);
    }
    return array(1 , '设备无此信号数据:'. $varname);
}

function Get_dm2300_Active_Power($dataArray){
    return array(0 , $dataArray["总有功绝对值电度量累计值(kWh)"]);
}


function Get_dm2300_RtData($memData, &$dataArray, $extraPara = false)
{
   if(empty($memData)) {
       $dataArray['无数据'] = true;
       $dataArray['更新时间'] = '无';
       $dataArray['错误'] = '数据长度不一致';
   } else {
        $dataArray['无数据'] = false;
        $v = unpack('C*',substr($memData , 4 , 1*1));
        $dataArray["继电器状态"] = $v[1] == 1 ? "闭合" : "断开";
        //DM2300_reg_40070_t
        $v = unpack('I*',substr($memData , 4 + 1*1 , 4*1));
        switch ($v[1]) {
            case 1:
                $dataArray["接线方式"] = "三相四线制3CT(3P4W/3PT+3CT)";
                break;
            case 2:
                $dataArray["接线方式"] = "三相四线制1CT(3P4W/3PT+1CT)";
                break;
            case 3:
                $dataArray["接线方式"] = "三相三线制3CT(3P3W/3PT+3CT)";
                break;
            case 4:
                $dataArray["接线方式"] = "三相三线制2CT(3P3W/3PT(或2PT)+2CT)";
                break;
            case 5:
                $dataArray["接线方式"] = "三相三线制1CT(3P4W/3PT+1CT)";
                break;
            default:
                $dataArray["接线方式"] = "无效";
                break;
        }
        //DM2300_reg_40072_40073_t
        $v = unpack('I*',substr($memData , 4 + 1*1 + 4*1 , 4*2));
        $dataArray["PT1"] = $v[1];
        $dataArray["PT2"] = $v[2];
        //DM2300_reg_40075_t
        $v = unpack('I*',substr($memData , 4 + 1*1 + 4*3 , 4*2));
        $dataArray["CT1"] = $v[1];
        $dataArray["CT2"] = $v[2];
        //DM2300_40100_40113_t
        $v = unpack('f*',substr($memData , 4 + 1*1 + 4*5 , 4*10));
        $dataArray["线电压Uab(V)"] = number_format($v[1],2);
        $dataArray["线电压Ubc(V)"] = number_format($v[2],2);
        $dataArray["线电压Uca(V)"] = number_format($v[3],2);
        $dataArray["相电压Ua(V)"] = number_format($v[4],2);
        $dataArray["相电压Ub(V)"] = number_format($v[5],2);
        $dataArray["相电压Uc(V)"] = number_format($v[6],2);
        $dataArray["电流Ia(A)"] = number_format($v[7],2);
        $dataArray["电流Ib(A)"] = number_format($v[8],2);
        $dataArray["电流Ic(A)"] = number_format($v[9],2);
        $dataArray["频率(Hz)"] = number_format($v[10],2);
        //DM2300_40115_40130_t
        $v = unpack('f*',substr($memData , 4 + 1*1 + 4*15 , 4*16));
        $dataArray["总功率因数"] = number_format($v[1],2);
        $dataArray["总有功功率(KW)"] = number_format($v[2]*10,2,'.','');
        $dataArray["总无功功率(Kvar)"] = number_format($v[3],2);
        $dataArray["总视在功率(KVA)"] = number_format($v[4]*10,2,'.','');
        $dataArray["A相功率因数"] = number_format($v[5],2);
        $dataArray["B相功率因数"] = number_format($v[6],2);
        $dataArray["C相功率因数"] = number_format($v[7],2);
        $dataArray["A相有功功率(KW)"] = number_format($v[8]*10,2,'.','');
        $dataArray["B相有功功率(KW)"] = number_format($v[9]*10,2,'.','');
        $dataArray["C相有功功率(KW)"] = number_format($v[10]*10,2,'.','');
        $dataArray["A相无功功率(var)"] = number_format($v[11],2);
        $dataArray["B相无功功率(var)"] = number_format($v[12],2);
        $dataArray["C相无功功率(var)"] = number_format($v[13],2);
        $dataArray["A相视在功率(KVA)"] = number_format($v[14]*10,2,'.','');
        $dataArray["B相视在功率(KVA)"] = number_format($v[15]*10,2,'.','');
        $dataArray["C相视在功率(KVA)"] = number_format($v[16]*10,2,'.','');
        //DM2300_40200_40215_t
        $v = unpack('f*',substr($memData , 4 + 1*1 + 4*31 , 4*8));
        $dataArray["总有功绝对值电度量累计值(kWh)"] = number_format($v[1],2,'.','');
        $dataArray["总无功绝对值电度量累计值(kvarh)"] = number_format($v[2],2,'.','');
        $dataArray["A相有功绝对值电度量累计值(kWh)"] = number_format($v[3],2,'.','');
        $dataArray["B相有功绝对值电度量累计值(kWh)"] = number_format($v[4],2,'.','');
        $dataArray["C相有功绝对值电度量累计值(kWh)"] = number_format($v[5],2,'.','');
        $dataArray["A相无功绝对值电度量累计值(kvarh)"] = number_format($v[6],2,'.','');
        $dataArray["B相无功绝对值电度量累计值(kvarh)"] = number_format($v[7],2,'.','');
        $dataArray["C相无功绝对值电度量累计值(kvarh)"] = number_format($v[8],2,'.','');

        $v = unpack('v', substr($memData, 4 + 1*1 + 4*31 + 4*8,2));
        $year = $v[1];
        $v = unpack('C*', substr($memData,  4 + 1*1 + 4*31 + 4*8 + 2,5));
        $dataArray["更新时间"] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
   }
}

?>
