<?php

function Get_dse7310_RtData($memData , &$dataArray , $extraPara = false)
{
    if($memData == false ){
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    }else{
        $dataArray['无数据'] = false;
        //设备配置
        $v = unpack('S*', substr($memData, 4, 2 * 1));
        $dataArray['控制模式'] = getControlMode($v[1]);
        $v = unpack('s*', substr($memData, 4 + 2*1 , 2 * 2));
        $dataArray['油压'] = $v[1] . " Bar";
        if($v[2] > 1000) {
            $dataArray['冷却液温度'] = "无效值";
        } else {
            $dataArray['冷却液温度'] = number_format($v[2],2) . "  ℃";
        }

        $v = unpack('f*', substr($memData, 4 + 2*3 , 4 * 2));
        $dataArray['交流发电电压'] = number_format($v[1],2) . ' V';
        $dataArray['电池电压（V）'] =  number_format($v[2],2) . " V";
        $dataArray['电池电压'] =  number_format($v[2],2) . " V";
        $v = unpack('s*', substr($memData, 4 + 2*3 + 4*2 , 2 * 1));
        $dataArray['发动机转速'] = $v[1] . " RPM";
        $v = unpack('f*', substr($memData, 4 + 2*4 + 4*2 , 4 * 11));
        $dataArray['发电机频率'] = number_format($v[1],2) . " Hz";
        $dataArray['发电机L1_N相电压'] = number_format($v[2],2) . " V";
        $dataArray['发电机L2_N相电压'] = number_format($v[3],2) . " V";
        $dataArray['发电机L3_N相电压'] = number_format($v[4],2) . " V";
        $dataArray['发电机L1_L2电压'] = number_format($v[5],2) . " V";
        $dataArray['发电机L2_L3电压'] = number_format($v[6],2) . " V";
        $dataArray['发电机L3_L1电压'] = number_format($v[7],2) . " V";
        $dataArray['发电机L1相电流'] = number_format($v[8],2) . " A";
        $dataArray['发电机L2相电流'] = number_format($v[9],2) . " A";
        $dataArray['发电机L3相电流'] = number_format($v[10],2) . " A";
        $dataArray['发电机对地电流'] = number_format($v[11],2) . " A";
        $v = unpack('I*', substr($memData, 4 + 2*4 + 4*13 , 4 * 3));
        $dataArray['发电机L1相功率'] = $v[1] . " W";
        $dataArray['发电机L2相功率'] = $v[2] . " W";
        $dataArray['发电机L3相功率'] = $v[3] . " W";
        $v = unpack('f*', substr($memData, 4 + 2*4 + 4*13 + 4*3 , 4 * 7));
        $dataArray['市电频率'] = number_format($v[1],2) . " Hz";
        $dataArray['市电L1_N电压'] = number_format($v[2],2) . " V";
        $dataArray['市电L2_N电压'] = number_format($v[3],2) . " V";
        $dataArray['市电L3_N电压'] = number_format($v[4],2) . " V";
        $dataArray['市电L1_L2电压'] = number_format($v[5],2) . " V";
        $dataArray['市电L2_L3电压'] = number_format($v[6],2) . " V";
        $dataArray['市电L3_L1电压'] = number_format($v[7],2) . " V";
        $v = unpack('S*', substr($memData, 4 + 2*4 + 4*20 + 4*3 , 2 * 2));
        $dataArray['发电机相位旋转'] = $v[1];
        $dataArray['市电相位旋转'] = $v[2];
        $v = unpack('S*', substr($memData, 4 + 2*6 + 4*20 + 4*3 , 2 * 18));

        //告警
        $dataArray['AlertArray'] = array();
        $dataArray['冷冻液低温'] = _GetDse5210AlarmData(($v[1] >> 0) & 0xFF);
        $dataArray['AlertArray']['冷冻液低温'] = $dataArray['冷冻液低温'] != "正常";
        $dataArray['冷冻液高温'] = _GetDse5210AlarmData(($v[1] >> 4) & 0xFF);
        $dataArray['AlertArray']['冷冻液高温'] = $dataArray['冷冻液高温'] != "正常";
        $dataArray['低油压'] = _GetDse5210AlarmData(($v[1] >> 8) & 0xFF);
        $dataArray['AlertArray']['低油压'] = $dataArray['低油压'] != "正常";
        $dataArray['紧急停机'] = _GetDse5210AlarmData(($v[1] >> 12) & 0xFF);
        $dataArray['AlertArray']['紧急停机'] = $dataArray['紧急停机'] != "正常";

        $dataArray['发电机频率过高'] = _GetDse5210AlarmData(($v[2] >> 0) & 0xFF);
        $dataArray['AlertArray']['发电机频率过高'] = $dataArray['发电机频率过高'] != "正常";
        $dataArray['发电机频率过低'] = _GetDse5210AlarmData(($v[2] >> 4) & 0xFF);
        $dataArray['AlertArray']['发电机频率过低'] = $dataArray['发电机频率过低'] != "正常";
        $dataArray['发电机转速过高'] = _GetDse5210AlarmData(($v[2] >> 8) & 0xFF);
        $dataArray['AlertArray']['发电机转速过高'] = $dataArray['发电机转速过高'] != "正常";
        $dataArray['发电机转速过低'] = _GetDse5210AlarmData(($v[2] >> 12) & 0xFF);
        $dataArray['AlertArray']['发电机转速过低'] = $dataArray['发电机转速过低'] != "正常";

        $dataArray['电池电压高'] = _GetDse5210AlarmData(($v[3] >> 0) & 0xFF);
        $dataArray['AlertArray']['电池电压高'] = $dataArray['电池电压高'] != "正常";
        $dataArray['电池电压低'] = _GetDse5210AlarmData(($v[3] >> 4) & 0xFF);
        $dataArray['AlertArray']['电池电压低'] = $dataArray['电池电压低'] != "正常";
        $dataArray['发电机电压高'] = _GetDse5210AlarmData(($v[3] >> 8) & 0xFF);
        $dataArray['AlertArray']['发电机电压高'] = $dataArray['发电机电压高'] != "正常";
        $dataArray['发电机电压低'] = _GetDse5210AlarmData(($v[3] >> 12) & 0xFF);
        $dataArray['AlertArray']['发电机电压低'] = $dataArray['发电机电压低'] != "正常";

        $dataArray['发电机关机失败'] = _GetDse5210AlarmData(($v[4] >> 0) & 0xFF);
        $dataArray['AlertArray']['发电机关机失败'] = $dataArray['发电机关机失败'] != "正常";
        $dataArray['发电机停机失败'] = _GetDse5210AlarmData(($v[4] >> 4) & 0xFF);
        $dataArray['AlertArray']['发电机停机失败'] = $dataArray['发电机停机失败'] != "正常";
        $dataArray['发电机开机失败'] = _GetDse5210AlarmData(($v[4] >> 8) & 0xFF);
        $dataArray['AlertArray']['发电机开机失败'] = $dataArray['发电机开机失败'] != "正常";
        $dataArray['充电发电机失败'] = _GetDse5210AlarmData(($v[4] >> 12) & 0xFF);
        $dataArray['AlertArray']['充电发电机失败'] = $dataArray['充电发电机失败'] != "正常";

        $dataArray['电磁开关开路'] = _GetDse5210AlarmData(($v[5] >> 0) & 0xFF);
        $dataArray['AlertArray']['电磁开关开路'] = $dataArray['电磁开关开路'] != "正常";
        $dataArray['电磁开关失效'] = _GetDse5210AlarmData(($v[5] >> 4) & 0xFF);
        $dataArray['AlertArray']['电磁开关失效'] = $dataArray['电磁开关失效'] != "正常";
        $dataArray['油压传感器失效'] = _GetDse5210AlarmData(($v[5] >> 8) & 0xFF);
        $dataArray['AlertArray']['油压传感器失效'] = $dataArray['油压传感器失效'] != "正常";
        $dataArray['主电源关闭失败'] = _GetDse5210AlarmData(($v[5] >> 12) & 0xFF);
        $dataArray['AlertArray']['主电源关闭失败'] = $dataArray['主电源关闭失败'] != "正常";

        $dataArray['CAN总线ECU警告'] = _GetDse5210AlarmData(($v[6] >> 0) & 0xFF);
        $dataArray['AlertArray']['CAN总线ECU警告'] = $dataArray['CAN总线ECU警告'] != "正常";
        $dataArray['燃料液位低'] = _GetDse5210AlarmData(($v[6] >> 4) & 0xFF);
        $dataArray['AlertArray']['燃料液位低'] = $dataArray['燃料液位低'] != "正常";
        $dataArray['同步失效'] = _GetDse5210AlarmData(($v[6] >> 8) & 0xFF);
        $dataArray['AlertArray']['同步失效'] = $dataArray['同步失效'] != "正常";
        $dataArray['发电机电流高'] = _GetDse5210AlarmData(($v[6] >> 12) & 0xFF);
        $dataArray['AlertArray']['发电机电流高'] = $dataArray['发电机电流高'] != "正常";

        $dataArray['切换开关温度高'] = _GetDse5210AlarmData(($v[7] >> 0) & 0xFF);
        $dataArray['AlertArray']['切换开关温度高'] = $dataArray['切换开关温度高'] != "正常";
        $dataArray['低油位开关'] = _GetDse5210AlarmData(($v[7] >> 4) & 0xFF);
        $dataArray['AlertArray']['低油位开关'] = $dataArray['低油位开关'] != "正常";
        $dataArray['CAN总线ECU数据异常'] = _GetDse5210AlarmData(($v[7] >> 8) & 0xFF);
        $dataArray['AlertArray']['CAN总线ECU数据异常'] = $dataArray['CAN总线ECU数据异常'] != "正常";
        $dataArray['CAN总线ECU关闭'] = _GetDse5210AlarmData(($v[7] >> 12) & 0xFF);
        $dataArray['AlertArray']['CAN总线ECU关闭'] = $dataArray['CAN总线ECU关闭'] != "正常";

        $dataArray['负相序电流警报'] = _GetDse5210AlarmData(($v[8] >> 0) & 0xFF);
        $dataArray['AlertArray']['负相序电流警报'] = $dataArray['负相序电流警报'] != "正常";
        $dataArray['功率过载警报'] = _GetDse5210AlarmData(($v[8] >> 4) & 0xFF);
        $dataArray['AlertArray']['功率过载警报'] = $dataArray['功率过载警报'] != "正常";
        $dataArray['扩展单元看门狗警报'] = _GetDse5210AlarmData(($v[8] >> 8) & 0xFF);
        $dataArray['AlertArray']['扩展单元看门狗警报'] = $dataArray['扩展单元看门狗警报'] != "正常";
        $dataArray['低燃料开关'] = _GetDse5210AlarmData(($v[8] >> 12) & 0xFF);
        $dataArray['AlertArray']['低燃料开关'] = $dataArray['低燃料开关'] != "正常";

        $dataArray['维护警报'] = _GetDse5210AlarmData(($v[9] >> 0) & 0xFF);
        $dataArray['AlertArray']['维护警报'] = $dataArray['维护警报'] != "正常";
        $dataArray['自动电压传感器失败'] = _GetDse5210AlarmData(($v[9] >> 4) & 0xFF);
        $dataArray['AlertArray']['自动电压传感器失败'] = $dataArray['自动电压传感器失败'] != "正常";
        $dataArray['发电机相位旋转警报'] = _GetDse5210AlarmData(($v[9] >> 8) & 0xFF);
        $dataArray['AlertArray']['发电机相位旋转警报'] = $dataArray['发电机相位旋转警报'] != "正常";
        $dataArray['接地故障脱扣警报'] = _GetDse5210AlarmData(($v[9] >> 12) & 0xFF);
        $dataArray['AlertArray']['接地故障脱扣警报'] = $dataArray['接地故障脱扣警报'] != "正常";

        $dataArray['燃料供应停止'] = _GetDse5210AlarmData(($v[10] >> 0) & 0xFF);
        $dataArray['AlertArray']['燃料供应停止'] = $dataArray['燃料供应停止'] != "正常";
        $dataArray['燃料供应进行中'] = _GetDse5210AlarmData(($v[10] >> 4) & 0xFF);
        $dataArray['AlertArray']['燃料供应进行中'] = $dataArray['燃料供应进行中'] != "正常";
        $dataArray['负载电压报警器'] = _GetDse5210AlarmData(($v[10] >> 8) & 0xFF);
        $dataArray['AlertArray']['负载电压报警器'] = $dataArray['负载电压报警器'] != "正常";
        $dataArray['负载频率报警器'] = _GetDse5210AlarmData(($v[10] >> 12) & 0xFF);
        $dataArray['AlertArray']['负载频率报警器'] = $dataArray['负载频率报警器'] != "正常";

        $dataArray['主电源高电流'] = _GetDse5210AlarmData(($v[11] >> 0) & 0xFF);
        $dataArray['AlertArray']['主电源高电流'] = $dataArray['主电源高电流'] != "正常";
        $dataArray['发电机短路'] = _GetDse5210AlarmData(($v[11] >> 4) & 0xFF);
        $dataArray['AlertArray']['发电机短路'] = $dataArray['发电机短路'] != "正常";
        $dataArray['保护系统被屏蔽'] = _GetDse5210AlarmData(($v[11] >> 8) & 0xFF);
        $dataArray['AlertArray']['保护系统被屏蔽'] = $dataArray['保护系统被屏蔽'] != "正常";
        $dataArray['保护系统被禁用'] = _GetDse5210AlarmData(($v[11] >> 12) & 0xFF);
        $dataArray['AlertArray']['保护系统被禁用'] = $dataArray['保护系统被禁用'] != "正常";

        $dataArray['ECU工作不正常'] = _GetDse5210AlarmData(($v[12] >> 0) & 0xFF);
        $dataArray['AlertArray']['ECU工作不正常'] = $dataArray['ECU工作不正常'] != "正常";
        $dataArray['ECU保护'] = _GetDse5210AlarmData(($v[12] >> 4) & 0xFF);
        $dataArray['AlertArray']['ECU保护'] = $dataArray['ECU保护'] != "正常";
        $dataArray['主电源短路'] = _GetDse5210AlarmData(($v[12] >> 8) & 0xFF);
        $dataArray['AlertArray']['主电源短路'] = $dataArray['主电源短路'] != "正常";
        $dataArray['主电源接地故障'] = _GetDse5210AlarmData(($v[12] >> 12) & 0xFF);
        $dataArray['AlertArray']['主电源接地故障'] = $dataArray['主电源接地故障'] != "正常";

        $dataArray['ECU跳闸'] = _GetDse5210AlarmData(($v[13] >> 0) & 0xFF);
        $dataArray['AlertArray']['ECU跳闸'] = $dataArray['ECU跳闸'] != "正常";
        $dataArray['ECU警告'] = _GetDse5210AlarmData(($v[13] >> 4) & 0xFF);
        $dataArray['AlertArray']['ECU警告'] = $dataArray['ECU警告'] != "正常";
        $dataArray['ECU关机'] = _GetDse5210AlarmData(($v[13] >> 8) & 0xFF);
        $dataArray['AlertArray']['ECU关机'] = $dataArray['ECU关机'] != "正常";
        $dataArray['ECU信息通知'] = _GetDse5210AlarmData(($v[13] >> 12) & 0xFF);
        $dataArray['AlertArray']['ECU信息通知'] = $dataArray['ECU信息通知'] != "正常";

        $dataArray['发电机正向无功'] = _GetDse5210AlarmData(($v[14] >> 0) & 0xFF);
        $dataArray['AlertArray']['发电机正向无功'] = $dataArray['发电机正向无功'] != "正常";
        $dataArray['发电机反向有功'] = _GetDse5210AlarmData(($v[14] >> 4) & 0xFF);
        $dataArray['AlertArray']['发电机反向有功'] = $dataArray['发电机反向有功'] != "正常";
        $dataArray['ECU燃料中有水'] = _GetDse5210AlarmData(($v[14] >> 8) & 0xFF);
        $dataArray['AlertArray']['ECU燃料中有水'] = $dataArray['ECU燃料中有水'] != "正常";
        $dataArray['ECU维护结束'] = _GetDse5210AlarmData(($v[14] >> 12) & 0xFF);
        $dataArray['AlertArray']['ECU维护结束'] = $dataArray['ECU维护结束'] != "正常";

        $dataArray['DEF液位低'] = _GetDse5210AlarmData(($v[15] >> 0) & 0xFF);
        $dataArray['AlertArray']['DEF液位低'] = $dataArray['DEF液位低'] != "正常";
        $dataArray['LCD加热器电压低'] = _GetDse5210AlarmData(($v[15] >> 8) & 0xFF);
        $dataArray['AlertArray']['LCD加热器电压低'] = $dataArray['LCD加热器电压低'] != "正常";
        $dataArray['发电机反向无功'] = _GetDse5210AlarmData(($v[15] >> 12) & 0xFF);
        $dataArray['AlertArray']['发电机反向无功'] = $dataArray['发电机反向无功'] != "正常";

        $dataArray['MSC旧版本'] = _GetDse5210AlarmData(($v[16] >> 8) & 0xFF);
        $dataArray['AlertArray']['MSC旧版本'] = $dataArray['MSC旧版本'] != "正常";
        $dataArray['SCR Inducement'] = _GetDse5210AlarmData(($v[16] >> 12) & 0xFF);
        $dataArray['AlertArray']['SCR Inducement'] = $dataArray['SCR Inducement'] != "正常";

        $dataArray['MSC优先级错误'] = _GetDse5210AlarmData(($v[17] >> 12) & 0xFF);
        $dataArray['AlertArray']['MSC优先级错误'] = $dataArray['MSC优先级错误'] != "正常";
        $dataArray['冷却液传感器开路'] = _GetDse5210AlarmData(($v[18] >> 12) & 0xFF);
        $dataArray['AlertArray']['冷却液传感器开路'] = $dataArray['冷却液传感器开路'] != "正常";

        $v = unpack('v', substr($memData, 4 + 2*24 + 4*20 + 4*3 , 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData, 4 + 2*24 + 4*20 + 4*3 + 2, 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}

function getControlMode($control_mode) {
    switch($control_mode){
        case 0:
            $str = "停止模式";
            break;
        case 1:
            $str = "自动模式";
            break;
        case 2:
            $str = "手动模式";
            break;
        case 3:
            $str = "测试负载模式";
            break;
        case 4:
            $str = "手动恢复模式/禁止返回";
            break;
        case 5:
            $str = "用户自定义模式";
            break;
        case 6:
            $str = "测试无负载模式";
            break;
        case 7:
            $str = "关机模式";
            break;
        default:
            $str = "无效";
            break;
    }
    return $str;
}

function _GetDse5210AlarmData($value) {
    switch ($value){
        case 2:$str = '预警'; break;
        case 3:$str =  '关闭告警'; break;
        case 4:$str =  '跳闸告警'; break;
        case 5:$str =  '人为关闭告警'; break;
        case 10:$str =  '告警'; break;
        case 0xFF:
            $str =  "设备不支持"; break;
        default:
            $str =  '正常'; break;
    }
    return $str;
}

?>
