<?php


function Get_dts100_UnicomCategory()
{
    return "911";
}

function Is_dts100_NeedExtraPara(){
    return true;
}


function Get_dts100_RtData($memData, &$dataArray, $extraPara = false)
{
    if(empty($memData)) {
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    } else {
        $dataArray['无数据'] = false;
	$number = 1024;
	if(isset($extraPara->number)){
	     $number = $extraPara->number;
	}
        $v = unpack('S*', substr($memData, 4, 2*1024));
        for($i=1; $i<=$number; $i++){
            $dataArray["报警分区".$i."温度"] = number_format($v[$i]/10, 1)."℃";
        }
        $v = unpack('C*', substr($memData, 4 + 2*1024, 1024));
        for($i=1; $i<=$number; $i++){
            $dataArray["报警分区".$i."状态"] = $v[$i] == 0 ? "正常" : "告警";
            $dataArray["AlertArray"]["报警分区".$i."状态"] = $v[$i] == 1;
	}
        $v = unpack('C*', substr($memData, 4 + 2*1024 + 1024, 1024));
        for($i=1; $i<=$number; $i++){
            $dataArray["故障分区".$i."状态"] = $v[$i] == 0 ? "正常" : "告警";
            $dataArray["AlertArray"]["故障分区".$i."状态"] = $v[$i] == 1;
        }
        $v = unpack('S*', substr($memData, 4 + 2*1024 + 2*1024, 2*1024));
        for($i=1; $i<=$number; $i++){
	    switch($v[$i]){
		case 0:
            		$dataArray["报警分区".$i."的火警类型"] = "无火警";
			break;
		case 1:
            		$dataArray["报警分区".$i."的火警类型"] = "定温报警";
            		$dataArray["AlertArray"]["故障分区".$i."状态"] = $v[$i] == 1;
			break;
		case 2:
            		$dataArray["报警分区".$i."的火警类型"] = "差温报警";
			break;
		case 3:
            		$dataArray["报警分区".$i."的火警类型"] = "模拟火警";
			break;
			
	    }
        }
        $v = unpack('S*', substr($memData, 4 + 2*1024 + 2*1024 + 2*1024, 2*1024));
        for($i=1; $i<=$number; $i++){
	    switch($v[$i]){
		case 0xFFFF:
			$dataArray["报警分区".$i."的火警位置"] = "无火警";
			break;
		default:
			$dataArray["报警分区".$i."的火警位置"] = $v[$i];
			break;
	    }
	}
	$v = unpack('S*', substr($memData, 4 + 2*1024 + 2*1024 + 2*1024 + 2*1024, 2*1024));
        for($i=1; $i<=$number; $i++){
            switch($v[$i]){
                case 0xFFFF:    
                        $dataArray["故障分区".$i."的故障位置"] = "无故障";
                        break;
                default:
                        $dataArray["故障分区".$i."的故障位置"] = $v[$i];
                        break;
            }
        }
        $v = unpack('v',substr($memData, 4 + 2*1024 + 2*1024 + 2*1024 + 2*1024 + 2*1024, 2));
        $year = $v[1];
        $v = unpack('C*',substr($memData,4 + 2*1024 + 2*1024 + 2*1024 + 2*1024 + 2*1024 + 2,5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s',strtotime($year.'-'.$v[1].'-'.$v[2].' '.$v[3].':'.$v[4].':'.$v[5]));
    }
}


