<?php
function Get_dtsd3366d_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '[A相电压]':
            return array(0, $dataArray['A相电压2'] * 1.732);
        case '[B相电压]':
            return array(0, $dataArray['B相电压2'] * 1.732);
        case '[C相电压]':
            return array(0, $dataArray['C相电压2'] * 1.732);
        case "[总功率]":
            return array(0, $dataArray['总有功功率2']);
    }
    return array(1 , '设备无此信号数据:'. $varname);
}

function Get_dtsd3366d_Active_Power($dataArray){
    return array(0 , $dataArray['正向有功电能2']);
}

//需要提供给联通B接口的AI，DI字段映射
function Get_dtsd3366d_Signals($type){
    switch($type){
        case "AI":
            return array("321110100001","321110200001","321110300001","321110100002","321110200002","321110300002","321110900001","321110A00001","321110B00001","321112C00001","321112C00002","321112900001","321112A00001","321112B00001","321117300001","321117000001","321117100001","321117200001","321111C00001","321111900001","321111A00001","321111B00001","321112400001","321112100001","321112200001","321112300001","321113900001","321113400001","321113400002");
        case "DI":
            return array();
        case "AO":
            return array("");
        case "DO":
            return array();
        case "ALARM":
            return array();
        default:
            return array();
    }

}

//设备类型
function Get_dtsd3366d_UnicomCategory()
{
    return "321";//智能电表	380V交流智能电表	32	1	321
}


function Get_dtsd3366d_RtData($memData, &$dataArray, $extraPara = false){
    if(empty($memData)){
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    }else{
        $dataArray['无数据'] = false;
        $dataArray['AlertArray'] = array();
        //DTSD3366D_REG_8_A_t
        $v = unpack("S*" , substr($memData , 4 , 4 * 2));
        $dataArray['设备地址'] = $v[1];
        //$v[2]  保留
        $dataArray['电压变比'] = $v[3];
        $dataArray['电流变比'] = $v[4];
        //DTSD3366D_REG_16E_199_t
        $v = unpack("I*" , substr($memData , 4 + 4*2 , 6 * 4));
        $dataArray['A相电压'] = number_format($v[1] / 10000 , 2).' V';
        $dataArray["AI"]["321110100001"] = "A相电压";
        $dataArray['B相电压'] = number_format($v[2] / 10000 , 2).' V';
        $dataArray["AI"]["321110200001"] = "B相电压";
        $dataArray['C相电压'] = number_format($v[3] / 10000 , 2 ).' V';
        $dataArray["AI"]["321110300001"] = "C相电压";
        $dataArray['A相电压2'] = number_format($v[1] / 10000 , 2);
        $dataArray["AI"]["321110100002"] = "A相电压2";
        $dataArray['B相电压2'] = number_format($v[2] / 10000 , 2);
        $dataArray["AI"]["321110200002"] = "B相电压2";
        $dataArray['C相电压2'] = number_format($v[3] / 10000 , 2 );
        $dataArray["AI"]["321110300002"] = "C相电压2";
        $dataArray['A相电流'] = number_format($v[4] / 10000 , 2 ).' A';
        $dataArray["AI"]["321110900001"] = "A相电流";
        $dataArray['B相电流'] = number_format($v[5] / 10000 , 2 ).' A';
        $dataArray["AI"]["321110A00001"] = "B相电流";
        $dataArray['C相电流'] = number_format($v[6] / 10000 , 2 ).' A';
        $dataArray["AI"]["321110B00001"] = "C相电流";
        $v = unpack("i*" , substr($memData , 4 + 4*2 + 6*4 , 8 * 4));
        $dataArray['总有功功率'] = number_format($v[1] / 10 , 2,'.','').' W';
        $dataArray["AI"]["321112C00001"] = "总有功功率";
        $dataArray['总有功功率2'] = number_format($v[1] / 10000 , 3,'.','');
        $dataArray["AI"]["321112C00002"] = "总有功功率2";
        $dataArray['A相有功功率'] = number_format($v[2] / 10 , 2,'.','').' W';
        $dataArray["AI"]["321112900001"] = "A相有功功率";
        $dataArray['B相有功功率'] = number_format($v[3] / 10 , 2,'.','').' W';
        $dataArray["AI"]["321112A00001"] = "B相有功功率";
        $dataArray['C相有功功率'] = number_format($v[4] / 10 , 2,'.','').' W';
        $dataArray["AI"]["321112B00001"] = "C相有功功率";
        
        $dataArray['总无功功率'] = number_format($v[5] / 10 , 2,'.','').' var';
        $dataArray["AI"]["321117300001"] = "总无功功率";
        $dataArray['A相无功功率'] = number_format($v[6] / 10 , 2,'.','').' var';
        $dataArray["AI"]["321117000001"] = "A相无功功率";
        $dataArray['B相无功功率'] = number_format($v[7] / 10 , 2,'.','').' var';
        $dataArray["AI"]["321117100001"] = "B相无功功率";
        $dataArray['C相无功功率'] = number_format($v[8] / 10 , 2,'.','').' var';
        $dataArray["AI"]["321117200001"] = "C相无功功率";

        $v = unpack("I*" , substr($memData , 4 + 4*2 + 14*4 , 4 * 4));
        $dataArray['总视在功率'] = number_format($v[1] / 10 , 2,'.','').' VA';
        $dataArray["AI"]["321111C00001"] = "总视在功率";
        $dataArray['A相视在功率'] = number_format($v[2] / 10 , 2,'.','').' VA';
        $dataArray["AI"]["321111900001"] = "A相视在功率";
        $dataArray['B相视在功率'] = number_format($v[3] / 10 , 2,'.','').' VA';
        $dataArray["AI"]["321111A00001"] = "B相视在功率";
        $dataArray['C相视在功率'] = number_format($v[4] / 10 , 2,'.','').' VA';
        $dataArray["AI"]["321111B00001"] = "C相视在功率";

        $v = unpack("s*" , substr($memData , 4 + 4*2 + 18*4 , 4 * 2));
        $dataArray['总功率因数'] = $v[1] / 1000;
        $dataArray["AI"]["321112400001"] = "总功率因数";
        $dataArray['A相功率因数'] = $v[2] / 1000;
        $dataArray["AI"]["321112100001"] = "A相功率因数";
        $dataArray['B相功率因数'] = $v[3] / 1000;
        $dataArray["AI"]["321112200001"] = "B相功率因数";
        $dataArray['C相功率因数'] = $v[4] / 1000;
        $dataArray["AI"]["321112300001"] = "C相功率因数";
        
        $v = unpack("S*" , substr($memData , 4 + 8*2 + 18*4 , 4 * 2));
        $dataArray['A相相角'] = ($v[1] / 10).' °';
        $dataArray['B相相角'] = ($v[2] / 10).' °';
        $dataArray['C相相角'] = ($v[3] / 10).' °';
        $dataArray['频率'] = ($v[4] / 100).' Hz';
        $dataArray["AI"]["321113900001"] = "频率";
        $v = unpack("i*" , substr($memData , 4 + 12*2 + 18*4 , 1 * 4));
        $dataArray['组合有功电能'] = ($v[1] / 100).' KWh';
        //$dataArray["AI"]["321113400001"] = "组合有功电能";
        $v = unpack("I*" , substr($memData , 4 + 12*2 + 19*4 , 2 * 4));
        $dataArray['正向有功电能'] = ($v[1] / 100).' KWh';
        $dataArray["AI"]["321113400001"] = "正向有功电能";
        $dataArray['正向有功电能2'] = ($v[1] / 100);
        $dataArray["AI"]["321113400002"] = "正向有功电能2";
        $dataArray['反向有功电能'] = ($v[2] / 100).' KWh';
        //$dataArray["AI"]["321117300001"] = "反向有功电能";
        $v = unpack('v', substr($memData, 4 + 12*2 + 21*4 , 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData, 4 + 12*2 + 21*4 + 2 , 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}
