<?php

function Is_dtsd3366m4_NeedExtraPara(){
    return true;
}


function Get_dtsd3366m4_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '[A相电压]':
            return array(0, $dataArray['AB线交流电压']);
        case '[B相电压]':
            return array(0, $dataArray['BC线交流电压']);
        case '[C相电压]':
            return array(0, $dataArray['CA线交流电压']);
        case "[总功率]":
            return array(0, $dataArray['总有功功率']);
        case '合相电能':
            return array(0, $dataArray['正向总有功电度']);
    }
    return array(1 , '设备无此信号数据:'. $varname);
}

function Get_dtsd3366m4_Active_Power($dataArray){
    return array(0 , $dataArray['正向有功电能2']);
}

function Get_dtsd3366m4_RtData($memData, &$dataArray, $extraPara = false){
    if(empty($memData)){
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    }else{
        $dataArray['无数据'] = false;
        $dataArray['AlertArray'] = array();

        $hasPower = false;
        if(strlen($memData) == 363)
        {
            $hasPower = true;
        }
        $index = -1;
        if(isset($extraPara->index))
        {
            $index = $extraPara->index;
        }
        $size = $hasPower ? 22 : 19;
        $offset = ($hasPower ? 4*22*4 : 4*19*4);
        $v = unpack("f*" , substr($memData , 4, $offset));
        if($index == -1){
           
            for($i=1;$i<=4;$i++){
                $offsetI = $i - 1;
                $dataArray[$i."路A相电压"] = number_format($v[$size*$offsetI + 1], 2)."V";
                $dataArray[$i."路B相电压"] = number_format($v[$size*$offsetI + 2], 2)."V";
                $dataArray[$i."路C相电压"] = number_format($v[$size*$offsetI + 3], 2)."V";
    
                $dataArray[$i."路A相电流"] = number_format($v[$size*$offsetI + 4], 2)."A";
                $dataArray[$i."路B相电流"] = number_format($v[$size*$offsetI + 5], 2)."A";
                $dataArray[$i."路C相电流"] = number_format($v[$size*$offsetI + 6], 2)."A";
    
                $dataArray[$i."路总有功功率"] = number_format($v[$size*$offsetI + 7], 2)."kW";
                $dataArray[$i."路A相有功功率"] = number_format($v[$size*$offsetI + 8], 2)."kW";
                $dataArray[$i."路B相有功功率"] = number_format($v[$size*$offsetI + 9], 2)."kW";
                $dataArray[$i."路C相有功功率"] = number_format($v[$size*$offsetI + 10], 2)."kW";
    
                $dataArray[$i."路总无功功率"] = number_format($v[$size*$offsetI + 11], 4)."kvarh";
                $dataArray[$i."路A相无功功率"] = number_format($v[$size*$offsetI +12], 4)."kvarh";
                $dataArray[$i."路B相无功功率"] = number_format($v[$size*$offsetI +13], 4)."kvarh";
                $dataArray[$i."路C相无功功率"] = number_format($v[$size*$offsetI + 14], 4)."kvarh";
    
                $dataArray[$i."路总功率因数"] = number_format($v[$size*$offsetI + 15], 3);
                $dataArray[$i."路A相功率因数"] = number_format($v[$size*$offsetI +16], 3);
                $dataArray[$i."路B相无功功率"] = number_format($v[$size*$offsetI +17], 3);
                $dataArray[$i."路C相无功功率"] = number_format($v[$size*$offsetI + 18], 3);
    
                $dataArray[$i."路频率"] = number_format($v[$size*$offsetI + 19], 2)."Hz";

                if(strlen($memData) == 363)
                {
                    //还有电能数据
                    $dataArray[$i."路组合有功电能"] = number_format($v[$size*$offsetI + 20], 2)."kWh";
                    $dataArray[$i."路正向有功电能"] = number_format($v[$size*$offsetI + 21], 2)."kWh";
                    $dataArray[$i."路反向有功电能"] = number_format($v[$size*$offsetI + 22], 2)."kWh";
                }
            }
        }else{
            for($i=1;$i<=4;$i++){
                if($i != $index)
                {
                    continue;
                }
                $offsetI = $i - 1;
                $dataArray["A相电压"] = number_format($v[$size*$offsetI + 1], 2)."V";
                $dataArray["B相电压"] = number_format($v[$size*$offsetI + 2], 2)."V";
                $dataArray["C相电压"] = number_format($v[$size*$offsetI + 3], 2)."V";
    
                $dataArray["A相电流"] = number_format($v[$size*$offsetI + 4], 2)."A";
                $dataArray["B相电流"] = number_format($v[$size*$offsetI + 5], 2)."A";
                $dataArray["C相电流"] = number_format($v[$size*$offsetI + 6], 2)."A";
    
                $dataArray["总有功功率"] = number_format($v[$size*$offsetI + 7], 2)."kW";
                $dataArray["A相有功功率"] = number_format($v[$size*$offsetI + 8], 2)."kW";
                $dataArray["B相有功功率"] = number_format($v[$size*$offsetI + 9], 2)."kW";
                $dataArray["C相有功功率"] = number_format($v[$size*$offsetI + 10], 2)."kW";
    
                $dataArray["总无功功率"] = number_format($v[$size*$offsetI + 11], 4)."kvarh";
                $dataArray["A相无功功率"] = number_format($v[$size*$offsetI +12], 4)."kvarh";
                $dataArray["B相无功功率"] = number_format($v[$size*$offsetI +13], 4)."kvarh";
                $dataArray["C相无功功率"] = number_format($v[$size*$offsetI + 14], 4)."kvarh";
    
                $dataArray["总功率因数"] = number_format($v[$size*$offsetI + 15], 3);
                $dataArray["A相功率因数"] = number_format($v[$size*$offsetI +16], 3);
                $dataArray["B相无功功率"] = number_format($v[$size*$offsetI +17], 3);
                $dataArray["C相无功功率"] = number_format($v[$size*$offsetI + 18], 3);
    
                $dataArray["频率"] = number_format($v[$size*$offsetI + 19], 2)."Hz";

                if(strlen($memData) == 363)
                {
                    //还有电能数据
                    $dataArray["组合有功电能"] = number_format($v[$size*$offsetI + 20], 2)."kWh";
                    $dataArray["正向有功电能"] = number_format($v[$size*$offsetI + 21], 2)."kWh";
                    $dataArray["反向有功电能"] = number_format($v[$size*$offsetI + 22], 2)."kWh";
                }
            }
        }
        
       
        $v = unpack('v', substr($memData, 4 + $offset , 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData, 4 + $offset + 2 , 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}
