<?php
function Get_dtsd3366p4_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '[A相电压]':
            return array(0, $dataArray['AB线交流电压']);
        case '[B相电压]':
            return array(0, $dataArray['BC线交流电压']);
        case '[C相电压]':
            return array(0, $dataArray['CA线交流电压']);
        case "[总功率]":
            return array(0, $dataArray['总有功功率']);
        case '合相电能':
            return array(0, $dataArray['正向总有功电度']);
    }
    return array(1 , '设备无此信号数据:'. $varname);
}

function Get_dtsd3366p4_Active_Power($dataArray){
    return array(0 , $dataArray['正向有功电能2']);
}

function Get_dtsd3366p4_RtData($memData, &$dataArray, $extraPara = false){
    if(empty($memData)){
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    }else{
        $dataArray['无数据'] = false;
        $dataArray['AlertArray'] = array();
        $v = unpack("f*" , substr($memData , 4   , 26 * 4));
        $dataArray['AB线交流电压'] = number_format($v[1] , 3).' V';
        $dataArray['BC线交流电压'] = number_format($v[2] , 3).' V';
        $dataArray['CA线交流电压'] = number_format($v[3] , 3).' V';
        $dataArray['A相交流电压'] = number_format($v[4] , 3).' V';
        $dataArray['B相交流电压'] = number_format($v[5] , 3).' V';
        $dataArray['C相交流电压'] = number_format($v[6] , 3).' V';
        $dataArray['A相交流电流'] = number_format($v[7] , 3).' A';
        $dataArray['B相交流电流'] = number_format($v[8] , 3).' A';
        $dataArray['C相交流电流'] = number_format($v[9] , 3).' A';
        $dataArray['零序电流'] = number_format($v[10] , 3).' A';
        $dataArray['功率因数'] = number_format($v[11] , 2);
        $dataArray['频率'] = number_format($v[12] , 2);
        $dataArray['总有功功率'] = number_format($v[13]/1000 , 3,'.','').' kW';
        $dataArray['A相有功功率'] = number_format($v[14]/1000  , 2,'.','').' kW';
        $dataArray['B相有功功率'] = number_format($v[15]/1000  , 2,'.','').' kW';
        $dataArray['C相有功功率'] = number_format($v[16]/1000  , 2,'.','').' kW';
        $dataArray['总无功功率'] = number_format($v[17] , 2,'.','').' var';
        $dataArray['A相无功功率'] = number_format($v[18] , 2,'.','').' var';
        $dataArray['B相无功功率'] = number_format($v[19]  , 2,'.','').' var';
        $dataArray['C相无功功率'] = number_format($v[20] , 2,'.','').' var';

        $dataArray['总有功电能'] = ($v[21]).' KWh';
        $dataArray['总无功电能'] = ($v[22] );
        $dataArray['正向有功电能'] = ($v[23] ).' KWh';
        $dataArray['正向无功电能'] = ($v[24] );
        $dataArray['反向有功电能'] = ($v[25] ).' KWh';
        $dataArray['反向无功电能'] = ($v[26] );
        $v = unpack('v', substr($memData, 4 + 26*4 , 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData, 4 + 26*4 + 2 , 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}
