<?php

function Get_eagle600_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '[A相电压]':
            return array(0, $dataArray['线电压UAB']);
        case '[B相电压]':
            return array(0, $dataArray['线电压UBC']);
        case '[C相电压]':
            return array(0, $dataArray['线电压UCA']);
        case "[总功率]":
            return array(0, $dataArray['总有功功率2']);
    }
    return array(1 , '设备无此信号数据:'. $varname);
}

function Get_eagle600_Active_Power($dataArray){
    return array(0 , $dataArray['正向有功电能']);
}

function Get_eagle600_RtData($memData, &$dataArray, $extraPara = false)
{
   if($memData == false) {
       $dataArray['无数据'] = true;
       $dataArray['更新时间'] = '无';
       $dataArray['错误'] = '数据长度不一致';
   } else {
        $dataArray['无数据'] = false;
        $V = unpack('I*', substr($memData, 4, 4 * 49));
        $dataArray['A相电流'] = number_format($V[1]/1000,2).' A';
        $dataArray['B相电流'] = number_format($V[2]/1000,2).' A';
        $dataArray['C相电流'] = number_format($V[3]/1000,2).' A';
        $dataArray['中性线电流'] = number_format($V[4]/1000,2).' A';
        $dataArray['线电压UAB'] = number_format($V[5]/100,2).' V';
        $dataArray['线电压UBC'] = number_format($V[6]/100,2).' V';
        $dataArray['线电压UCA'] = number_format($V[7]/100,2).' V';
        $dataArray['相电压A'] = number_format($V[8]/100,2).' V';
        $dataArray['相电压B'] = number_format($V[9]/100,2).' V';
        $dataArray['相电压C'] = number_format($V[10]/100,2).' V';
        $dataArray['频率'] = number_format($V[11]/100,2).' Hz';
        $dataArray['总有功功率'] = number_format($V[12]/100/1000,2,'.','').' KW';
        $dataArray['总有功功率2'] = number_format($V[12]/100/1000,3,'.','');
        $dataArray['总无功功率'] = number_format($V[13]/100,2).' Kvar';
        $dataArray['总视在功率'] = number_format($V[14]/100,2).' KVA';
        $dataArray['总功率因数'] = number_format($V[15] * 0.001 , 2);
        $dataArray['A相有功功率'] = number_format($V[16]/100,2).' KW';
        $dataArray['B相有功功率'] = number_format($V[17]/100,2).' KW';
        $dataArray['C相有功功率'] = number_format($V[18]/100,2).' KW';
        $dataArray['A相无功功率'] = number_format($V[19]/100,2).' Kvar';
        $dataArray['B相无功功率'] = number_format($V[20]/100,2).' Kvar';
        $dataArray['C相无功功率'] = number_format($V[21]/100,2).' Kvar';
        $dataArray['A相视在功率'] = number_format($V[22]/100,2).' KVA';
        $dataArray['B相视在功率'] = number_format($V[23]/100,2).' KVA';
        $dataArray['C相视在功率'] = number_format($V[24]/100,2).' KVA';
        $dataArray['A相功率因数'] = number_format($V[25] * 0.001 , 2);
        $dataArray['B相功率因数'] = number_format($V[26] * 0.001 , 2);
        $dataArray['C相功率因数'] = number_format($V[27] * 0.001 , 2);
        $dataArray['A相平均电流'] = number_format($V[28]/1000,2).' A';
        $dataArray['B相平均电流'] = number_format($V[29]/1000,2).' A';
        $dataArray['C相平均电流'] = number_format($V[30]/1000,2).' A';
        $dataArray['正向总平均有功功率'] = number_format($V[31]/100,2).' KW';
        $dataArray['反向总平均有功功率'] = number_format($V[32]/100,2).' KW';
        $dataArray['正向总平均无功功率'] = number_format($V[33]/100,2).' Kvar';
        $dataArray['正向总平均无功功率'] = number_format($V[34]/100,2).' Kvar';
        $dataArray['总平均视在功率'] = number_format($V[35]/100,2).' KVA';
        $dataArray['平均A相电流最大值'] = number_format($V[36]/1000,2).' A';
        $dataArray['平均B相电流最大值'] = number_format($V[37]/1000,2).' A';
        $dataArray['平均C相电流最大值'] = number_format($V[38]/1000,2).' A';
        $dataArray['正向总平均功率最大值'] = number_format($V[39]/100,2).' KW';
        $dataArray['反向总平均功率最大值'] = number_format($V[40]/100,2).' KW';
        $dataArray['正向总平均无功功率最大值'] = number_format($V[41]/100,2).' KW';
        $dataArray['反向总平均无功功率最大值'] = number_format($V[42]/100,2).' KW';
        $dataArray['总平均视在功率'] = number_format($V[43]/100,2).' KVA';
        $dataArray['小时计'] = number_format($V[44]/100,2).' h';
        $dataArray['正向有功电能'] = number_format($V[45]/100,2,'.','').' KWh';
        $dataArray['正向无功电能'] = number_format($V[46],2).' Kvarh';
        $dataArray['视在电能'] = number_format($V[47],2).' KVAh';
        $dataArray['反向有功电能'] = number_format($V[48],2).' KWh';
        $dataArray['反向无功电能'] = number_format($V[49],2).' Kvarh';
        $v = unpack('v', substr($memData, 4 + 4 * 49, 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData,  6 + 4 * 49, 5));
        $dataArray["更新时间"] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
   }
}

?>
