<?php

function Get_eatonups9390_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '[A相电压]':
            return array(0, $dataArray['线电压UAB']);
        case '[B相电压]':
            return array(0, $dataArray['线电压UBC']);
        case '[C相电压]':
            return array(0, $dataArray['线电压UCA']);
        case "[总功率]":
            return array(0, $dataArray['总有功功率2']);
    }
    return array(1 , '设备无此信号数据:'. $varname);
}


function Get_eatonups9390_RtData($memData, &$dataArray, $extraPara = false)
{
   if(empty($memData)) {
       $dataArray['无数据'] = true;
       $dataArray['更新时间'] = '无';
       $dataArray['错误'] = '数据长度不一致';
   } else {
        $dataArray['无数据'] = false;
        $dataArray['AlertArray'] = array();
        $v = unpack('C*', substr($memData, 4, 6));
        switch($v[1]){
            case 0xF0:
            $dataArray['UPS状态'] = "电池供电";
            break;
            case 0xE0:
            $dataArray['UPS状态'] = "输出过载";
            break;
            case 0xD0:
            $dataArray['UPS状态'] = "整流器过载";
            break;
            case 0x90:
            $dataArray['UPS状态'] = "逆变器输出电压升高";
            break;
            case 0x80:
            $dataArray['UPS状态'] = "逆变器向旁路同步相位";
            break;
            case 0x70:
            $dataArray['UPS状态'] = "整流器启动中";
            break;
            case 0x64:
            $dataArray['UPS状态'] = "手工/维护旁路模式";
            break;
            case 0x63:
            $dataArray['UPS状态'] = "降低市电电压到合理范围";
            break;
            case 0x62:
            $dataArray['UPS状态'] = "提高市电电压到合理范围";
            break;
            case 0x61:
            $dataArray['UPS状态'] = "双机工作提高市电电压到合理范围";
            break;
            case 0x60:
            $dataArray['UPS状态'] = "旁路工作";
            break;
            case 0x51:
            $dataArray['UPS状态'] = "高效模式";
            break;
            case 0x50:
            $dataArray['UPS状态'] = "系统正常";
            break;
            case 0x43:
            case 0x40:
            $dataArray['UPS状态'] = "UPS辅助支持模式";
            break;
            case 0x30:
            $dataArray['UPS状态'] = "UPS工作中";
            break;
            case 0x21:
            $dataArray['UPS状态'] = "负载开关开路";
            break;
            case 0x20:
            $dataArray['UPS状态'] = "输出断路器开路";
            break;
            case 0x11:
            $dataArray['UPS状态'] = "本模组无法启动";
            break;
            case 0x10:
            $dataArray['UPS状态'] = "关机";
            break;
            default:
            $dataArray['UPS状态'] = "未知状态".$v[1];
            break;
        }
        //topology status
        if($v[2] & 0x80){
            $dataArray["市电状态"] = "正常";
        }else{
            $dataArray["市电状态"] = "异常";
        }
        if($v[2] & 0x40){
            $dataArray["整流器状态"] = "工作中";
        }else{
            $dataArray["整流器状态"] = "未工作";
        }
        if($v[2] & 0x20){
            $dataArray["电池电量"] = "电量低";
        }else{
            $dataArray["电池电量"] = "正常";
        }
        if($v[2] & 0x10){
            $dataArray["逆变器状态"] = "工作中";
        }else{
            $dataArray["逆变器状态"] = "未工作";
        }
        if($v[2] & 0x08){
            $dataArray["电池供电状态"] = "电池供电";
        }else{
            $dataArray["电池供电状态"] = "电池未供电";
        }
        if($v[2] & 0x04){
            $dataArray["旁路状态"] = "旁路供电";
        }else{
            $dataArray["旁路状态"] = "旁路未供电";
        }
        if($v[2] & 0x02){
            $dataArray["输出断路器状态"] = "闭合";
        }else{
            $dataArray["输出断路器状态"] = "开路";
        }
        if($v[2] & 0x01){
            $dataArray["是否有旁路"] = "有";
        }else{
            $dataArray["是否有旁路"] = "无";
        }
        //breaker status
        if($v[3] & 0x80){
            $dataArray["市电输入断路器"] = "闭合";
        }else{
            $dataArray["市电输入断路器"] = "开路";
        }
        if($v[3] & 0x40){
            $dataArray["旁路断路器"] = "闭合";
        }else{
            $dataArray["旁路断路器"] = "开路";
        }
        if($v[3] & 0x20){
            $dataArray["静态开关"] = "闭合";
        }else{
            $dataArray["静态开关"] = "开路";
        }
        if($v[3] & 0x10){
            $dataArray["电池接触点"] = "闭合";
        }else{
            $dataArray["电池接触点"] = "开路";
        }
        if($v[3] & 0x08){
            $dataArray["逆变输出断路器"] = "闭合";
        }else{
            $dataArray["逆变输出断路器"] = "开路";
        }
        if($v[3] & 0x04){
            $dataArray["并联负载断路器"] = "闭合";
        }else{
            $dataArray["并联负载断路器"] = "开路";
        }
        if($v[3] & 0x02){
            $dataArray["其他断路器#1"] = "闭合";
        }else{
            $dataArray["其他断路器#1"] = "开路";
        }
        if($v[3] & 0x01){
            $dataArray["其他断路器#2"] = "闭合";
        }else{
            $dataArray["其他断路器#2"] = "开路";
        }
        $dataArray["UPS开机延迟"] = $v[4]."分钟";
        $dataArray["UPS关机延迟"] = $v[5]."分钟";
        $dataArray["UPS负载卸载延迟"] = $v[6]."秒";
        $v = unpack('f*', substr($memData, 4 + 6, 4*28));
        $dataArray['A相输入电流'] = number_format($v[1],1).' A';
        $dataArray['B相输入电流'] = number_format($v[2],1).' A';
        $dataArray['C相输入电流'] = number_format($v[3],1).' A';
        $dataArray['输出有功功率'] = number_format($v[4],1).' W';
        $dataArray['输入有功功率'] = number_format($v[5],1).' W';
        $dataArray['输出视在功率'] = number_format($v[6],1).' VA';
        $dataArray['输入视在功率'] = number_format($v[7],1).' VA';
        $dataArray['输出功率因数'] = number_format($v[8],2).'';
        $dataArray['输入功率因数'] = number_format($v[9],2).'';
        $dataArray['输出频率'] = number_format($v[10],2).' Hz';
        $dataArray['输入频率'] = number_format($v[11],2).' Hz';
        $dataArray['旁路频率'] = number_format($v[12],2).' Hz';
        $dataArray['电池组电流'] = number_format($v[13],1)." A";
        $dataArray['电池组电压'] = number_format($v[14],2).' V';
        $dataArray['电池组剩余容量'] = number_format($v[15],2);
        $dataArray['电池组剩余供电时间'] = number_format($v[16], 2);
        $dataArray['旁路A相电压'] = number_format($v[17],2).' V';
        $dataArray['旁路B相电压'] = number_format($v[18],2).' V';
        $dataArray['旁路C相电压'] = number_format($v[19],2).' V';
        $dataArray['输入A相电压'] = number_format($v[20],2).' V';
        $dataArray['输入B相电压'] = number_format($v[21],2).' V';
        $dataArray['输入C相电压'] = number_format($v[22],2).' V';
        $dataArray['负载A相电流'] = number_format($v[23],2).' A';
        $dataArray['负载B相电流'] = number_format($v[24],2).' A';
        $dataArray['负载C相电流'] = number_format($v[25],2).' A';
        $dataArray['负载A相电流比例'] = number_format($v[26], 2);
        $dataArray['负载B相电流比例'] = number_format($v[27], 2);
        $dataArray['负载C相电流比例'] = number_format($v[28], 2);
        $v = unpack('C*', substr($memData, 4 + 6 + 4*28, 8));
        $v = unpack('f*', substr($memData, 4 + 6 + 4*28 + 8, 4*3));
        $dataArray['输出A相电压'] = number_format($v[1],2).' V';
        $dataArray['输出B相电压'] = number_format($v[2],2).' V';
        $dataArray['输出C相电压'] = number_format($v[3],2).' V';
        $v = unpack('C*', substr($memData, 4 + 6 + 4*28 + 8 + 4*3, 108));
        $dataArray['逆变器交流电压过高'] = $v[1] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['逆变器交流电压过高'] = $v[1] != 0;
        $dataArray['逆变器交流电压过低'] = $v[2] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['逆变器交流电压过低'] = $v[2] != 0;
        $dataArray['逆变器频率过高或过低'] = $v[3] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['逆变器频率过高或过低'] = $v[3] != 0;
        $dataArray['旁路交流电压过高'] = $v[4] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['旁路交流电压过高'] = $v[4] != 0;
        $dataArray['旁路交流电压过低'] = $v[5] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['旁路交流电压过低'] = $v[5] != 0;
        $dataArray['旁路频率过高或过低'] = $v[6] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['旁路频率过高或过低'] = $v[6] != 0;
        $dataArray['交流输入电压过高'] = $v[7] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['交流输入电压过高'] = $v[7] != 0;
        $dataArray['交流输入电压过低'] = $v[8] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['交流输入电压过低'] = $v[8] != 0;
        $dataArray['交流输入频率过高或过低'] = $v[9] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['交流输入频率过高或过低'] = $v[9] != 0;
        $dataArray['交流输出电压过高'] = $v[10] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['交流输出电压过高'] = $v[10] != 0;
        $dataArray['交流输出电压过低'] = $v[11] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['交流输出电压过低'] = $v[11] != 0;
        $dataArray['交流输出频率过高或过低'] = $v[12] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['交流输出频率过高或过低'] = $v[12] != 0;
        $dataArray['远程紧急关机'] = $v[13] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['远程紧急关机'] = $v[13] != 0;
        $dataArray['外部干节点告警6'] = $v[14] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['外部干节点告警6'] = $v[14] != 0;
        $dataArray['外部干节点告警5'] = $v[15] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['外部干节点告警5'] = $v[15] != 0;
        $dataArray['外部干节点告警4'] = $v[16] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['外部干节点告警4'] = $v[16] != 0;
        $dataArray['外部干节点告警3'] = $v[17] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['外部干节点告警3'] = $v[17] != 0;
        $dataArray['外部干节点告警2'] = $v[18] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['外部干节点告警2'] = $v[18] != 0;
        $dataArray['外部干节点告警1'] = $v[19] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['外部干节点告警1'] = $v[19] != 0;
        $dataArray['充电机电路故障'] = $v[20] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['充电机电路故障'] = $v[20] != 0;
        $dataArray['充电机电压或电流过载'] = $v[21] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['充电机电压或电流过载'] = $v[21] != 0;
        $dataArray['逆变器过热'] = $v[22] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['逆变器过热'] = $v[22] != 0;
        $dataArray['输出过载'] = $v[23] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['输出过载'] = $v[23] != 0;
        $dataArray['逆变器输出电流过载'] = $v[24] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['逆变器输出电流过载'] = $v[24] != 0;
        $dataArray['直流链路电压过高'] = $v[25] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['直流链路电压过高'] = $v[25] != 0;
        $dataArray['直流链路电压过低'] = $v[26] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['直流链路电压过低'] = $v[26] != 0;
        $dataArray['整流器故障'] = $v[27] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['整流器故障'] = $v[27] != 0;
        $dataArray['逆变器故障'] = $v[28] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['逆变器故障'] = $v[28] != 0;
        $dataArray['电池接触器故障'] = $v[29] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['电池接触器故障'] = $v[29] != 0;
        $dataArray['旁路断路器故障'] = $v[30] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['旁路断路器故障'] = $v[30] != 0;
        $dataArray['静态开关故障'] = $v[31] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['静态开关故障'] = $v[31] != 0;
        $dataArray['电池电流限流'] = $v[32] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['电池电流限流'] = $v[32] != 0;
        $dataArray['电池接地故障'] = $v[33] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['电池接地故障'] = $v[33] != 0;
        $dataArray['非易失性存储故障'] = $v[34] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['非易失性存储故障'] = $v[34] != 0;
        $dataArray['即将关机'] = $v[35] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['即将关机'] = $v[35] != 0;
        $dataArray['电池电量低'] = $v[36] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['电池电量低'] = $v[36] != 0;
        $dataArray['市电故障'] = $v[37] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['市电故障'] = $v[37] != 0;
        $dataArray['内部通信故障'] = $v[38] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['内部通信故障'] = $v[38] != 0;
        $dataArray['电池电压高'] = $v[39] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['电池电压高'] = $v[39] != 0;
        $dataArray['内部供电故障'] = $v[40] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['内部供电故障'] = $v[40] != 0;
        $dataArray['内部主供电故障'] = $v[41] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['内部主供电故障'] = $v[41] != 0;
        $dataArray['散热器温度过高'] = $v[42] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['散热器温度过高'] = $v[42] != 0;
        $dataArray['散热器传感器失败'] = $v[43] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['散热器传感器失败'] = $v[43] != 0;
        $dataArray['整流器电流超过125%'] = $v[44] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['整流器电流超过125%'] = $v[44] != 0;
        $dataArray['收到逆变器关机命令'] = $v[45] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['收到逆变器关机命令'] = $v[45] != 0;
        $dataArray['收到转旁路命令'] = $v[46] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['收到转旁路命令'] = $v[46] != 0;
        $dataArray['A相电流限流'] = $v[47] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['A相电流限流'] = $v[47] != 0;
        $dataArray['B相电流限流'] = $v[48] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['B相电流限流'] = $v[48] != 0;
        $dataArray['C相电流限流'] = $v[49] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['C相电流限流'] = $v[49] != 0;
        $dataArray['缺少旁路'] = $v[50] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['缺少旁路'] = $v[50] != 0;
        $dataArray['电池接触器打开'] = $v[51] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['电池接触器打开'] = $v[51] != 0;
        $dataArray['逆变器接触器打开'] = $v[52] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['逆变器接触器打开'] = $v[52] != 0;
        $dataArray['逆变器温度过高'] = $v[53] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['逆变器温度过高'] = $v[53] != 0;
        $dataArray['整流器相位错'] = $v[54] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['整流器相位错'] = $v[54] != 0;
        $dataArray['旁路相位错'] = $v[55] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['旁路相位错'] = $v[55] != 0;
        $dataArray['电池完全放电'] = $v[56] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['电池完全放电'] = $v[56] != 0;
        $dataArray['缺少冗余'] = $v[57] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['缺少冗余'] = $v[57] != 0;
        $dataArray['输出断路器打开'] = $v[58] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['输出断路器打开'] = $v[58] != 0;
        $dataArray['处于手工/维护旁路模式'] = $v[59] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['处于手工/维护旁路模式'] = $v[59] != 0;
        $dataArray['电池需要维护'] = $v[60] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['电池需要维护'] = $v[60] != 0;
        $dataArray['A相2级过载'] = $v[61] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['A相2级过载'] = $v[61] != 0;
        $dataArray['B相2级过载'] = $v[62] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['B相2级过载'] = $v[62] != 0;
        $dataArray['C相2级过载'] = $v[63] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['C相2级过载'] = $v[63] != 0;
        $dataArray['A相3级过载'] = $v[64] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['A相3级过载'] = $v[64] != 0;
        $dataArray['B相3级过载'] = $v[65] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['B相3级过载'] = $v[65] != 0;
        $dataArray['C相3级过载'] = $v[66] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['C相3级过载'] = $v[66] != 0;
        $dataArray['A相4级过载'] = $v[67] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['A相4级过载'] = $v[67] != 0;
        $dataArray['B相4级过载'] = $v[68] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['B相4级过载'] = $v[68] != 0;
        $dataArray['C相4级过载'] = $v[69] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['C相4级过载'] = $v[69] != 0;
        $dataArray['UPS电池供电中'] = $v[70] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['UPS电池供电中'] = $v[70] != 0;
        $dataArray['UPS旁路供电中'] = $v[71] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['UPS旁路供电中'] = $v[71] != 0;
        $dataArray['负载关机'] = $v[72] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['负载关机'] = $v[72] != 0;
        $dataArray['电池电量低关机'] = $v[73] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['电池电量低关机'] = $v[73] != 0;
        $dataArray['检测到软件不兼容'] = $v[74] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['检测到软件不兼容'] = $v[74] != 0;
        $dataArray['逆变器温度传感器失效'] = $v[75] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['逆变器温度传感器失效'] = $v[75] != 0;
        $dataArray['暂时切换到旁路模式'] = $v[76] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['暂时切换到旁路模式'] = $v[76] != 0;
        $dataArray['旁路失败'] = $v[77] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['旁路失败'] = $v[77] != 0;
        $dataArray['自动关机命令执行'] = $v[78] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['自动关机命令执行'] = $v[78] != 0;
        $dataArray['电池测试失败'] = $v[79] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['电池测试失败'] = $v[79] != 0;
        $dataArray['保险丝失败'] = $v[80] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['保险丝失败'] = $v[80] != 0;
        $dataArray['风扇失败'] = $v[81] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['风扇失败'] = $v[81] != 0;
        $dataArray['输入线路故障'] = $v[82] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['输入线路故障'] = $v[82] != 0;
        $dataArray['电池断开'] = $v[83] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['电池断开'] = $v[83] != 0;
        $dataArray['自动关机挂起中'] = $v[84] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['自动关机挂起中'] = $v[84] != 0;
        $dataArray['启动失败-检查EPO重置'] = $v[85] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['启动失败-检查EPO重置'] = $v[85] != 0;

        $dataArray['自动启动挂起中'] = $v[86] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['自动启动挂起中'] = $v[86] != 0;
        $dataArray['调制解调器失败'] = $v[87] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['调制解调器失败'] = $v[87] != 0;
        $dataArray['调制解调器协商流程失败'] = $v[88] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['调制解调器协商流程失败'] = $v[88] != 0;
        $dataArray['输入断路器失败'] = $v[89] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['输入断路器失败'] = $v[89] != 0;
        $dataArray['模块脱离并联系统'] = $v[90] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['模块脱离并联系统'] = $v[90] != 0;
        $dataArray['逆变器输出故障'] = $v[91] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['逆变器输出故障'] = $v[91] != 0;
        $dataArray['整流器过温'] = $v[92] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['整流器过温'] = $v[92] != 0;
        $dataArray['配置错误'] = $v[93] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['配置错误'] = $v[93] != 0;

        $v = unpack('v', substr($memData, 4 + 6 + 4*28 + 8 + 4*3 + 108, 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData,  4 + 6 + 4*28 + 8 + 4*3 + 108 + 2, 5));
        $dataArray["更新时间"] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
   }
}

?>
