<?php
function Get_em300_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '[A相电压]':
            return array(0, $dataArray['A相线电压']);
        case '[B相电压]':
            return array(0, $dataArray['B相线电压']);
        case '[C相电压]':
            return array(0, $dataArray['C相线电压']);
        case '[总功率]':
            return array(0, $dataArray['总有功功率2']);
    }
    return array(1 , '设备无此信号数据:'. $varname);
}

function Get_em300_Active_Power($dataArray){
    return array(0 , $dataArray['有功总电能2']);
}

function Get_em300_RtData($memData, &$dataArray, $extraPara = false)
{
    if(empty($memData)){
        $dataArray["无数据"] = true;
        $dataArray["更新时间"] = '无';
        $dataArray["错误"] = "数据长度不一致";
    }else{
        $dataArray["无数据"] = false;
        $v = unpack('s*',substr($memData, 4, 2*34));
        $dataArray["PT"] = $pt = $v[1]/10;
        $dataArray["CT"] = $ct = $v[2]/10;

        $dataArray["L1相电压"] = number_format($v[3]/10, 2)." V";
        $dataArray["L2相电压"] = number_format($v[4]/10, 2)." V";
        $dataArray["L3相电压"] = number_format($v[5]/10, 2)." V";
        $dataArray["相电压平均值"] = number_format($v[6]/10, 2)." V";

        $dataArray["L12线电压"] = number_format($v[7]/10, 2)." V";
        $dataArray["A相线电压"] = number_format($v[7]/10, 2);
        $dataArray["L23线电压"] = number_format($v[8]/10, 2)." V";
        $dataArray["B相线电压"] = number_format($v[8]/10, 2);
        $dataArray["L31线电压"] = number_format($v[9]/10, 2)." V";
        $dataArray["C相线电压"] = number_format($v[9]/10, 2);
        $dataArray["线电压平均值"] = number_format($v[10]/10, 2)." V";

        $dataArray["I1电流"] = number_format($v[11]/1000 * $ct, 2)." A";
        $dataArray["I2电流"] = number_format($v[12]/1000 * $ct, 2)." A";
        $dataArray["I3电流"] = number_format($v[13]/1000 * $ct, 2)." A";
        $dataArray["三相电流平均值"] = number_format($v[14]/1000 * $ct, 2)." A";

        $dataArray["L1相视在功率"] = number_format($v[15]/1000*$ct, 2)." kVA";
        $dataArray["L2相视在功率"] = number_format($v[16]/1000*$ct, 2)." kVA";
        $dataArray["L3相视在功率"] = number_format($v[17]/1000*$ct, 2)." kVA";
        $dataArray["三相视在总功率"] = number_format($v[18]/1000*$ct, 2)." kVA";

        $dataArray["L1相有功功率"] = number_format($v[19]/1000*$ct, 2)." kW";
        $dataArray["L2相有功功率"] = number_format($v[20]/1000*$ct, 2)." kW";
        $dataArray["L3相有功功率"] = number_format($v[21]/1000*$ct, 2)." kW";
        $dataArray["三相有功总功率"] = number_format($v[22]/1000*$ct, 2)." kW";
        $dataArray["总有功功率2"] = number_format($v[22]/1000*$ct, 3,'.','');

        $dataArray["L1相无功功率"] = number_format($v[23]/1000*$ct, 2,'.','')." kVAr";
        $dataArray["L2相无功功率"] = number_format($v[24]/1000*$ct, 2,'.','')." kVAr";
        $dataArray["L3相无功功率"] = number_format($v[25]/1000*$ct, 2,'.','')." kVAr";
        $dataArray["三相无功总功率"] = number_format($v[26]/1000*$ct, 2,'.','')." kVAr";

        $dataArray["L1相功率因数"] = number_format($v[27]/1000, 2);
        $dataArray["L2相功率因数"] = number_format($v[28]/1000, 2);
        $dataArray["L3相功率因数"] = number_format($v[29]/1000, 2);
        $dataArray["三相功率因数"] = number_format($v[30]/1000, 2);

        $dataArray["电网频率"] = number_format($v[31]/100, 2)." Hz";
        $dataArray["零序电流"] = number_format($v[32]/1000*$ct, 2)." A";
        $dataArray["电压不平衡度"] = number_format($v[33]/1000, 2);
        $dataArray["电流不平衡度"] = number_format($v[34]/1000, 2);

        $v = unpack('f*',substr($memData, 4 + 2*34, 4*3));
        $dataArray["有功总电能"] = number_format($v[1]*$ct, 2 ,'.','')." kwh";
        $dataArray["有功总电能2"] = number_format($v[1]*$ct, 2,'.','');
        $dataArray["正向有功电能"] = number_format($v[2]*$ct, 2,'.','')." kwh";
        $dataArray["反向有功电能"] = number_format($v[3]*$ct, 2,'.','')." kwh";

        $v = unpack('v',substr($memData, 4 + 2*34 + 4*3, 2));
        $year = $v[1];
        $v = unpack('C*',substr($memData, 4 + 2*34 + 4*3 + 2,5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s',strtotime($year.'-'.$v[1].'-'.$v[2].' '.$v[3].':'.$v[4].':'.$v[5]));
    }
}

?>
