<?php
function Get_em400_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '[A相电压]':
            return array(0, $dataArray['线电压Uab(V)']);
        case '[B相电压]':
            return array(0, $dataArray['线电压Ubc(V)']);
        case '[C相电压]':
            return array(0, $dataArray['线电压Uca(V)']);
        case '[总功率]':
            return array(0, $dataArray['总有功功率2']);
        case '主开关状态':
            return array(0, $dataArray['开关量DI1状态']);
        case '次开关状态':
            return array(0, $dataArray['开关量DI2状态']);
       case '低压配电屏线电压Uab':
            return array(0, $dataArray['线电压Uab(V)']);
       case '低压配电屏线电压Ubc':
            return array(0, $dataArray['线电压Ubc(V)']);
       case '低压配电屏线电压Uca':
            return array(0, $dataArray['线电压Uca(V)']);
       case '低压配电屏相电压Ua':
            return array(0, $dataArray['相电压Ua(V)']);
      case '低压配电屏相电压Ub':
            return array(0, $dataArray['相电压Ub(V)']);
      case '低压配电屏相电压Uc':
            return array(0, $dataArray['相电压Uc(V)']);
     case '低压配电屏相电流Ia':
            return array(0, $dataArray['相电流Ia(A)']);
        case '低压配电屏相电流Ib':
            return array(0, $dataArray['相电流Ib']);
       case '低压配电屏相电流Ic':
            return array(0, $dataArray['相电流Ic(A)']);
       case '低压配电屏频率F':
            return array(0, $dataArray['频率(Hz)']);
       case '低压配电屏功率因数PF':
            return array(0, $dataArray['总功率因数']);
       case '低压配电屏总有功功率':
            return array(0, $dataArray['总有功功率(W)']);
      case '低压配电屏总无功功率':
            return array(0, $dataArray['总无功功率(Var)']);
      case '低压配电屏总视在功率':
            return array(0, $dataArray['总视在功率(Va)']);
    case '智能电表A相功率因数':
            return array(0, $dataArray['A相功率因数']);
        case '智能电表B相功率因数':
            return array(0, $dataArray['B相功率因数']);
       case '智能电表C相功率因数':
            return array(0, $dataArray['C相功率因数']);
       case '低压配电屏A相有功功率Pa':
            return array(0, $dataArray['A相有功功率(W)']);
       case '低压配电屏B相有功功率Pb':
            return array(0, $dataArray['B相有功功率(W)']);
       case '低压配电屏C相有功功率Pc':
            return array(0, $dataArray['C相有功功率(W)']);
      case '低压配电屏A相无功功率Qa':
            return array(0, $dataArray['A相无功功率(Var)']);
      case '低压配电屏B相无功功率Qb':
            return array(0, $dataArray['B相无功功率(Var)']);
     case '低压配电屏C相无功功率Qc':
            return array(0, $dataArray['C相无功功率(Var)']);
       case '低压配电屏A相视在功率Sa':
            return array(0, $dataArray['A相视在功率(VA)']);
      case '低压配电屏B相视在功率Sb':
            return array(0, $dataArray['B相视在功率(VA)']);
      case '低压配电屏C相视在功率Sc':
            return array(0, $dataArray['C相视在功率(VA)']);

    }
    return array(1 , '设备无此信号数据:'. $varname);
}

function Get_em400_Active_Power($dataArray){
    return array(0 , $dataArray['总有功绝对值电度量累计值(Kwh)']);
}

function Get_em400_RtData($memData, &$dataArray, $extraPara = false)
{
   if($memData == false) {
       $dataArray['无数据'] = true;
       $dataArray['更新时间'] = '无';
       $dataArray['错误'] = '数据长度不一致';
   } else {
        $dataArray['无数据'] = false;
        $v = unpack('C*',substr($memData, 4 , 1*4));
        $dataArray["开关量DI1状态"] = $v[1] == 1 ? "开" : "关";
        $dataArray["开关量DI2状态"] = $v[2] == 1 ? "开" : "关";
        $dataArray["开关量DI3状态"] = $v[3] == 1 ? "开" : "关";
        $dataArray["开关量DI4状态"] = $v[4] == 1 ? "开" : "关";

        $v = unpack('s*',substr($memData, 4 + 1*4 , 2*1));
        $dataArray['硬时钟异常'] = ($v[1] >> 9) & 0x1 == 1 ? '异常' : '正常';
        $dataArray['E2p读写异常'] = ($v[1] >> 12) & 0x1 == 1 ? '异常' : '正常';
        $dataArray['AD采集异常'] = ($v[1] >> 13) & 0x1 == 1 ? '异常' : '正常';

        $v = unpack('s*',substr($memData, 4 + 1*4 + 2*1 , 2*4));
        $dataArray["PT的一次电压额定值(V)"] = $pt1 = $v[1];
        $dataArray["PT的二次电压额定值(V)"] = $pt2 = $v[2];
        $dataArray["CT的一次电流额定值(A)"] = $ct1 = $v[3];
        if($v[4] == 0){
            $dataArray["CT的二次电流额定值(A)"] = $ct2 = 5;
        }else if($v[4] == 1){
            $dataArray["CT的二次电流额定值(A)"] = $ct2 = 1;
        }

        $v = unpack('S*',substr($memData, 4 + 1*4 + 2*5 , 2*14));
        $dataArray["线电压Uab(V)"] = ($v[1]/100) * ($pt1/$pt2);
        $dataArray['线电压Ubc(V)'] = ($v[2]/100) * ($pt1/$pt2);
        $dataArray['线电压Uca(V)'] = ($v[3]/100) * ($pt1/$pt2);//$v[4]保留
        $dataArray['相电压Ua(V)'] = ($v[5]/100) * ($pt1/$pt2);
        $dataArray['相电压Ub(V)'] = ($v[6]/100) * ($pt1/$pt2);
        $dataArray['相电压Uc(V)'] = ($v[7]/100) * ($pt1/$pt2);//$v[8]保留
        $dataArray['相电流Ia(A)'] = number_format(($v[9]/1000) * ($ct1/$ct2) , 2);
        $dataArray['相电流Ib(A)'] = number_format(($v[10]/1000) * ($ct1/$ct2) , 2);
        $dataArray['相电流Ic(A)'] = number_format(($v[11]/1000) * ($ct1/$ct2) , 2);//$v[13]$v[12]保留
        $dataArray['频率(Hz)'] = $v[14]/100;

        $v = unpack('s*',substr($memData, 4 + 1*4 + 2*19 , 2*16));
        $dataArray['总功率因数'] = $v[1]/1000;
        $dataArray['总有功功率(W)'] = $v[2] * ($pt1/$pt2) * ($ct1/$ct2);
        $dataArray['总有功功率2'] = $v[2] * ($pt1/$pt2) * ($ct1/$ct2) / 1000;
        $dataArray['总无功功率(Var)'] = $v[3] * ($pt1/$pt2) * ($ct1/$ct2);
        $dataArray['总视在功率(Va)'] = $v[4] * ($pt1/$pt2) * ($ct1/$ct2);
        $dataArray['A相功率因数'] = $v[5]/1000;
        $dataArray['B相功率因数'] = $v[6]/1000;
        $dataArray['C相功率因数'] = $v[7]/1000;
        $dataArray['A相有功功率(W)'] = $v[8] * ($pt1/$pt2) * ($ct1/$ct2);
        $dataArray['B相有功功率(W)'] = $v[9] * ($pt1/$pt2) * ($ct1/$ct2);
        $dataArray['C相有功功率(W)'] = $v[10] * ($pt1/$pt2) * ($ct1/$ct2);
        $dataArray['A相无功功率(Var)'] = $v[11] * ($pt1/$pt2) * ($ct1/$ct2);
        $dataArray['B相无功功率(Var)'] = $v[12] * ($pt1/$pt2) * ($ct1/$ct2);
        $dataArray['C相无功功率(Var)'] = $v[13] * ($pt1/$pt2) * ($ct1/$ct2);
        $dataArray['A相视在功率(VA)'] = $v[14] * ($pt1/$pt2) * ($ct1/$ct2);
        $dataArray['B相视在功率(VA)'] = $v[15] * ($pt1/$pt2) * ($ct1/$ct2);
        $dataArray['C相视在功率(VA)'] = $v[16] * ($pt1/$pt2) * ($ct1/$ct2);
        //EM400_REG_40200_40214_t
        $v = unpack('I*',substr($memData, 4 + 1*4 + 2*35 , 4*8));
        $dataArray['总有功绝对值电度量累计值(Kwh)'] = $v[1]/10;
        $dataArray['总无功绝对值电度量累计值(Kwarh)'] = $v[2]/10;
        $dataArray['A相有功绝对值电度量累计值(Kwh)'] = $v[3]/10;
        $dataArray['B相有功绝对值电度量累计值(Kwh)'] = $v[4]/10;
        $dataArray['C相有功绝对值电度量累计值(Kwh)'] = $v[5]/10;
        $dataArray['A相无功绝对值电度量累计值(Kwarh)'] = $v[6]/10;
        $dataArray['B相无功绝对值电度量累计值(Kwarh)'] = $v[7]/10;
        $dataArray['C相无功绝对值电度量累计值(Kwarh)'] = $v[8]/10;

       /* $v = unpack('S*',substr($memData, 4 + 1*4 + 2*35 + 4*8 , 2*17));
        $em400Obj->ia2 = ($v[3]/1000) * ($ct1/$ct2);//$v[1]$v[2]保留
        $em400Obj->ib2 = ($v[4]/1000) * ($ct1/$ct2);
        $em400Obj->ic2 = ($v[5]/1000) * ($ct1/$ct2);//$v[6]保留
        $em400Obj->uab2 = ($v[7]/100) * ($pt1/$pt2);
        $em400Obj->ubc2 = ($v[8]/100) * ($pt1/$pt2);
        $em400Obj->uca2 = ($v[9]/100) * ($pt1/$pt2);
        $em400Obj->ua2 = ($v[10]/100) * ($pt1/$pt2);
        $em400Obj->ub2 = ($v[11]/100) * ($pt1/$pt2);
        $em400Obj->uc2 = ($v[12]/100) * ($pt1/$pt2);
        $em400Obj->freq2 = $v[13]/100;
        $em400Obj->w2 = $v[14] * ($pt1/$pt2) * ($ct1/$ct2);
        $em400Obj->q2 = $v[15] * ($pt1/$pt2) * ($ct1/$ct2);
        $em400Obj->s2 = $v[16] * ($pt1/$pt2) * ($ct1/$ct2);
        $em400Obj->pf2 = $v[17]/1000;
        $v = unpack('I*',substr($memData, 4 + 1*4 + 2*52 + 4*8 , 4*2));
        $em400Obj->ep2 = $v[1]/10;
        $em400Obj->eq2 = $v[2]/10;*/
        
        $v = unpack('v', substr($memData, 4 + 1*4 + 2*52 + 4*10 ,2));
        $year = $v[1];
        $v = unpack('C*', substr($memData,  4 + 1*4 + 2*52 + 4*10 + 2 ,5));
        $dataArray["更新时间"] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
   }
}

?>