<?php

function Get_epm600k_Standard_Variable($dataArray, $varname){
    return array(1 , '设备无此信号数据:'. $varname);
}


function Get_epm600k_RtData($memData, &$dataArray, $extraPara = false)
{
        if (empty($memData)) {
            $dataArray['更新时间'] = '无';
            $dataArray['无数据'] = true;
            $dataArray['错误'] = '数据长度不一致';
        } else {
            $dataArray['无数据'] = false;
            $dataArray['AlertArray'] = array();
            //tele_c_epm600k_41_t  系统模拟量
            $dataArray['整机'] = array();
            for($i=1;$i<=12;$i++){
                $dataArray['模块'.$i] = array();
            }
            for($i=0;$i<=12;$i++){
                $key = '整机';
                if($i > 0){
                    $key = '模块'.$i;
                }
                $tMem = substr($memData, 4 + 48*$i, 48);
                $v = unpack('C', substr($tMem, 0 ,1));
                $dataArray[$key]['索引'] = $v[1];
                $v = unpack('f*', substr($tMem, 1, 4*11));
                $dataArray[$key]['A相输入电压'] = number_format($v[1] , 2).' V';
                $dataArray[$key]['B相输入电压'] = number_format($v[2] , 2).' V';
                $dataArray[$key]['C相输入电压'] = number_format($v[3] , 2).' V';
                $dataArray[$key]['A相输出电压'] = number_format($v[4] , 2).' V';
                $dataArray[$key]['B相输出电压'] = number_format($v[5] , 2).' V';
                $dataArray[$key]['C相输出电压'] = number_format($v[6] , 2).' V';
                $dataArray[$key]['A相输出电流'] = number_format($v[7] , 2).' A';
                $dataArray[$key]['B相输出电流'] = number_format($v[8] , 2).' A';
                $dataArray[$key]['C相输出电流'] = number_format($v[9] , 2).' A';
                $dataArray[$key]['电池组1电池电压'] = number_format($v[10] , 2).' V';
                $dataArray[$key]['输出频率'] = number_format($v[11] , 2).' Hz';
                $v = unpack('C*', substr($tMem, 1 + 4 * 11, 1*3));
                $dataArray[$key]['整机标识电池数量'] = $v[1];
                $dataArray[$key]['整机标识温度数量'] = $v[2];
                //$dataArray['用户自定义遥测内容数量'] = $v[3];
            }
            $offset = 4 + 48*13;
            for($i = 0 ; $i <= 12 ; $i++){
                $module = '整机';
                if($i > 0){
                    $module = '模块'.$i;
                }
                $tMem = substr($memData, $offset + 82*$i, 82);
                $v = unpack('C*', substr($tMem, 0, 2*1));
                $dataArray[$module]['模块号'] = $v[1];
                //$dataArray[$module]['模拟量个数'] = $v[2];
                $v = unpack('f*', substr($tMem, 0 + 2*1, 4*20));
                $dataArray[$module]['交流输入线电压AB'] = number_format($v[1] , 2).' V';
                $dataArray[$module]['交流输入线电压BC'] = number_format($v[2] , 2).' V';
                $dataArray[$module]['交流输入线电压CA'] = number_format($v[3] , 2).' V';
                $dataArray[$module]['A相输入电流'] = number_format($v[4] , 2).' A';
                $dataArray[$module]['B相输入电流'] = number_format($v[5] , 2).' A';
                $dataArray[$module]['C相输入电流'] = number_format($v[6] , 2).' A';
                $dataArray[$module]['输入频率'] = number_format($v[7] , 2).' Hz';
                $dataArray[$module]['A相输入功率因数'] = number_format($v[8] , 2);
                $dataArray[$module]['B相输入功率因数'] = number_format($v[9] , 2);
                $dataArray[$module]['C相输入功率因数'] = number_format($v[10] , 2);
                $dataArray[$module]['A相旁路电压'] = number_format($v[11] , 2).' V';
                $dataArray[$module]['B相旁路电压'] = number_format($v[12] , 2).' V';
                $dataArray[$module]['C相旁路电压'] = number_format($v[13] , 2).' V';
                $dataArray[$module]['旁路频率'] = number_format($v[14] , 2).' Hz';
                $dataArray[$module]['AB线输出电压'] = number_format($v[15] , 2).' V';
                $dataArray[$module]['BC线输出电压'] = number_format($v[16] , 2).' V';
                $dataArray[$module]['CA线输出电压'] = number_format($v[17] , 2).' V';
                $dataArray[$module]['AB线旁路电压'] = number_format($v[18] , 2).' V';
                $dataArray[$module]['BC线旁路电压'] = number_format($v[19] , 2).' V';
                $dataArray[$module]['CA线旁路电压'] = number_format($v[20] , 2).' V';
            }
            $offset = 4 + 48*13 + 82*13;
            for($i = 0 ; $i <= 12 ;$i++){
                $module = '整机';
                if($i > 0){
                    $module = '模块'.$i;
                }
                $tMem = substr($memData, $offset + 150*$i, 150);
                $v = unpack('C*',substr($tMem, 0, 2*1));
                //$dataArray[$module]['模块号'] = $v[1];
                //$dataArray[$module]['模拟量个数'] = $v[2];
                $v = unpack('f*', substr($tMem, 2*1, 4*37));
                $dataArray[$module]['A相输出功率因数'] = number_format($v[1] , 2);
                $dataArray[$module]['B相输出功率因数'] = number_format($v[2] , 2);
                $dataArray[$module]['C相输出功率因数'] = number_format($v[3] , 2);
                $dataArray[$module]['A相输出峰值比'] = number_format($v[4] , 2);
                $dataArray[$module]['B相输出峰值比'] = number_format($v[5] , 2);
                $dataArray[$module]['C相输出峰值比'] = number_format($v[6] , 2);
                $dataArray[$module]['A相输出有功功率'] = number_format($v[7] , 2).' KW';
                $dataArray[$module]['B相输出有功功率'] = number_format($v[8] , 2).' KW';
                $dataArray[$module]['C相输出有功功率'] = number_format($v[9] , 2).' KW';
                $dataArray[$module]['A相输出无功功率'] = number_format($v[10] , 2).' KVA';
                $dataArray[$module]['B相输出无功功率'] = number_format($v[11] , 2).' KVA';
                $dataArray[$module]['C相输出无功功率'] = number_format($v[12] , 2).' KVA';
                $dataArray[$module]['A相输出视在功率'] = number_format($v[13] , 2).' KVAR';
                $dataArray[$module]['B相输出视在功率'] = number_format($v[14] , 2).' KVAR';
                $dataArray[$module]['C相输出视在功率'] = number_format($v[15] , 2).' KVAR';
                $dataArray[$module]['A相输出负载百分比'] = number_format($v[16] , 2).' %';
                $dataArray[$module]['B相输出负载百分比'] = number_format($v[17] , 2).' %';
                $dataArray[$module]['C相输出负载百分比'] = number_format($v[18] , 2).' %';

                $dataArray[$module]['A相输出视在功率百分比'] = number_format($v[19] , 2).' %';
                $dataArray[$module]['B相输出视在功率百分比'] = number_format($v[20] , 2).' %';
                $dataArray[$module]['C相输出视在功率百分比'] = number_format($v[21] , 2).' %';

                $dataArray[$module]['A相输出有功功率百分比'] = number_format($v[22] , 2).' %';
                $dataArray[$module]['B相输出有功功率百分比'] = number_format($v[23] , 2).' %';
                $dataArray[$module]['C相输出有功功率百分比'] = number_format($v[24] , 2).' %';


                $dataArray[$module]['本机架A相主路输入视在功率'] = number_format($v[25] , 2).' kVAR';
                $dataArray[$module]['本机架B相主路输入视在功率'] = number_format($v[26] , 2).' kVAR';
                $dataArray[$module]['本机架C相主路输入视在功率'] = number_format($v[27] , 2).' kVAR';

                $dataArray[$module]['本机架A相主路输入有功功率'] = number_format($v[28] , 2).' KW';
                $dataArray[$module]['本机架B相主路输入有功功率'] = number_format($v[29] , 2).' KW';
                $dataArray[$module]['本机架C相主路输入有功功率'] = number_format($v[30] , 2).' KW';

                $dataArray[$module]['本机架A相旁路输入视在功率'] = number_format($v[31] , 2).' kVAR';
                $dataArray[$module]['本机架B相旁路输入视在功率'] = number_format($v[32] , 2).' kVAR';
                $dataArray[$module]['本机架C相旁路输入视在功率'] = number_format($v[33] , 2).' kVAR';

                $dataArray[$module]['本机架A相旁路输入有功功率'] = number_format($v[34] , 2).' KW';
                $dataArray[$module]['本机架B相旁路输入有功功率'] = number_format($v[35] , 2).' KW';
                $dataArray[$module]['本机架C相旁路输入有功功率'] = number_format($v[36] , 2).' KW';

                $dataArray[$module]['ECO模式下切换到旁路剩余时间'] = $v[37].' S';
            }
            $offset = 4 + 48*13 + 82*13 + 150 * 13;
            //tele_c_EPM600K_E3   系统状态
            $v = unpack('C*', substr($memData, $offset, 38));
            switch ($v[1]){
                case 1 : $dataArray['供电方式'] = '逆变供电'; break;
                case 2 : $dataArray['供电方式'] = '旁路供电'; break;
                case 0xE9 : $dataArray['供电方式'] = '均不供电'; break;
                default : $dataArray['供电方式'] = '无效';
            }
            //$v[2]  用户自定义数量 36
            switch ($v[3]){
                case 0xE0 : $dataArray['电池组1电池自检'] = '自检中'; break;
                case 0xE1 : $dataArray['电池组1电池自检'] = '没在自检'; break;
                default : $dataArray['电池组1电池自检'] = '无效';
            }
            switch ($v[4]){
                case 0xE0 : $dataArray['电池组1均充/浮充'] = '浮充'; break;
                case 0xE1 : $dataArray['电池组1均充/浮充'] = '均充'; break;
                case 0xE2 : $dataArray['电池组1均充/浮充'] = '非充电状态'; break;
                default : $dataArray['电池组1均充/浮充'] = '无效';
            }
            switch ($v[5]){
                case 0xE0 : $dataArray['整机开机/关机'] = '关机'; break;
                case 0xE1 : $dataArray['整机开机/关机'] = '开机'; break;
                default : $dataArray['整机开机/关机'] = '无效';
            }
            switch ($v[6]){
                case 0xE0 : $dataArray['整流器供电状态'] = '主路逆变供电'; break;
                case 0xE1 : $dataArray['整流器供电状态'] = '电池逆变供电'; break;
                //case 0xE2 : $dataArray['整流器供电状态'] = '联合逆变供电'; break;
                case 0xE3 : $dataArray['整流器供电状态'] = '整流电池均不供电'; break;
                default : $dataArray['整流器供电状态'] = '无效';
            }
            switch ($v[7]){
                case 0xE0 : $dataArray['整机发电机接入状态'] = '发电机接入'; break;
                case 0xE1 : $dataArray['整机发电机接入状态'] = '发电机没接入'; break;
                default : $dataArray['整机发电机接入状态'] = '无效';
            }
            switch ($v[8]){
                case 0xE0 : $dataArray['整机输入空开状态'] = '断开'; break;
                case 0xE1 : $dataArray['整机输入空开状态'] = '闭合'; break;
                default : $dataArray['整机输入空开状态'] = '无效';
            }
            switch ($v[9]){
                case 0xE0 : $dataArray['整机维修旁路空开状态'] = '断开'; break;
                case 0xE1 : $dataArray['整机维修旁路空开状态'] = '闭合'; break;
                default : $dataArray['整机维修旁路空开状态'] = '无效';
            }
            switch ($v[10]){
                case 0xE0 : $dataArray['整机旁路空开状态'] = '断开'; break;
                case 0xE1 : $dataArray['整机旁路空开状态'] = '闭合'; break;
                default : $dataArray['整机旁路空开状态'] = '无效';
            }
            switch ($v[11]){
                case 0xE0 : $dataArray['整机输出空开状态'] = '断开'; break;
                case 0xE1 : $dataArray['整机输出空开状态'] = '闭合'; break;
                default : $dataArray['整机输出空开状态'] = '无效';
            }
            switch ($v[12]){
                case 0xE0 : $dataArray['整机工作模式'] = '正常模式'; break;
                case 0xE1 : $dataArray['整机工作模式'] = '变频器模式'; break;
                case 0xE2 : $dataArray['整机工作模式'] = '智能并机模式'; break;
                case 0xE3 : $dataArray['整机工作模式'] = '智能并机演示模式'; break;
                case 0xE4 : $dataArray['整机工作模式'] = 'ECO模式'; break;
                case 0xE4 : $dataArray['整机工作模式'] = '智能ECO模式'; break;
                default : $dataArray['整机工作模式'] = '无效';
            }
            switch ($v[13]){
                case 0xE0 : $dataArray['机架并机系统供电状态'] = '均不供电'; break;
                case 0xE1 : $dataArray['机架并机系统供电状态'] = '旁路供电'; break;
                case 0xE2 : $dataArray['机架并机系统供电状态'] = '主路逆变供电'; break;
                case 0xE3 : $dataArray['机架并机系统供电状态'] = '电池逆变供电'; break;
                default : $dataArray['机架并机系统供电状态'] = '无效';
            }
            switch ($v[14]){
                case 0xE0 : $dataArray['模块1在线状态'] = '在线'; break;
                case 0xE1 : $dataArray['模块1在线状态'] = '不在线'; break;
                default : $dataArray['模块1在线状态'] = '无效';
            }
            switch ($v[15]){
                case 0xE0 : $dataArray['模块2在线状态'] = '在线'; break;
                case 0xE1 : $dataArray['模块2在线状态'] = '不在线'; break;
                default : $dataArray['模块2在线状态'] = '无效';
            }
            switch ($v[16]){
                case 0xE0 : $dataArray['模块3在线状态'] = '在线'; break;
                case 0xE1 : $dataArray['模块3在线状态'] = '不在线'; break;
                default : $dataArray['模块3在线状态'] = '无效';
            }
            switch ($v[17]){
                case 0xE0 : $dataArray['模块4在线状态'] = '在线'; break;
                case 0xE1 : $dataArray['模块4在线状态'] = '不在线'; break;
                default : $dataArray['模块4在线状态'] = '无效';
            }
            switch ($v[18]){
                case 0xE0 : $dataArray['模块5在线状态'] = '在线'; break;
                case 0xE1 : $dataArray['模块5在线状态'] = '不在线'; break;
                default : $dataArray['模块5在线状态'] = '无效';
            }
            switch ($v[19]){
                case 0xE0 : $dataArray['模块6在线状态'] = '在线'; break;
                case 0xE1 : $dataArray['模块6在线状态'] = '不在线'; break;
                default : $dataArray['模块6在线状态'] = '无效';
            }
            switch ($v[20]){
                case 0xE0 : $dataArray['模块7在线状态'] = '在线'; break;
                case 0xE1 : $dataArray['模块7在线状态'] = '不在线'; break;
                default : $dataArray['模块7在线状态'] = '无效';
            }
            switch ($v[21]){
                case 0xE0 : $dataArray['模块8在线状态'] = '在线'; break;
                case 0xE1 : $dataArray['模块8在线状态'] = '不在线'; break;
                default : $dataArray['模块8在线状态'] = '无效';
            }
            switch ($v[22]){
                case 0xE0 : $dataArray['模块9在线状态'] = '在线'; break;
                case 0xE1 : $dataArray['模块9在线状态'] = '不在线'; break;
                default : $dataArray['模块9在线状态'] = '无效';
            }
            switch ($v[23]){
                case 0xE0 : $dataArray['模块10在线状态'] = '在线'; break;
                case 0xE1 : $dataArray['模块10在线状态'] = '不在线'; break;
                default : $dataArray['模块10在线状态'] = '无效';
            }
            switch ($v[24]){
                case 0xE0 : $dataArray['模块11在线状态'] = '在线'; break;
                case 0xE1 : $dataArray['模块11在线状态'] = '不在线'; break;
                default : $dataArray['模块11在线状态'] = '无效';
            }
            switch ($v[25]){
                case 0xE0 : $dataArray['模块12在线状态'] = '在线'; break;
                case 0xE1 : $dataArray['模块12在线状态'] = '不在线'; break;
                default : $dataArray['模块12在线状态'] = '无效';
            }
            $dataArray['内置电池空开状态'] = $v[34] == 0xE0 ? '断开' : ($v[34] == 0xE1 ? "闭合" : '不支持');
            switch ($v[35]){
                case 0: $dataArray['BCB状态'] = '未接入'; break;
                case 0xE0 : $dataArray['BCB状态'] = '闭合'; break;
                case 0xE1 : $dataArray['BCB状态'] = '断开'; break;
                default : $dataArray['BCB状态'] = '无效';
            }
            //tele_c_EPM600K_44_t
            $offset += 38;
            $v = unpack('C*', substr($memData, $offset, 97*1));
            $dataArray['逆变器不同步告警'] = $v[1] == 3 ? '告警' : '正常';
            $dataArray['主路电压异常'] = $v[2] == 0xF0 ? '告警' : '正常';
            $dataArray['整流器故障'] = $v[3] == 0xF0 ? '告警' : '正常';
            $dataArray['逆变器故障'] = $v[4] == 0xF0 ? '告警' : '正常';
            $dataArray['旁路状态（电压或频率）'] = $v[5] == 0xF0 ? '告警' : '正常';
            switch($v[6]){
                case 0xF0: $dataArray['电池状态'] = '电压低于下限'; break;
                case 0xF1: $dataArray['电池状态'] = '电压高于上限'; break;
                case 0xF2: $dataArray['电池状态'] = '电池无'; break;
                case 0xF3: $dataArray['电池状态'] = '预告警'; break;
                case 0xF4: $dataArray['电池状态'] = '电池接反'; break;
                default : $dataArray['电池状态'] = '正常';
            }
            //7 8  标识电池数量    用户自定义告警数量
            $dataArray['ParaMonCAN通讯异常'] = $v[9] == 0xF0 ? '告警' : '正常';
            $dataArray['PowerCAN通讯异常'] = $v[10] == 0xF0 ? '告警' : '正常';

            $dataArray['AlertArray']['逆变器不同步告警'] = $v[1] == 3;
            $dataArray['AlertArray']['主路电压异常'] = $v[2] == 0xF0;
            $dataArray['AlertArray']['整流器故障'] = $v[3] == 0xF0;
            $dataArray['AlertArray']['逆变器故障'] = $v[4] == 0xF0;
            $dataArray['AlertArray']['旁路状态（电压或频率）'] = $v[5] == 0xF0;
            switch($v[6]){
                case 0xF0:
                case 0xF1:
                case 0xF2:
                case 0xF3:
                case 0xF4: $dataArray['AlertArray']['电池状态'] = true;
                default : $dataArray['AlertArray']['电池状态'] = false;
            }
            $dataArray['AlertArray']['ParaMonCAN通讯异常'] = $v[9] == 0xF0;
            $dataArray['AlertArray']['PowerCAN通讯异常'] = $v[10] == 0xF0;

            $dataArray['整流DSP程序错误'] = $v[11] == 0xF0 ? '告警' : '正常';
            $dataArray['整流FPGA程序错误'] = $v[12] == 0xF0 ? '告警' : '正常';
            $dataArray['逆变DSP程序错误'] = $v[13] == 0xF0 ? '告警' : '正常';
            $dataArray['逆变FPGA程序错误'] = $v[14] == 0xF0 ? '告警' : '正常';
            $dataArray['旁路DSP程序错误'] = $v[15] == 0xF0 ? '告警' : '正常';
            $dataArray['旁路FPGA程序错误'] = $v[16] == 0xF0 ? '告警' : '正常';
            $dataArray['机架内离散总线通讯异常'] = $v[17] == 0xF0 ? '告警' : '正常';
            $dataArray['机架间离散总线通讯异常1'] = $v[18] == 0xF0 ? '告警' : '正常';
            $dataArray['AlertArray']['整流DSP程序错误'] = $v[11] == 0xF0;
            $dataArray['AlertArray']['整流FPGA程序错误'] = $v[12] == 0xF0;
            $dataArray['AlertArray']['逆变DSP程序错误'] = $v[13] == 0xF0;
            $dataArray['AlertArray']['逆变FPGA程序错误'] = $v[14] == 0xF0;
            $dataArray['AlertArray']['旁路DSP程序错误'] = $v[15] == 0xF0;
            $dataArray['AlertArray']['旁路FPGA程序错误'] = $v[16] == 0xF0;
            $dataArray['AlertArray']['机架内离散总线通讯异常'] = $v[17] == 0xF0;
            $dataArray['AlertArray']['机架间离散总线通讯异常'] = $v[18] == 0xF0;

            $dataArray['主控模块设置不匹配'] = $v[23] == 0xF0 ? '告警' : '正常';
            $dataArray['LBS异常'] = $v[24] == 0xF0 ? '告警' : '正常';
            $dataArray['紧急关机'] = $v[25] == 0xF0 ? '告警' : '正常';
            $dataArray['旁路晶闸管故障'] = $v[26] == 0xF0 ? '告警' : '正常';
            $dataArray['旁路相序反'] = $v[27] == 0xF0 ? '告警' : '正常';
            $dataArray['旁路过流'] = $v[28] == 0xF0 ? '告警' : '正常';
            $dataArray['旁路异常关机'] = $v[29] == 0xF0 ? '告警' : '正常';
            $dataArray['切换次数限制'] = $v[30] == 0xF0 ? '告警' : '正常';
            $dataArray['AlertArray']['主控模块设置不匹配'] = $v[23] == 0xF0;
            $dataArray['AlertArray']['LBS异常'] = $v[24] == 0xF0;
            $dataArray['AlertArray']['紧急关机'] = $v[25] == 0xF0;
            $dataArray['AlertArray']['旁路晶闸管故障'] = $v[26] == 0xF0;
            $dataArray['AlertArray']['旁路相序反'] = $v[27] == 0xF0;
            $dataArray['AlertArray']['旁路过流'] = $v[28] == 0xF0;
            $dataArray['AlertArray']['旁路异常关机'] = $v[29] == 0xF0;
            $dataArray['AlertArray']['切换次数限制'] = $v[30] == 0xF0;

            $dataArray['ECO切换次数限制'] = $v[31] == 0xF0 ? '告警' : '正常';
            $dataArray['ParaPowerCAN通讯异常'] = $v[32] == 0xF0 ? '告警' : '正常';
            $dataArray['电池放电限流'] = $v[33] == 0xF0 ? '告警' : '正常';
            $dataArray['放电器故障'] = $v[34] == 0xF0 ? '告警' : '正常';
            $dataArray['充电器故障'] = $v[35] == 0xF0 ? '告警' : '正常';
            $dataArray['LBS连接线异常'] = $v[36] == 0xF0 ? '告警' : '正常';
            $dataArray['电池需维护'] = $v[37] == 0xF0 ? '需更换' : '正常';
            $dataArray['电池过温'] = $v[38] == 0xF0 ? '告警' : '正常';
            $dataArray['电池接地故障'] = $v[39] == 0xF0 ? '告警' : '正常';
            $dataArray['主路频率异常'] = $v[40] == 0xF0 ? '告警' : '正常';
            $dataArray['AlertArray']['ECO切换次数限制'] = $v[31] == 0xF0;
            $dataArray['AlertArray']['ParaPowerCAN通讯异常'] = $v[32] == 0xF0;
            $dataArray['AlertArray']['电池放电限流'] = $v[33] == 0xF0;
            $dataArray['AlertArray']['放电器故障'] = $v[34] == 0xF0;
            $dataArray['AlertArray']['充电器故障'] = $v[35] == 0xF0;
            $dataArray['AlertArray']['LBS连接线异常'] = $v[36] == 0xF0;
            $dataArray['AlertArray']['电池需维护'] = $v[37] == 0xF0;
            $dataArray['AlertArray']['电池过温'] = $v[38] == 0xF0;
            $dataArray['AlertArray']['电池接地故障'] = $v[39] == 0xF0;
            $dataArray['AlertArray']['主路频率异常'] = $v[40] == 0xF0;

            $dataArray['模块过温'] = $v[41] == 0xF0 ? '告警' : '正常';
            $dataArray['从控模块设置不匹配'] = $v[42] == 0xF0 ? '不匹配' : '正常';
            $dataArray['接口模块设置不匹配'] = $v[43] == 0xF0 ? '告警' : '正常';
            $dataArray['均充超时'] = $v[44] == 0xF0 ? '超时' : '正常';
            $dataArray['辅助电源掉电'] = $v[45] == 0xF0 ? '告警' : '正常';
            $dataArray['主路相序反'] = $v[46] == 0xF0 ? '告警' : '正常';

            $dataArray['整流器软启动失败'] = $v[47] == 0xF0 ? '失败' : '正常';
            $dataArray['用户操作错误'] = $v[48] == 0xF0 ? '错误' : '正常';
            $dataArray['输出熔丝断'] = $v[49] == 0xF0 ? '断' : '正常';
            $dataArray['输出过载'] = $v[50] == 0xF0 ? '过载' : '正常';

            $dataArray['AlertArray']['模块过温'] = $v[41] == 0xF0;
            $dataArray['AlertArray']['从控模块设置不匹配'] = $v[42] == 0xF0;
            $dataArray['AlertArray']['接口模块设置不匹配'] = $v[43] == 0xF0;
            $dataArray['AlertArray']['均充超时'] = $v[44] == 0xF0;
            $dataArray['AlertArray']['辅助电源掉电'] = $v[45] == 0xF0;
            $dataArray['AlertArray']['主路相序反'] = $v[46] == 0xF0;

            $dataArray['AlertArray']['整流器软启动失败'] = $v[47] == 0xF0;
            $dataArray['AlertArray']['用户操作错误'] = $v[48] == 0xF0;
            $dataArray['AlertArray']['输出熔丝断'] = $v[49] == 0xF0;
            $dataArray['AlertArray']['输出过载'] = $v[50] == 0xF0;

            $dataArray['系统过载'] = $v[51] == 0xF0 ? '过载' : '正常';
            $dataArray['输出过载超时'] = $v[52] == 0xF0 ? '过载超时' : '正常';
            $dataArray['负载冲击转旁路'] = $v[53] == 0xF0 ? '转旁路' : '正常';
            $dataArray['并机均流异常'] = $v[54] == 0xF0 ? '异常' : '正常';
            $dataArray['母线异常关机'] = $v[55] == 0xF0 ? '异常关机' : '正常';
            $dataArray['邻机请求转旁路'] = $v[56] == 0xF0 ? '转旁路' : '正常';
            $dataArray['直流母线过压'] = $v[57] == 0xF0 ? '过压' : '正常';
            $dataArray['MonCAN通讯异常'] = $v[58] == 0xF0 ? '异常' : '正常';
            $dataArray['输入缺零故障'] = $v[59] == 0xF0 ? '故障' : '正常';
            $dataArray['逆变继电器故障'] = $v[60] == 0xF0 ? '故障' : '正常';
            $dataArray['AlertArray']['系统过载'] = $v[51] == 0xF0;
            $dataArray['AlertArray']['输出过载超时'] = $v[52] == 0xF0;
            $dataArray['AlertArray']['负载冲击转旁路'] = $v[53] == 0xF0;
            $dataArray['AlertArray']['并机均流异常'] = $v[54] == 0xF0;
            $dataArray['AlertArray']['母线异常关机'] = $v[55] == 0xF0;
            $dataArray['AlertArray']['邻机请求转旁路'] = $v[56] == 0xF0;
            $dataArray['AlertArray']['直流母线过压'] = $v[57] == 0xF0;
            $dataArray['AlertArray']['MonCAN通讯异常'] = $v[58] == 0xF0;
            $dataArray['AlertArray']['输入缺零故障'] = $v[59] == 0xF0;
            $dataArray['AlertArray']['逆变继电器故障'] = $v[60] == 0xF0;

            $dataArray['主路反灌'] = $v[61] == 0xF0 ? '反灌' : '正常';
            $dataArray['输入电流异常'] = $v[62] == 0xF0 ? '异常' : '正常';
            $dataArray['输出电压异常'] = $v[63] == 0xF0 ? '异常' : '正常';
            $dataArray['输入电流超限'] = $v[64] == 0xF0 ? '超限' : '正常';
            $dataArray['旁路过温'] = $v[65] == 0xF0 ? '过温' : '正常';
            $dataArray['邻机旁路晶闸管故障'] = $v[66] == 0xF0 ? '故障' : '正常';
            $dataArray['并机连接线异常Para. Cable'] = $v[67] == 0xF0 ? '异常' : '正常';
            $dataArray['充电器过温'] = $v[68] == 0xF0 ? '过温' : '正常';
            $dataArray['电池端口短路'] = $v[69] == 0xF0 ? '短路' : '正常';
            $dataArray['电池房环境异常'] = $v[70] == 0xF0 ? '异常' : '正常';
            $dataArray['AlertArray']['主路反灌'] = $v[61] == 0xF0;
            $dataArray['AlertArray']['输入电流异常'] = $v[62] == 0xF0;
            $dataArray['AlertArray']['输出电压异常'] = $v[63] == 0xF0;
            $dataArray['AlertArray']['输入电流超限'] = $v[64] == 0xF0;
            $dataArray['AlertArray']['旁路过温'] = $v[65] == 0xF0;
            $dataArray['AlertArray']['邻机旁路晶闸管故障'] = $v[66] == 0xF0;
            $dataArray['AlertArray']['并机连接线异常Para. Cable'] = $v[67] == 0xF0;
            $dataArray['AlertArray']['充电器过温'] = $v[68] == 0xF0;
            $dataArray['AlertArray']['电池端口短路'] = $v[69] == 0xF0;
            $dataArray['AlertArray']['电池房环境异常'] = $v[70] == 0xF0;

            $dataArray['风扇异常'] = $v[71] == 0xF0 ? '异常' : '正常';
            $dataArray['旁路缺零故障'] = $v[72] == 0xF0 ? '故障' : '正常';
            $dataArray['旁路接管'] = $v[73] == 0xF0 ? '接管' : '正常';
            $dataArray['BCB 状态异常'] = $v[74] == 0xF0 ? '告警' : '正常';

            $dataArray['旁路SCR风扇异常'] = $v[78] == 0xF0 ? '异常' : '正常';
            $dataArray['平衡电路故障'] = $v[79] == 0xF0 ? '故障' : '正常';
            $dataArray['平衡电路过流'] = $v[80] == 0xF0 ? '过流' : '正常';
            $dataArray['AlertArray']['风扇异常'] = $v[71] == 0xF0;
            $dataArray['AlertArray']['旁路缺零故障'] = $v[72] == 0xF0;
            $dataArray['AlertArray']['旁路接管'] = $v[73] == 0xF0;
            $dataArray['AlertArray']['BCB 状态异常'] = $v[74] == 0xF0;

            $dataArray['AlertArray']['旁路SCR风扇异常'] = $v[78] == 0xF0;
            $dataArray['AlertArray']['平衡电路故障'] = $v[79] == 0xF0;
            $dataArray['AlertArray']['平衡电路过流'] = $v[80] == 0xF0;

            $dataArray['平衡电路过温'] = $v[81] == 0xF0 ? '过温' : '正常';
            $dataArray['失去冗余'] = $v[82] == 0xF0 ? '故障' : '正常';
            $dataArray['容量过载'] = $v[83] == 0xF0 ? '过载' : '正常';
            $dataArray['功率板设置不匹配'] = $v[84] == 0xF0 ? '不匹配' : '正常';
            $dataArray['旁路设置不匹配'] = $v[85] == 0xF0 ? '不匹配' : '正常';
            $dataArray['上抽风风扇异常'] = $v[86] == 0xF0 ? '异常' : '正常';

            $dataArray['旁路无效'] = $v[90] == 0xF0 ? '告警' : '正常';
            $dataArray['AlertArray']['平衡电路过温'] = $v[81] == 0xF0;
            $dataArray['AlertArray']['失去冗余'] = $v[82] == 0xF0;
            $dataArray['AlertArray']['容量过载'] = $v[83] == 0xF0;
            $dataArray['AlertArray']['功率板设置不匹配'] = $v[84] == 0xF0;
            $dataArray['AlertArray']['旁路设置不匹配'] = $v[85] == 0xF0;
            $dataArray['AlertArray']['上抽风风扇异常'] = $v[86] == 0xF0;

            $dataArray['AlertArray']['旁路无效'] = $v[90] == 0xF0;

            $dataArray['整流器过流'] = $v[91] == 0xF0 ? '告警' : '正常';
            $dataArray['旁路过流超时'] = $v[92] == 0xF0 ? '告警' : '正常';
            $dataArray['AlertArray']['整流器过流'] = $v[91] == 0xF0;
            $dataArray['AlertArray']['旁路过流超时'] = $v[92] == 0xF0;

            $dataArray['输出零地过压'] = $v[93] == 0xF0 ? '过压' : '正常';
            $dataArray['系统主路熔丝断'] = $v[94] == 0xF0 ? '断' : '正常';
            $dataArray['旁路熔丝断'] = $v[95] == 0xF0 ? '断' : '正常';
            $dataArray['模块未就绪'] = $v[96] == 0xF0 ? '断' : '正常';
            $dataArray['并机系统容量过载'] = $v[97] == 0xF0 ? '断' : '正常';
            $dataArray['AlertArray']['输出零地过压'] = $v[93] == 0xF0;
            $dataArray['AlertArray']['系统主路熔丝断'] = $v[94] == 0xF0;
            $dataArray['AlertArray']['旁路熔丝断'] = $v[95] == 0xF0;
            $dataArray['AlertArray']['模块未就绪'] = $v[96] == 0xF0;
            $dataArray['AlertArray']['并机系统容量过载'] = $v[97] == 0xF0;

            //e3
            $offset += 97;
            $v = unpack('f*', substr($memData, $offset + 1, 4*10));
            $dataArray["系统A相输出有功功率"] = number_format($v[1] , 2).' KW';
            $dataArray["系统B相输出有功功率"] = number_format($v[2] , 2).' KW';
            $dataArray["系统C相输出有功功率"] = number_format($v[3] , 2).' KW';

            $dataArray["系统A相输出视在功率"] = number_format($v[4] , 2).' KVAR';
            $dataArray["系统B相输出视在功率"] = number_format($v[5] , 2).' KVAR';
            $dataArray["系统C相输出视在功率"] = number_format($v[6] , 2).' KVAR';

            $dataArray["系统A相输出无功功率"] = number_format($v[7] , 2).' KVA';
            $dataArray["系统B相输出无功功率"] = number_format($v[8] , 2).' KVA';
            $dataArray["系统C相输出无功功率"] = number_format($v[9] , 2).' KVA';

            $dataArray["整机环境温度"] = number_format($v[10] , 2);
            $offset += 41;
            //e7
            $v = unpack('f*', substr($memData, $offset + 2, 4*8));
            $dataArray["电池后备时间"] = number_format($v[1] , 2);
            $dataArray["正电池电压"] = number_format($v[2] , 2);
            $dataArray["正电池电流"] = number_format($v[3] , 2);

            $dataArray["负电池电压"] = number_format($v[4] , 2);
            $dataArray["负电池电流"] = number_format($v[5] , 2);
            $dataArray["电池老化系数"] = number_format($v[6] , 2);

            $dataArray["电池温度"] = number_format($v[7] , 2);
            $dataArray["环境温度"] = number_format($v[8] , 2);

            $offset += 34;
            $v = unpack('v', substr($memData, $offset, 2));
            $year = $v[1];
            $v = unpack('C*', substr($memData, $offset + 2, 5));
            $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
        }
}
