<?php
function Get_et903_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '[A相电压]':
            return array(0, $dataArray['线电压U12']);
        case '[B相电压]':
            return array(0, $dataArray['线电压U23']);
        case '[C相电压]':
            return array(0, $dataArray['线电压U31']);
        case "[总功率]":
            return array(0, $dataArray['总有功功率2']);
    }
    return array(1 , '设备无此信号数据:'. $varname);
}

function Get_et903_Active_Power($dataArray){
    return array(0 , $dataArray['正向有功电能2']);
}

function Get_et903_RtData($memData, &$dataArray, $extraPara = false)
{
   if($memData == false) {
       $dataArray['无数据'] = true;
       $dataArray['更新时间'] = '无';
       $dataArray['错误'] = '数据长度不一致';
   } else {
        $dataArray['无数据'] = false;
        $v = unpack('S',substr($memData, 4 , 2));
	$ct = intval($v[1]);
        $dataArray["CT"] = $ct;
        $v = unpack('S*',substr($memData, 4 + 2, 2*12));
        $dataArray["相电压U1"] = ($v[1]/10).' V';
        $dataArray["相电压U2"] = ($v[2]/10).' V';
        $dataArray["相电压U3"] = ($v[3]/10).' V';
        $dataArray["三相平均相电压"] = ($v[4]/10).' V';

        $dataArray["线电压U12"] = ($v[5]/10).' V';
        $dataArray["线电压U23"] = ($v[6]/10).' V';
        $dataArray["线电压U31"] = ($v[7]/10).' V';
        $dataArray["三相平均线电压"] = ($v[8]/10).' V';

        $dataArray["第1相电流"] = ($ct * $v[9]/1000).' A';
        $dataArray["第2相电流"] = ($ct * $v[10]/1000).' A';
        $dataArray["第3相电流"] = ($ct * $v[11]/1000).' A';
        $dataArray["三相平均电流"] = ($ct * $v[12]/1000).' A';

        $v = unpack('s*',substr($memData, 4 + 2 + 2*12, 2*16));
        $dataArray["1相有功功率"] = ($ct * $v[1]/1000)." KW";
        $dataArray["2相有功功率"] = ($ct * $v[2]/1000)." KW";
        $dataArray["3相有功功率"] = ($ct * $v[3]/1000)." KW";
        $dataArray["系统有功功率"] = ($ct * $v[4]/1000)." KW";

        $dataArray["1相无功功率"] = ($ct * $v[5]/1000)." Kvar";
        $dataArray["2相无功功率"] = ($ct * $v[6]/1000)." Kvar";
        $dataArray["3相无功功率"] = ($ct * $v[7]/1000)." Kvar";
        $dataArray["系统无功功率"] = ($ct * $v[8]/1000)." Kvar";

        $dataArray["1相视在功率"] = ($ct * $v[9]/1000)." KVA";
        $dataArray["2相视在功率"] = ($ct * $v[10]/1000)." KVA";
        $dataArray["3相视在功率"] = ($ct * $v[11]/1000)." KVA";
        $dataArray["系统视在功率"] = ($ct * $v[12]/1000)." KVA";

        $dataArray["1相功率因数"] = $v[13]/10000;
        $dataArray["2相功率因数"] = $v[14]/10000;
        $dataArray["3相功率因数"] = $v[15]/10000;
        $dataArray["系统功率因数"] = $v[16]/10000;

        $v = unpack('S',substr($memData, 4 + 2 + 2*12 + 2*16, 2));
        $dataArray["频率"] = ($v[1]/1000)." Hz";
	
	$v=  unpack('S',substr($memData, 4 + 2 + 2*12 + 2*16 + 2, 2));
	$dataArray["DI1"] = ($v[1]&0x1) ? "闭合" : "断开";
	$dataArray["DI2"] = (($v[1]>>1)&0x1) ? "闭合" : "断开";
	$dataArray["DI3"] = (($v[1]>>2)&0x1) ? "闭合" : "断开";
	$dataArray["DI4"] = (($v[1]>>3)&0x1) ? "闭合" : "断开";

	$dataArray["DO1"] = (($v[1]>>8)&0x1) ? "闭合" : "断开";
	$dataArray["DO2"] = (($v[1]>>9)&0x1) ? "闭合" : "断开";
	$dataArray["DO3"] = (($v[1]>>10)&0x1) ? "闭合" : "断开";
	$dataArray["DO4"] = (($v[1]>>11)&0x1) ? "闭合" : "断开";

        $v = unpack('I*',substr($memData, 4 + 2 + 2*30 , 4*4));
        $dataArray["正向有功电能"] = ($ct * $v[1]/1000)." KWH";
        $dataArray["反向有功电能"] = ($ct * $v[2]/1000)." KWH";
        $dataArray["正向无功电能"] = ($ct * $v[3]/1000)." KWH";
        $dataArray["反向无功电能"] = ($ct * $v[4]/1000)." KWH";

        $v = unpack('v', substr($memData, 4 + 2 + 2*30 + 4*4 ,2));
        $year = $v[1];
        $v = unpack('C*', substr($memData,  4 + 2 + 2*30 + 4*4 + 2 ,5));
        $dataArray["更新时间"] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}
