<?php
function Get_ex8_33_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '[A相电压]':
            return array(0, $dataArray['A相电压2']);
        case '[B相电压]':
            return array(0, $dataArray['B相电压2']);
        case '[C相电压]':
            return array(0, $dataArray['C相电压2']);
        case "[总功率]":
            return array(0, $dataArray['总有功功率2']);
    }
    return array(1 , '设备无此信号数据:'. $varname);
}

function Get_ex8_33_Active_Power($dataArray){
    return array(0 , $dataArray['正向有功总电能2']);
}

function Get_ex8_33_RtData($memData , &$dataArray , $extraPara = false)
{
        if (empty($memData)){
            $dataArray['无数据'] = true;
            $dataArray['更新时间'] = '无';
            $dataArray['错误'] = '数据长度不一致';
        }else {
            $dataArray['无数据'] = false;
            $dataArray['AlertArray'] = array();
            //REG_0_7_t
            $v = unpack('S*', substr($memData, 4, 2 * 8));
            switch($v[1]){
                case 0xE081 : $dataArray['电表型号'] = 'EX8-33-Ⅰ'; break;
                case 0xE082 : $dataArray['电表型号'] = 'EX8-33-Ⅱ'; break;
                case 0xE083 : $dataArray['电表型号'] = 'EX8-33-Ⅲ'; break;
                case 0xE084 : $dataArray['电表型号'] = 'EX8-33-Ⅳ'; break;
                default : $dataArray['电表型号'] = '无效';
            }
            $dataArray['电压量程'] = $v[2].' V';
            $U0 = $v[2];
            $dataArray['电流量程'] = ($v[3] / 10).' A';
            $I0 = $v[3]/10;
            $dataArray['设备地址'] = $v[4];
            switch($v[5]){
                case 0 : $dataArray['数据格式位'] = '10位，即(n,8,1)'; break;
                case 1 : $dataArray['数据格式位'] = '11位，偶校验，即(e,8,1)'; break;
                case 2 : $dataArray['数据格式位'] = '11位，奇校验，(o,8,1)'; break;
                case 3 : $dataArray['数据格式位'] = '11位，无校验，2停止位，(n,8,2)'; break;
                default : $dataArray['数据格式位'] = '无效';
            }
            switch($v[6]){
                case 3 : $dataArray['波特率'] = '1200 BPS'; break;
                case 4 : $dataArray['波特率'] = '2400 BPS'; break;
                case 5 : $dataArray['波特率'] = '4800 BPS'; break;
                case 6 : $dataArray['波特率'] = '9600 BPS'; break;
                case 7 : $dataArray['波特率'] = '19200 BPS'; break;
                default : $dataArray['波特率'] = '无效';
            }
            $dataArray['电压变比'] = $Ubb = $v[7];
            $dataArray['电流变比'] = $Ibb = $v[8];
            
            $v = unpack('C*', substr($memData, 20, 4 * 1));
            $dataArray['数据更新周期'] = ($v[1] * 10).' mS';
            $dataArray['A相电流穿心方向'] = $v[2] == 0 ? '正常接入' : '反向接入';
            $dataArray['B相电流穿心方向'] = $v[3] == 0 ? '正常接入' : '反向接入';
            $dataArray['C相电流穿心方向'] = $v[4] == 0 ? '正常接入' : '反向接入';
            
            $v = unpack('S*', substr($memData, 24, 2 * 1));
            $dataArray['背光点亮时间'] = ($v[1]).' S';
            //REG_C_16_t
            $v = unpack('f*', substr($memData, 26 , 4 * 6));
            $dataArray['正向有功总电能'] = number_format($v[1] , 2 , '.' ,'').' KWh';
            $dataArray['正向有功总电能2'] = number_format($v[1] , 2 , '.' ,'');
            $dataArray['反向有功总电能'] = number_format($v[2] , 2 , '.' ,'').' KWh';
            $dataArray['正向无功总电能'] = number_format($v[3] , 2 , '.' ,'').' Kvarh';
            $dataArray['反向无功总电能'] = number_format($v[4] , 2 , '.' ,'').' Kvarh';
            $dataArray['有功总电能'] = number_format($v[5] , 2 , '.' ,'').' KWh';
            $dataArray['无功总电能'] = number_format($v[6] , 2 , '.' ,'').' Kvarh';
            //REG_40_49_t
            $v = unpack('f*', substr($memData, 50 , 4 * 10));
            $dataArray['A相相电压'] = number_format($v[1] , 2).' V';
            $dataArray['B相相电压'] = number_format($v[2] , 2).' V';
            $dataArray['C相相电压'] = number_format($v[3] , 2).' V';
            $dataArray['AB线电压'] = number_format($v[4] , 2).' V';
            $dataArray['BC线电压'] = number_format($v[5] , 2).' V';
            $dataArray['AC线电压'] = number_format($v[6] , 2).' V';
            $dataArray['A相电压2'] = number_format($v[4] , 2);
            $dataArray['B相电压2'] = number_format($v[5] , 2);
            $dataArray['C相电压2'] = number_format($v[6] , 2);
            $dataArray['A相电流'] = number_format($v[7] , 2).' A';
            $dataArray['B相电流'] = number_format($v[8] , 2).' A';
            $dataArray['C相电流'] = number_format($v[9] , 2).' A';
            $dataArray['有功功率'] = number_format($v[10] , 2).' W';
            $dataArray['总有功功率2'] = number_format($v[10] / 1000 , 3 ,'.','');
            //REG_28_2A_t
            $v = unpack('f*', substr($memData, 90 , 4 * 3));
            //ia ib ic 阈值
            $v = unpack('v', substr($memData, 102 , 2));
            $year = $v[1];
            $v = unpack('C*', substr($memData, 104 , 5));
            $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
        }
}
