<?php
function _exm2ups_ShowAlert(&$dataArray, $label, $value, $vsValue)
{
    $dataArray[$label] = $value == $vsValue ? '正常' : '告警';
    $dataArray['AlertArray'][$label] = $value != $vsValue;
}


function Get_exm2ups_RtData($memData, &$dataArray, $extraPara = false){
    if($memData == false){
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    }else{
        $dataArray['无数据'] = false;
        $dataArray['AlertArray'] = array();
        $offset = 4;
            $v = unpack("S*" , substr($memData , $offset, 2*9));
      
        $dataArray["系统A相输出有功功率"] = number_format($v[1]/100, 2)."kW";
      

      
        $dataArray["系统B相输出有功功率"] = number_format($v[2]/100, 2)."kW";
      

      
        $dataArray["系统C相输出有功功率"] = number_format($v[3]/100, 2)."kW";
      

      
        $dataArray["系统A相输出视在功率"] = number_format($v[4]/100, 2)."kVar";
      

      
        $dataArray["系统B相输出视在功率"] = number_format($v[5]/100, 2)."kVar";
      

      
        $dataArray["系统C相输出视在功率"] = number_format($v[6]/100, 2)."kVar";
      

      
        $dataArray["系统A相输出无功功率"] = number_format($v[7]/100, 2)."kVA";
      

      
        $dataArray["系统B相输出无功功率"] = number_format($v[8]/100, 2)."kVA";
      

      
        $dataArray["系统C相输出无功功率"] = number_format($v[9]/100, 2)."kVA";
      

      $offset += 18;

            $v = unpack("S*" , substr($memData , $offset, 2*4));
      
        $dataArray["整机基本模块数"] = number_format($v[1], 2);
      

      
        $dataArray["整机冗余模块数"] = number_format($v[2], 2);
      

      
        $dataArray["整机授权容量"] = number_format($v[3], 2)."kVA";
      

      
        $dataArray["铭牌功率"] = number_format($v[4], 2)."kVA";
      

      $offset += 8;

            $v = unpack("S*" , substr($memData , $offset, 2*6));
      
        $dataArray["A相输入电压"] = number_format($v[1]/10, 2)."V";
      

      
        $dataArray["B相输入电压"] = number_format($v[2]/10, 2)."V";
      

      
        $dataArray["C相输入电压"] = number_format($v[3]/10, 2)."V";
      

      
        $dataArray["A相输出电压"] = number_format($v[4]/10, 2)."V";
      

      
        $dataArray["B相输出电压"] = number_format($v[5]/10, 2)."V";
      

      
        $dataArray["C相输出电压"] = number_format($v[6]/10, 2)."V";
      

      $offset += 12;

            $v = unpack("s*" , substr($memData , $offset, 2*3));
      
        $dataArray["A相输出电流"] = number_format($v[1]/10, 2)."A";
      

      
        $dataArray["B相输出电流"] = number_format($v[2]/10, 2)."A";
      

      
        $dataArray["C相输出电流"] = number_format($v[3]/10, 2)."A";
      

      $offset += 6;

            $v = unpack("S*" , substr($memData , $offset, 2*2));
      
        $dataArray["电池电压"] = number_format($v[1]/10, 2)."V";
      

      
        $dataArray["输出频率"] = number_format($v[2]/10, 2)."Hz";
      

      $offset += 4;

            $v = unpack("S*" , substr($memData , $offset, 2*3));
      
        $dataArray["AB线输入电压"] = number_format($v[1]/10, 2)."V";
      

      
        $dataArray["BC线输入电压"] = number_format($v[2]/10, 2)."V";
      

      
        $dataArray["CA线输入电压"] = number_format($v[3]/10, 2)."V";
      

      $offset += 6;

            $v = unpack("s*" , substr($memData , $offset, 2*3));
      
        $dataArray["A相输入电流"] = number_format($v[1]/10, 2)."A";
      

      
        $dataArray["B相输入电流"] = number_format($v[2]/10, 2)."A";
      

      
        $dataArray["C相输入电流"] = number_format($v[3]/10, 2)."A";
      

      $offset += 6;

            $v = unpack("S*" , substr($memData , $offset, 2*1));
      
        $dataArray["输入频率"] = number_format($v[1]/100, 2)."Hz";
      

      $offset += 2;

            $v = unpack("s*" , substr($memData , $offset, 2*3));
      
        $dataArray["A相输入功率因数"] = number_format($v[1]/100, 2);
      

      
        $dataArray["B相输入功率因数"] = number_format($v[2]/100, 2);
      

      
        $dataArray["C相输入功率因数"] = number_format($v[3]/100, 2);
      

      $offset += 6;

            $v = unpack("S*" , substr($memData , $offset, 2*22));
      
        $dataArray["A相旁路电压"] = number_format($v[1]/10, 2)."V";
      

      
        $dataArray["B相旁路电压"] = number_format($v[2]/10, 2)."V";
      

      
        $dataArray["C相旁路电压"] = number_format($v[3]/10, 2)."V";
      

      
        $dataArray["旁路频率"] = number_format($v[4]/100, 2)."Hz";
      

      
        $dataArray["AB线输出电压"] = number_format($v[5]/100, 2)."V";
      

      
        $dataArray["BC线输出电压"] = number_format($v[6]/100, 2)."V";
      

      
        $dataArray["CA线输出电压"] = number_format($v[7]/100, 2)."V";
      

      
        $dataArray["AB线旁路电压"] = number_format($v[8]/100, 2)."V";
      

      
        $dataArray["BC线旁路电压"] = number_format($v[9]/100, 2)."V";
      

      
        $dataArray["CA线旁路电压"] = number_format($v[10]/100, 2)."V";
      

      
        $dataArray["A相输入有功功率"] = number_format($v[11]/100, 2)."kW";
      

      
        $dataArray["B相输入有功功率"] = number_format($v[12]/100, 2)."kW";
      

      
        $dataArray["C相输入有功功率"] = number_format($v[13]/100, 2)."kW";
      

      
        $dataArray["A相输入视在功率"] = number_format($v[14]/100, 2)."kVar";
      

      
        $dataArray["B相输入视在功率"] = number_format($v[15]/100, 2)."kVar";
      

      
        $dataArray["C相输入视在功率"] = number_format($v[16]/100, 2)."kVar";
      

      
        $dataArray["A相输入电能"] = ((($v[17]<<16) | $v[18]))."kWh";
      

      
        $dataArray["B相输入电能"] = ((($v[19]<<16) | $v[20]))."kWh";
      

      
        $dataArray["C相输入电能"] = ((($v[21]<<16) | $v[22]))."kWh";
      

      $offset += 44;

            $v = unpack("s*" , substr($memData , $offset, 2*3));
      
        $dataArray["A相输出功率因数"] = number_format($v[1]/100, 2);
      

      
        $dataArray["B相输出功率因数"] = number_format($v[2]/100, 2);
      

      
        $dataArray["C相输出功率因数"] = number_format($v[3]/100, 2);
      

      $offset += 6;

            $v = unpack("S*" , substr($memData , $offset, 2*24));
      
        $dataArray["A相输出峰值比"] = number_format($v[1]/100, 2);
      

      
        $dataArray["B相输出峰值比"] = number_format($v[2]/100, 2);
      

      
        $dataArray["C相输出峰值比"] = number_format($v[3]/100, 2);
      

      
        $dataArray["A相输出有功功率"] = number_format($v[4]/100, 2)."kW";
      

      
        $dataArray["B相输出有功功率"] = number_format($v[5]/100, 2)."kW";
      

      
        $dataArray["C相输出有功功率"] = number_format($v[6]/kW, 2);
      

      
        $dataArray["A相输出无功功率"] = number_format($v[7]/100, 2)."kVar";
      

      
        $dataArray["B相输出无功功率"] = number_format($v[8]/100, 2)."kVar";
      

      
        $dataArray["C相输出无功功率"] = number_format($v[9]/kVar, 2);
      

      
        $dataArray["A相输出视在功率"] = number_format($v[10]/100, 2)."kVA";
      

      
        $dataArray["B相输出视在功率"] = number_format($v[11]/100, 2)."kVA";
      

      
        $dataArray["C相输出视在功率"] = number_format($v[12]/kVA, 2);
      

      
        $dataArray["A相输出负载百分比"] = number_format($v[13]/100, 2);
      

      
        $dataArray["B相输出负载百分比"] = number_format($v[14]/100, 2);
      

      
        $dataArray["C相输出负载百分比"] = number_format($v[15]/100, 2);
      

      
        $dataArray["输出电能A"] = ((($v[19]<<16) | $v[20]))."kWh";
      

      
        $dataArray["输出电能B"] = ((($v[21]<<16) | $v[22]))."kWh";
      

      
        $dataArray["输出电能C"] = ((($v[23]<<16) | $v[24]))."kWh";
      

      $offset += 48;

            $v = unpack("S*" , substr($memData , $offset, 2*1));
      
        $dataArray["电池后备时间"] = number_format($v[1], 2)."分钟";
      

      $offset += 2;

            $v = unpack("s*" , substr($memData , $offset, 2*4));
      
        $dataArray["正电池电压"] = number_format($v[1]/100, 2)."V";
      

      
        $dataArray["正电池电流"] = number_format($v[2]/100, 2)."A";
      

      
        $dataArray["负电池电压"] = number_format($v[3]/100, 2)."V";
      

      
        $dataArray["负电池电流"] = number_format($v[4]/100, 2)."A";
      

      $offset += 8;

            $v = unpack("S*" , substr($memData , $offset, 2*3));
      
        $dataArray["电池老化系数"] = number_format($v[1]/100, 2);
      

      
        $dataArray["电池温度"] = number_format($v[2]/10, 2)."°C";
      

      
        $dataArray["环境温度"] = number_format($v[3]/10, 2)."°C";
      

      $offset += 6;

            
            for($cgIndex = 1400,$index = 1; $cgIndex < 4400; $cgIndex+=200, $index++){
              $namePrefix = sprintf("模块%d数据", $index);
            $v = unpack("S*" , substr($memData , $offset, 2*6));
      
        $dataArray[$namePrefix."A相输入电压"] = number_format($v[1]/10, 2)."V";
      

      
        $dataArray[$namePrefix."B相输入电压"] = number_format($v[2]/10, 2)."V";
      

      
        $dataArray[$namePrefix."C相输入电压"] = number_format($v[3]/10, 2)."V";
      

      
        $dataArray[$namePrefix."A相输出电压"] = number_format($v[4]/10, 2)."V";
      

      
        $dataArray[$namePrefix."B相输出电压"] = number_format($v[5]/10, 2)."V";
      

      
        $dataArray[$namePrefix."C相输出电压"] = number_format($v[6]/10, 2)."V";
      

      $offset += 12;

            $v = unpack("s*" , substr($memData , $offset, 2*3));
      
        $dataArray[$namePrefix."A相输出电流"] = number_format($v[1]/10, 2)."A";
      

      
        $dataArray[$namePrefix."B相输出电流"] = number_format($v[2]/10, 2)."A";
      

      
        $dataArray[$namePrefix."C相输出电流"] = number_format($v[3]/10, 2)."A";
      

      $offset += 6;

            $v = unpack("S*" , substr($memData , $offset, 2*2));
      
        $dataArray[$namePrefix."电池电压"] = number_format($v[1]/10, 2)."V";
      

      
        $dataArray[$namePrefix."输出频率"] = number_format($v[2]/10, 2)."Hz";
      

      $offset += 4;

            $v = unpack("S*" , substr($memData , $offset, 2*3));
      
        $dataArray[$namePrefix."AB线输入电压"] = number_format($v[1]/10, 2)."V";
      

      
        $dataArray[$namePrefix."BC线输入电压"] = number_format($v[2]/10, 2)."V";
      

      
        $dataArray[$namePrefix."CA线输入电压"] = number_format($v[3]/10, 2)."V";
      

      $offset += 6;

            $v = unpack("s*" , substr($memData , $offset, 2*3));
      
        $dataArray[$namePrefix."A相输入电流"] = number_format($v[1]/10, 2)."A";
      

      
        $dataArray[$namePrefix."B相输入电流"] = number_format($v[2]/10, 2)."A";
      

      
        $dataArray[$namePrefix."C相输入电流"] = number_format($v[3]/10, 2)."A";
      

      $offset += 6;

            $v = unpack("S*" , substr($memData , $offset, 2*1));
      
        $dataArray[$namePrefix."输入频率"] = number_format($v[1]/100, 2)."Hz";
      

      $offset += 2;

            $v = unpack("s*" , substr($memData , $offset, 2*3));
      
        $dataArray[$namePrefix."A相输入功率因数"] = number_format($v[1]/100, 2);
      

      
        $dataArray[$namePrefix."B相输入功率因数"] = number_format($v[2]/100, 2);
      

      
        $dataArray[$namePrefix."C相输入功率因数"] = number_format($v[3]/100, 2);
      

      $offset += 6;

            $v = unpack("S*" , substr($memData , $offset, 2*22));
      
        $dataArray[$namePrefix."A相旁路电压"] = number_format($v[1]/10, 2)."V";
      

      
        $dataArray[$namePrefix."B相旁路电压"] = number_format($v[2]/10, 2)."V";
      

      
        $dataArray[$namePrefix."C相旁路电压"] = number_format($v[3]/10, 2)."V";
      

      
        $dataArray[$namePrefix."旁路频率"] = number_format($v[4]/100, 2)."Hz";
      

      
        $dataArray[$namePrefix."AB线输出电压"] = number_format($v[5]/100, 2)."V";
      

      
        $dataArray[$namePrefix."BC线输出电压"] = number_format($v[6]/100, 2)."V";
      

      
        $dataArray[$namePrefix."CA线输出电压"] = number_format($v[7]/100, 2)."V";
      

      
        $dataArray[$namePrefix."AB线旁路电压"] = number_format($v[8]/100, 2)."V";
      

      
        $dataArray[$namePrefix."BC线旁路电压"] = number_format($v[9]/100, 2)."V";
      

      
        $dataArray[$namePrefix."CA线旁路电压"] = number_format($v[10]/100, 2)."V";
      

      
        $dataArray[$namePrefix."A相输入有功功率"] = number_format($v[11]/100, 2)."kW";
      

      
        $dataArray[$namePrefix."B相输入有功功率"] = number_format($v[12]/100, 2)."kW";
      

      
        $dataArray[$namePrefix."C相输入有功功率"] = number_format($v[13]/100, 2)."kW";
      

      
        $dataArray[$namePrefix."A相输入视在功率"] = number_format($v[14]/100, 2)."kVar";
      

      
        $dataArray[$namePrefix."B相输入视在功率"] = number_format($v[15]/100, 2)."kVar";
      

      
        $dataArray[$namePrefix."C相输入视在功率"] = number_format($v[16]/100, 2)."kVar";
      

      
        $dataArray[$namePrefix."A相输入电能"] = ((($v[17]<<16) | $v[18]))."kWh";
      

      
        $dataArray[$namePrefix."B相输入电能"] = ((($v[19]<<16) | $v[20]))."kWh";
      

      
        $dataArray[$namePrefix."C相输入电能"] = ((($v[21]<<16) | $v[22]))."kWh";
      

      $offset += 44;

            $v = unpack("s*" , substr($memData , $offset, 2*3));
      
        $dataArray[$namePrefix."A相输出功率因数"] = number_format($v[1]/100, 2);
      

      
        $dataArray[$namePrefix."B相输出功率因数"] = number_format($v[2]/100, 2);
      

      
        $dataArray[$namePrefix."C相输出功率因数"] = number_format($v[3]/100, 2);
      

      $offset += 6;

            $v = unpack("S*" , substr($memData , $offset, 2*24));
      
        $dataArray[$namePrefix."A相输出峰值比"] = number_format($v[1]/100, 2);
      

      
        $dataArray[$namePrefix."B相输出峰值比"] = number_format($v[2]/100, 2);
      

      
        $dataArray[$namePrefix."C相输出峰值比"] = number_format($v[3]/100, 2);
      

      
        $dataArray[$namePrefix."A相输出有功功率"] = number_format($v[4]/100, 2)."kW";
      

      
        $dataArray[$namePrefix."B相输出有功功率"] = number_format($v[5]/100, 2)."kW";
      

      
        $dataArray[$namePrefix."C相输出有功功率"] = number_format($v[6]/kW, 2);
      

      
        $dataArray[$namePrefix."A相输出无功功率"] = number_format($v[7]/100, 2)."kVar";
      

      
        $dataArray[$namePrefix."B相输出无功功率"] = number_format($v[8]/100, 2)."kVar";
      

      
        $dataArray[$namePrefix."C相输出无功功率"] = number_format($v[9]/kVar, 2);
      

      
        $dataArray[$namePrefix."A相输出视在功率"] = number_format($v[10]/100, 2)."kVA";
      

      
        $dataArray[$namePrefix."B相输出视在功率"] = number_format($v[11]/100, 2)."kVA";
      

      
        $dataArray[$namePrefix."C相输出视在功率"] = number_format($v[12]/kVA, 2);
      

      
        $dataArray[$namePrefix."A相输出负载百分比"] = number_format($v[13]/100, 2);
      

      
        $dataArray[$namePrefix."B相输出负载百分比"] = number_format($v[14]/100, 2);
      

      
        $dataArray[$namePrefix."C相输出负载百分比"] = number_format($v[15]/100, 2);
      

      
        $dataArray[$namePrefix."输出电能A"] = ((($v[19]<<16) | $v[20]))."kWh";
      

      
        $dataArray[$namePrefix."输出电能B"] = ((($v[21]<<16) | $v[22]))."kWh";
      

      
        $dataArray[$namePrefix."输出电能C"] = ((($v[23]<<16) | $v[24]))."kWh";
      

      $offset += 48;

            $v = unpack("S*" , substr($memData , $offset, 2*1));
      
        $dataArray[$namePrefix."电池后备时间"] = number_format($v[1], 2)."分钟";
      

      $offset += 2;

            $v = unpack("s*" , substr($memData , $offset, 2*4));
      
        $dataArray[$namePrefix."正电池电压"] = number_format($v[1]/100, 2)."V";
      

      
        $dataArray[$namePrefix."正电池电流"] = number_format($v[2]/100, 2)."A";
      

      
        $dataArray[$namePrefix."负电池电压"] = number_format($v[3]/100, 2)."V";
      

      
        $dataArray[$namePrefix."负电池电流"] = number_format($v[4]/100, 2)."A";
      

      $offset += 8;

            $v = unpack("S*" , substr($memData , $offset, 2*3));
      
        $dataArray[$namePrefix."电池老化系数"] = number_format($v[1]/100, 2);
      

      
        $dataArray[$namePrefix."电池温度"] = number_format($v[2]/10, 2)."°C";
      

      
        $dataArray[$namePrefix."环境温度"] = number_format($v[3]/10, 2)."°C";
      

      $offset += 6;

            }
            $v = unpack("S*" , substr($memData , $offset, 2*6));
      
        switch(($v[1] & 0x7)){
          case 0:
          $dataArray["本机架供电方式"] = "UPS供电(逆变供电)";
            break;
          case 1:
          $dataArray["本机架供电方式"] = "旁路供电";
            break;
          case 2:
          $dataArray["本机架供电方式"] = "维修旁路供电";
            break;
          case 3:
          $dataArray["本机架供电方式"] = "均不供电";
            break;
          default:
            $dataArray["本机架供电方式"] = "无效值";
            break;
        }
      

      
        switch(( ($v[1]>>3) & 0x1)){
          case 0:
          $dataArray["电池自检状态"] = "不在自检";
            break;
          case 1:
          $dataArray["电池自检状态"] = "自检中";
            break;
          default:
            $dataArray["电池自检状态"] = "无效值";
            break;
        }
      

      
        switch(( ($v[1]>>4) & 0x3)){
          case 0:
          $dataArray["电池充电状态"] = "非充电状态";
            break;
          case 1:
          $dataArray["电池充电状态"] = "电池浮充";
            break;
          case 2:
          $dataArray["电池充电状态"] = "电池均充";
            break;
          default:
            $dataArray["电池充电状态"] = "无效值";
            break;
        }
      

      
        switch(( ($v[1]>>6) & 0x1)){
          case 0:
          $dataArray["逆变器开/关机状态"] = "开机";
            break;
          case 1:
          $dataArray["逆变器开/关机状态"] = "关机";
            break;
          default:
            $dataArray["逆变器开/关机状态"] = "无效值";
            break;
        }
      

      
        switch(( ($v[1]>>7) & 0x3)){
          case 0:
          $dataArray["整流器供电状态"] = "主路供电";
            break;
          case 1:
          $dataArray["整流器供电状态"] = "电池供电";
            break;
          case 2:
          $dataArray["整流器供电状态"] = "均不供电";
            break;
          default:
            $dataArray["整流器供电状态"] = "无效值";
            break;
        }
      

      
        switch(( ($v[1]>>9) & 0x1)){
          case 0:
          $dataArray["发电机接入状态"] = "未接入";
            break;
          case 1:
          $dataArray["发电机接入状态"] = "接入";
            break;
          default:
            $dataArray["发电机接入状态"] = "无效值";
            break;
        }
      

      
        switch(( ($v[1]>>10) & 0x3)){
          case 0:
          $dataArray["输入空开状态"] = "闭合";
            break;
          case 1:
          $dataArray["输入空开状态"] = "断开";
            break;
          case 2:
          $dataArray["输入空开状态"] = "不支持";
            break;
          default:
            $dataArray["输入空开状态"] = "无效值";
            break;
        }
      

      
        switch(( ($v[1]>>12) & 0x3)){
          case 0:
          $dataArray["维修空开状态"] = "断开";
            break;
          case 1:
          $dataArray["维修空开状态"] = "闭合";
            break;
          case 2:
          $dataArray["维修空开状态"] = "不支持";
            break;
          default:
            $dataArray["维修空开状态"] = "无效值";
            break;
        }
      

      
        switch(( ($v[1]>>14) & 0x3)){
          case 0:
          $dataArray["旁路空开状态"] = "闭合";
            break;
          case 1:
          $dataArray["旁路空开状态"] = "断开";
            break;
          case 2:
          $dataArray["旁路空开状态"] = "不支持";
            break;
          default:
            $dataArray["旁路空开状态"] = "无效值";
            break;
        }
      

      
        switch(( ($v[2]) & 0x3)){
          case 0:
          $dataArray["输出空开状态"] = "闭合";
            break;
          case 1:
          $dataArray["输出空开状态"] = "断开";
            break;
          case 2:
          $dataArray["输出空开状态"] = "不支持";
            break;
          default:
            $dataArray["输出空开状态"] = "无效值";
            break;
        }
      

      
        switch(( ($v[2] >> 2) & 0x1F)){
          case 0:
          $dataArray["整机工作模式"] = "正常模式";
            break;
          case 1:
          $dataArray["整机工作模式"] = "智能并机模式";
            break;
          case 2:
          $dataArray["整机工作模式"] = "智能并机演示模式";
            break;
          case 3:
          $dataArray["整机工作模式"] = "ECO模式";
            break;
          case 4:
          $dataArray["整机工作模式"] = "智能ECO模式";
            break;
          case 5:
          $dataArray["整机工作模式"] = "智能ECO演示模式";
            break;
          case 6:
          $dataArray["整机工作模式"] = "变频器模式（接电池）";
            break;
          case 7:
          $dataArray["整机工作模式"] = "变频器模式（不接电池）";
            break;
          case 8:
          $dataArray["整机工作模式"] = "功率调节器模式";
            break;
          case 9:
          $dataArray["整机工作模式"] = "自老化模式";
            break;
          case 10:
          $dataArray["整机工作模式"] = "调测模式";
            break;
          case 11:
          $dataArray["整机工作模式"] = "动态在线模式";
            break;
          default:
            $dataArray["整机工作模式"] = "无效值";
            break;
        }
      

      
        switch(( ($v[2] >> 7) & 0x7)){
          case 0:
          $dataArray["并机系统供电状态"] = "均不供电";
            break;
          case 1:
          $dataArray["并机系统供电状态"] = "旁路供电";
            break;
          case 2:
          $dataArray["并机系统供电状态"] = "主路逆变供电";
            break;
          case 3:
          $dataArray["并机系统供电状态"] = "电池逆变供电";
            break;
          case 4:
          $dataArray["并机系统供电状态"] = "维修旁路供电";
            break;
          default:
            $dataArray["并机系统供电状态"] = "无效值";
            break;
        }
      

      
        switch(( ($v[2] >> 10) & 0x3)){
          case 0:
          $dataArray["外部维修空开状态"] = "断开";
            break;
          case 1:
          $dataArray["外部维修空开状态"] = "闭合";
            break;
          case 2:
          $dataArray["外部维修空开状态"] = "不支持";
            break;
          default:
            $dataArray["外部维修空开状态"] = "无效值";
            break;
        }
      

      
        switch(( ($v[2] >> 12) & 0x3)){
          case 0:
          $dataArray["外部维修空开状态"] = "断开";
            break;
          case 1:
          $dataArray["外部维修空开状态"] = "闭合";
            break;
          case 2:
          $dataArray["外部维修空开状态"] = "不支持";
            break;
          default:
            $dataArray["外部维修空开状态"] = "无效值";
            break;
        }
      

      
        switch(( ($v[2] >> 14) & 0x3)){
          case 0:
          $dataArray["外部维修隔离空开状态"] = "闭合";
            break;
          case 1:
          $dataArray["外部维修隔离空开状态"] = "断开";
            break;
          case 2:
          $dataArray["外部维修隔离空开状态"] = "不支持";
            break;
          default:
            $dataArray["外部维修隔离空开状态"] = "无效值";
            break;
        }
      

      
        switch(( ($v[3]) & 0x1)){
          case 0:
          $dataArray["旁路在线状态"] = "不在线";
            break;
          case 1:
          $dataArray["旁路在线状态"] = "在线";
            break;
          default:
            $dataArray["旁路在线状态"] = "无效值";
            break;
        }
      

      
        switch(( ($v[3]>>1) & 0x1)){
          case 0:
          $dataArray["模块1在线状态"] = "不在线";
            break;
          case 1:
          $dataArray["模块1在线状态"] = "在线";
            break;
          default:
            $dataArray["模块1在线状态"] = "无效值";
            break;
        }
      

      
        switch(( ($v[3]>>2) & 0x1)){
          case 0:
          $dataArray["模块2在线状态"] = "不在线";
            break;
          case 1:
          $dataArray["模块2在线状态"] = "在线";
            break;
          default:
            $dataArray["模块2在线状态"] = "无效值";
            break;
        }
      

      
        switch(( ($v[3]>>3) & 0x1)){
          case 0:
          $dataArray["模块3在线状态"] = "不在线";
            break;
          case 1:
          $dataArray["模块3在线状态"] = "在线";
            break;
          default:
            $dataArray["模块3在线状态"] = "无效值";
            break;
        }
      

      
        switch(( ($v[3]>>4) & 0x1)){
          case 0:
          $dataArray["模块4在线状态"] = "不在线";
            break;
          case 1:
          $dataArray["模块4在线状态"] = "在线";
            break;
          default:
            $dataArray["模块4在线状态"] = "无效值";
            break;
        }
      

      
        switch(( ($v[3]>>5) & 0x1)){
          case 0:
          $dataArray["模块5在线状态"] = "不在线";
            break;
          case 1:
          $dataArray["模块5在线状态"] = "在线";
            break;
          default:
            $dataArray["模块5在线状态"] = "无效值";
            break;
        }
      

      
        switch(( ($v[3]>>6) & 0x1)){
          case 0:
          $dataArray["模块6在线状态"] = "不在线";
            break;
          case 1:
          $dataArray["模块6在线状态"] = "在线";
            break;
          default:
            $dataArray["模块6在线状态"] = "无效值";
            break;
        }
      

      
        switch(( ($v[3]>>7) & 0x1)){
          case 0:
          $dataArray["模块7在线状态"] = "不在线";
            break;
          case 1:
          $dataArray["模块7在线状态"] = "在线";
            break;
          default:
            $dataArray["模块7在线状态"] = "无效值";
            break;
        }
      

      
        switch(( ($v[3]>>8) & 0x1)){
          case 0:
          $dataArray["模块8在线状态"] = "不在线";
            break;
          case 1:
          $dataArray["模块8在线状态"] = "在线";
            break;
          default:
            $dataArray["模块8在线状态"] = "无效值";
            break;
        }
      

      
        switch(( ($v[3]>>9) & 0x1)){
          case 0:
          $dataArray["模块9在线状态"] = "不在线";
            break;
          case 1:
          $dataArray["模块9在线状态"] = "在线";
            break;
          default:
            $dataArray["模块9在线状态"] = "无效值";
            break;
        }
      

      
        switch(( ($v[3]>>10) & 0x1)){
          case 0:
          $dataArray["模块10在线状态"] = "不在线";
            break;
          case 1:
          $dataArray["模块10在线状态"] = "在线";
            break;
          default:
            $dataArray["模块10在线状态"] = "无效值";
            break;
        }
      

      
        switch(( ($v[3]>>11) & 0x1)){
          case 0:
          $dataArray["模块11在线状态"] = "不在线";
            break;
          case 1:
          $dataArray["模块11在线状态"] = "在线";
            break;
          default:
            $dataArray["模块11在线状态"] = "无效值";
            break;
        }
      

      
        switch(( ($v[3]>>12) & 0x1)){
          case 0:
          $dataArray["模块12在线状态"] = "不在线";
            break;
          case 1:
          $dataArray["模块12在线状态"] = "在线";
            break;
          default:
            $dataArray["模块12在线状态"] = "无效值";
            break;
        }
      

      
        switch(( ($v[3]>>13) & 0x1)){
          case 0:
          $dataArray["模块13在线状态"] = "不在线";
            break;
          case 1:
          $dataArray["模块13在线状态"] = "在线";
            break;
          default:
            $dataArray["模块13在线状态"] = "无效值";
            break;
        }
      

      
        switch(( ($v[3]>>14) & 0x1)){
          case 0:
          $dataArray["模块14在线状态"] = "不在线";
            break;
          case 1:
          $dataArray["模块14在线状态"] = "在线";
            break;
          default:
            $dataArray["模块14在线状态"] = "无效值";
            break;
        }
      

      
        switch(( ($v[3]>>15) & 0x1)){
          case 0:
          $dataArray["模块15在线状态"] = "不在线";
            break;
          case 1:
          $dataArray["模块15在线状态"] = "在线";
            break;
          default:
            $dataArray["模块15在线状态"] = "无效值";
            break;
        }
      

      
        switch(( ($v[4]) & 0x1)){
          case 0:
          $dataArray["模块16在线状态"] = "不在线";
            break;
          case 1:
          $dataArray["模块16在线状态"] = "在线";
            break;
          default:
            $dataArray["模块16在线状态"] = "无效值";
            break;
        }
      

      
        switch(( ($v[4] >> 1) & 0x1)){
          case 0:
          $dataArray["模块17在线状态"] = "不在线";
            break;
          case 1:
          $dataArray["模块17在线状态"] = "在线";
            break;
          default:
            $dataArray["模块17在线状态"] = "无效值";
            break;
        }
      

      
        switch(( ($v[4] >> 2) & 0x1)){
          case 0:
          $dataArray["模块18在线状态"] = "不在线";
            break;
          case 1:
          $dataArray["模块18在线状态"] = "在线";
            break;
          default:
            $dataArray["模块18在线状态"] = "无效值";
            break;
        }
      

      
        switch(( ($v[4] >> 3) & 0x1)){
          case 0:
          $dataArray["模块19在线状态"] = "不在线";
            break;
          case 1:
          $dataArray["模块19在线状态"] = "在线";
            break;
          default:
            $dataArray["模块19在线状态"] = "无效值";
            break;
        }
      

      
        switch(( ($v[4] >> 4) & 0x1)){
          case 0:
          $dataArray["模块20在线状态"] = "不在线";
            break;
          case 1:
          $dataArray["模块20在线状态"] = "在线";
            break;
          default:
            $dataArray["模块20在线状态"] = "无效值";
            break;
        }
      

      
        switch(( ($v[4] >> 5) & 0x1)){
          case 0:
          $dataArray["模块21在线状态"] = "不在线";
            break;
          case 1:
          $dataArray["模块21在线状态"] = "在线";
            break;
          default:
            $dataArray["模块21在线状态"] = "无效值";
            break;
        }
      

      
        switch(( ($v[4] >> 6) & 0x1)){
          case 0:
          $dataArray["模块22在线状态"] = "不在线";
            break;
          case 1:
          $dataArray["模块22在线状态"] = "在线";
            break;
          default:
            $dataArray["模块22在线状态"] = "无效值";
            break;
        }
      

      
        switch(( ($v[4] >> 7) & 0x1)){
          case 0:
          $dataArray["模块23在线状态"] = "不在线";
            break;
          case 1:
          $dataArray["模块23在线状态"] = "在线";
            break;
          default:
            $dataArray["模块23在线状态"] = "无效值";
            break;
        }
      

      
        switch(( ($v[4] >> 8) & 0x1)){
          case 0:
          $dataArray["模块24在线状态"] = "不在线";
            break;
          case 1:
          $dataArray["模块24在线状态"] = "在线";
            break;
          default:
            $dataArray["模块24在线状态"] = "无效值";
            break;
        }
      

      
        switch(( ($v[4] >> 9) & 0x1)){
          case 0:
          $dataArray["模块25在线状态"] = "不在线";
            break;
          case 1:
          $dataArray["模块25在线状态"] = "在线";
            break;
          default:
            $dataArray["模块25在线状态"] = "无效值";
            break;
        }
      

      
        switch(( ($v[4] >> 10) & 0x1)){
          case 0:
          $dataArray["模块26在线状态"] = "不在线";
            break;
          case 1:
          $dataArray["模块26在线状态"] = "在线";
            break;
          default:
            $dataArray["模块26在线状态"] = "无效值";
            break;
        }
      

      
        switch(( ($v[4] >> 11) & 0x1)){
          case 0:
          $dataArray["模块27在线状态"] = "不在线";
            break;
          case 1:
          $dataArray["模块27在线状态"] = "在线";
            break;
          default:
            $dataArray["模块27在线状态"] = "无效值";
            break;
        }
      

      
        switch(( ($v[4] >> 12) & 0x1)){
          case 0:
          $dataArray["模块28在线状态"] = "不在线";
            break;
          case 1:
          $dataArray["模块28在线状态"] = "在线";
            break;
          default:
            $dataArray["模块28在线状态"] = "无效值";
            break;
        }
      

      
        switch(( ($v[4] >> 13) & 0x1)){
          case 0:
          $dataArray["模块29在线状态"] = "不在线";
            break;
          case 1:
          $dataArray["模块29在线状态"] = "在线";
            break;
          default:
            $dataArray["模块29在线状态"] = "无效值";
            break;
        }
      

      
        switch(( ($v[4] >> 14) & 0x1)){
          case 0:
          $dataArray["模块30在线状态"] = "不在线";
            break;
          case 1:
          $dataArray["模块30在线状态"] = "在线";
            break;
          default:
            $dataArray["模块30在线状态"] = "无效值";
            break;
        }
      

      
        switch(( ($v[4] >> 15) & 0x1)){
          case 0:
          $dataArray["模块31在线状态"] = "不在线";
            break;
          case 1:
          $dataArray["模块31在线状态"] = "在线";
            break;
          default:
            $dataArray["模块31在线状态"] = "无效值";
            break;
        }
      

      
        switch(( ($v[5]) & 0x1)){
          case 0:
          $dataArray["模块休眠"] = "正常";
            break;
          case 1:
          $dataArray["模块休眠"] = "休眠";
            break;
          default:
            $dataArray["模块休眠"] = "无效值";
            break;
        }
      

      
        switch(( ($v[5] >> 1) & 0x1)){
          case 0:
          $dataArray["充电器需关闭"] = "无充电器关闭命令";
            break;
          case 1:
          $dataArray["充电器需关闭"] = "干接点要求关闭充电器";
            break;
          default:
            $dataArray["充电器需关闭"] = "无效值";
            break;
        }
      

      
        switch(( ($v[5] >> 2) & 0x3)){
          case 0:
          $dataArray["内置电池空开状态"] = "闭合";
            break;
          case 1:
          $dataArray["内置电池空开状态"] = "断开";
            break;
          case 2:
          $dataArray["内置电池空开状态"] = "不支持";
            break;
          default:
            $dataArray["内置电池空开状态"] = "无效值";
            break;
        }
      

      
        switch(( ($v[5] >> 4) & 0x3)){
          case 0:
          $dataArray["ATS输入源状态"] = "ATS输入源2";
            break;
          case 1:
          $dataArray["ATS输入源状态"] = "ATS输入源1";
            break;
          case 2:
          $dataArray["ATS输入源状态"] = "非输入源配置";
            break;
          case 3:
          $dataArray["ATS输入源状态"] = "不支持";
            break;
          default:
            $dataArray["ATS输入源状态"] = "无效值";
            break;
        }
      

      
        switch(( ($v[5] >> 6) & 0x3)){
          case 0:
          $dataArray["输入断路器状态"] = "断开";
            break;
          case 1:
          $dataArray["输入断路器状态"] = "闭合";
            break;
          case 2:
          $dataArray["输入断路器状态"] = "非输入断路器配置";
            break;
          case 3:
          $dataArray["输入断路器状态"] = "不支持";
            break;
          default:
            $dataArray["输入断路器状态"] = "无效值";
            break;
        }
      

      
        switch(( ($v[5] >> 8) & 0x3)){
          case 0:
          $dataArray["BCB1状态"] = "闭合";
            break;
          case 1:
          $dataArray["BCB1状态"] = "断开";
            break;
          case 2:
          $dataArray["BCB1状态"] = "未接入";
            break;
          default:
            $dataArray["BCB1状态"] = "无效值";
            break;
        }
      

      
        switch(( ($v[5] >> 10) & 0x3)){
          case 0:
          $dataArray["BCB2状态"] = "未接入";
            break;
          case 1:
          $dataArray["BCB2状态"] = "闭合";
            break;
          case 2:
          $dataArray["BCB2状态"] = "断开";
            break;
          default:
            $dataArray["BCB2状态"] = "无效值";
            break;
        }
      

      
        switch(( ($v[5] >> 12) & 0x3)){
          case 0:
          $dataArray["BCB3状态"] = "未接入";
            break;
          case 1:
          $dataArray["BCB3状态"] = "闭合";
            break;
          case 2:
          $dataArray["BCB3状态"] = "断开";
            break;
          default:
            $dataArray["BCB3状态"] = "无效值";
            break;
        }
      

      
        switch(( ($v[5] >> 14) & 0x3)){
          case 0:
          $dataArray["BCB4状态"] = "未接入";
            break;
          case 1:
          $dataArray["BCB4状态"] = "闭合";
            break;
          case 2:
          $dataArray["BCB4状态"] = "断开";
            break;
          default:
            $dataArray["BCB4状态"] = "无效值";
            break;
        }
      

      
        switch(( ($v[6]) & 0x3)){
          case 0:
          $dataArray["禁止ECO模式"] = "无禁止ECO命令";
            break;
          case 1:
          $dataArray["禁止ECO模式"] = "干接点要求禁止ECO模式";
            break;
          case 2:
          $dataArray["禁止ECO模式"] = "不支持";
            break;
          default:
            $dataArray["禁止ECO模式"] = "无效值";
            break;
        }
      

      
        switch(( ($v[6] >> 2) & 0x3)){
          case 0:
          $dataArray["禁止切逆变"] = "无禁止切逆变命令";
            break;
          case 1:
          $dataArray["禁止切逆变"] = "干结点要求禁止切逆变";
            break;
          case 2:
          $dataArray["禁止切逆变"] = "不支持";
            break;
          default:
            $dataArray["禁止切逆变"] = "无效值";
            break;
        }
      

      
        switch(( ($v[6] >> 4) & 0x3)){
          case 0:
          $dataArray["锂电池接入状态"] = "未接入";
            break;
          case 1:
          $dataArray["锂电池接入状态"] = "接入";
            break;
          case 2:
          $dataArray["锂电池接入状态"] = "不支持";
            break;
          default:
            $dataArray["锂电池接入状态"] = "无效值";
            break;
        }
      

      $offset += 12;

            $v = unpack("S*" , substr($memData , $offset, 2*7));
      
        _exm2ups_ShowAlert($dataArray, "设备通讯异常", ($v[1]&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "逆变器不同步", (($v[1]>>1)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "主路电压异常", (($v[1]>>2)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "整流器故障", (($v[1]>>3)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "逆变器故障", (($v[1]>>4)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "旁路异常", (($v[1]>>5)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "电池状态", (($v[1]>>6)&0x7), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "环境过温", (($v[1]>>9)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "PowerCAN通讯异常", (($v[1]>>10)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "整流DSP程序错误", (($v[1]>>11)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "输出禁止", (($v[1]>>12)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "逆变DSP程序错误", (($v[1]>>13)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "逆变FPGA程序错误", (($v[1]>>14)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "旁路DSP程序错误", (($v[1]>>15)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "旁路FPGA程序错误", ($v[2]&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "机架内离散总线通讯异常", (($v[2]>>1)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "机架间离散总线通讯异常", (($v[2]>>2)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "LBS异常", (($v[2]>>3)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "紧急关机", (($v[2]>>4)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "旁路晶闸管故障", (($v[2]>>5)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "旁路相序反", (($v[2]>>6)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "旁路过流", (($v[2]>>7)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "旁路异常关机", (($v[2]>>8)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "切换次数限制", (($v[2]>>9)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "ECO切换次数限制", (($v[2]>>10)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "ParaPowerCAN通讯异常", (($v[2]>>11)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "电池放电限流", (($v[2]>>12)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "放电器故障", (($v[2]>>13)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "充电器故障", (($v[2]>>14)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "LBS连接线异常", (($v[2]>>15)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "电池需维护", ($v[3]&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "电池过温", (($v[3]>>1)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "电池接地故障", (($v[3]>>2)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "主路频率异常", (($v[3]>>3)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "模块过温", (($v[3]>>4)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "输入变压器过温", (($v[3]>>5)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "旁路柜变压器过温", (($v[3]>>6)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "均充超时", (($v[3]>>7)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "辅助电源掉电", (($v[3]>>8)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "主路相序反", (($v[3]>>9)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "整流器软启动失败", (($v[3]>>10)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "用户操作错误", (($v[3]>>11)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "输出过载", (($v[3]>>12)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "并机系统容量过载", (($v[3]>>13)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "输出过载超时", (($v[3]>>14)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "负载冲击转旁路", (($v[3]>>15)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "并机均流异常", ($v[4]&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "母线异常关机", (($v[4]>>1)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "邻机请求转旁路", (($v[4]>>2)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "直流母线过压", (($v[4]>>3)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "MonCAN通讯异常", (($v[4]>>4)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "输入缺零故障", (($v[4]>>5)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "逆变继电器故障", (($v[4]>>6)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "主路反灌", (($v[4]>>7)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "输入电流异常", (($v[4]>>8)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "输出电压异常", (($v[4]>>9)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "输入电流超限", (($v[4]>>10)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "旁路过温", (($v[4]>>11)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "邻机旁路晶闸管故障", (($v[4]>>12)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "并机连接线异常", (($v[4]>>13)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "充电器过温", (($v[4]>>14)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "电池端口异常", (($v[4]>>15)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "电池房环境异常", ($v[5]&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "风扇异常", (($v[5]>>1)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "旁路接管", (($v[5]>>2)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "BCB1状态异常", (($v[5]>>3)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "BCB2状态异常", (($v[5]>>4)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "BCB3状态异常", (($v[5]>>5)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "BCB4状态异常", (($v[5]>>6)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "旁路模块未授权", (($v[5]>>7)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "功率模块未授权", (($v[5]>>8)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "监控未授权", (($v[5]>>9)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "旁路SCR风扇异常", (($v[5]>>10)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "平衡电路故障", (($v[5]>>11)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "平衡电路过流", (($v[5]>>12)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "平衡电路过温", (($v[5]>>13)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "失去冗余", (($v[5]>>14)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "功率板设置不匹配", (($v[5]>>15)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "模块未就绪", ($v[6]&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "上抽风风扇异常", (($v[6]>>1)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "系统A相输出熔丝断", (($v[6]>>2)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "系统B相输出熔丝断", (($v[6]>>3)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "系统C相输出熔丝断", (($v[6]>>4)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "参数配置失败", (($v[6]>>5)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "旁路过流超时", (($v[6]>>6)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "零地过压", (($v[6]>>7)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "旁路无效", (($v[6]>>8)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "功率模块未授权", (($v[6]>>9)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "输出熔丝断", (($v[6]>>10)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "电池自检失败", (($v[6]>>11)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "分级下电1生效", (($v[6]>>12)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "分级下电2生效", (($v[6]>>13)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "旁路功率模块未就绪", (($v[6]>>14)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "旁路控制模块未就绪", (($v[6]>>15)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "系统主路熔丝断", ($v[7]&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "旁路熔丝断", (($v[7]>>1)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "系统输出熔丝断", (($v[7]>>2)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "维修旁路供电", (($v[7]>>3)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "输出短路", (($v[7]>>4)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "电池深度放电", (($v[7]>>5)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "双旁路供电", (($v[7]>>6)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "电池温度异常", (($v[7]>>7)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "主路熔丝断", (($v[7]>>8)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "放电器关闭", (($v[7]>>9)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "ParaMonCAN通讯异常", (($v[7]>>10)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "BMS通讯异常", (($v[7]>>11)&0x1), 0);
      

      
        _exm2ups_ShowAlert($dataArray, "锂电池需脱扣", (($v[7]>>12)&0x1), 0);
      

      
        $dataArray["电池系统异常"] = ((($v[7]>>13)&0x1));
      

      $offset += 14;

        $v = unpack('v', substr($memData, $offset , 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData, $offset + 2 , 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}

